//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// AttestationsServer is a fake server for instances of the armpolicyinsights.AttestationsClient type.
type AttestationsServer struct {
	// BeginCreateOrUpdateAtResource is the fake for method AttestationsClient.BeginCreateOrUpdateAtResource
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtResource func(ctx context.Context, resourceID string, attestationName string, parameters armpolicyinsights.Attestation, options *armpolicyinsights.AttestationsClientBeginCreateOrUpdateAtResourceOptions) (resp azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtResourceResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAtResourceGroup is the fake for method AttestationsClient.BeginCreateOrUpdateAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtResourceGroup func(ctx context.Context, resourceGroupName string, attestationName string, parameters armpolicyinsights.Attestation, options *armpolicyinsights.AttestationsClientBeginCreateOrUpdateAtResourceGroupOptions) (resp azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAtSubscription is the fake for method AttestationsClient.BeginCreateOrUpdateAtSubscription
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtSubscription func(ctx context.Context, attestationName string, parameters armpolicyinsights.Attestation, options *armpolicyinsights.AttestationsClientBeginCreateOrUpdateAtSubscriptionOptions) (resp azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// DeleteAtResource is the fake for method AttestationsClient.DeleteAtResource
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtResource func(ctx context.Context, resourceID string, attestationName string, options *armpolicyinsights.AttestationsClientDeleteAtResourceOptions) (resp azfake.Responder[armpolicyinsights.AttestationsClientDeleteAtResourceResponse], errResp azfake.ErrorResponder)

	// DeleteAtResourceGroup is the fake for method AttestationsClient.DeleteAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtResourceGroup func(ctx context.Context, resourceGroupName string, attestationName string, options *armpolicyinsights.AttestationsClientDeleteAtResourceGroupOptions) (resp azfake.Responder[armpolicyinsights.AttestationsClientDeleteAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// DeleteAtSubscription is the fake for method AttestationsClient.DeleteAtSubscription
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtSubscription func(ctx context.Context, attestationName string, options *armpolicyinsights.AttestationsClientDeleteAtSubscriptionOptions) (resp azfake.Responder[armpolicyinsights.AttestationsClientDeleteAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// GetAtResource is the fake for method AttestationsClient.GetAtResource
	// HTTP status codes to indicate success: http.StatusOK
	GetAtResource func(ctx context.Context, resourceID string, attestationName string, options *armpolicyinsights.AttestationsClientGetAtResourceOptions) (resp azfake.Responder[armpolicyinsights.AttestationsClientGetAtResourceResponse], errResp azfake.ErrorResponder)

	// GetAtResourceGroup is the fake for method AttestationsClient.GetAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetAtResourceGroup func(ctx context.Context, resourceGroupName string, attestationName string, options *armpolicyinsights.AttestationsClientGetAtResourceGroupOptions) (resp azfake.Responder[armpolicyinsights.AttestationsClientGetAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// GetAtSubscription is the fake for method AttestationsClient.GetAtSubscription
	// HTTP status codes to indicate success: http.StatusOK
	GetAtSubscription func(ctx context.Context, attestationName string, options *armpolicyinsights.AttestationsClientGetAtSubscriptionOptions) (resp azfake.Responder[armpolicyinsights.AttestationsClientGetAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// NewListForResourcePager is the fake for method AttestationsClient.NewListForResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForResourcePager func(resourceID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.AttestationsClientListForResourceOptions) (resp azfake.PagerResponder[armpolicyinsights.AttestationsClientListForResourceResponse])

	// NewListForResourceGroupPager is the fake for method AttestationsClient.NewListForResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForResourceGroupPager func(resourceGroupName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.AttestationsClientListForResourceGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.AttestationsClientListForResourceGroupResponse])

	// NewListForSubscriptionPager is the fake for method AttestationsClient.NewListForSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForSubscriptionPager func(queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.AttestationsClientListForSubscriptionOptions) (resp azfake.PagerResponder[armpolicyinsights.AttestationsClientListForSubscriptionResponse])
}

// NewAttestationsServerTransport creates a new instance of AttestationsServerTransport with the provided implementation.
// The returned AttestationsServerTransport instance is connected to an instance of armpolicyinsights.AttestationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAttestationsServerTransport(srv *AttestationsServer) *AttestationsServerTransport {
	return &AttestationsServerTransport{
		srv:                                srv,
		beginCreateOrUpdateAtResource:      newTracker[azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtResourceResponse]](),
		beginCreateOrUpdateAtResourceGroup: newTracker[azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtResourceGroupResponse]](),
		beginCreateOrUpdateAtSubscription:  newTracker[azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtSubscriptionResponse]](),
		newListForResourcePager:            newTracker[azfake.PagerResponder[armpolicyinsights.AttestationsClientListForResourceResponse]](),
		newListForResourceGroupPager:       newTracker[azfake.PagerResponder[armpolicyinsights.AttestationsClientListForResourceGroupResponse]](),
		newListForSubscriptionPager:        newTracker[azfake.PagerResponder[armpolicyinsights.AttestationsClientListForSubscriptionResponse]](),
	}
}

// AttestationsServerTransport connects instances of armpolicyinsights.AttestationsClient to instances of AttestationsServer.
// Don't use this type directly, use NewAttestationsServerTransport instead.
type AttestationsServerTransport struct {
	srv                                *AttestationsServer
	beginCreateOrUpdateAtResource      *tracker[azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtResourceResponse]]
	beginCreateOrUpdateAtResourceGroup *tracker[azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtResourceGroupResponse]]
	beginCreateOrUpdateAtSubscription  *tracker[azfake.PollerResponder[armpolicyinsights.AttestationsClientCreateOrUpdateAtSubscriptionResponse]]
	newListForResourcePager            *tracker[azfake.PagerResponder[armpolicyinsights.AttestationsClientListForResourceResponse]]
	newListForResourceGroupPager       *tracker[azfake.PagerResponder[armpolicyinsights.AttestationsClientListForResourceGroupResponse]]
	newListForSubscriptionPager        *tracker[azfake.PagerResponder[armpolicyinsights.AttestationsClientListForSubscriptionResponse]]
}

// Do implements the policy.Transporter interface for AttestationsServerTransport.
func (a *AttestationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AttestationsClient.BeginCreateOrUpdateAtResource":
		resp, err = a.dispatchBeginCreateOrUpdateAtResource(req)
	case "AttestationsClient.BeginCreateOrUpdateAtResourceGroup":
		resp, err = a.dispatchBeginCreateOrUpdateAtResourceGroup(req)
	case "AttestationsClient.BeginCreateOrUpdateAtSubscription":
		resp, err = a.dispatchBeginCreateOrUpdateAtSubscription(req)
	case "AttestationsClient.DeleteAtResource":
		resp, err = a.dispatchDeleteAtResource(req)
	case "AttestationsClient.DeleteAtResourceGroup":
		resp, err = a.dispatchDeleteAtResourceGroup(req)
	case "AttestationsClient.DeleteAtSubscription":
		resp, err = a.dispatchDeleteAtSubscription(req)
	case "AttestationsClient.GetAtResource":
		resp, err = a.dispatchGetAtResource(req)
	case "AttestationsClient.GetAtResourceGroup":
		resp, err = a.dispatchGetAtResourceGroup(req)
	case "AttestationsClient.GetAtSubscription":
		resp, err = a.dispatchGetAtSubscription(req)
	case "AttestationsClient.NewListForResourcePager":
		resp, err = a.dispatchNewListForResourcePager(req)
	case "AttestationsClient.NewListForResourceGroupPager":
		resp, err = a.dispatchNewListForResourceGroupPager(req)
	case "AttestationsClient.NewListForSubscriptionPager":
		resp, err = a.dispatchNewListForSubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AttestationsServerTransport) dispatchBeginCreateOrUpdateAtResource(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdateAtResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtResource not implemented")}
	}
	beginCreateOrUpdateAtResource := a.beginCreateOrUpdateAtResource.get(req)
	if beginCreateOrUpdateAtResource == nil {
		const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.Attestation](req)
		if err != nil {
			return nil, err
		}
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdateAtResource(req.Context(), resourceIDParam, attestationNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtResource = &respr
		a.beginCreateOrUpdateAtResource.add(req, beginCreateOrUpdateAtResource)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtResource, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdateAtResource.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtResource) {
		a.beginCreateOrUpdateAtResource.remove(req)
	}

	return resp, nil
}

func (a *AttestationsServerTransport) dispatchBeginCreateOrUpdateAtResourceGroup(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdateAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtResourceGroup not implemented")}
	}
	beginCreateOrUpdateAtResourceGroup := a.beginCreateOrUpdateAtResourceGroup.get(req)
	if beginCreateOrUpdateAtResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.Attestation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdateAtResourceGroup(req.Context(), resourceGroupNameParam, attestationNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtResourceGroup = &respr
		a.beginCreateOrUpdateAtResourceGroup.add(req, beginCreateOrUpdateAtResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdateAtResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtResourceGroup) {
		a.beginCreateOrUpdateAtResourceGroup.remove(req)
	}

	return resp, nil
}

func (a *AttestationsServerTransport) dispatchBeginCreateOrUpdateAtSubscription(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdateAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtSubscription not implemented")}
	}
	beginCreateOrUpdateAtSubscription := a.beginCreateOrUpdateAtSubscription.get(req)
	if beginCreateOrUpdateAtSubscription == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.Attestation](req)
		if err != nil {
			return nil, err
		}
		attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdateAtSubscription(req.Context(), attestationNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtSubscription = &respr
		a.beginCreateOrUpdateAtSubscription.add(req, beginCreateOrUpdateAtSubscription)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtSubscription, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdateAtSubscription.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtSubscription) {
		a.beginCreateOrUpdateAtSubscription.remove(req)
	}

	return resp, nil
}

func (a *AttestationsServerTransport) dispatchDeleteAtResource(req *http.Request) (*http.Response, error) {
	if a.srv.DeleteAtResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtResource not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.DeleteAtResource(req.Context(), resourceIDParam, attestationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttestationsServerTransport) dispatchDeleteAtResourceGroup(req *http.Request) (*http.Response, error) {
	if a.srv.DeleteAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.DeleteAtResourceGroup(req.Context(), resourceGroupNameParam, attestationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttestationsServerTransport) dispatchDeleteAtSubscription(req *http.Request) (*http.Response, error) {
	if a.srv.DeleteAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.DeleteAtSubscription(req.Context(), attestationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttestationsServerTransport) dispatchGetAtResource(req *http.Request) (*http.Response, error) {
	if a.srv.GetAtResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtResource not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetAtResource(req.Context(), resourceIDParam, attestationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Attestation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttestationsServerTransport) dispatchGetAtResourceGroup(req *http.Request) (*http.Response, error) {
	if a.srv.GetAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetAtResourceGroup(req.Context(), resourceGroupNameParam, attestationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Attestation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttestationsServerTransport) dispatchGetAtSubscription(req *http.Request) (*http.Response, error) {
	if a.srv.GetAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations/(?P<attestationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	attestationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attestationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetAtSubscription(req.Context(), attestationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Attestation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttestationsServerTransport) dispatchNewListForResourcePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForResourcePager not implemented")}
	}
	newListForResourcePager := a.newListForResourcePager.get(req)
	if newListForResourcePager == nil {
		const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := a.srv.NewListForResourcePager(resourceIDParam, queryOptions, nil)
		newListForResourcePager = &resp
		a.newListForResourcePager.add(req, newListForResourcePager)
		server.PagerResponderInjectNextLinks(newListForResourcePager, req, func(page *armpolicyinsights.AttestationsClientListForResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForResourcePager) {
		a.newListForResourcePager.remove(req)
	}
	return resp, nil
}

func (a *AttestationsServerTransport) dispatchNewListForResourceGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForResourceGroupPager not implemented")}
	}
	newListForResourceGroupPager := a.newListForResourceGroupPager.get(req)
	if newListForResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := a.srv.NewListForResourceGroupPager(resourceGroupNameParam, queryOptions, nil)
		newListForResourceGroupPager = &resp
		a.newListForResourceGroupPager.add(req, newListForResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListForResourceGroupPager, req, func(page *armpolicyinsights.AttestationsClientListForResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForResourceGroupPager) {
		a.newListForResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (a *AttestationsServerTransport) dispatchNewListForSubscriptionPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForSubscriptionPager not implemented")}
	}
	newListForSubscriptionPager := a.newListForSubscriptionPager.get(req)
	if newListForSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/attestations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := a.srv.NewListForSubscriptionPager(queryOptions, nil)
		newListForSubscriptionPager = &resp
		a.newListForSubscriptionPager.add(req, newListForSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListForSubscriptionPager, req, func(page *armpolicyinsights.AttestationsClientListForSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForSubscriptionPager) {
		a.newListForSubscriptionPager.remove(req)
	}
	return resp, nil
}
