#pragma once
/*
 *  $Id: fit-table.h 28511 2025-09-04 17:57:11Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_FIT_TABLE_H__
#define __GWYUI_FIT_TABLE_H__

#include <gtk/gtk.h>
#include <libgwyddion/unit.h>
#include <libgwyddion/gwynlfit.h>

G_BEGIN_DECLS

#define GWY_TYPE_FIT_TABLE            (gwy_fit_table_get_type())
#define GWY_FIT_TABLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_FIT_TABLE, GwyFitTable))
#define GWY_FIT_TABLE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_FIT_TABLE, GwyFitTableClass))
#define GWY_IS_FIT_TABLE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_FIT_TABLE))
#define GWY_IS_FIT_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_FIT_TABLE))
#define GWY_FIT_TABLE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_FIT_TABLE, GwyFitTableClass))

typedef struct _GwyFitTable             GwyFitTable;
typedef struct _GwyFitTableClass        GwyFitTableClass;
typedef struct _GwyFitTablePrivate      GwyFitTablePrivate;

struct _GwyFitTable {
    GtkGrid grid;
    GwyFitTablePrivate *priv;
};

struct _GwyFitTableClass {
    GtkGridClass parent_class;

    void (*changed)(gint i);
    void (*activated)(gint i);
    void (*toggled)(gint i);

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType      gwy_fit_table_get_type           (void)                      G_GNUC_CONST;
GtkWidget* gwy_fit_table_new                (void);
void       gwy_fit_table_set_has_checkboxes (GwyFitTable *table,
                                             gboolean setting);
gboolean   gwy_fit_table_get_has_checkboxes (GwyFitTable *table);
void       gwy_fit_table_set_values_editable(GwyFitTable *table,
                                             gboolean setting);
gboolean   gwy_fit_table_get_values_editable(GwyFitTable *table);
void       gwy_fit_table_resize             (GwyFitTable *table,
                                             guint n);
void       gwy_fit_table_set_header         (GwyFitTable *table,
                                             const gchar *markup,
                                             guint col,
                                             guint width);
void       gwy_fit_table_set_name           (GwyFitTable *table,
                                             guint i,
                                             const gchar *markup);
void       gwy_fit_table_set_tooltip        (GwyFitTable *table,
                                             guint i,
                                             const gchar *markup);
void       gwy_fit_table_set_unit           (GwyFitTable *table,
                                             guint i,
                                             GwyUnit *unit);
void       gwy_fit_table_set_flags          (GwyFitTable *table,
                                             guint i,
                                             GwyNLFitParamFlags flags);
void       gwy_fit_table_set_value          (GwyFitTable *table,
                                             guint i,
                                             gdouble value);
void       gwy_fit_table_set_error          (GwyFitTable *table,
                                             guint i,
                                             gdouble error);
gboolean   gwy_fit_table_error_is_set       (GwyFitTable *table,
                                             guint i);
void       gwy_fit_table_clear_error        (GwyFitTable *table,
                                             guint i);
void       gwy_fit_table_clear_errors       (GwyFitTable *table);
void       gwy_fit_table_clear_value        (GwyFitTable *table,
                                             guint i);
void       gwy_fit_table_clear_values       (GwyFitTable *table);
gboolean   gwy_fit_table_value_is_set       (GwyFitTable *table,
                                             guint i);
void       gwy_fit_table_revert_values      (GwyFitTable *table);
void       gwy_fit_table_set_checked        (GwyFitTable *table,
                                             guint i,
                                             gboolean checked);
gdouble    gwy_fit_table_get_value          (GwyFitTable *table,
                                             guint i);
gdouble    gwy_fit_table_get_error          (GwyFitTable *table,
                                             guint i);
gboolean   gwy_fit_table_get_checked        (GwyFitTable *table,
                                             guint i);
void       gwy_fit_table_set_sensitive      (GwyFitTable *table,
                                             guint i,
                                             gboolean setting);
void       gwy_fit_table_reset_sensitivity  (GwyFitTable *table);
gint       gwy_fit_table_gather             (GwyFitTable *table,
                                             gdouble *values,
                                             gdouble *errors,
                                             gboolean *checked);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
