; RUN: llc     < %s | FileCheck %s
; RUN: llc -O3 < %s | FileCheck %s
; RUN: llc -O3 -debug-only=stackmaps < %s 2>&1 | FileCheck -check-prefix=STACKMAPS %s
; REQUIRES: asserts

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.11.0"


; STACKMAPS: Stack Maps: callsite 2882400015
; STACKMAPS-NEXT: Stack Maps:   has 4 locations
; STACKMAPS-NEXT: Stack Maps: 		Loc 0: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 1: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 2: Constant 1	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 1]
; STACKMAPS-NEXT: Stack Maps: 		Loc 3: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 	has 0 live-out registers
; STACKMAPS-NEXT: Stack Maps: callsite 4242
; STACKMAPS-NEXT: Stack Maps:   has 4 locations
; STACKMAPS-NEXT: Stack Maps: 		Loc 0: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 1: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 2: Constant 1	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 1]
; STACKMAPS-NEXT: Stack Maps: 		Loc 3: Constant 1	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 1]
; STACKMAPS-NEXT: Stack Maps: 	has 0 live-out registers
; STACKMAPS-NEXT: Stack Maps: callsite 4243
; STACKMAPS-NEXT: Stack Maps:   has 4 locations
; STACKMAPS-NEXT: Stack Maps: 		Loc 0: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 1: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 2: Constant 1	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 1]
; STACKMAPS-NEXT: Stack Maps: 		Loc 3: Constant 16	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 16]
; STACKMAPS-NEXT: Stack Maps: 	has 0 live-out registers
; STACKMAPS-NEXT: Stack Maps: callsite 2882400015
; STACKMAPS-NEXT: Stack Maps:   has 4 locations
; STACKMAPS-NEXT: Stack Maps: 		Loc 0: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 1: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 2: Constant 1	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 1]
; STACKMAPS-NEXT: Stack Maps: 		Loc 3: Constant 2	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 2]
; STACKMAPS-NEXT: Stack Maps: 	has 0 live-out registers
; STACKMAPS-NEXT: Stack Maps: callsite 2882400015
; STACKMAPS-NEXT: Stack Maps:   has 4 locations
; STACKMAPS-NEXT: Stack Maps: 		Loc 0: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 1: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 2: Constant 1	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 1]
; STACKMAPS-NEXT: Stack Maps: 		Loc 3: Constant 3	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 3]
; STACKMAPS-NEXT: Stack Maps: 	has 0 live-out registers
; STACKMAPS-NEXT: Stack Maps: callsite 4243
; STACKMAPS-NEXT: Stack Maps:   has 4 locations
; STACKMAPS-NEXT: Stack Maps: 		Loc 0: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 1: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 2: Constant 1	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 1]
; STACKMAPS-NEXT: Stack Maps: 		Loc 3: Constant 55	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 55]
; STACKMAPS-NEXT: Stack Maps: 	has 0 live-out registers

declare i32 @callee_0()
declare i32 @callee_1(i32)
declare i32 @callee_vararg(...)

define i32 @caller_0() {
; CHECK-LABEL: _caller_0
entry:
  %v = call i32 @callee_0() [ "deopt"(i32 0) ]
  %v2 = add i32 %v, 1
  ret i32 %v2
; CHECK:	callq	_callee_0
; CHECK:	incl	%eax
; CHECK:	retq
}

define i32 @caller_1() {
; CHECK-LABEL: _caller_1
entry:
  %v = call i32 @callee_1(i32 42) "statepoint-id"="4242" [ "deopt"(i32 1) ]
  ret i32 %v
; CHECK:	callq	_callee_1
; CHECK:	popq	%rcx
; CHECK:	retq
}

define i32 @caller_vararg() {
; CHECK-LABEL: _caller_vararg
entry:
; CHECK: movb    $1, %al
; CHECK: callq   _callee_vararg
  %v = call i32(...) @callee_vararg(i32 42, double 500.0) "statepoint-id"="4243" [ "deopt"(i32 16) ]
  ret i32 %v
}

define i32 @invoker_0() personality i8 0 {
; CHECK-LABEL: _invoker_0
entry:
  %v = invoke i32 @callee_0() [ "deopt"(i32 2) ]
          to label %normal unwind label %uw

normal:
  ret i32 %v

uw:
  %ehvals = landingpad { ptr, i32 }
      cleanup
  ret i32 1
; CHECK:	callq	_callee_0
; CHECK:	popq	%rcx
; CHECK:	retq
; CHECK:	movl	$1, %eax
; CHECK:	popq	%rcx
; CHECK:	retq
}

define i32 @invoker_1() personality i8 0 {
; CHECK-LABEL: _invoker_1
entry:
  %v = invoke i32 @callee_1(i32 45) "statepoint-num-patch-bytes"="9" [ "deopt"(i32 3) ]
          to label %normal unwind label %uw

normal:
  ret i32 %v

uw:
  %ehvals = landingpad { ptr, i32 }
      cleanup
  ret i32 1
; CHECK:	movl	$45, %edi
; CHECK:	nopw    512(%rax,%rax)
; CHECK:	popq	%rcx
; CHECK:	retq
; CHECK:	movl	$1, %eax
; CHECK:	popq	%rcx
; CHECK:	retq
}

define i32 @invoker_2() personality ptr @__CxxFrameHandler3 {
entry:
  %val = invoke i32 @callee_1(i32 1)
          to label %try.cont unwind label %catch.dispatch

catch.dispatch:
  %cs1 = catchswitch within none [label %catch] unwind to caller

catch:
  %cp1 = catchpad within %cs1 [ptr null, i32 64, ptr null]
  %val2 = call i32 @callee_1(i32 100) "statepoint-id"="4243" [ "funclet"(token %cp1), "deopt"(i32 55) ]
  catchret from %cp1 to label %try.cont

try.cont:
  ret i32 0
}

declare i32 @__CxxFrameHandler3(...)

define void @f_0(i64 %n) {
  ; CHECK-LABEL: _f_0
  %s = alloca i64
  %vl = alloca i64, i64 %n
  ; Check that the stackmap does not reference %s through
  ; SP since the offset is not static because of %vl.
  ; STACKMAPS: Loc 3: Direct 6
  call void @g_0(ptr %vl) [ "deopt"(ptr %s) ]
  ret void
}

declare void @g_0(ptr %vl)

define void @vector_deopt_bundle(<32 x ptr addrspace(1)> %val) {
; CHECK-LABEL: _vector_deopt_bundle:
; CHECK: movaps  16(%rbp), %xmm8
; CHECK-NEXT: movaps  32(%rbp), %xmm9
; CHECK-NEXT: movaps  48(%rbp), %xmm10
; CHECK-NEXT: movaps  64(%rbp), %xmm11
; CHECK-NEXT: movaps  80(%rbp), %xmm12
; CHECK-NEXT: movaps  96(%rbp), %xmm13
; CHECK-NEXT: movaps  112(%rbp), %xmm14
; CHECK-NEXT: movaps  128(%rbp), %xmm15
; CHECK-NEXT: movaps  %xmm15, 240(%rsp)
; CHECK-NEXT: movaps  %xmm14, 224(%rsp)
; CHECK-NEXT: movaps  %xmm13, 208(%rsp)
; CHECK-NEXT: movaps  %xmm12, 192(%rsp)
; CHECK-NEXT: movaps  %xmm11, 176(%rsp)
; CHECK-NEXT: movaps  %xmm10, 160(%rsp)
; CHECK-NEXT: movaps  %xmm9, 144(%rsp)
; CHECK-NEXT: movaps  %xmm8, 128(%rsp)
; CHECK-NEXT: movaps  %xmm7, 112(%rsp)
; CHECK-NEXT: movaps  %xmm6, 96(%rsp)
; CHECK-NEXT: movaps  %xmm5, 80(%rsp)
; CHECK-NEXT: movaps  %xmm4, 64(%rsp)
; CHECK-NEXT: movaps  %xmm3, 48(%rsp)
; CHECK-NEXT: movaps  %xmm2, 32(%rsp)
; CHECK-NEXT: movaps  %xmm1, 16(%rsp)
; CHECK-NEXT: movaps  %xmm0, (%rsp)
  call void @unknown() [ "deopt"(<32 x ptr addrspace(1)> %val) ]
  ret void
; STACKMAPS: Stack Maps: callsite 2882400015
; STACKMAPS-NEXT: Stack Maps:   has 4 locations
; STACKMAPS-NEXT: Stack Maps: 		Loc 0: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 1: Constant 0	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 		Loc 2: Constant 1	[encoding: .byte 4, .byte 0, .short 8, .short 0, .short 0, .int 1]
; STACKMAPS-NEXT: Stack Maps: 		Loc 3: Indirect 7+0	[encoding: .byte 3, .byte 0, .short 256, .short 7, .short 0, .int 0]
; STACKMAPS-NEXT: Stack Maps: 	has 0 live-out registers
}

declare void @unknown()
