//===-- Implementation header of dladdr -------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIBC_SRC_DLFCN_DLADDR_H
#define LLVM_LIBC_SRC_DLFCN_DLADDR_H

#include "src/__support/macros/config.h"

#include "hdr/types/dl_info.h"

namespace LIBC_NAMESPACE_DECL {

int dladdr(const void *__restrict, Dl_info *__restrict);

} // namespace LIBC_NAMESPACE_DECL

#endif // LLVM_LIBC_SRC_DLFCN_DLADDR_H
