<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

December 7, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [ ] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Nick Shaw - Antler Post

Apologies:
  * Mei Chu

# **OCIO TSC Meeting Notes**

* Doug to summarize in-progress work:
    - Doug: With regard to categories, looking at issue (#1222). Idea to 
      improve app helpers code to implement improved category mechanism.
    - Other work in progress:
        - Color space alias mechanism. Seemed to be good consensus on this 
          being helpful.
        - Improve list of builtin transforms in support of ACES.
        - Various bug fixes.
    - Michael: Any feedback so far on OCIO v2 testing?
    - Doug: Not as much as we would like - a risk factor on release. Wondering
      what we can do to improve that situation. Draft PR for OFX plugin arrived 
      yesterday. Still ways from being done, but could get us more testing upon 
      completion. Chicken and egg situation.
    - Michael: Any studios here tested it out?
    - Kevin: Not that I'm aware of [at Framestore]. Have used commandline stuff.
    - Michael: Might be worth starting ocio-dev thread to invite people to beta 
      test. Could mention what needs feedback and provide more details.
    - **TODO**: Michael and Doug will draft ocio-dev thread to reiterate beta 
      testing. 
    - Mark T: We have started testing it, but off for break. In new year will 
      hope to have something. End of January-ish.
    - Kevin: Talked to Nigel about work done there so far. Suggested demoing 
      the work for the TSC.
    - Michael: We're happy to set up a Zoom meeting if that's helpful, to give
      feedback. Will help once we have UX working group up and running.

* Frozen doc generation platform differences and difference threshold:
    - Michael: See PR #1197 for explanation, but faced challenge with frozen 
      docs differing between platforms, due to subtle naming differences from
      the C++ side. Implemented fuzzy matching to pass/fail CI based on 
      difference threshold, which isn't ideal, but will work for now. Should 
      probably limit freezing to Linux builds only since that's what RTD uses.
      Any objections to the current RST freezing workflow?
    - Doug: May impact developers. Have to build docs and run python 3 to pass 
      CI. 
    - Michael: True. Alternative solution was to store CI build artifacts in an 
      S3 bucket and download those during RTD build, but current ASWF S3 bucket 
      is not public and requires secrets to access. Would need another setup.
    - Mark B: Good first step to get in the door. Good for now. Not such a bad 
      thing.
    - Doug: Huge step forward in process. Have looked at review. Think we 
      should merge it, and do follow ups.
    - **TODO**: Michael to talk to Lf and/or RTD about plans for future 
      CMake/compiler support. Would remove need for these workarounds.

* Categories, continued discussion (Issue #1222)
    - Doug: To summarize, we're proposing making the 3 changes listed in 
      summary of issue #1222.
    - Doug: Documenting these initial categories would not be part of the 
      initial PR. any questions?
    - Kevin: The names we give these things have to be really bulletproof about 
      what they mean, or leave it up to the apps to tell us what to look for. 
      Would make is straightforward to link apps and config. May need default 
      set of terms, but need to be careful to say what they mean.
    - Doug: If we don't companies will come up with their own and could make 
      the list much longer if everyone has different name for same thing. Will 
      be differences between apps, so not clear cut.
    - Carol: Can we reach out to some subsets of apps, Foundry, AD, and others 
      (Black Magic) and ask what their preferences would be?
    - Doug: Proposed these from an app point of view. These three seemed like 
      they would be common menus. Proposed starting point. 
    - Carol: Would be worthwhile to show to Foundry and others.
    - Mark T: I can show this and discuss internally.
    - Mark B: We could agree on the categories, but the list is large and some 
      are not represented in this meeting. Felt that empowering users to always 
      set it is the only answer. Would allow all needed workflows; up to config 
      author if they want to tag them as disciplines or tag based on 
      functionality.
    - Carol: What would we do for ACES studio config?
    - Mark B: That will come up in that working group discussion. Should expect 
      the default case to be a user telling a DCC what category is assigned to 
      what drop down menu.
    - Doug: That would be the ultimate in flexibility. Does impose more work on 
      app vendors - that customization, and not everyone may do it.
    - Kevin: If we had that and same default terms. Would need map between apps 
      and what they need to know about. Also other cases where rules were used 
      in past. Becomes open ended at some point. Sometimes we have SG task or 
      process step that tells the app why the user is loading it: tracking, 
      lighting, etc. In that case, doing it in one config would be difficult.
    - Mark: If you want artist based workflow, tag those, but still up to app 
      to associate the tags with menus. Need app preferences of which category 
      to assign to specific menus.
    - Kevin: That's almost a different table of mappings.
    - Mark: Or a different config per DCC, which we would likely not have.
    - Doug: In terms of proposed code, app helpers implements possibility to 
      pass in two categories and do a join/intersection. Initial PR doesn't 
      need to sort out question of recommended categories or not, or if users 
      should be able to customize menus. Talked about UX working group, that 
      would be a topic to wrestle with.
    - Mark: Current proposed work seems fine and mergeable then. Would be great 
      if working group result would be PR into app helpers. Already a place to 
      point to for DCC authors to buy into. Almost outside our scope, 
      encouraging apps to save these options. 
    - Michael: We have one volunteer to lead the UX group, but would like to 
      have a second to balance the work. If anyone is interested place reach 
      out.
    - Carol: Definitely want to be part of it.
    - Kevin: In response to Zach's comment in issue: Not sure I'm enamoured by 
      the suggested do-not-use approach. If going to have a feature it should 
      be explicit.
    - Doug: Will make PR and have concrete stuff to review. For purposes of 
      docs, what we can take these menu and artist categories and include them 
      in docs as examples. Make it clear it's open to what users want.
    - Carol: Agree.
    - Doug: Can use OFX plugin as prototype. Can have field in plugin for 
      categories to use, and users can type different things. Can anyone 
      provide some help on this OFX work? It's an important step for 
      testing.
    - Mark T: Spoke to some at Foundry. Many involved in OFX no longer there, 
      but some could help with specific questions. Reached out to contributor 
      after previous TSC meeting about build issues and got that fixed. Tried 
      examples on my end and worked fine. Just had bad flag. Definitely 
      potential for help from engineers at Foundry.
    - Michael: I can help with guidance too. I'll have a look at the PR.
