# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.policyinsights import PolicyInsightsClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-policyinsights
# USAGE
    python attestations_create_resource_group_scope.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = PolicyInsightsClient(
        credential=DefaultAzureCredential(),
        subscription_id="35ee058e-5fa0-414c-8145-3ebb8d09b6e2",
    )

    response = client.attestations.begin_create_or_update_at_resource_group(
        resource_group_name="myRg",
        attestation_name="790996e6-9871-4b1f-9cd9-ec42cd6ced1e",
        parameters={
            "properties": {
                "assessmentDate": "2021-06-10T00:00:00Z",
                "comments": "This subscription has passed a security audit.",
                "complianceState": "Compliant",
                "evidence": [
                    {
                        "description": "The results of the security audit.",
                        "sourceUri": "https://gist.github.com/contoso/9573e238762c60166c090ae16b814011",
                    }
                ],
                "expiresOn": "2021-06-15T00:00:00Z",
                "metadata": {"departmentId": "NYC-MARKETING-1"},
                "owner": "55a32e28-3aa5-4eea-9b5a-4cd85153b966",
                "policyAssignmentId": "/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5",
                "policyDefinitionReferenceId": "0b158b46-ff42-4799-8e39-08a5c23b4551",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2024-10-01/examples/Attestations_CreateResourceGroupScope.json
if __name__ == "__main__":
    main()
