import sys
from argparse import Namespace

import generate_control
from config import Signing


class SigningMock:
    def __init__(self):
        self.flavour_archs = {}
        self.arch_flavour_data = {}

    def package_flavour_archs(self, key):
        return self.flavour_archs.get(key, [])


def test_gen_depends_uci_none(capfd):
    signing = SigningMock()
    generate_control.gen_depends_uci(signing)

    out, err = capfd.readouterr()
    assert out == ""


def test_gen_depends_uci_cvm(capfd):
    signing = SigningMock()
    signing.flavour_archs["cvm"] = (("", ["amd64"]), ("", ["arm64"]))
    generate_control.gen_depends_uci(signing)

    out, err = capfd.readouterr()
    assert out == " ubuntu-core-initramfs [amd64 arm64] <pkg.linux-generate>,\n"


def test_gen_depends_uci_cvm_uc(capfd):
    signing = SigningMock()
    signing.flavour_archs["cvm"] = (("", ["amd64"]),)
    signing.flavour_archs["uc"] = (("", ["arm64"]),)
    generate_control.gen_depends_uci(signing)

    out, err = capfd.readouterr()
    assert out == " ubuntu-core-initramfs [amd64 arm64] <pkg.linux-generate>,\n"


def test_main(capfd):
    args = Namespace()
    args.series = "oracular"
    args.source_name = "linux-signed"
    args.generate_name = "linux-generate"
    args.source_version = "6.11.0-8.8"
    args.unsigned_name = "linux"
    args.unsigned_version = "6.11.0-8.8"
    args.abi_version = "6.11.0-8"

    sys.stdin = open("debian/control.stub")
    generate_control.main(Signing.load("debian/package.config"), args)

    expected_output = """Source: linux-signed
Section: kernel
Priority: optional
Maintainer: Canonical Kernel Team <kernel-team@lists.ubuntu.com>
Build-Depends:
 debhelper (>= 9),
 lsb-release,
 python3,
 python3-apt,
Build-Depends-Arch:
 linux-image-unsigned-6.11.0-8-generic (= 6.11.0-8.8) [amd64 arm64 s390x],
 linux-buildinfo-6.11.0-8-generic (= 6.11.0-8.8) [amd64 arm64 s390x],
 linux-image-unsigned-6.11.0-8-generic-64k (= 6.11.0-8.8) [arm64],
 linux-buildinfo-6.11.0-8-generic-64k (= 6.11.0-8.8) [arm64],
 ubuntu-core-initramfs [amd64 arm64] <pkg.linux-generate>,
 linux-generate (= 6.11.0-8.8) <!pkg.linux-generate>,
 linux-modules-extra-6.11.0-8-generic (= 6.11.0-8.8) [amd64 arm64]  <pkg.linux-generate>,
 sbsigntool [amd64 arm64],
 openssl,
Standards-Version: 3.9.4

Package: linux-image-6.11.0-8-generic
Architecture: amd64 arm64 s390x
Depends: ${unsigned:Depends}
Recommends: ${unsigned:Recommends}
Suggests: ${unsigned:Suggests}
Conflicts: ${unsigned:Conflicts}
Provides: ${unsigned:Provides}
Built-Using: linux (= 6.11.0-8.8)
Description: Signed kernel image generic
 A kernel image for generic.  This version of it is signed with
 Canonical's signing key.

Package: linux-image-6.11.0-8-generic-64k
Architecture: arm64
Depends: ${unsigned:Depends}
Recommends: ${unsigned:Recommends}
Suggests: ${unsigned:Suggests}
Conflicts: ${unsigned:Conflicts}
Provides: ${unsigned:Provides}
Built-Using: linux (= 6.11.0-8.8)
Description: Signed kernel image generic-64k
 A kernel image for generic-64k.  This version of it is signed with
 Canonical's signing key.

Package: linux-image-uc-6.11.0-8-generic
Architecture: amd64 arm64
Depends: linux-modules-6.11.0-8-generic, linux-modules-extra-6.11.0-8-generic [amd64 arm64]
Built-Using: linux (= 6.11.0-8.8)
Description: Signed kernel image generic for Ubuntu Core
 A kernel image for generic.  This version of it is signed with
 Canonical's signing key.

Package: linux-image-uc-6.11.0-8-generic-64k
Architecture: arm64
Depends: linux-modules-6.11.0-8-generic-64k
Built-Using: linux (= 6.11.0-8.8)
Description: Signed kernel image generic-64k for Ubuntu Core
 A kernel image for generic-64k.  This version of it is signed with
 Canonical's signing key.

Package: linux-image-6.11.0-8-generic-dbgsym
Section: devel
Architecture: amd64 arm64 s390x
Depends: linux-image-unsigned-6.11.0-8-generic-dbgsym
Description: Signed kernel image generic
 A link to the debugging symbols for the generic signed kernel.

Package: linux-image-6.11.0-8-generic-64k-dbgsym
Section: devel
Architecture: arm64
Depends: linux-image-unsigned-6.11.0-8-generic-64k-dbgsym
Description: Signed kernel image generic-64k
 A link to the debugging symbols for the generic-64k signed kernel.
"""

    out, err = capfd.readouterr()
    assert out == expected_output
