// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{SvgFeatures, SymbolicPaintable, ffi};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSvg")]
    pub struct Svg(Object<ffi::GtkSvg, ffi::GtkSvgClass>) @implements gdk::Paintable, SymbolicPaintable;

    match fn {
        type_ => || ffi::gtk_svg_get_type(),
    }
}

impl Svg {
    #[doc(alias = "gtk_svg_new")]
    pub fn new() -> Svg {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_svg_new()) }
    }

    #[doc(alias = "gtk_svg_new_from_bytes")]
    #[doc(alias = "new_from_bytes")]
    pub fn from_bytes(bytes: &glib::Bytes) -> Svg {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_svg_new_from_bytes(bytes.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_svg_new_from_resource")]
    #[doc(alias = "new_from_resource")]
    pub fn from_resource(path: &str) -> Svg {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_svg_new_from_resource(path.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_svg_get_features")]
    #[doc(alias = "get_features")]
    pub fn features(&self) -> SvgFeatures {
        unsafe { from_glib(ffi::gtk_svg_get_features(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_svg_get_n_states")]
    #[doc(alias = "get_n_states")]
    pub fn n_states(&self) -> u32 {
        unsafe { ffi::gtk_svg_get_n_states(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_svg_get_state")]
    #[doc(alias = "get_state")]
    pub fn state(&self) -> u32 {
        unsafe { ffi::gtk_svg_get_state(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_svg_get_weight")]
    #[doc(alias = "get_weight")]
    pub fn weight(&self) -> f64 {
        unsafe { ffi::gtk_svg_get_weight(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_svg_load_from_bytes")]
    pub fn load_from_bytes(&self, bytes: &glib::Bytes) {
        unsafe {
            ffi::gtk_svg_load_from_bytes(self.to_glib_none().0, bytes.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_svg_load_from_resource")]
    pub fn load_from_resource(&self, path: &str) {
        unsafe {
            ffi::gtk_svg_load_from_resource(self.to_glib_none().0, path.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_svg_pause")]
    pub fn pause(&self) {
        unsafe {
            ffi::gtk_svg_pause(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_svg_play")]
    pub fn play(&self) {
        unsafe {
            ffi::gtk_svg_play(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_svg_serialize")]
    pub fn serialize(&self) -> glib::Bytes {
        unsafe { from_glib_full(ffi::gtk_svg_serialize(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_svg_set_features")]
    #[doc(alias = "features")]
    pub fn set_features(&self, features: SvgFeatures) {
        unsafe {
            ffi::gtk_svg_set_features(self.to_glib_none().0, features.into_glib());
        }
    }

    #[doc(alias = "gtk_svg_set_frame_clock")]
    pub fn set_frame_clock(&self, clock: &gdk::FrameClock) {
        unsafe {
            ffi::gtk_svg_set_frame_clock(self.to_glib_none().0, clock.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_svg_set_state")]
    #[doc(alias = "state")]
    pub fn set_state(&self, state: u32) {
        unsafe {
            ffi::gtk_svg_set_state(self.to_glib_none().0, state);
        }
    }

    #[doc(alias = "gtk_svg_set_weight")]
    #[doc(alias = "weight")]
    pub fn set_weight(&self, weight: f64) {
        unsafe {
            ffi::gtk_svg_set_weight(self.to_glib_none().0, weight);
        }
    }

    #[doc(alias = "gtk_svg_write_to_file")]
    pub fn write_to_file(&self, filename: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gtk_svg_write_to_file(
                self.to_glib_none().0,
                filename.to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    pub fn is_playing(&self) -> bool {
        ObjectExt::property(self, "playing")
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    pub fn set_playing(&self, playing: bool) {
        ObjectExt::set_property(self, "playing", playing)
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    pub fn resource(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "resource")
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    pub fn set_resource(&self, resource: Option<&str>) {
        ObjectExt::set_property(self, "resource", resource)
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "error")]
    pub fn connect_error<F: Fn(&Self, &glib::Error) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn error_trampoline<F: Fn(&Svg, &glib::Error) + 'static>(
            this: *mut ffi::GtkSvg,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), &from_glib_borrow(error))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"error".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "features")]
    pub fn connect_features_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_features_trampoline<F: Fn(&Svg) + 'static>(
            this: *mut ffi::GtkSvg,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::features".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_features_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "playing")]
    pub fn connect_playing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_playing_trampoline<F: Fn(&Svg) + 'static>(
            this: *mut ffi::GtkSvg,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::playing".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_playing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "resource")]
    pub fn connect_resource_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resource_trampoline<F: Fn(&Svg) + 'static>(
            this: *mut ffi::GtkSvg,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::resource".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_resource_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "state")]
    pub fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_trampoline<F: Fn(&Svg) + 'static>(
            this: *mut ffi::GtkSvg,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::state".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "weight")]
    pub fn connect_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_trampoline<F: Fn(&Svg) + 'static>(
            this: *mut ffi::GtkSvg,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::weight".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_weight_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v4_22")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
impl Default for Svg {
    fn default() -> Self {
        Self::new()
    }
}
