// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;
using System.Numerics;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.X86;
using Xunit;

// Generated by Fuzzlyn v2.2 on 2024-08-04 14:56:48
// Run on X64 Linux
// Seed: 9948973805593331013-vectort,vector128,vector256,vector512,x86aes,x86avx,x86avx2,x86avx512bw,x86avx512bwvl,x86avx512cd,x86avx512cdvl,x86avx512dq,x86avx512dqvl,x86avx512f,x86avx512fvl,x86avx512fx64,x86avx512vbmi,x86avx512vbmivl,x86bmi1,x86bmi1x64,x86bmi2,x86bmi2x64,x86fma,x86lzcnt,x86lzcntx64,x86pclmulqdq,x86popcnt,x86popcntx64,x86sse,x86ssex64,x86sse2,x86sse2x64,x86sse3,x86sse41,x86sse41x64,x86sse42,x86sse42x64,x86ssse3,x86x86base
// Reduced from 36.9 KiB to 0.8 KiB in 00:01:07
// Debug: Outputs <0, 0, 0, 0, 0, 0, 0, 0>
// Release: Outputs <1, 0, 0, 0, 0, 0, 0, 0>

public class Runtime_105966
{
    public static ulong s_3 = 0;

    [Fact]
    public static void TestEntryPoint()
    {
        if (Avx512F.IsSupported)
        {
            var vr4 = Vector512.Create<ulong>(s_3);
            var vr5 = M4();
            var vr6 = Vector512.CreateScalar(vr5); 
            Vector512<ulong> vr7 = Avx512F.Min(vr4, vr6);
            Vector512<ulong> expected = Vector512.Create((ulong)0);
            Assert.Equal(expected, vr7);
        }
    }

    public static ulong M4()
    {
        ulong vr8 = s_3++;
        return s_3;
    }
}
