# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class DataConnectorsCheckRequirements(_serialization.Model):
    """Data connector requirements properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AwsCloudTrailCheckRequirements, AwsS3CheckRequirements, AADCheckRequirements,
    AATPCheckRequirements, ASCCheckRequirements, Dynamics365CheckRequirements,
    IoTCheckRequirements, MCASCheckRequirements, MDATPCheckRequirements, MSTICheckRequirements,
    MtpCheckRequirements, Office365ProjectCheckRequirements, OfficeATPCheckRequirements,
    OfficeIRMCheckRequirements, OfficePowerBICheckRequirements, TICheckRequirements,
    TiTaxiiCheckRequirements

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "AmazonWebServicesCloudTrail": "AwsCloudTrailCheckRequirements",
            "AmazonWebServicesS3": "AwsS3CheckRequirements",
            "AzureActiveDirectory": "AADCheckRequirements",
            "AzureAdvancedThreatProtection": "AATPCheckRequirements",
            "AzureSecurityCenter": "ASCCheckRequirements",
            "Dynamics365": "Dynamics365CheckRequirements",
            "IOT": "IoTCheckRequirements",
            "MicrosoftCloudAppSecurity": "MCASCheckRequirements",
            "MicrosoftDefenderAdvancedThreatProtection": "MDATPCheckRequirements",
            "MicrosoftThreatIntelligence": "MSTICheckRequirements",
            "MicrosoftThreatProtection": "MtpCheckRequirements",
            "Office365Project": "Office365ProjectCheckRequirements",
            "OfficeATP": "OfficeATPCheckRequirements",
            "OfficeIRM": "OfficeIRMCheckRequirements",
            "OfficePowerBI": "OfficePowerBICheckRequirements",
            "ThreatIntelligence": "TICheckRequirements",
            "ThreatIntelligenceTaxii": "TiTaxiiCheckRequirements",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class AADCheckRequirements(DataConnectorsCheckRequirements):
    """Represents AAD (Azure Active Directory) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "AzureActiveDirectory"
        self.tenant_id = tenant_id


class DataConnectorTenantId(_serialization.Model):
    """Properties data connector on tenant level.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id


class AADCheckRequirementsProperties(DataConnectorTenantId):
    """AAD (Azure Active Directory) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ResourceWithEtag(Resource):
    """An azure resource object with an Etag property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.etag = etag


class DataConnector(ResourceWithEtag):
    """Data connector.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CodelessApiPollingDataConnector, AwsCloudTrailDataConnector, AwsS3DataConnector,
    AADDataConnector, AATPDataConnector, ASCDataConnector, Dynamics365DataConnector,
    CodelessUiDataConnector, IoTDataConnector, MCASDataConnector, MDATPDataConnector,
    MSTIDataConnector, MTPDataConnector, OfficeDataConnector, Office365ProjectDataConnector,
    OfficeATPDataConnector, OfficeIRMDataConnector, OfficePowerBIDataConnector, TIDataConnector,
    TiTaxiiDataConnector

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "APIPolling": "CodelessApiPollingDataConnector",
            "AmazonWebServicesCloudTrail": "AwsCloudTrailDataConnector",
            "AmazonWebServicesS3": "AwsS3DataConnector",
            "AzureActiveDirectory": "AADDataConnector",
            "AzureAdvancedThreatProtection": "AATPDataConnector",
            "AzureSecurityCenter": "ASCDataConnector",
            "Dynamics365": "Dynamics365DataConnector",
            "GenericUI": "CodelessUiDataConnector",
            "IOT": "IoTDataConnector",
            "MicrosoftCloudAppSecurity": "MCASDataConnector",
            "MicrosoftDefenderAdvancedThreatProtection": "MDATPDataConnector",
            "MicrosoftThreatIntelligence": "MSTIDataConnector",
            "MicrosoftThreatProtection": "MTPDataConnector",
            "Office365": "OfficeDataConnector",
            "Office365Project": "Office365ProjectDataConnector",
            "OfficeATP": "OfficeATPDataConnector",
            "OfficeIRM": "OfficeIRMDataConnector",
            "OfficePowerBI": "OfficePowerBIDataConnector",
            "ThreatIntelligence": "TIDataConnector",
            "ThreatIntelligenceTaxii": "TiTaxiiDataConnector",
        }
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: Optional[str] = None


class AADDataConnector(DataConnector):
    """Represents AAD (Azure Active Directory) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AlertsDataTypeOfDataConnector"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "AzureActiveDirectory"
        self.tenant_id = tenant_id
        self.data_types = data_types


class DataConnectorWithAlertsProperties(_serialization.Model):
    """Data connector properties.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "AlertsDataTypeOfDataConnector"},
    }

    def __init__(self, *, data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None, **kwargs):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super().__init__(**kwargs)
        self.data_types = data_types


class AADDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """AAD (Azure Active Directory) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self, *, tenant_id: str, data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None, **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class AATPCheckRequirements(DataConnectorsCheckRequirements):
    """Represents AATP (Azure Advanced Threat Protection) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "AzureAdvancedThreatProtection"
        self.tenant_id = tenant_id


class AATPCheckRequirementsProperties(DataConnectorTenantId):
    """AATP (Azure Advanced Threat Protection) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class AATPDataConnector(DataConnector):
    """Represents AATP (Azure Advanced Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AlertsDataTypeOfDataConnector"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "AzureAdvancedThreatProtection"
        self.tenant_id = tenant_id
        self.data_types = data_types


class AATPDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """AATP (Azure Advanced Threat Protection) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self, *, tenant_id: str, data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None, **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class Entity(Resource):
    """Specific entity.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AccountEntity, AzureResourceEntity, HuntingBookmark, CloudApplicationEntity, DnsEntity,
    FileEntity, FileHashEntity, HostEntity, IoTDeviceEntity, IpEntity, MailClusterEntity,
    MailMessageEntity, MailboxEntity, MalwareEntity, NicEntity, ProcessEntity, RegistryKeyEntity,
    RegistryValueEntity, SecurityAlert, SecurityGroupEntity, SubmissionMailEntity, UrlEntity

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "Account": "AccountEntity",
            "AzureResource": "AzureResourceEntity",
            "Bookmark": "HuntingBookmark",
            "CloudApplication": "CloudApplicationEntity",
            "DnsResolution": "DnsEntity",
            "File": "FileEntity",
            "FileHash": "FileHashEntity",
            "Host": "HostEntity",
            "IoTDevice": "IoTDeviceEntity",
            "Ip": "IpEntity",
            "MailCluster": "MailClusterEntity",
            "MailMessage": "MailMessageEntity",
            "Mailbox": "MailboxEntity",
            "Malware": "MalwareEntity",
            "Nic": "NicEntity",
            "Process": "ProcessEntity",
            "RegistryKey": "RegistryKeyEntity",
            "RegistryValue": "RegistryValueEntity",
            "SecurityAlert": "SecurityAlert",
            "SecurityGroup": "SecurityGroupEntity",
            "SubmissionMail": "SubmissionMailEntity",
            "Url": "UrlEntity",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class AccountEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents an account entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar aad_tenant_id: The Azure Active Directory tenant id.
    :vartype aad_tenant_id: str
    :ivar aad_user_id: The Azure Active Directory user id.
    :vartype aad_user_id: str
    :ivar account_name: The name of the account. This field should hold only the name without any
     domain added to it, i.e. administrator.
    :vartype account_name: str
    :ivar display_name: The display name of the account.
    :vartype display_name: str
    :ivar host_entity_id: The Host entity id that contains the account in case it is a local
     account (not domain joined).
    :vartype host_entity_id: str
    :ivar is_domain_joined: Determines whether this is a domain account.
    :vartype is_domain_joined: bool
    :ivar nt_domain: The NetBIOS domain name as it appears in the alert format - domain/username.
     Examples: NT AUTHORITY.
    :vartype nt_domain: str
    :ivar object_guid: The objectGUID attribute is a single-value attribute that is the unique
     identifier for the object, assigned by active directory.
    :vartype object_guid: str
    :ivar puid: The Azure Active Directory Passport User ID.
    :vartype puid: str
    :ivar sid: The account security identifier, e.g. S-1-5-18.
    :vartype sid: str
    :ivar upn_suffix: The user principal name suffix for the account, in some cases it is also the
     domain name. Examples: contoso.com.
    :vartype upn_suffix: str
    :ivar dns_domain: The fully qualified domain DNS name.
    :vartype dns_domain: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "aad_tenant_id": {"readonly": True},
        "aad_user_id": {"readonly": True},
        "account_name": {"readonly": True},
        "display_name": {"readonly": True},
        "host_entity_id": {"readonly": True},
        "is_domain_joined": {"readonly": True},
        "nt_domain": {"readonly": True},
        "object_guid": {"readonly": True},
        "puid": {"readonly": True},
        "sid": {"readonly": True},
        "upn_suffix": {"readonly": True},
        "dns_domain": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "aad_tenant_id": {"key": "properties.aadTenantId", "type": "str"},
        "aad_user_id": {"key": "properties.aadUserId", "type": "str"},
        "account_name": {"key": "properties.accountName", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "host_entity_id": {"key": "properties.hostEntityId", "type": "str"},
        "is_domain_joined": {"key": "properties.isDomainJoined", "type": "bool"},
        "nt_domain": {"key": "properties.ntDomain", "type": "str"},
        "object_guid": {"key": "properties.objectGuid", "type": "str"},
        "puid": {"key": "properties.puid", "type": "str"},
        "sid": {"key": "properties.sid", "type": "str"},
        "upn_suffix": {"key": "properties.upnSuffix", "type": "str"},
        "dns_domain": {"key": "properties.dnsDomain", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "Account"
        self.additional_data = None
        self.friendly_name = None
        self.aad_tenant_id = None
        self.aad_user_id = None
        self.account_name = None
        self.display_name = None
        self.host_entity_id = None
        self.is_domain_joined = None
        self.nt_domain = None
        self.object_guid = None
        self.puid = None
        self.sid = None
        self.upn_suffix = None
        self.dns_domain = None


class EntityCommonProperties(_serialization.Model):
    """Entity common property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.additional_data = None
        self.friendly_name = None


class AccountEntityProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Account entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar aad_tenant_id: The Azure Active Directory tenant id.
    :vartype aad_tenant_id: str
    :ivar aad_user_id: The Azure Active Directory user id.
    :vartype aad_user_id: str
    :ivar account_name: The name of the account. This field should hold only the name without any
     domain added to it, i.e. administrator.
    :vartype account_name: str
    :ivar display_name: The display name of the account.
    :vartype display_name: str
    :ivar host_entity_id: The Host entity id that contains the account in case it is a local
     account (not domain joined).
    :vartype host_entity_id: str
    :ivar is_domain_joined: Determines whether this is a domain account.
    :vartype is_domain_joined: bool
    :ivar nt_domain: The NetBIOS domain name as it appears in the alert format - domain/username.
     Examples: NT AUTHORITY.
    :vartype nt_domain: str
    :ivar object_guid: The objectGUID attribute is a single-value attribute that is the unique
     identifier for the object, assigned by active directory.
    :vartype object_guid: str
    :ivar puid: The Azure Active Directory Passport User ID.
    :vartype puid: str
    :ivar sid: The account security identifier, e.g. S-1-5-18.
    :vartype sid: str
    :ivar upn_suffix: The user principal name suffix for the account, in some cases it is also the
     domain name. Examples: contoso.com.
    :vartype upn_suffix: str
    :ivar dns_domain: The fully qualified domain DNS name.
    :vartype dns_domain: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "aad_tenant_id": {"readonly": True},
        "aad_user_id": {"readonly": True},
        "account_name": {"readonly": True},
        "display_name": {"readonly": True},
        "host_entity_id": {"readonly": True},
        "is_domain_joined": {"readonly": True},
        "nt_domain": {"readonly": True},
        "object_guid": {"readonly": True},
        "puid": {"readonly": True},
        "sid": {"readonly": True},
        "upn_suffix": {"readonly": True},
        "dns_domain": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "aad_tenant_id": {"key": "aadTenantId", "type": "str"},
        "aad_user_id": {"key": "aadUserId", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "host_entity_id": {"key": "hostEntityId", "type": "str"},
        "is_domain_joined": {"key": "isDomainJoined", "type": "bool"},
        "nt_domain": {"key": "ntDomain", "type": "str"},
        "object_guid": {"key": "objectGuid", "type": "str"},
        "puid": {"key": "puid", "type": "str"},
        "sid": {"key": "sid", "type": "str"},
        "upn_suffix": {"key": "upnSuffix", "type": "str"},
        "dns_domain": {"key": "dnsDomain", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.aad_tenant_id = None
        self.aad_user_id = None
        self.account_name = None
        self.display_name = None
        self.host_entity_id = None
        self.is_domain_joined = None
        self.nt_domain = None
        self.object_guid = None
        self.puid = None
        self.sid = None
        self.upn_suffix = None
        self.dns_domain = None


class ActionPropertiesBase(_serialization.Model):
    """Action property bag base.

    All required parameters must be populated in order to send to Azure.

    :ivar logic_app_resource_id: Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
     Required.
    :vartype logic_app_resource_id: str
    """

    _validation = {
        "logic_app_resource_id": {"required": True},
    }

    _attribute_map = {
        "logic_app_resource_id": {"key": "logicAppResourceId", "type": "str"},
    }

    def __init__(self, *, logic_app_resource_id: str, **kwargs):
        """
        :keyword logic_app_resource_id: Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
         Required.
        :paramtype logic_app_resource_id: str
        """
        super().__init__(**kwargs)
        self.logic_app_resource_id = logic_app_resource_id


class ActionRequest(ResourceWithEtag):
    """Action for alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar logic_app_resource_id: Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
    :vartype logic_app_resource_id: str
    :ivar trigger_uri: Logic App Callback URL for this specific workflow.
    :vartype trigger_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "logic_app_resource_id": {"key": "properties.logicAppResourceId", "type": "str"},
        "trigger_uri": {"key": "properties.triggerUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        logic_app_resource_id: Optional[str] = None,
        trigger_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword logic_app_resource_id: Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
        :paramtype logic_app_resource_id: str
        :keyword trigger_uri: Logic App Callback URL for this specific workflow.
        :paramtype trigger_uri: str
        """
        super().__init__(etag=etag, **kwargs)
        self.logic_app_resource_id = logic_app_resource_id
        self.trigger_uri = trigger_uri


class ActionRequestProperties(ActionPropertiesBase):
    """Action property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar logic_app_resource_id: Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
     Required.
    :vartype logic_app_resource_id: str
    :ivar trigger_uri: Logic App Callback URL for this specific workflow. Required.
    :vartype trigger_uri: str
    """

    _validation = {
        "logic_app_resource_id": {"required": True},
        "trigger_uri": {"required": True},
    }

    _attribute_map = {
        "logic_app_resource_id": {"key": "logicAppResourceId", "type": "str"},
        "trigger_uri": {"key": "triggerUri", "type": "str"},
    }

    def __init__(self, *, logic_app_resource_id: str, trigger_uri: str, **kwargs):
        """
        :keyword logic_app_resource_id: Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
         Required.
        :paramtype logic_app_resource_id: str
        :keyword trigger_uri: Logic App Callback URL for this specific workflow. Required.
        :paramtype trigger_uri: str
        """
        super().__init__(logic_app_resource_id=logic_app_resource_id, **kwargs)
        self.trigger_uri = trigger_uri


class ActionResponse(ResourceWithEtag):
    """Action for alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar logic_app_resource_id: Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
    :vartype logic_app_resource_id: str
    :ivar workflow_id: The name of the logic app's workflow.
    :vartype workflow_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "logic_app_resource_id": {"key": "properties.logicAppResourceId", "type": "str"},
        "workflow_id": {"key": "properties.workflowId", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        logic_app_resource_id: Optional[str] = None,
        workflow_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword logic_app_resource_id: Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
        :paramtype logic_app_resource_id: str
        :keyword workflow_id: The name of the logic app's workflow.
        :paramtype workflow_id: str
        """
        super().__init__(etag=etag, **kwargs)
        self.logic_app_resource_id = logic_app_resource_id
        self.workflow_id = workflow_id


class ActionResponseProperties(ActionPropertiesBase):
    """Action property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar logic_app_resource_id: Logic App Resource Id,
     /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
     Required.
    :vartype logic_app_resource_id: str
    :ivar workflow_id: The name of the logic app's workflow.
    :vartype workflow_id: str
    """

    _validation = {
        "logic_app_resource_id": {"required": True},
    }

    _attribute_map = {
        "logic_app_resource_id": {"key": "logicAppResourceId", "type": "str"},
        "workflow_id": {"key": "workflowId", "type": "str"},
    }

    def __init__(self, *, logic_app_resource_id: str, workflow_id: Optional[str] = None, **kwargs):
        """
        :keyword logic_app_resource_id: Logic App Resource Id,
         /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
         Required.
        :paramtype logic_app_resource_id: str
        :keyword workflow_id: The name of the logic app's workflow.
        :paramtype workflow_id: str
        """
        super().__init__(logic_app_resource_id=logic_app_resource_id, **kwargs)
        self.workflow_id = workflow_id


class ActionsList(_serialization.Model):
    """List all the actions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of actions.
    :vartype next_link: str
    :ivar value: Array of actions. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.ActionResponse]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ActionResponse]"},
    }

    def __init__(self, *, value: List["_models.ActionResponse"], **kwargs):
        """
        :keyword value: Array of actions. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.ActionResponse]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class CustomEntityQuery(ResourceWithEtag):
    """Specific entity query that supports put requests.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActivityCustomEntityQuery

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: the entity query kind. Required. "Activity"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.CustomEntityQueryKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Activity": "ActivityCustomEntityQuery"}}

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: Optional[str] = None


class ActivityCustomEntityQuery(CustomEntityQuery):  # pylint: disable=too-many-instance-attributes
    """Represents Activity entity query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: the entity query kind. Required. "Activity"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.CustomEntityQueryKind
    :ivar title: The entity query title.
    :vartype title: str
    :ivar content: The entity query content to display in timeline.
    :vartype content: str
    :ivar description: The entity query description.
    :vartype description: str
    :ivar query_definitions: The Activity query definitions.
    :vartype query_definitions:
     ~azure.mgmt.securityinsight.models.ActivityEntityQueriesPropertiesQueryDefinitions
    :ivar input_entity_type: The type of the query's source entity. Known values are: "Account",
     "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware",
     "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
     "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail",
     and "Nic".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: List of the fields of the source entity that are required to
     run the query.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: dict[str, list[str]]
    :ivar template_name: The template id this activity was created from.
    :vartype template_name: str
    :ivar enabled: Determines whether this activity is enabled or disabled.
    :vartype enabled: bool
    :ivar created_time_utc: The time the activity was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The last time the activity was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "created_time_utc": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "content": {"key": "properties.content", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "query_definitions": {
            "key": "properties.queryDefinitions",
            "type": "ActivityEntityQueriesPropertiesQueryDefinitions",
        },
        "input_entity_type": {"key": "properties.inputEntityType", "type": "str"},
        "required_input_fields_sets": {"key": "properties.requiredInputFieldsSets", "type": "[[str]]"},
        "entities_filter": {"key": "properties.entitiesFilter", "type": "{[str]}"},
        "template_name": {"key": "properties.templateName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "created_time_utc": {"key": "properties.createdTimeUtc", "type": "iso-8601"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        title: Optional[str] = None,
        content: Optional[str] = None,
        description: Optional[str] = None,
        query_definitions: Optional["_models.ActivityEntityQueriesPropertiesQueryDefinitions"] = None,
        input_entity_type: Optional[Union[str, "_models.EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[Dict[str, List[str]]] = None,
        template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword title: The entity query title.
        :paramtype title: str
        :keyword content: The entity query content to display in timeline.
        :paramtype content: str
        :keyword description: The entity query description.
        :paramtype description: str
        :keyword query_definitions: The Activity query definitions.
        :paramtype query_definitions:
         ~azure.mgmt.securityinsight.models.ActivityEntityQueriesPropertiesQueryDefinitions
        :keyword input_entity_type: The type of the query's source entity. Known values are: "Account",
         "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware",
         "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
         "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail",
         and "Nic".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: List of the fields of the source entity that are required
         to run the query.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: dict[str, list[str]]
        :keyword template_name: The template id this activity was created from.
        :paramtype template_name: str
        :keyword enabled: Determines whether this activity is enabled or disabled.
        :paramtype enabled: bool
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Activity"
        self.title = title
        self.content = content
        self.description = description
        self.query_definitions = query_definitions
        self.input_entity_type = input_entity_type
        self.required_input_fields_sets = required_input_fields_sets
        self.entities_filter = entities_filter
        self.template_name = template_name
        self.enabled = enabled
        self.created_time_utc = None
        self.last_modified_time_utc = None


class ActivityEntityQueriesPropertiesQueryDefinitions(_serialization.Model):
    """The Activity query definitions.

    :ivar query: The Activity query to run on a given entity.
    :vartype query: str
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, *, query: Optional[str] = None, **kwargs):
        """
        :keyword query: The Activity query to run on a given entity.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.query = query


class EntityQuery(ResourceWithEtag):
    """Specific entity query.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActivityEntityQuery, ExpansionEntityQuery

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: the entity query kind. Required. Known values are: "Expansion", "Insight", and
     "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Activity": "ActivityEntityQuery", "Expansion": "ExpansionEntityQuery"}}

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: Optional[str] = None


class ActivityEntityQuery(EntityQuery):  # pylint: disable=too-many-instance-attributes
    """Represents Activity entity query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: the entity query kind. Required. Known values are: "Expansion", "Insight", and
     "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    :ivar title: The entity query title.
    :vartype title: str
    :ivar content: The entity query content to display in timeline.
    :vartype content: str
    :ivar description: The entity query description.
    :vartype description: str
    :ivar query_definitions: The Activity query definitions.
    :vartype query_definitions:
     ~azure.mgmt.securityinsight.models.ActivityEntityQueriesPropertiesQueryDefinitions
    :ivar input_entity_type: The type of the query's source entity. Known values are: "Account",
     "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware",
     "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
     "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail",
     and "Nic".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: List of the fields of the source entity that are required to
     run the query.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: dict[str, list[str]]
    :ivar template_name: The template id this activity was created from.
    :vartype template_name: str
    :ivar enabled: Determines whether this activity is enabled or disabled.
    :vartype enabled: bool
    :ivar created_time_utc: The time the activity was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The last time the activity was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "created_time_utc": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "content": {"key": "properties.content", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "query_definitions": {
            "key": "properties.queryDefinitions",
            "type": "ActivityEntityQueriesPropertiesQueryDefinitions",
        },
        "input_entity_type": {"key": "properties.inputEntityType", "type": "str"},
        "required_input_fields_sets": {"key": "properties.requiredInputFieldsSets", "type": "[[str]]"},
        "entities_filter": {"key": "properties.entitiesFilter", "type": "{[str]}"},
        "template_name": {"key": "properties.templateName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "created_time_utc": {"key": "properties.createdTimeUtc", "type": "iso-8601"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        title: Optional[str] = None,
        content: Optional[str] = None,
        description: Optional[str] = None,
        query_definitions: Optional["_models.ActivityEntityQueriesPropertiesQueryDefinitions"] = None,
        input_entity_type: Optional[Union[str, "_models.EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[Dict[str, List[str]]] = None,
        template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword title: The entity query title.
        :paramtype title: str
        :keyword content: The entity query content to display in timeline.
        :paramtype content: str
        :keyword description: The entity query description.
        :paramtype description: str
        :keyword query_definitions: The Activity query definitions.
        :paramtype query_definitions:
         ~azure.mgmt.securityinsight.models.ActivityEntityQueriesPropertiesQueryDefinitions
        :keyword input_entity_type: The type of the query's source entity. Known values are: "Account",
         "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware",
         "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
         "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail",
         and "Nic".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: List of the fields of the source entity that are required
         to run the query.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: dict[str, list[str]]
        :keyword template_name: The template id this activity was created from.
        :paramtype template_name: str
        :keyword enabled: Determines whether this activity is enabled or disabled.
        :paramtype enabled: bool
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Activity"
        self.title = title
        self.content = content
        self.description = description
        self.query_definitions = query_definitions
        self.input_entity_type = input_entity_type
        self.required_input_fields_sets = required_input_fields_sets
        self.entities_filter = entities_filter
        self.template_name = template_name
        self.enabled = enabled
        self.created_time_utc = None
        self.last_modified_time_utc = None


class EntityQueryTemplate(Resource):
    """Specific entity query template.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActivityEntityQueryTemplate

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: the entity query template kind. Required. "Activity"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryTemplateKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Activity": "ActivityEntityQueryTemplate"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class ActivityEntityQueryTemplate(EntityQueryTemplate):  # pylint: disable=too-many-instance-attributes
    """Represents Activity entity query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: the entity query template kind. Required. "Activity"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryTemplateKind
    :ivar title: The entity query title.
    :vartype title: str
    :ivar content: The entity query content to display in timeline.
    :vartype content: str
    :ivar description: The entity query description.
    :vartype description: str
    :ivar query_definitions: The Activity query definitions.
    :vartype query_definitions:
     ~azure.mgmt.securityinsight.models.ActivityEntityQueryTemplatePropertiesQueryDefinitions
    :ivar data_types: List of required data types for the given entity query template.
    :vartype data_types: list[~azure.mgmt.securityinsight.models.DataTypeDefinitions]
    :ivar input_entity_type: The type of the query's source entity. Known values are: "Account",
     "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware",
     "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
     "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail",
     and "Nic".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: List of the fields of the source entity that are required to
     run the query.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: dict[str, list[str]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "content": {"key": "properties.content", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "query_definitions": {
            "key": "properties.queryDefinitions",
            "type": "ActivityEntityQueryTemplatePropertiesQueryDefinitions",
        },
        "data_types": {"key": "properties.dataTypes", "type": "[DataTypeDefinitions]"},
        "input_entity_type": {"key": "properties.inputEntityType", "type": "str"},
        "required_input_fields_sets": {"key": "properties.requiredInputFieldsSets", "type": "[[str]]"},
        "entities_filter": {"key": "properties.entitiesFilter", "type": "{[str]}"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        content: Optional[str] = None,
        description: Optional[str] = None,
        query_definitions: Optional["_models.ActivityEntityQueryTemplatePropertiesQueryDefinitions"] = None,
        data_types: Optional[List["_models.DataTypeDefinitions"]] = None,
        input_entity_type: Optional[Union[str, "_models.EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[Dict[str, List[str]]] = None,
        **kwargs
    ):
        """
        :keyword title: The entity query title.
        :paramtype title: str
        :keyword content: The entity query content to display in timeline.
        :paramtype content: str
        :keyword description: The entity query description.
        :paramtype description: str
        :keyword query_definitions: The Activity query definitions.
        :paramtype query_definitions:
         ~azure.mgmt.securityinsight.models.ActivityEntityQueryTemplatePropertiesQueryDefinitions
        :keyword data_types: List of required data types for the given entity query template.
        :paramtype data_types: list[~azure.mgmt.securityinsight.models.DataTypeDefinitions]
        :keyword input_entity_type: The type of the query's source entity. Known values are: "Account",
         "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware",
         "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
         "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail",
         and "Nic".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: List of the fields of the source entity that are required
         to run the query.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: dict[str, list[str]]
        """
        super().__init__(**kwargs)
        self.kind: str = "Activity"
        self.title = title
        self.content = content
        self.description = description
        self.query_definitions = query_definitions
        self.data_types = data_types
        self.input_entity_type = input_entity_type
        self.required_input_fields_sets = required_input_fields_sets
        self.entities_filter = entities_filter


class ActivityEntityQueryTemplatePropertiesQueryDefinitions(_serialization.Model):
    """The Activity query definitions.

    :ivar query: The Activity query to run on a given entity.
    :vartype query: str
    :ivar summarize_by: The dimensions we want to summarize the timeline results on, this is comma
     separated list.
    :vartype summarize_by: str
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "summarize_by": {"key": "summarizeBy", "type": "str"},
    }

    def __init__(self, *, query: Optional[str] = None, summarize_by: Optional[str] = None, **kwargs):
        """
        :keyword query: The Activity query to run on a given entity.
        :paramtype query: str
        :keyword summarize_by: The dimensions we want to summarize the timeline results on, this is
         comma separated list.
        :paramtype summarize_by: str
        """
        super().__init__(**kwargs)
        self.query = query
        self.summarize_by = summarize_by


class EntityTimelineItem(_serialization.Model):
    """Entity timeline Item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActivityTimelineItem, AnomalyTimelineItem, BookmarkTimelineItem, SecurityAlertTimelineItem

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The entity query kind type. Required. Known values are: "Activity", "Bookmark",
     "SecurityAlert", and "Anomaly".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "Activity": "ActivityTimelineItem",
            "Anomaly": "AnomalyTimelineItem",
            "Bookmark": "BookmarkTimelineItem",
            "SecurityAlert": "SecurityAlertTimelineItem",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class ActivityTimelineItem(EntityTimelineItem):
    """Represents Activity timeline item.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The entity query kind type. Required. Known values are: "Activity", "Bookmark",
     "SecurityAlert", and "Anomaly".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    :ivar query_id: The activity query id. Required.
    :vartype query_id: str
    :ivar bucket_start_time_utc: The grouping bucket start time. Required.
    :vartype bucket_start_time_utc: ~datetime.datetime
    :ivar bucket_end_time_utc: The grouping bucket end time. Required.
    :vartype bucket_end_time_utc: ~datetime.datetime
    :ivar first_activity_time_utc: The time of the first activity in the grouping bucket. Required.
    :vartype first_activity_time_utc: ~datetime.datetime
    :ivar last_activity_time_utc: The time of the last activity in the grouping bucket. Required.
    :vartype last_activity_time_utc: ~datetime.datetime
    :ivar content: The activity timeline content. Required.
    :vartype content: str
    :ivar title: The activity timeline title. Required.
    :vartype title: str
    """

    _validation = {
        "kind": {"required": True},
        "query_id": {"required": True},
        "bucket_start_time_utc": {"required": True},
        "bucket_end_time_utc": {"required": True},
        "first_activity_time_utc": {"required": True},
        "last_activity_time_utc": {"required": True},
        "content": {"required": True},
        "title": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "query_id": {"key": "queryId", "type": "str"},
        "bucket_start_time_utc": {"key": "bucketStartTimeUTC", "type": "iso-8601"},
        "bucket_end_time_utc": {"key": "bucketEndTimeUTC", "type": "iso-8601"},
        "first_activity_time_utc": {"key": "firstActivityTimeUTC", "type": "iso-8601"},
        "last_activity_time_utc": {"key": "lastActivityTimeUTC", "type": "iso-8601"},
        "content": {"key": "content", "type": "str"},
        "title": {"key": "title", "type": "str"},
    }

    def __init__(
        self,
        *,
        query_id: str,
        bucket_start_time_utc: datetime.datetime,
        bucket_end_time_utc: datetime.datetime,
        first_activity_time_utc: datetime.datetime,
        last_activity_time_utc: datetime.datetime,
        content: str,
        title: str,
        **kwargs
    ):
        """
        :keyword query_id: The activity query id. Required.
        :paramtype query_id: str
        :keyword bucket_start_time_utc: The grouping bucket start time. Required.
        :paramtype bucket_start_time_utc: ~datetime.datetime
        :keyword bucket_end_time_utc: The grouping bucket end time. Required.
        :paramtype bucket_end_time_utc: ~datetime.datetime
        :keyword first_activity_time_utc: The time of the first activity in the grouping bucket.
         Required.
        :paramtype first_activity_time_utc: ~datetime.datetime
        :keyword last_activity_time_utc: The time of the last activity in the grouping bucket.
         Required.
        :paramtype last_activity_time_utc: ~datetime.datetime
        :keyword content: The activity timeline content. Required.
        :paramtype content: str
        :keyword title: The activity timeline title. Required.
        :paramtype title: str
        """
        super().__init__(**kwargs)
        self.kind: str = "Activity"
        self.query_id = query_id
        self.bucket_start_time_utc = bucket_start_time_utc
        self.bucket_end_time_utc = bucket_end_time_utc
        self.first_activity_time_utc = first_activity_time_utc
        self.last_activity_time_utc = last_activity_time_utc
        self.content = content
        self.title = title


class AddIncidentTaskActionProperties(_serialization.Model):
    """AddIncidentTaskActionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar title: The title of the task. Required.
    :vartype title: str
    :ivar description: The description of the task.
    :vartype description: str
    """

    _validation = {
        "title": {"required": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, title: str, description: Optional[str] = None, **kwargs):
        """
        :keyword title: The title of the task. Required.
        :paramtype title: str
        :keyword description: The description of the task.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description


class AlertDetailsOverride(_serialization.Model):
    """Settings for how to dynamically override alert static details.

    :ivar alert_display_name_format: the format containing columns name(s) to override the alert
     name.
    :vartype alert_display_name_format: str
    :ivar alert_description_format: the format containing columns name(s) to override the alert
     description.
    :vartype alert_description_format: str
    :ivar alert_tactics_column_name: the column name to take the alert tactics from.
    :vartype alert_tactics_column_name: str
    :ivar alert_severity_column_name: the column name to take the alert severity from.
    :vartype alert_severity_column_name: str
    :ivar alert_dynamic_properties: List of additional dynamic properties to override.
    :vartype alert_dynamic_properties:
     list[~azure.mgmt.securityinsight.models.AlertPropertyMapping]
    """

    _attribute_map = {
        "alert_display_name_format": {"key": "alertDisplayNameFormat", "type": "str"},
        "alert_description_format": {"key": "alertDescriptionFormat", "type": "str"},
        "alert_tactics_column_name": {"key": "alertTacticsColumnName", "type": "str"},
        "alert_severity_column_name": {"key": "alertSeverityColumnName", "type": "str"},
        "alert_dynamic_properties": {"key": "alertDynamicProperties", "type": "[AlertPropertyMapping]"},
    }

    def __init__(
        self,
        *,
        alert_display_name_format: Optional[str] = None,
        alert_description_format: Optional[str] = None,
        alert_tactics_column_name: Optional[str] = None,
        alert_severity_column_name: Optional[str] = None,
        alert_dynamic_properties: Optional[List["_models.AlertPropertyMapping"]] = None,
        **kwargs
    ):
        """
        :keyword alert_display_name_format: the format containing columns name(s) to override the alert
         name.
        :paramtype alert_display_name_format: str
        :keyword alert_description_format: the format containing columns name(s) to override the alert
         description.
        :paramtype alert_description_format: str
        :keyword alert_tactics_column_name: the column name to take the alert tactics from.
        :paramtype alert_tactics_column_name: str
        :keyword alert_severity_column_name: the column name to take the alert severity from.
        :paramtype alert_severity_column_name: str
        :keyword alert_dynamic_properties: List of additional dynamic properties to override.
        :paramtype alert_dynamic_properties:
         list[~azure.mgmt.securityinsight.models.AlertPropertyMapping]
        """
        super().__init__(**kwargs)
        self.alert_display_name_format = alert_display_name_format
        self.alert_description_format = alert_description_format
        self.alert_tactics_column_name = alert_tactics_column_name
        self.alert_severity_column_name = alert_severity_column_name
        self.alert_dynamic_properties = alert_dynamic_properties


class AlertPropertyMapping(_serialization.Model):
    """A single alert property mapping to override.

    :ivar alert_property: The V3 alert property. Known values are: "AlertLink", "ConfidenceLevel",
     "ConfidenceScore", "ExtendedLinks", "ProductName", "ProviderName", "ProductComponentName",
     "RemediationSteps", and "Techniques".
    :vartype alert_property: str or ~azure.mgmt.securityinsight.models.AlertProperty
    :ivar value: the column name to use to override this property.
    :vartype value: str
    """

    _attribute_map = {
        "alert_property": {"key": "alertProperty", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        alert_property: Optional[Union[str, "_models.AlertProperty"]] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword alert_property: The V3 alert property. Known values are: "AlertLink",
         "ConfidenceLevel", "ConfidenceScore", "ExtendedLinks", "ProductName", "ProviderName",
         "ProductComponentName", "RemediationSteps", and "Techniques".
        :paramtype alert_property: str or ~azure.mgmt.securityinsight.models.AlertProperty
        :keyword value: the column name to use to override this property.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.alert_property = alert_property
        self.value = value


class AlertRule(ResourceWithEtag):
    """Alert rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FusionAlertRule, MLBehaviorAnalyticsAlertRule, MicrosoftSecurityIncidentCreationAlertRule,
    NrtAlertRule, ScheduledAlertRule, ThreatIntelligenceAlertRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "Fusion": "FusionAlertRule",
            "MLBehaviorAnalytics": "MLBehaviorAnalyticsAlertRule",
            "MicrosoftSecurityIncidentCreation": "MicrosoftSecurityIncidentCreationAlertRule",
            "NRT": "NrtAlertRule",
            "Scheduled": "ScheduledAlertRule",
            "ThreatIntelligence": "ThreatIntelligenceAlertRule",
        }
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: Optional[str] = None


class AlertRulesList(_serialization.Model):
    """List all the alert rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of alert rules.
    :vartype next_link: str
    :ivar value: Array of alert rules. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.AlertRule]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[AlertRule]"},
    }

    def __init__(self, *, value: List["_models.AlertRule"], **kwargs):
        """
        :keyword value: Array of alert rules. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.AlertRule]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class AlertRuleTemplate(Resource):
    """Alert rule template.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FusionAlertRuleTemplate, MLBehaviorAnalyticsAlertRuleTemplate,
    MicrosoftSecurityIncidentCreationAlertRuleTemplate, NrtAlertRuleTemplate,
    ScheduledAlertRuleTemplate, ThreatIntelligenceAlertRuleTemplate

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "Fusion": "FusionAlertRuleTemplate",
            "MLBehaviorAnalytics": "MLBehaviorAnalyticsAlertRuleTemplate",
            "MicrosoftSecurityIncidentCreation": "MicrosoftSecurityIncidentCreationAlertRuleTemplate",
            "NRT": "NrtAlertRuleTemplate",
            "Scheduled": "ScheduledAlertRuleTemplate",
            "ThreatIntelligence": "ThreatIntelligenceAlertRuleTemplate",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class AlertRuleTemplateDataSource(_serialization.Model):
    """alert rule template data sources.

    :ivar connector_id: The connector id that provides the following data types.
    :vartype connector_id: str
    :ivar data_types: The data types used by the alert rule template.
    :vartype data_types: list[str]
    """

    _attribute_map = {
        "connector_id": {"key": "connectorId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "[str]"},
    }

    def __init__(self, *, connector_id: Optional[str] = None, data_types: Optional[List[str]] = None, **kwargs):
        """
        :keyword connector_id: The connector id that provides the following data types.
        :paramtype connector_id: str
        :keyword data_types: The data types used by the alert rule template.
        :paramtype data_types: list[str]
        """
        super().__init__(**kwargs)
        self.connector_id = connector_id
        self.data_types = data_types


class AlertRuleTemplatePropertiesBase(_serialization.Model):
    """Base alert rule template property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    """

    _validation = {
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "alert_rules_created_by_template_count": {"key": "alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "createdDateUTC", "type": "iso-8601"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "required_data_connectors": {"key": "requiredDataConnectors", "type": "[AlertRuleTemplateDataSource]"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        """
        super().__init__(**kwargs)
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status


class AlertRuleTemplatesList(_serialization.Model):
    """List all the alert rule templates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of alert rule templates.
    :vartype next_link: str
    :ivar value: Array of alert rule templates. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.AlertRuleTemplate]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[AlertRuleTemplate]"},
    }

    def __init__(self, *, value: List["_models.AlertRuleTemplate"], **kwargs):
        """
        :keyword value: Array of alert rule templates. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.AlertRuleTemplate]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class AlertRuleTemplateWithMitreProperties(AlertRuleTemplatePropertiesBase):
    """Alert rule template with MITRE property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "alert_rules_created_by_template_count": {"key": "alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "createdDateUTC", "type": "iso-8601"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "required_data_connectors": {"key": "requiredDataConnectors", "type": "[AlertRuleTemplateDataSource]"},
        "status": {"key": "status", "type": "str"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "techniques": {"key": "techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        """
        super().__init__(
            alert_rules_created_by_template_count=alert_rules_created_by_template_count,
            description=description,
            display_name=display_name,
            required_data_connectors=required_data_connectors,
            status=status,
            **kwargs
        )
        self.tactics = tactics
        self.techniques = techniques


class AlertsDataTypeOfDataConnector(_serialization.Model):
    """Alerts data type for data connectors.

    All required parameters must be populated in order to send to Azure.

    :ivar alerts: Alerts data type connection. Required.
    :vartype alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _validation = {
        "alerts": {"required": True},
    }

    _attribute_map = {
        "alerts": {"key": "alerts", "type": "DataConnectorDataTypeCommon"},
    }

    def __init__(self, *, alerts: "_models.DataConnectorDataTypeCommon", **kwargs):
        """
        :keyword alerts: Alerts data type connection. Required.
        :paramtype alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
        """
        super().__init__(**kwargs)
        self.alerts = alerts


class Settings(ResourceWithEtag):
    """The Setting.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Anomalies, EntityAnalytics, EyesOn, Ueba

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the setting. Required. Known values are: "Anomalies", "EyesOn",
     "EntityAnalytics", and "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {"Anomalies": "Anomalies", "EntityAnalytics": "EntityAnalytics", "EyesOn": "EyesOn", "Ueba": "Ueba"}
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: Optional[str] = None


class Anomalies(Settings):
    """Settings with single toggle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the setting. Required. Known values are: "Anomalies", "EyesOn",
     "EntityAnalytics", and "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :ivar is_enabled: Determines whether the setting is enable or disabled.
    :vartype is_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "is_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Anomalies"
        self.is_enabled = None


class SecurityMLAnalyticsSetting(ResourceWithEtag):
    """Security ML Analytics Setting.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AnomalySecurityMLAnalyticsSettings

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of security ML Analytics Settings. Required. "Anomaly"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SecurityMLAnalyticsSettingsKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Anomaly": "AnomalySecurityMLAnalyticsSettings"}}

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: Optional[str] = None


class AnomalySecurityMLAnalyticsSettings(SecurityMLAnalyticsSetting):  # pylint: disable=too-many-instance-attributes
    """Represents Anomaly Security ML Analytics Settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of security ML Analytics Settings. Required. "Anomaly"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SecurityMLAnalyticsSettingsKind
    :ivar description: The description of the SecurityMLAnalyticsSettings.
    :vartype description: str
    :ivar display_name: The display name for settings created by this SecurityMLAnalyticsSettings.
    :vartype display_name: str
    :ivar enabled: Determines whether this settings is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this SecurityMLAnalyticsSettings has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar required_data_connectors: The required data sources for this SecurityMLAnalyticsSettings.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.SecurityMLAnalyticsSettingsDataSource]
    :ivar tactics: The tactics of the SecurityMLAnalyticsSettings.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the SecurityMLAnalyticsSettings.
    :vartype techniques: list[str]
    :ivar anomaly_version: The anomaly version of the AnomalySecurityMLAnalyticsSettings.
    :vartype anomaly_version: str
    :ivar customizable_observations: The customizable observations of the
     AnomalySecurityMLAnalyticsSettings.
    :vartype customizable_observations: JSON
    :ivar frequency: The frequency that this SecurityMLAnalyticsSettings will be run.
    :vartype frequency: ~datetime.timedelta
    :ivar settings_status: The anomaly SecurityMLAnalyticsSettings status. Known values are:
     "Production" and "Flighting".
    :vartype settings_status: str or ~azure.mgmt.securityinsight.models.SettingsStatus
    :ivar is_default_settings: Determines whether this anomaly security ml analytics settings is a
     default settings.
    :vartype is_default_settings: bool
    :ivar anomaly_settings_version: The anomaly settings version of the Anomaly security ml
     analytics settings that dictates whether job version gets updated or not.
    :vartype anomaly_settings_version: int
    :ivar settings_definition_id: The anomaly settings definition Id.
    :vartype settings_definition_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "last_modified_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "required_data_connectors": {
            "key": "properties.requiredDataConnectors",
            "type": "[SecurityMLAnalyticsSettingsDataSource]",
        },
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "anomaly_version": {"key": "properties.anomalyVersion", "type": "str"},
        "customizable_observations": {"key": "properties.customizableObservations", "type": "object"},
        "frequency": {"key": "properties.frequency", "type": "duration"},
        "settings_status": {"key": "properties.settingsStatus", "type": "str"},
        "is_default_settings": {"key": "properties.isDefaultSettings", "type": "bool"},
        "anomaly_settings_version": {"key": "properties.anomalySettingsVersion", "type": "int"},
        "settings_definition_id": {"key": "properties.settingsDefinitionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        required_data_connectors: Optional[List["_models.SecurityMLAnalyticsSettingsDataSource"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        anomaly_version: Optional[str] = None,
        customizable_observations: Optional[JSON] = None,
        frequency: Optional[datetime.timedelta] = None,
        settings_status: Optional[Union[str, "_models.SettingsStatus"]] = None,
        is_default_settings: Optional[bool] = None,
        anomaly_settings_version: Optional[int] = None,
        settings_definition_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword description: The description of the SecurityMLAnalyticsSettings.
        :paramtype description: str
        :keyword display_name: The display name for settings created by this
         SecurityMLAnalyticsSettings.
        :paramtype display_name: str
        :keyword enabled: Determines whether this settings is enabled or disabled.
        :paramtype enabled: bool
        :keyword required_data_connectors: The required data sources for this
         SecurityMLAnalyticsSettings.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.SecurityMLAnalyticsSettingsDataSource]
        :keyword tactics: The tactics of the SecurityMLAnalyticsSettings.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the SecurityMLAnalyticsSettings.
        :paramtype techniques: list[str]
        :keyword anomaly_version: The anomaly version of the AnomalySecurityMLAnalyticsSettings.
        :paramtype anomaly_version: str
        :keyword customizable_observations: The customizable observations of the
         AnomalySecurityMLAnalyticsSettings.
        :paramtype customizable_observations: JSON
        :keyword frequency: The frequency that this SecurityMLAnalyticsSettings will be run.
        :paramtype frequency: ~datetime.timedelta
        :keyword settings_status: The anomaly SecurityMLAnalyticsSettings status. Known values are:
         "Production" and "Flighting".
        :paramtype settings_status: str or ~azure.mgmt.securityinsight.models.SettingsStatus
        :keyword is_default_settings: Determines whether this anomaly security ml analytics settings is
         a default settings.
        :paramtype is_default_settings: bool
        :keyword anomaly_settings_version: The anomaly settings version of the Anomaly security ml
         analytics settings that dictates whether job version gets updated or not.
        :paramtype anomaly_settings_version: int
        :keyword settings_definition_id: The anomaly settings definition Id.
        :paramtype settings_definition_id: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Anomaly"
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.required_data_connectors = required_data_connectors
        self.tactics = tactics
        self.techniques = techniques
        self.anomaly_version = anomaly_version
        self.customizable_observations = customizable_observations
        self.frequency = frequency
        self.settings_status = settings_status
        self.is_default_settings = is_default_settings
        self.anomaly_settings_version = anomaly_settings_version
        self.settings_definition_id = settings_definition_id


class AnomalyTimelineItem(EntityTimelineItem):  # pylint: disable=too-many-instance-attributes
    """Represents anomaly timeline item.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The entity query kind type. Required. Known values are: "Activity", "Bookmark",
     "SecurityAlert", and "Anomaly".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    :ivar azure_resource_id: The anomaly azure resource id. Required.
    :vartype azure_resource_id: str
    :ivar product_name: The anomaly product name.
    :vartype product_name: str
    :ivar description: The anomaly description.
    :vartype description: str
    :ivar display_name: The anomaly name. Required.
    :vartype display_name: str
    :ivar end_time_utc: The anomaly end time. Required.
    :vartype end_time_utc: ~datetime.datetime
    :ivar start_time_utc: The anomaly start time. Required.
    :vartype start_time_utc: ~datetime.datetime
    :ivar time_generated: The anomaly generated time. Required.
    :vartype time_generated: ~datetime.datetime
    :ivar vendor: The name of the anomaly vendor.
    :vartype vendor: str
    :ivar intent: The intent of the anomaly.
    :vartype intent: str
    :ivar techniques: The techniques of the anomaly.
    :vartype techniques: list[str]
    :ivar reasons: The reasons that cause the anomaly.
    :vartype reasons: list[str]
    """

    _validation = {
        "kind": {"required": True},
        "azure_resource_id": {"required": True},
        "display_name": {"required": True},
        "end_time_utc": {"required": True},
        "start_time_utc": {"required": True},
        "time_generated": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "azure_resource_id": {"key": "azureResourceId", "type": "str"},
        "product_name": {"key": "productName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
        "start_time_utc": {"key": "startTimeUtc", "type": "iso-8601"},
        "time_generated": {"key": "timeGenerated", "type": "iso-8601"},
        "vendor": {"key": "vendor", "type": "str"},
        "intent": {"key": "intent", "type": "str"},
        "techniques": {"key": "techniques", "type": "[str]"},
        "reasons": {"key": "reasons", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        azure_resource_id: str,
        display_name: str,
        end_time_utc: datetime.datetime,
        start_time_utc: datetime.datetime,
        time_generated: datetime.datetime,
        product_name: Optional[str] = None,
        description: Optional[str] = None,
        vendor: Optional[str] = None,
        intent: Optional[str] = None,
        techniques: Optional[List[str]] = None,
        reasons: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword azure_resource_id: The anomaly azure resource id. Required.
        :paramtype azure_resource_id: str
        :keyword product_name: The anomaly product name.
        :paramtype product_name: str
        :keyword description: The anomaly description.
        :paramtype description: str
        :keyword display_name: The anomaly name. Required.
        :paramtype display_name: str
        :keyword end_time_utc: The anomaly end time. Required.
        :paramtype end_time_utc: ~datetime.datetime
        :keyword start_time_utc: The anomaly start time. Required.
        :paramtype start_time_utc: ~datetime.datetime
        :keyword time_generated: The anomaly generated time. Required.
        :paramtype time_generated: ~datetime.datetime
        :keyword vendor: The name of the anomaly vendor.
        :paramtype vendor: str
        :keyword intent: The intent of the anomaly.
        :paramtype intent: str
        :keyword techniques: The techniques of the anomaly.
        :paramtype techniques: list[str]
        :keyword reasons: The reasons that cause the anomaly.
        :paramtype reasons: list[str]
        """
        super().__init__(**kwargs)
        self.kind: str = "Anomaly"
        self.azure_resource_id = azure_resource_id
        self.product_name = product_name
        self.description = description
        self.display_name = display_name
        self.end_time_utc = end_time_utc
        self.start_time_utc = start_time_utc
        self.time_generated = time_generated
        self.vendor = vendor
        self.intent = intent
        self.techniques = techniques
        self.reasons = reasons


class ASCCheckRequirements(DataConnectorsCheckRequirements):
    """Represents ASC (Azure Security Center) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(self, *, subscription_id: Optional[str] = None, **kwargs):
        """
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "AzureSecurityCenter"
        self.subscription_id = subscription_id


class ASCDataConnector(DataConnector):
    """Represents ASC (Azure Security Center) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "AzureSecurityCenter"
        self.data_types = data_types
        self.subscription_id = subscription_id


class ASCDataConnectorProperties(DataConnectorWithAlertsProperties):
    """ASC (Azure Security Center) data connector properties.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super().__init__(data_types=data_types, **kwargs)
        self.subscription_id = subscription_id


class AutomationRule(ResourceWithEtag):  # pylint: disable=too-many-instance-attributes
    """AutomationRule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar display_name: The display name of the automation rule. Required.
    :vartype display_name: str
    :ivar order: The order of execution of the automation rule. Required.
    :vartype order: int
    :ivar triggering_logic: Describes automation rule triggering logic. Required.
    :vartype triggering_logic: ~azure.mgmt.securityinsight.models.AutomationRuleTriggeringLogic
    :ivar actions: The actions to execute when the automation rule is triggered. Required.
    :vartype actions: list[~azure.mgmt.securityinsight.models.AutomationRuleAction]
    :ivar last_modified_time_utc: The last time the automation rule was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar created_time_utc: The time the automation rule was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_by: Information on the client (user or application) that made some action.
    :vartype last_modified_by: ~azure.mgmt.securityinsight.models.ClientInfo
    :ivar created_by: Information on the client (user or application) that made some action.
    :vartype created_by: ~azure.mgmt.securityinsight.models.ClientInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "display_name": {"required": True, "max_length": 500},
        "order": {"required": True, "maximum": 1000, "minimum": 1},
        "triggering_logic": {"required": True},
        "actions": {"required": True, "max_items": 20, "min_items": 0},
        "last_modified_time_utc": {"readonly": True},
        "created_time_utc": {"readonly": True},
        "last_modified_by": {"readonly": True},
        "created_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "order": {"key": "properties.order", "type": "int"},
        "triggering_logic": {"key": "properties.triggeringLogic", "type": "AutomationRuleTriggeringLogic"},
        "actions": {"key": "properties.actions", "type": "[AutomationRuleAction]"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "created_time_utc": {"key": "properties.createdTimeUtc", "type": "iso-8601"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "ClientInfo"},
        "created_by": {"key": "properties.createdBy", "type": "ClientInfo"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        order: int,
        triggering_logic: "_models.AutomationRuleTriggeringLogic",
        actions: List["_models.AutomationRuleAction"],
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword display_name: The display name of the automation rule. Required.
        :paramtype display_name: str
        :keyword order: The order of execution of the automation rule. Required.
        :paramtype order: int
        :keyword triggering_logic: Describes automation rule triggering logic. Required.
        :paramtype triggering_logic: ~azure.mgmt.securityinsight.models.AutomationRuleTriggeringLogic
        :keyword actions: The actions to execute when the automation rule is triggered. Required.
        :paramtype actions: list[~azure.mgmt.securityinsight.models.AutomationRuleAction]
        """
        super().__init__(etag=etag, **kwargs)
        self.display_name = display_name
        self.order = order
        self.triggering_logic = triggering_logic
        self.actions = actions
        self.last_modified_time_utc = None
        self.created_time_utc = None
        self.last_modified_by = None
        self.created_by = None


class AutomationRuleAction(_serialization.Model):
    """Describes an automation rule action.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutomationRuleAddIncidentTaskAction, AutomationRuleModifyPropertiesAction,
    AutomationRuleRunPlaybookAction

    All required parameters must be populated in order to send to Azure.

    :ivar order: Required.
    :vartype order: int
    :ivar action_type: The type of the automation rule action. Required. Known values are:
     "ModifyProperties", "RunPlaybook", and "AddIncidentTask".
    :vartype action_type: str or ~azure.mgmt.securityinsight.models.ActionType
    """

    _validation = {
        "order": {"required": True},
        "action_type": {"required": True},
    }

    _attribute_map = {
        "order": {"key": "order", "type": "int"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    _subtype_map = {
        "action_type": {
            "AddIncidentTask": "AutomationRuleAddIncidentTaskAction",
            "ModifyProperties": "AutomationRuleModifyPropertiesAction",
            "RunPlaybook": "AutomationRuleRunPlaybookAction",
        }
    }

    def __init__(self, *, order: int, **kwargs):
        """
        :keyword order: Required.
        :paramtype order: int
        """
        super().__init__(**kwargs)
        self.order = order
        self.action_type: Optional[str] = None


class AutomationRuleAddIncidentTaskAction(AutomationRuleAction):
    """Describes an automation rule action to add a task to an incident.

    All required parameters must be populated in order to send to Azure.

    :ivar order: Required.
    :vartype order: int
    :ivar action_type: The type of the automation rule action. Required. Known values are:
     "ModifyProperties", "RunPlaybook", and "AddIncidentTask".
    :vartype action_type: str or ~azure.mgmt.securityinsight.models.ActionType
    :ivar action_configuration:
    :vartype action_configuration:
     ~azure.mgmt.securityinsight.models.AddIncidentTaskActionProperties
    """

    _validation = {
        "order": {"required": True},
        "action_type": {"required": True},
    }

    _attribute_map = {
        "order": {"key": "order", "type": "int"},
        "action_type": {"key": "actionType", "type": "str"},
        "action_configuration": {"key": "actionConfiguration", "type": "AddIncidentTaskActionProperties"},
    }

    def __init__(
        self, *, order: int, action_configuration: Optional["_models.AddIncidentTaskActionProperties"] = None, **kwargs
    ):
        """
        :keyword order: Required.
        :paramtype order: int
        :keyword action_configuration:
        :paramtype action_configuration:
         ~azure.mgmt.securityinsight.models.AddIncidentTaskActionProperties
        """
        super().__init__(order=order, **kwargs)
        self.action_type: str = "AddIncidentTask"
        self.action_configuration = action_configuration


class AutomationRuleBooleanCondition(_serialization.Model):
    """AutomationRuleBooleanCondition.

    :ivar operator: Known values are: "And" and "Or".
    :vartype operator: str or
     ~azure.mgmt.securityinsight.models.AutomationRuleBooleanConditionSupportedOperator
    :ivar inner_conditions:
    :vartype inner_conditions: list[~azure.mgmt.securityinsight.models.AutomationRuleCondition]
    """

    _validation = {
        "inner_conditions": {"max_items": 10, "min_items": 2},
    }

    _attribute_map = {
        "operator": {"key": "operator", "type": "str"},
        "inner_conditions": {"key": "innerConditions", "type": "[AutomationRuleCondition]"},
    }

    def __init__(
        self,
        *,
        operator: Optional[Union[str, "_models.AutomationRuleBooleanConditionSupportedOperator"]] = None,
        inner_conditions: Optional[List["_models.AutomationRuleCondition"]] = None,
        **kwargs
    ):
        """
        :keyword operator: Known values are: "And" and "Or".
        :paramtype operator: str or
         ~azure.mgmt.securityinsight.models.AutomationRuleBooleanConditionSupportedOperator
        :keyword inner_conditions:
        :paramtype inner_conditions: list[~azure.mgmt.securityinsight.models.AutomationRuleCondition]
        """
        super().__init__(**kwargs)
        self.operator = operator
        self.inner_conditions = inner_conditions


class AutomationRuleCondition(_serialization.Model):
    """Describes an automation rule condition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BooleanConditionProperties, PropertyConditionProperties, PropertyArrayConditionProperties,
    PropertyArrayChangedConditionProperties, PropertyChangedConditionProperties

    All required parameters must be populated in order to send to Azure.

    :ivar condition_type: Required. Known values are: "Property", "PropertyArray",
     "PropertyChanged", "PropertyArrayChanged", and "Boolean".
    :vartype condition_type: str or ~azure.mgmt.securityinsight.models.ConditionType
    """

    _validation = {
        "condition_type": {"required": True},
    }

    _attribute_map = {
        "condition_type": {"key": "conditionType", "type": "str"},
    }

    _subtype_map = {
        "condition_type": {
            "Boolean": "BooleanConditionProperties",
            "Property": "PropertyConditionProperties",
            "PropertyArray": "PropertyArrayConditionProperties",
            "PropertyArrayChanged": "PropertyArrayChangedConditionProperties",
            "PropertyChanged": "PropertyChangedConditionProperties",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.condition_type: Optional[str] = None


class AutomationRuleModifyPropertiesAction(AutomationRuleAction):
    """Describes an automation rule action to modify an object's properties.

    All required parameters must be populated in order to send to Azure.

    :ivar order: Required.
    :vartype order: int
    :ivar action_type: The type of the automation rule action. Required. Known values are:
     "ModifyProperties", "RunPlaybook", and "AddIncidentTask".
    :vartype action_type: str or ~azure.mgmt.securityinsight.models.ActionType
    :ivar action_configuration:
    :vartype action_configuration: ~azure.mgmt.securityinsight.models.IncidentPropertiesAction
    """

    _validation = {
        "order": {"required": True},
        "action_type": {"required": True},
    }

    _attribute_map = {
        "order": {"key": "order", "type": "int"},
        "action_type": {"key": "actionType", "type": "str"},
        "action_configuration": {"key": "actionConfiguration", "type": "IncidentPropertiesAction"},
    }

    def __init__(
        self, *, order: int, action_configuration: Optional["_models.IncidentPropertiesAction"] = None, **kwargs
    ):
        """
        :keyword order: Required.
        :paramtype order: int
        :keyword action_configuration:
        :paramtype action_configuration: ~azure.mgmt.securityinsight.models.IncidentPropertiesAction
        """
        super().__init__(order=order, **kwargs)
        self.action_type: str = "ModifyProperties"
        self.action_configuration = action_configuration


class AutomationRulePropertyArrayChangedValuesCondition(_serialization.Model):
    """AutomationRulePropertyArrayChangedValuesCondition.

    :ivar array_type: Known values are: "Alerts", "Labels", "Tactics", and "Comments".
    :vartype array_type: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayChangedConditionSupportedArrayType
    :ivar change_type: "Added"
    :vartype change_type: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayChangedConditionSupportedChangeType
    """

    _attribute_map = {
        "array_type": {"key": "arrayType", "type": "str"},
        "change_type": {"key": "changeType", "type": "str"},
    }

    def __init__(
        self,
        *,
        array_type: Optional[
            Union[str, "_models.AutomationRulePropertyArrayChangedConditionSupportedArrayType"]
        ] = None,
        change_type: Optional[
            Union[str, "_models.AutomationRulePropertyArrayChangedConditionSupportedChangeType"]
        ] = None,
        **kwargs
    ):
        """
        :keyword array_type: Known values are: "Alerts", "Labels", "Tactics", and "Comments".
        :paramtype array_type: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayChangedConditionSupportedArrayType
        :keyword change_type: "Added"
        :paramtype change_type: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayChangedConditionSupportedChangeType
        """
        super().__init__(**kwargs)
        self.array_type = array_type
        self.change_type = change_type


class AutomationRulePropertyArrayValuesCondition(_serialization.Model):
    """AutomationRulePropertyArrayValuesCondition.

    :ivar array_type: Known values are: "CustomDetails" and "CustomDetailValues".
    :vartype array_type: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayConditionSupportedArrayType
    :ivar array_condition_type: "AnyItem"
    :vartype array_condition_type: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayConditionSupportedArrayConditionType
    :ivar item_conditions:
    :vartype item_conditions: list[~azure.mgmt.securityinsight.models.AutomationRuleCondition]
    """

    _validation = {
        "item_conditions": {"max_items": 10, "min_items": 0},
    }

    _attribute_map = {
        "array_type": {"key": "arrayType", "type": "str"},
        "array_condition_type": {"key": "arrayConditionType", "type": "str"},
        "item_conditions": {"key": "itemConditions", "type": "[AutomationRuleCondition]"},
    }

    def __init__(
        self,
        *,
        array_type: Optional[Union[str, "_models.AutomationRulePropertyArrayConditionSupportedArrayType"]] = None,
        array_condition_type: Optional[
            Union[str, "_models.AutomationRulePropertyArrayConditionSupportedArrayConditionType"]
        ] = None,
        item_conditions: Optional[List["_models.AutomationRuleCondition"]] = None,
        **kwargs
    ):
        """
        :keyword array_type: Known values are: "CustomDetails" and "CustomDetailValues".
        :paramtype array_type: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayConditionSupportedArrayType
        :keyword array_condition_type: "AnyItem"
        :paramtype array_condition_type: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayConditionSupportedArrayConditionType
        :keyword item_conditions:
        :paramtype item_conditions: list[~azure.mgmt.securityinsight.models.AutomationRuleCondition]
        """
        super().__init__(**kwargs)
        self.array_type = array_type
        self.array_condition_type = array_condition_type
        self.item_conditions = item_conditions


class AutomationRulePropertyValuesChangedCondition(_serialization.Model):
    """AutomationRulePropertyValuesChangedCondition.

    :ivar property_name: Known values are: "IncidentSeverity", "IncidentStatus", and
     "IncidentOwner".
    :vartype property_name: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyChangedConditionSupportedPropertyType
    :ivar change_type: Known values are: "ChangedFrom" and "ChangedTo".
    :vartype change_type: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyChangedConditionSupportedChangedType
    :ivar operator: Known values are: "Equals", "NotEquals", "Contains", "NotContains",
     "StartsWith", "NotStartsWith", "EndsWith", and "NotEndsWith".
    :vartype operator: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedOperator
    :ivar property_values:
    :vartype property_values: list[str]
    """

    _attribute_map = {
        "property_name": {"key": "propertyName", "type": "str"},
        "change_type": {"key": "changeType", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "property_values": {"key": "propertyValues", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        property_name: Optional[
            Union[str, "_models.AutomationRulePropertyChangedConditionSupportedPropertyType"]
        ] = None,
        change_type: Optional[Union[str, "_models.AutomationRulePropertyChangedConditionSupportedChangedType"]] = None,
        operator: Optional[Union[str, "_models.AutomationRulePropertyConditionSupportedOperator"]] = None,
        property_values: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword property_name: Known values are: "IncidentSeverity", "IncidentStatus", and
         "IncidentOwner".
        :paramtype property_name: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyChangedConditionSupportedPropertyType
        :keyword change_type: Known values are: "ChangedFrom" and "ChangedTo".
        :paramtype change_type: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyChangedConditionSupportedChangedType
        :keyword operator: Known values are: "Equals", "NotEquals", "Contains", "NotContains",
         "StartsWith", "NotStartsWith", "EndsWith", and "NotEndsWith".
        :paramtype operator: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedOperator
        :keyword property_values:
        :paramtype property_values: list[str]
        """
        super().__init__(**kwargs)
        self.property_name = property_name
        self.change_type = change_type
        self.operator = operator
        self.property_values = property_values


class AutomationRulePropertyValuesCondition(_serialization.Model):
    """AutomationRulePropertyValuesCondition.

    :ivar property_name: The property to evaluate in an automation rule property condition. Known
     values are: "IncidentTitle", "IncidentDescription", "IncidentSeverity", "IncidentStatus",
     "IncidentRelatedAnalyticRuleIds", "IncidentTactics", "IncidentLabel", "IncidentProviderName",
     "IncidentUpdatedBySource", "IncidentCustomDetailsKey", "IncidentCustomDetailsValue",
     "AccountAadTenantId", "AccountAadUserId", "AccountName", "AccountNTDomain", "AccountPUID",
     "AccountSid", "AccountObjectGuid", "AccountUPNSuffix", "AlertProductNames",
     "AlertAnalyticRuleIds", "AzureResourceResourceId", "AzureResourceSubscriptionId",
     "CloudApplicationAppId", "CloudApplicationAppName", "DNSDomainName", "FileDirectory",
     "FileName", "FileHashValue", "HostAzureID", "HostName", "HostNetBiosName", "HostNTDomain",
     "HostOSVersion", "IoTDeviceId", "IoTDeviceName", "IoTDeviceType", "IoTDeviceVendor",
     "IoTDeviceModel", "IoTDeviceOperatingSystem", "IPAddress", "MailboxDisplayName",
     "MailboxPrimaryAddress", "MailboxUPN", "MailMessageDeliveryAction",
     "MailMessageDeliveryLocation", "MailMessageRecipient", "MailMessageSenderIP",
     "MailMessageSubject", "MailMessageP1Sender", "MailMessageP2Sender", "MalwareCategory",
     "MalwareName", "ProcessCommandLine", "ProcessId", "RegistryKey", "RegistryValueData", and
     "Url".
    :vartype property_name: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedProperty
    :ivar operator: Known values are: "Equals", "NotEquals", "Contains", "NotContains",
     "StartsWith", "NotStartsWith", "EndsWith", and "NotEndsWith".
    :vartype operator: str or
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedOperator
    :ivar property_values:
    :vartype property_values: list[str]
    """

    _attribute_map = {
        "property_name": {"key": "propertyName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "property_values": {"key": "propertyValues", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        property_name: Optional[Union[str, "_models.AutomationRulePropertyConditionSupportedProperty"]] = None,
        operator: Optional[Union[str, "_models.AutomationRulePropertyConditionSupportedOperator"]] = None,
        property_values: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword property_name: The property to evaluate in an automation rule property condition.
         Known values are: "IncidentTitle", "IncidentDescription", "IncidentSeverity", "IncidentStatus",
         "IncidentRelatedAnalyticRuleIds", "IncidentTactics", "IncidentLabel", "IncidentProviderName",
         "IncidentUpdatedBySource", "IncidentCustomDetailsKey", "IncidentCustomDetailsValue",
         "AccountAadTenantId", "AccountAadUserId", "AccountName", "AccountNTDomain", "AccountPUID",
         "AccountSid", "AccountObjectGuid", "AccountUPNSuffix", "AlertProductNames",
         "AlertAnalyticRuleIds", "AzureResourceResourceId", "AzureResourceSubscriptionId",
         "CloudApplicationAppId", "CloudApplicationAppName", "DNSDomainName", "FileDirectory",
         "FileName", "FileHashValue", "HostAzureID", "HostName", "HostNetBiosName", "HostNTDomain",
         "HostOSVersion", "IoTDeviceId", "IoTDeviceName", "IoTDeviceType", "IoTDeviceVendor",
         "IoTDeviceModel", "IoTDeviceOperatingSystem", "IPAddress", "MailboxDisplayName",
         "MailboxPrimaryAddress", "MailboxUPN", "MailMessageDeliveryAction",
         "MailMessageDeliveryLocation", "MailMessageRecipient", "MailMessageSenderIP",
         "MailMessageSubject", "MailMessageP1Sender", "MailMessageP2Sender", "MalwareCategory",
         "MalwareName", "ProcessCommandLine", "ProcessId", "RegistryKey", "RegistryValueData", and
         "Url".
        :paramtype property_name: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedProperty
        :keyword operator: Known values are: "Equals", "NotEquals", "Contains", "NotContains",
         "StartsWith", "NotStartsWith", "EndsWith", and "NotEndsWith".
        :paramtype operator: str or
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyConditionSupportedOperator
        :keyword property_values:
        :paramtype property_values: list[str]
        """
        super().__init__(**kwargs)
        self.property_name = property_name
        self.operator = operator
        self.property_values = property_values


class AutomationRuleRunPlaybookAction(AutomationRuleAction):
    """Describes an automation rule action to run a playbook.

    All required parameters must be populated in order to send to Azure.

    :ivar order: Required.
    :vartype order: int
    :ivar action_type: The type of the automation rule action. Required. Known values are:
     "ModifyProperties", "RunPlaybook", and "AddIncidentTask".
    :vartype action_type: str or ~azure.mgmt.securityinsight.models.ActionType
    :ivar action_configuration:
    :vartype action_configuration: ~azure.mgmt.securityinsight.models.PlaybookActionProperties
    """

    _validation = {
        "order": {"required": True},
        "action_type": {"required": True},
    }

    _attribute_map = {
        "order": {"key": "order", "type": "int"},
        "action_type": {"key": "actionType", "type": "str"},
        "action_configuration": {"key": "actionConfiguration", "type": "PlaybookActionProperties"},
    }

    def __init__(
        self, *, order: int, action_configuration: Optional["_models.PlaybookActionProperties"] = None, **kwargs
    ):
        """
        :keyword order: Required.
        :paramtype order: int
        :keyword action_configuration:
        :paramtype action_configuration: ~azure.mgmt.securityinsight.models.PlaybookActionProperties
        """
        super().__init__(order=order, **kwargs)
        self.action_type: str = "RunPlaybook"
        self.action_configuration = action_configuration


class AutomationRulesList(_serialization.Model):
    """AutomationRulesList.

    :ivar value:
    :vartype value: list[~azure.mgmt.securityinsight.models.AutomationRule]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AutomationRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AutomationRule"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.securityinsight.models.AutomationRule]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutomationRuleTriggeringLogic(_serialization.Model):
    """Describes automation rule triggering logic.

    All required parameters must be populated in order to send to Azure.

    :ivar is_enabled: Determines whether the automation rule is enabled or disabled. Required.
    :vartype is_enabled: bool
    :ivar expiration_time_utc: Determines when the automation rule should automatically expire and
     be disabled.
    :vartype expiration_time_utc: ~datetime.datetime
    :ivar triggers_on: Required. Known values are: "Incidents" and "Alerts".
    :vartype triggers_on: str or ~azure.mgmt.securityinsight.models.TriggersOn
    :ivar triggers_when: Required. Known values are: "Created" and "Updated".
    :vartype triggers_when: str or ~azure.mgmt.securityinsight.models.TriggersWhen
    :ivar conditions: The conditions to evaluate to determine if the automation rule should be
     triggered on a given object.
    :vartype conditions: list[~azure.mgmt.securityinsight.models.AutomationRuleCondition]
    """

    _validation = {
        "is_enabled": {"required": True},
        "triggers_on": {"required": True},
        "triggers_when": {"required": True},
        "conditions": {"max_items": 50, "min_items": 0},
    }

    _attribute_map = {
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "expiration_time_utc": {"key": "expirationTimeUtc", "type": "iso-8601"},
        "triggers_on": {"key": "triggersOn", "type": "str"},
        "triggers_when": {"key": "triggersWhen", "type": "str"},
        "conditions": {"key": "conditions", "type": "[AutomationRuleCondition]"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        triggers_on: Union[str, "_models.TriggersOn"],
        triggers_when: Union[str, "_models.TriggersWhen"],
        expiration_time_utc: Optional[datetime.datetime] = None,
        conditions: Optional[List["_models.AutomationRuleCondition"]] = None,
        **kwargs
    ):
        """
        :keyword is_enabled: Determines whether the automation rule is enabled or disabled. Required.
        :paramtype is_enabled: bool
        :keyword expiration_time_utc: Determines when the automation rule should automatically expire
         and be disabled.
        :paramtype expiration_time_utc: ~datetime.datetime
        :keyword triggers_on: Required. Known values are: "Incidents" and "Alerts".
        :paramtype triggers_on: str or ~azure.mgmt.securityinsight.models.TriggersOn
        :keyword triggers_when: Required. Known values are: "Created" and "Updated".
        :paramtype triggers_when: str or ~azure.mgmt.securityinsight.models.TriggersWhen
        :keyword conditions: The conditions to evaluate to determine if the automation rule should be
         triggered on a given object.
        :paramtype conditions: list[~azure.mgmt.securityinsight.models.AutomationRuleCondition]
        """
        super().__init__(**kwargs)
        self.is_enabled = is_enabled
        self.expiration_time_utc = expiration_time_utc
        self.triggers_on = triggers_on
        self.triggers_when = triggers_when
        self.conditions = conditions


class Availability(_serialization.Model):
    """Connector Availability Status.

    :ivar status: The connector Availability Status. Default value is 1.
    :vartype status: int
    :ivar is_preview: Set connector as preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "status": {"key": "status", "type": "int"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(self, *, status: Optional[Literal[1]] = None, is_preview: Optional[bool] = None, **kwargs):
        """
        :keyword status: The connector Availability Status. Default value is 1.
        :paramtype status: int
        :keyword is_preview: Set connector as preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.status = status
        self.is_preview = is_preview


class AwsCloudTrailCheckRequirements(DataConnectorsCheckRequirements):
    """Amazon Web Services CloudTrail requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "AmazonWebServicesCloudTrail"


class AwsCloudTrailDataConnector(DataConnector):
    """Represents Amazon Web Services CloudTrail data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar aws_role_arn: The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access
     the Aws account.
    :vartype aws_role_arn: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "aws_role_arn": {"key": "properties.awsRoleArn", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AwsCloudTrailDataConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        aws_role_arn: Optional[str] = None,
        data_types: Optional["_models.AwsCloudTrailDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword aws_role_arn: The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access
         the Aws account.
        :paramtype aws_role_arn: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "AmazonWebServicesCloudTrail"
        self.aws_role_arn = aws_role_arn
        self.data_types = data_types


class AwsCloudTrailDataConnectorDataTypes(_serialization.Model):
    """The available data types for Amazon Web Services CloudTrail data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar logs: Logs data type. Required.
    :vartype logs: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypesLogs
    """

    _validation = {
        "logs": {"required": True},
    }

    _attribute_map = {
        "logs": {"key": "logs", "type": "AwsCloudTrailDataConnectorDataTypesLogs"},
    }

    def __init__(self, *, logs: "_models.AwsCloudTrailDataConnectorDataTypesLogs", **kwargs):
        """
        :keyword logs: Logs data type. Required.
        :paramtype logs: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypesLogs
        """
        super().__init__(**kwargs)
        self.logs = logs


class DataConnectorDataTypeCommon(_serialization.Model):
    """Common field for data type in data connectors.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(**kwargs)
        self.state = state


class AwsCloudTrailDataConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class AwsS3CheckRequirements(DataConnectorsCheckRequirements):
    """Amazon Web Services S3 requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "AmazonWebServicesS3"


class AwsS3DataConnector(DataConnector):
    """Represents Amazon Web Services S3 data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar destination_table: The logs destination table name in LogAnalytics.
    :vartype destination_table: str
    :ivar sqs_urls: The AWS sqs urls for the connector.
    :vartype sqs_urls: list[str]
    :ivar role_arn: The Aws Role Arn that is used to access the Aws account.
    :vartype role_arn: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AwsS3DataConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "destination_table": {"key": "properties.destinationTable", "type": "str"},
        "sqs_urls": {"key": "properties.sqsUrls", "type": "[str]"},
        "role_arn": {"key": "properties.roleArn", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AwsS3DataConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        destination_table: Optional[str] = None,
        sqs_urls: Optional[List[str]] = None,
        role_arn: Optional[str] = None,
        data_types: Optional["_models.AwsS3DataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword destination_table: The logs destination table name in LogAnalytics.
        :paramtype destination_table: str
        :keyword sqs_urls: The AWS sqs urls for the connector.
        :paramtype sqs_urls: list[str]
        :keyword role_arn: The Aws Role Arn that is used to access the Aws account.
        :paramtype role_arn: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AwsS3DataConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "AmazonWebServicesS3"
        self.destination_table = destination_table
        self.sqs_urls = sqs_urls
        self.role_arn = role_arn
        self.data_types = data_types


class AwsS3DataConnectorDataTypes(_serialization.Model):
    """The available data types for Amazon Web Services S3 data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar logs: Logs data type. Required.
    :vartype logs: ~azure.mgmt.securityinsight.models.AwsS3DataConnectorDataTypesLogs
    """

    _validation = {
        "logs": {"required": True},
    }

    _attribute_map = {
        "logs": {"key": "logs", "type": "AwsS3DataConnectorDataTypesLogs"},
    }

    def __init__(self, *, logs: "_models.AwsS3DataConnectorDataTypesLogs", **kwargs):
        """
        :keyword logs: Logs data type. Required.
        :paramtype logs: ~azure.mgmt.securityinsight.models.AwsS3DataConnectorDataTypesLogs
        """
        super().__init__(**kwargs)
        self.logs = logs


class AwsS3DataConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class AzureDevOpsResourceInfo(_serialization.Model):
    """Resources created in Azure DevOps repository.

    :ivar pipeline_id: Id of the pipeline created for the source-control.
    :vartype pipeline_id: str
    :ivar service_connection_id: Id of the service-connection created for the source-control.
    :vartype service_connection_id: str
    """

    _attribute_map = {
        "pipeline_id": {"key": "pipelineId", "type": "str"},
        "service_connection_id": {"key": "serviceConnectionId", "type": "str"},
    }

    def __init__(self, *, pipeline_id: Optional[str] = None, service_connection_id: Optional[str] = None, **kwargs):
        """
        :keyword pipeline_id: Id of the pipeline created for the source-control.
        :paramtype pipeline_id: str
        :keyword service_connection_id: Id of the service-connection created for the source-control.
        :paramtype service_connection_id: str
        """
        super().__init__(**kwargs)
        self.pipeline_id = pipeline_id
        self.service_connection_id = service_connection_id


class AzureResourceEntity(Entity):
    """Represents an azure resource entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar resource_id: The azure resource id of the resource.
    :vartype resource_id: str
    :ivar subscription_id: The subscription id of the resource.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "resource_id": {"readonly": True},
        "subscription_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "AzureResource"
        self.additional_data = None
        self.friendly_name = None
        self.resource_id = None
        self.subscription_id = None


class AzureResourceEntityProperties(EntityCommonProperties):
    """AzureResource entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar resource_id: The azure resource id of the resource.
    :vartype resource_id: str
    :ivar subscription_id: The subscription id of the resource.
    :vartype subscription_id: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "resource_id": {"readonly": True},
        "subscription_id": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_id = None
        self.subscription_id = None


class Bookmark(ResourceWithEtag):  # pylint: disable=too-many-instance-attributes
    """Represents a bookmark in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar created: The time the bookmark was created.
    :vartype created: ~datetime.datetime
    :ivar created_by: Describes a user that created the bookmark.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar display_name: The display name of the bookmark.
    :vartype display_name: str
    :ivar labels: List of labels relevant to this bookmark.
    :vartype labels: list[str]
    :ivar notes: The notes of the bookmark.
    :vartype notes: str
    :ivar query: The query of the bookmark.
    :vartype query: str
    :ivar query_result: The query result of the bookmark.
    :vartype query_result: str
    :ivar updated: The last time the bookmark was updated.
    :vartype updated: ~datetime.datetime
    :ivar updated_by: Describes a user that updated the bookmark.
    :vartype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar event_time: The bookmark event time.
    :vartype event_time: ~datetime.datetime
    :ivar query_start_time: The start time for the query.
    :vartype query_start_time: ~datetime.datetime
    :ivar query_end_time: The end time for the query.
    :vartype query_end_time: ~datetime.datetime
    :ivar incident_info: Describes an incident that relates to bookmark.
    :vartype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
    :ivar entity_mappings: Describes the entity mappings of the bookmark.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.BookmarkEntityMappings]
    :ivar tactics: A list of relevant mitre attacks.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: A list of relevant mitre techniques.
    :vartype techniques: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "created_by": {"key": "properties.createdBy", "type": "UserInfo"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "labels": {"key": "properties.labels", "type": "[str]"},
        "notes": {"key": "properties.notes", "type": "str"},
        "query": {"key": "properties.query", "type": "str"},
        "query_result": {"key": "properties.queryResult", "type": "str"},
        "updated": {"key": "properties.updated", "type": "iso-8601"},
        "updated_by": {"key": "properties.updatedBy", "type": "UserInfo"},
        "event_time": {"key": "properties.eventTime", "type": "iso-8601"},
        "query_start_time": {"key": "properties.queryStartTime", "type": "iso-8601"},
        "query_end_time": {"key": "properties.queryEndTime", "type": "iso-8601"},
        "incident_info": {"key": "properties.incidentInfo", "type": "IncidentInfo"},
        "entity_mappings": {"key": "properties.entityMappings", "type": "[BookmarkEntityMappings]"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        created: Optional[datetime.datetime] = None,
        created_by: Optional["_models.UserInfo"] = None,
        display_name: Optional[str] = None,
        labels: Optional[List[str]] = None,
        notes: Optional[str] = None,
        query: Optional[str] = None,
        query_result: Optional[str] = None,
        updated: Optional[datetime.datetime] = None,
        updated_by: Optional["_models.UserInfo"] = None,
        event_time: Optional[datetime.datetime] = None,
        query_start_time: Optional[datetime.datetime] = None,
        query_end_time: Optional[datetime.datetime] = None,
        incident_info: Optional["_models.IncidentInfo"] = None,
        entity_mappings: Optional[List["_models.BookmarkEntityMappings"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword created: The time the bookmark was created.
        :paramtype created: ~datetime.datetime
        :keyword created_by: Describes a user that created the bookmark.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword display_name: The display name of the bookmark.
        :paramtype display_name: str
        :keyword labels: List of labels relevant to this bookmark.
        :paramtype labels: list[str]
        :keyword notes: The notes of the bookmark.
        :paramtype notes: str
        :keyword query: The query of the bookmark.
        :paramtype query: str
        :keyword query_result: The query result of the bookmark.
        :paramtype query_result: str
        :keyword updated: The last time the bookmark was updated.
        :paramtype updated: ~datetime.datetime
        :keyword updated_by: Describes a user that updated the bookmark.
        :paramtype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword event_time: The bookmark event time.
        :paramtype event_time: ~datetime.datetime
        :keyword query_start_time: The start time for the query.
        :paramtype query_start_time: ~datetime.datetime
        :keyword query_end_time: The end time for the query.
        :paramtype query_end_time: ~datetime.datetime
        :keyword incident_info: Describes an incident that relates to bookmark.
        :paramtype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
        :keyword entity_mappings: Describes the entity mappings of the bookmark.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.BookmarkEntityMappings]
        :keyword tactics: A list of relevant mitre attacks.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: A list of relevant mitre techniques.
        :paramtype techniques: list[str]
        """
        super().__init__(etag=etag, **kwargs)
        self.created = created
        self.created_by = created_by
        self.display_name = display_name
        self.labels = labels
        self.notes = notes
        self.query = query
        self.query_result = query_result
        self.updated = updated
        self.updated_by = updated_by
        self.event_time = event_time
        self.query_start_time = query_start_time
        self.query_end_time = query_end_time
        self.incident_info = incident_info
        self.entity_mappings = entity_mappings
        self.tactics = tactics
        self.techniques = techniques


class BookmarkEntityMappings(_serialization.Model):
    """Describes the entity mappings of a single entity.

    :ivar entity_type: The entity type.
    :vartype entity_type: str
    :ivar field_mappings: Array of fields mapping for that entity type.
    :vartype field_mappings: list[~azure.mgmt.securityinsight.models.EntityFieldMapping]
    """

    _attribute_map = {
        "entity_type": {"key": "entityType", "type": "str"},
        "field_mappings": {"key": "fieldMappings", "type": "[EntityFieldMapping]"},
    }

    def __init__(
        self,
        *,
        entity_type: Optional[str] = None,
        field_mappings: Optional[List["_models.EntityFieldMapping"]] = None,
        **kwargs
    ):
        """
        :keyword entity_type: The entity type.
        :paramtype entity_type: str
        :keyword field_mappings: Array of fields mapping for that entity type.
        :paramtype field_mappings: list[~azure.mgmt.securityinsight.models.EntityFieldMapping]
        """
        super().__init__(**kwargs)
        self.entity_type = entity_type
        self.field_mappings = field_mappings


class BookmarkExpandParameters(_serialization.Model):
    """The parameters required to execute an expand operation on the given bookmark.

    :ivar end_time: The end date filter, so the only expansion results returned are before this
     date.
    :vartype end_time: ~datetime.datetime
    :ivar expansion_id: The Id of the expansion to perform.
    :vartype expansion_id: str
    :ivar start_time: The start date filter, so the only expansion results returned are after this
     date.
    :vartype start_time: ~datetime.datetime
    """

    _attribute_map = {
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "expansion_id": {"key": "expansionId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        end_time: Optional[datetime.datetime] = None,
        expansion_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword end_time: The end date filter, so the only expansion results returned are before this
         date.
        :paramtype end_time: ~datetime.datetime
        :keyword expansion_id: The Id of the expansion to perform.
        :paramtype expansion_id: str
        :keyword start_time: The start date filter, so the only expansion results returned are after
         this date.
        :paramtype start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.end_time = end_time
        self.expansion_id = expansion_id
        self.start_time = start_time


class BookmarkExpandResponse(_serialization.Model):
    """The entity expansion result operation response.

    :ivar meta_data: The metadata from the expansion operation results.
    :vartype meta_data: ~azure.mgmt.securityinsight.models.ExpansionResultsMetadata
    :ivar value: The expansion result values.
    :vartype value: ~azure.mgmt.securityinsight.models.BookmarkExpandResponseValue
    """

    _attribute_map = {
        "meta_data": {"key": "metaData", "type": "ExpansionResultsMetadata"},
        "value": {"key": "value", "type": "BookmarkExpandResponseValue"},
    }

    def __init__(
        self,
        *,
        meta_data: Optional["_models.ExpansionResultsMetadata"] = None,
        value: Optional["_models.BookmarkExpandResponseValue"] = None,
        **kwargs
    ):
        """
        :keyword meta_data: The metadata from the expansion operation results.
        :paramtype meta_data: ~azure.mgmt.securityinsight.models.ExpansionResultsMetadata
        :keyword value: The expansion result values.
        :paramtype value: ~azure.mgmt.securityinsight.models.BookmarkExpandResponseValue
        """
        super().__init__(**kwargs)
        self.meta_data = meta_data
        self.value = value


class BookmarkExpandResponseValue(_serialization.Model):
    """The expansion result values.

    :ivar entities: Array of the expansion result entities.
    :vartype entities: list[~azure.mgmt.securityinsight.models.Entity]
    :ivar edges: Array of expansion result connected entities.
    :vartype edges: list[~azure.mgmt.securityinsight.models.ConnectedEntity]
    """

    _attribute_map = {
        "entities": {"key": "entities", "type": "[Entity]"},
        "edges": {"key": "edges", "type": "[ConnectedEntity]"},
    }

    def __init__(
        self,
        *,
        entities: Optional[List["_models.Entity"]] = None,
        edges: Optional[List["_models.ConnectedEntity"]] = None,
        **kwargs
    ):
        """
        :keyword entities: Array of the expansion result entities.
        :paramtype entities: list[~azure.mgmt.securityinsight.models.Entity]
        :keyword edges: Array of expansion result connected entities.
        :paramtype edges: list[~azure.mgmt.securityinsight.models.ConnectedEntity]
        """
        super().__init__(**kwargs)
        self.entities = entities
        self.edges = edges


class BookmarkList(_serialization.Model):
    """List all the bookmarks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of bookmarks.
    :vartype next_link: str
    :ivar value: Array of bookmarks. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.Bookmark]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Bookmark]"},
    }

    def __init__(self, *, value: List["_models.Bookmark"], **kwargs):
        """
        :keyword value: Array of bookmarks. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Bookmark]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class BookmarkTimelineItem(EntityTimelineItem):
    """Represents bookmark timeline item.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The entity query kind type. Required. Known values are: "Activity", "Bookmark",
     "SecurityAlert", and "Anomaly".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    :ivar azure_resource_id: The bookmark azure resource id. Required.
    :vartype azure_resource_id: str
    :ivar display_name: The bookmark display name.
    :vartype display_name: str
    :ivar notes: The notes of the bookmark.
    :vartype notes: str
    :ivar end_time_utc: The bookmark end time.
    :vartype end_time_utc: ~datetime.datetime
    :ivar start_time_utc: The bookmark start time.
    :vartype start_time_utc: ~datetime.datetime
    :ivar event_time: The bookmark event time.
    :vartype event_time: ~datetime.datetime
    :ivar created_by: Describes a user that created the bookmark.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar labels: List of labels relevant to this bookmark.
    :vartype labels: list[str]
    """

    _validation = {
        "kind": {"required": True},
        "azure_resource_id": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "azure_resource_id": {"key": "azureResourceId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "notes": {"key": "notes", "type": "str"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
        "start_time_utc": {"key": "startTimeUtc", "type": "iso-8601"},
        "event_time": {"key": "eventTime", "type": "iso-8601"},
        "created_by": {"key": "createdBy", "type": "UserInfo"},
        "labels": {"key": "labels", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        azure_resource_id: str,
        display_name: Optional[str] = None,
        notes: Optional[str] = None,
        end_time_utc: Optional[datetime.datetime] = None,
        start_time_utc: Optional[datetime.datetime] = None,
        event_time: Optional[datetime.datetime] = None,
        created_by: Optional["_models.UserInfo"] = None,
        labels: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword azure_resource_id: The bookmark azure resource id. Required.
        :paramtype azure_resource_id: str
        :keyword display_name: The bookmark display name.
        :paramtype display_name: str
        :keyword notes: The notes of the bookmark.
        :paramtype notes: str
        :keyword end_time_utc: The bookmark end time.
        :paramtype end_time_utc: ~datetime.datetime
        :keyword start_time_utc: The bookmark start time.
        :paramtype start_time_utc: ~datetime.datetime
        :keyword event_time: The bookmark event time.
        :paramtype event_time: ~datetime.datetime
        :keyword created_by: Describes a user that created the bookmark.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword labels: List of labels relevant to this bookmark.
        :paramtype labels: list[str]
        """
        super().__init__(**kwargs)
        self.kind: str = "Bookmark"
        self.azure_resource_id = azure_resource_id
        self.display_name = display_name
        self.notes = notes
        self.end_time_utc = end_time_utc
        self.start_time_utc = start_time_utc
        self.event_time = event_time
        self.created_by = created_by
        self.labels = labels


class BooleanConditionProperties(AutomationRuleCondition):
    """Describes an automation rule condition that applies a boolean operator (e.g AND, OR) to conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_type: Required. Known values are: "Property", "PropertyArray",
     "PropertyChanged", "PropertyArrayChanged", and "Boolean".
    :vartype condition_type: str or ~azure.mgmt.securityinsight.models.ConditionType
    :ivar condition_properties:
    :vartype condition_properties:
     ~azure.mgmt.securityinsight.models.AutomationRuleBooleanCondition
    """

    _validation = {
        "condition_type": {"required": True},
    }

    _attribute_map = {
        "condition_type": {"key": "conditionType", "type": "str"},
        "condition_properties": {"key": "conditionProperties", "type": "AutomationRuleBooleanCondition"},
    }

    def __init__(self, *, condition_properties: Optional["_models.AutomationRuleBooleanCondition"] = None, **kwargs):
        """
        :keyword condition_properties:
        :paramtype condition_properties:
         ~azure.mgmt.securityinsight.models.AutomationRuleBooleanCondition
        """
        super().__init__(**kwargs)
        self.condition_type: str = "Boolean"
        self.condition_properties = condition_properties


class ClientInfo(_serialization.Model):
    """Information on the client (user or application) that made some action.

    :ivar email: The email of the client.
    :vartype email: str
    :ivar name: The name of the client.
    :vartype name: str
    :ivar object_id: The object id of the client.
    :vartype object_id: str
    :ivar user_principal_name: The user principal name of the client.
    :vartype user_principal_name: str
    """

    _attribute_map = {
        "email": {"key": "email", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "user_principal_name": {"key": "userPrincipalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        name: Optional[str] = None,
        object_id: Optional[str] = None,
        user_principal_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword email: The email of the client.
        :paramtype email: str
        :keyword name: The name of the client.
        :paramtype name: str
        :keyword object_id: The object id of the client.
        :paramtype object_id: str
        :keyword user_principal_name: The user principal name of the client.
        :paramtype user_principal_name: str
        """
        super().__init__(**kwargs)
        self.email = email
        self.name = name
        self.object_id = object_id
        self.user_principal_name = user_principal_name


class CloudApplicationEntity(Entity):
    """Represents a cloud application entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar app_id: The technical identifier of the application.
    :vartype app_id: int
    :ivar app_name: The name of the related cloud application.
    :vartype app_name: str
    :ivar instance_name: The user defined instance name of the cloud application. It is often used
     to distinguish between several applications of the same type that a customer has.
    :vartype instance_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "app_id": {"readonly": True},
        "app_name": {"readonly": True},
        "instance_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "app_id": {"key": "properties.appId", "type": "int"},
        "app_name": {"key": "properties.appName", "type": "str"},
        "instance_name": {"key": "properties.instanceName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "CloudApplication"
        self.additional_data = None
        self.friendly_name = None
        self.app_id = None
        self.app_name = None
        self.instance_name = None


class CloudApplicationEntityProperties(EntityCommonProperties):
    """CloudApplication entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar app_id: The technical identifier of the application.
    :vartype app_id: int
    :ivar app_name: The name of the related cloud application.
    :vartype app_name: str
    :ivar instance_name: The user defined instance name of the cloud application. It is often used
     to distinguish between several applications of the same type that a customer has.
    :vartype instance_name: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "app_id": {"readonly": True},
        "app_name": {"readonly": True},
        "instance_name": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "app_id": {"key": "appId", "type": "int"},
        "app_name": {"key": "appName", "type": "str"},
        "instance_name": {"key": "instanceName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.app_id = None
        self.app_name = None
        self.instance_name = None


class CloudErrorBody(_serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class CodelessApiPollingDataConnector(DataConnector):
    """Represents Codeless API Polling data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar connector_ui_config: Config to describe the instructions blade.
    :vartype connector_ui_config:
     ~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigProperties
    :ivar polling_config: Config to describe the polling instructions.
    :vartype polling_config:
     ~azure.mgmt.securityinsight.models.CodelessConnectorPollingConfigProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "connector_ui_config": {"key": "properties.connectorUiConfig", "type": "CodelessUiConnectorConfigProperties"},
        "polling_config": {"key": "properties.pollingConfig", "type": "CodelessConnectorPollingConfigProperties"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        connector_ui_config: Optional["_models.CodelessUiConnectorConfigProperties"] = None,
        polling_config: Optional["_models.CodelessConnectorPollingConfigProperties"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword connector_ui_config: Config to describe the instructions blade.
        :paramtype connector_ui_config:
         ~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigProperties
        :keyword polling_config: Config to describe the polling instructions.
        :paramtype polling_config:
         ~azure.mgmt.securityinsight.models.CodelessConnectorPollingConfigProperties
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "APIPolling"
        self.connector_ui_config = connector_ui_config
        self.polling_config = polling_config


class CodelessConnectorPollingAuthProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describe the authentication properties needed to successfully authenticate with the server.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The authentication type. Required.
    :vartype auth_type: str
    :ivar api_key_name: The header name which the token is sent with.
    :vartype api_key_name: str
    :ivar api_key_identifier: A prefix send in the header before the actual token.
    :vartype api_key_identifier: str
    :ivar is_api_key_in_post_payload: Marks if the key should sent in header.
    :vartype is_api_key_in_post_payload: str
    :ivar flow_name: Describes the flow name, for example 'AuthCode' for Oauth 2.0.
    :vartype flow_name: str
    :ivar token_endpoint: The endpoint used to issue a token, used in Oauth 2.0 flow.
    :vartype token_endpoint: str
    :ivar authorization_endpoint: The endpoint used to authorize the user, used in Oauth 2.0 flow.
    :vartype authorization_endpoint: str
    :ivar authorization_endpoint_query_parameters: The query parameters used in authorization
     request, used in Oauth 2.0 flow.
    :vartype authorization_endpoint_query_parameters: JSON
    :ivar redirection_endpoint: The redirect endpoint where we will get the authorization code,
     used in Oauth 2.0 flow.
    :vartype redirection_endpoint: str
    :ivar token_endpoint_headers: The query headers used in token request, used in Oauth 2.0 flow.
    :vartype token_endpoint_headers: JSON
    :ivar token_endpoint_query_parameters: The query parameters used in token request, used in
     Oauth 2.0 flow.
    :vartype token_endpoint_query_parameters: JSON
    :ivar is_client_secret_in_header: Marks if we should send the client secret in header or
     payload, used in Oauth 2.0 flow.
    :vartype is_client_secret_in_header: bool
    :ivar scope: The OAuth token scope.
    :vartype scope: str
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "api_key_name": {"key": "apiKeyName", "type": "str"},
        "api_key_identifier": {"key": "apiKeyIdentifier", "type": "str"},
        "is_api_key_in_post_payload": {"key": "isApiKeyInPostPayload", "type": "str"},
        "flow_name": {"key": "flowName", "type": "str"},
        "token_endpoint": {"key": "tokenEndpoint", "type": "str"},
        "authorization_endpoint": {"key": "authorizationEndpoint", "type": "str"},
        "authorization_endpoint_query_parameters": {"key": "authorizationEndpointQueryParameters", "type": "object"},
        "redirection_endpoint": {"key": "redirectionEndpoint", "type": "str"},
        "token_endpoint_headers": {"key": "tokenEndpointHeaders", "type": "object"},
        "token_endpoint_query_parameters": {"key": "tokenEndpointQueryParameters", "type": "object"},
        "is_client_secret_in_header": {"key": "isClientSecretInHeader", "type": "bool"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        auth_type: str,
        api_key_name: Optional[str] = None,
        api_key_identifier: Optional[str] = None,
        is_api_key_in_post_payload: Optional[str] = None,
        flow_name: Optional[str] = None,
        token_endpoint: Optional[str] = None,
        authorization_endpoint: Optional[str] = None,
        authorization_endpoint_query_parameters: Optional[JSON] = None,
        redirection_endpoint: Optional[str] = None,
        token_endpoint_headers: Optional[JSON] = None,
        token_endpoint_query_parameters: Optional[JSON] = None,
        is_client_secret_in_header: Optional[bool] = None,
        scope: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword auth_type: The authentication type. Required.
        :paramtype auth_type: str
        :keyword api_key_name: The header name which the token is sent with.
        :paramtype api_key_name: str
        :keyword api_key_identifier: A prefix send in the header before the actual token.
        :paramtype api_key_identifier: str
        :keyword is_api_key_in_post_payload: Marks if the key should sent in header.
        :paramtype is_api_key_in_post_payload: str
        :keyword flow_name: Describes the flow name, for example 'AuthCode' for Oauth 2.0.
        :paramtype flow_name: str
        :keyword token_endpoint: The endpoint used to issue a token, used in Oauth 2.0 flow.
        :paramtype token_endpoint: str
        :keyword authorization_endpoint: The endpoint used to authorize the user, used in Oauth 2.0
         flow.
        :paramtype authorization_endpoint: str
        :keyword authorization_endpoint_query_parameters: The query parameters used in authorization
         request, used in Oauth 2.0 flow.
        :paramtype authorization_endpoint_query_parameters: JSON
        :keyword redirection_endpoint: The redirect endpoint where we will get the authorization code,
         used in Oauth 2.0 flow.
        :paramtype redirection_endpoint: str
        :keyword token_endpoint_headers: The query headers used in token request, used in Oauth 2.0
         flow.
        :paramtype token_endpoint_headers: JSON
        :keyword token_endpoint_query_parameters: The query parameters used in token request, used in
         Oauth 2.0 flow.
        :paramtype token_endpoint_query_parameters: JSON
        :keyword is_client_secret_in_header: Marks if we should send the client secret in header or
         payload, used in Oauth 2.0 flow.
        :paramtype is_client_secret_in_header: bool
        :keyword scope: The OAuth token scope.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.auth_type = auth_type
        self.api_key_name = api_key_name
        self.api_key_identifier = api_key_identifier
        self.is_api_key_in_post_payload = is_api_key_in_post_payload
        self.flow_name = flow_name
        self.token_endpoint = token_endpoint
        self.authorization_endpoint = authorization_endpoint
        self.authorization_endpoint_query_parameters = authorization_endpoint_query_parameters
        self.redirection_endpoint = redirection_endpoint
        self.token_endpoint_headers = token_endpoint_headers
        self.token_endpoint_query_parameters = token_endpoint_query_parameters
        self.is_client_secret_in_header = is_client_secret_in_header
        self.scope = scope


class CodelessConnectorPollingConfigProperties(_serialization.Model):
    """Config to describe the polling config for API poller connector.

    All required parameters must be populated in order to send to Azure.

    :ivar is_active: The poller active status.
    :vartype is_active: bool
    :ivar auth: Describe the authentication type of the poller. Required.
    :vartype auth: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingAuthProperties
    :ivar request: Describe the poll request config parameters of the poller. Required.
    :vartype request: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingRequestProperties
    :ivar paging: Describe the poll request paging config of the poller.
    :vartype paging: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingPagingProperties
    :ivar response: Describe the response config parameters of the poller.
    :vartype response:
     ~azure.mgmt.securityinsight.models.CodelessConnectorPollingResponseProperties
    """

    _validation = {
        "auth": {"required": True},
        "request": {"required": True},
    }

    _attribute_map = {
        "is_active": {"key": "isActive", "type": "bool"},
        "auth": {"key": "auth", "type": "CodelessConnectorPollingAuthProperties"},
        "request": {"key": "request", "type": "CodelessConnectorPollingRequestProperties"},
        "paging": {"key": "paging", "type": "CodelessConnectorPollingPagingProperties"},
        "response": {"key": "response", "type": "CodelessConnectorPollingResponseProperties"},
    }

    def __init__(
        self,
        *,
        auth: "_models.CodelessConnectorPollingAuthProperties",
        request: "_models.CodelessConnectorPollingRequestProperties",
        is_active: Optional[bool] = None,
        paging: Optional["_models.CodelessConnectorPollingPagingProperties"] = None,
        response: Optional["_models.CodelessConnectorPollingResponseProperties"] = None,
        **kwargs
    ):
        """
        :keyword is_active: The poller active status.
        :paramtype is_active: bool
        :keyword auth: Describe the authentication type of the poller. Required.
        :paramtype auth: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingAuthProperties
        :keyword request: Describe the poll request config parameters of the poller. Required.
        :paramtype request:
         ~azure.mgmt.securityinsight.models.CodelessConnectorPollingRequestProperties
        :keyword paging: Describe the poll request paging config of the poller.
        :paramtype paging: ~azure.mgmt.securityinsight.models.CodelessConnectorPollingPagingProperties
        :keyword response: Describe the response config parameters of the poller.
        :paramtype response:
         ~azure.mgmt.securityinsight.models.CodelessConnectorPollingResponseProperties
        """
        super().__init__(**kwargs)
        self.is_active = is_active
        self.auth = auth
        self.request = request
        self.paging = paging
        self.response = response


class CodelessConnectorPollingPagingProperties(_serialization.Model):
    """Describe the properties needed to make a pagination call.

    All required parameters must be populated in order to send to Azure.

    :ivar paging_type: Describes the type. could be 'None', 'PageToken', 'PageCount', 'TimeStamp'.
     Required.
    :vartype paging_type: str
    :ivar next_page_para_name: Defines the name of a next page attribute.
    :vartype next_page_para_name: str
    :ivar next_page_token_json_path: Defines the path to a next page token JSON.
    :vartype next_page_token_json_path: str
    :ivar page_count_attribute_path: Defines the path to a page count attribute.
    :vartype page_count_attribute_path: str
    :ivar page_total_count_attribute_path: Defines the path to a page total count attribute.
    :vartype page_total_count_attribute_path: str
    :ivar page_time_stamp_attribute_path: Defines the path to a paging time stamp attribute.
    :vartype page_time_stamp_attribute_path: str
    :ivar search_the_latest_time_stamp_from_events_list: Determines whether to search for the
     latest time stamp in the events list.
    :vartype search_the_latest_time_stamp_from_events_list: str
    :ivar page_size_para_name: Defines the name of the page size parameter.
    :vartype page_size_para_name: str
    :ivar page_size: Defines the paging size.
    :vartype page_size: int
    """

    _validation = {
        "paging_type": {"required": True},
    }

    _attribute_map = {
        "paging_type": {"key": "pagingType", "type": "str"},
        "next_page_para_name": {"key": "nextPageParaName", "type": "str"},
        "next_page_token_json_path": {"key": "nextPageTokenJsonPath", "type": "str"},
        "page_count_attribute_path": {"key": "pageCountAttributePath", "type": "str"},
        "page_total_count_attribute_path": {"key": "pageTotalCountAttributePath", "type": "str"},
        "page_time_stamp_attribute_path": {"key": "pageTimeStampAttributePath", "type": "str"},
        "search_the_latest_time_stamp_from_events_list": {
            "key": "searchTheLatestTimeStampFromEventsList",
            "type": "str",
        },
        "page_size_para_name": {"key": "pageSizeParaName", "type": "str"},
        "page_size": {"key": "pageSize", "type": "int"},
    }

    def __init__(
        self,
        *,
        paging_type: str,
        next_page_para_name: Optional[str] = None,
        next_page_token_json_path: Optional[str] = None,
        page_count_attribute_path: Optional[str] = None,
        page_total_count_attribute_path: Optional[str] = None,
        page_time_stamp_attribute_path: Optional[str] = None,
        search_the_latest_time_stamp_from_events_list: Optional[str] = None,
        page_size_para_name: Optional[str] = None,
        page_size: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword paging_type: Describes the type. could be 'None', 'PageToken', 'PageCount',
         'TimeStamp'. Required.
        :paramtype paging_type: str
        :keyword next_page_para_name: Defines the name of a next page attribute.
        :paramtype next_page_para_name: str
        :keyword next_page_token_json_path: Defines the path to a next page token JSON.
        :paramtype next_page_token_json_path: str
        :keyword page_count_attribute_path: Defines the path to a page count attribute.
        :paramtype page_count_attribute_path: str
        :keyword page_total_count_attribute_path: Defines the path to a page total count attribute.
        :paramtype page_total_count_attribute_path: str
        :keyword page_time_stamp_attribute_path: Defines the path to a paging time stamp attribute.
        :paramtype page_time_stamp_attribute_path: str
        :keyword search_the_latest_time_stamp_from_events_list: Determines whether to search for the
         latest time stamp in the events list.
        :paramtype search_the_latest_time_stamp_from_events_list: str
        :keyword page_size_para_name: Defines the name of the page size parameter.
        :paramtype page_size_para_name: str
        :keyword page_size: Defines the paging size.
        :paramtype page_size: int
        """
        super().__init__(**kwargs)
        self.paging_type = paging_type
        self.next_page_para_name = next_page_para_name
        self.next_page_token_json_path = next_page_token_json_path
        self.page_count_attribute_path = page_count_attribute_path
        self.page_total_count_attribute_path = page_total_count_attribute_path
        self.page_time_stamp_attribute_path = page_time_stamp_attribute_path
        self.search_the_latest_time_stamp_from_events_list = search_the_latest_time_stamp_from_events_list
        self.page_size_para_name = page_size_para_name
        self.page_size = page_size


class CodelessConnectorPollingRequestProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describe the request properties needed to successfully pull from the server.

    All required parameters must be populated in order to send to Azure.

    :ivar api_endpoint: Describe the endpoint we should pull the data from. Required.
    :vartype api_endpoint: str
    :ivar rate_limit_qps: Defines the rate limit QPS.
    :vartype rate_limit_qps: int
    :ivar query_window_in_min: The window interval we will use the pull the data. Required.
    :vartype query_window_in_min: int
    :ivar http_method: The http method type we will use in the poll request, GET or POST. Required.
    :vartype http_method: str
    :ivar query_time_format: The time format will be used the query events in a specific window.
     Required.
    :vartype query_time_format: str
    :ivar retry_count: Describe the amount of time we should try and poll the data in case of
     failure.
    :vartype retry_count: int
    :ivar timeout_in_seconds: The number of seconds we will consider as a request timeout.
    :vartype timeout_in_seconds: int
    :ivar headers: Describe the headers sent in the poll request.
    :vartype headers: JSON
    :ivar query_parameters: Describe the query parameters sent in the poll request.
    :vartype query_parameters: JSON
    :ivar query_parameters_template: For advanced scenarios for example user name/password embedded
     in nested JSON payload.
    :vartype query_parameters_template: str
    :ivar start_time_attribute_name: This will be used the query events from a start of the time
     window.
    :vartype start_time_attribute_name: str
    :ivar end_time_attribute_name: This will be used the query events from the end of the time
     window.
    :vartype end_time_attribute_name: str
    """

    _validation = {
        "api_endpoint": {"required": True},
        "query_window_in_min": {"required": True},
        "http_method": {"required": True},
        "query_time_format": {"required": True},
    }

    _attribute_map = {
        "api_endpoint": {"key": "apiEndpoint", "type": "str"},
        "rate_limit_qps": {"key": "rateLimitQps", "type": "int"},
        "query_window_in_min": {"key": "queryWindowInMin", "type": "int"},
        "http_method": {"key": "httpMethod", "type": "str"},
        "query_time_format": {"key": "queryTimeFormat", "type": "str"},
        "retry_count": {"key": "retryCount", "type": "int"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "headers": {"key": "headers", "type": "object"},
        "query_parameters": {"key": "queryParameters", "type": "object"},
        "query_parameters_template": {"key": "queryParametersTemplate", "type": "str"},
        "start_time_attribute_name": {"key": "startTimeAttributeName", "type": "str"},
        "end_time_attribute_name": {"key": "endTimeAttributeName", "type": "str"},
    }

    def __init__(
        self,
        *,
        api_endpoint: str,
        query_window_in_min: int,
        http_method: str,
        query_time_format: str,
        rate_limit_qps: Optional[int] = None,
        retry_count: Optional[int] = None,
        timeout_in_seconds: Optional[int] = None,
        headers: Optional[JSON] = None,
        query_parameters: Optional[JSON] = None,
        query_parameters_template: Optional[str] = None,
        start_time_attribute_name: Optional[str] = None,
        end_time_attribute_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword api_endpoint: Describe the endpoint we should pull the data from. Required.
        :paramtype api_endpoint: str
        :keyword rate_limit_qps: Defines the rate limit QPS.
        :paramtype rate_limit_qps: int
        :keyword query_window_in_min: The window interval we will use the pull the data. Required.
        :paramtype query_window_in_min: int
        :keyword http_method: The http method type we will use in the poll request, GET or POST.
         Required.
        :paramtype http_method: str
        :keyword query_time_format: The time format will be used the query events in a specific window.
         Required.
        :paramtype query_time_format: str
        :keyword retry_count: Describe the amount of time we should try and poll the data in case of
         failure.
        :paramtype retry_count: int
        :keyword timeout_in_seconds: The number of seconds we will consider as a request timeout.
        :paramtype timeout_in_seconds: int
        :keyword headers: Describe the headers sent in the poll request.
        :paramtype headers: JSON
        :keyword query_parameters: Describe the query parameters sent in the poll request.
        :paramtype query_parameters: JSON
        :keyword query_parameters_template: For advanced scenarios for example user name/password
         embedded in nested JSON payload.
        :paramtype query_parameters_template: str
        :keyword start_time_attribute_name: This will be used the query events from a start of the time
         window.
        :paramtype start_time_attribute_name: str
        :keyword end_time_attribute_name: This will be used the query events from the end of the time
         window.
        :paramtype end_time_attribute_name: str
        """
        super().__init__(**kwargs)
        self.api_endpoint = api_endpoint
        self.rate_limit_qps = rate_limit_qps
        self.query_window_in_min = query_window_in_min
        self.http_method = http_method
        self.query_time_format = query_time_format
        self.retry_count = retry_count
        self.timeout_in_seconds = timeout_in_seconds
        self.headers = headers
        self.query_parameters = query_parameters
        self.query_parameters_template = query_parameters_template
        self.start_time_attribute_name = start_time_attribute_name
        self.end_time_attribute_name = end_time_attribute_name


class CodelessConnectorPollingResponseProperties(_serialization.Model):
    """Describes the response from the external server.

    All required parameters must be populated in order to send to Azure.

    :ivar events_json_paths: Describes the path we should extract the data in the response.
     Required.
    :vartype events_json_paths: list[str]
    :ivar success_status_json_path: Describes the path we should extract the status code in the
     response.
    :vartype success_status_json_path: str
    :ivar success_status_value: Describes the path we should extract the status value in the
     response.
    :vartype success_status_value: str
    :ivar is_gzip_compressed: Describes if the data in the response is Gzip.
    :vartype is_gzip_compressed: bool
    """

    _validation = {
        "events_json_paths": {"required": True},
    }

    _attribute_map = {
        "events_json_paths": {"key": "eventsJsonPaths", "type": "[str]"},
        "success_status_json_path": {"key": "successStatusJsonPath", "type": "str"},
        "success_status_value": {"key": "successStatusValue", "type": "str"},
        "is_gzip_compressed": {"key": "isGzipCompressed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        events_json_paths: List[str],
        success_status_json_path: Optional[str] = None,
        success_status_value: Optional[str] = None,
        is_gzip_compressed: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword events_json_paths: Describes the path we should extract the data in the response.
         Required.
        :paramtype events_json_paths: list[str]
        :keyword success_status_json_path: Describes the path we should extract the status code in the
         response.
        :paramtype success_status_json_path: str
        :keyword success_status_value: Describes the path we should extract the status value in the
         response.
        :paramtype success_status_value: str
        :keyword is_gzip_compressed: Describes if the data in the response is Gzip.
        :paramtype is_gzip_compressed: bool
        """
        super().__init__(**kwargs)
        self.events_json_paths = events_json_paths
        self.success_status_json_path = success_status_json_path
        self.success_status_value = success_status_value
        self.is_gzip_compressed = is_gzip_compressed


class CodelessUiConnectorConfigProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Config to describe the instructions blade.

    All required parameters must be populated in order to send to Azure.

    :ivar title: Connector blade title. Required.
    :vartype title: str
    :ivar publisher: Connector publisher name. Required.
    :vartype publisher: str
    :ivar description_markdown: Connector description. Required.
    :vartype description_markdown: str
    :ivar custom_image: An optional custom image to be used when displaying the connector within
     Azure Sentinel's connector's gallery.
    :vartype custom_image: str
    :ivar graph_queries_table_name: Name of the table the connector will insert the data to.
     Required.
    :vartype graph_queries_table_name: str
    :ivar graph_queries: The graph query to show the current data status. Required.
    :vartype graph_queries:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesGraphQueriesItem]
    :ivar sample_queries: The sample queries for the connector. Required.
    :vartype sample_queries:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesSampleQueriesItem]
    :ivar data_types: Data types to check for last data received. Required.
    :vartype data_types:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesDataTypesItem]
    :ivar connectivity_criteria: Define the way the connector check connectivity. Required.
    :vartype connectivity_criteria:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem]
    :ivar availability: Connector Availability Status. Required.
    :vartype availability: ~azure.mgmt.securityinsight.models.Availability
    :ivar permissions: Permissions required for the connector. Required.
    :vartype permissions: ~azure.mgmt.securityinsight.models.Permissions
    :ivar instruction_steps: Instruction steps to enable the connector. Required.
    :vartype instruction_steps:
     list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesInstructionStepsItem]
    """

    _validation = {
        "title": {"required": True},
        "publisher": {"required": True},
        "description_markdown": {"required": True},
        "graph_queries_table_name": {"required": True},
        "graph_queries": {"required": True},
        "sample_queries": {"required": True},
        "data_types": {"required": True},
        "connectivity_criteria": {"required": True},
        "availability": {"required": True},
        "permissions": {"required": True},
        "instruction_steps": {"required": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "description_markdown": {"key": "descriptionMarkdown", "type": "str"},
        "custom_image": {"key": "customImage", "type": "str"},
        "graph_queries_table_name": {"key": "graphQueriesTableName", "type": "str"},
        "graph_queries": {"key": "graphQueries", "type": "[CodelessUiConnectorConfigPropertiesGraphQueriesItem]"},
        "sample_queries": {"key": "sampleQueries", "type": "[CodelessUiConnectorConfigPropertiesSampleQueriesItem]"},
        "data_types": {"key": "dataTypes", "type": "[CodelessUiConnectorConfigPropertiesDataTypesItem]"},
        "connectivity_criteria": {
            "key": "connectivityCriteria",
            "type": "[CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem]",
        },
        "availability": {"key": "availability", "type": "Availability"},
        "permissions": {"key": "permissions", "type": "Permissions"},
        "instruction_steps": {
            "key": "instructionSteps",
            "type": "[CodelessUiConnectorConfigPropertiesInstructionStepsItem]",
        },
    }

    def __init__(
        self,
        *,
        title: str,
        publisher: str,
        description_markdown: str,
        graph_queries_table_name: str,
        graph_queries: List["_models.CodelessUiConnectorConfigPropertiesGraphQueriesItem"],
        sample_queries: List["_models.CodelessUiConnectorConfigPropertiesSampleQueriesItem"],
        data_types: List["_models.CodelessUiConnectorConfigPropertiesDataTypesItem"],
        connectivity_criteria: List["_models.CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem"],
        availability: "_models.Availability",
        permissions: "_models.Permissions",
        instruction_steps: List["_models.CodelessUiConnectorConfigPropertiesInstructionStepsItem"],
        custom_image: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword title: Connector blade title. Required.
        :paramtype title: str
        :keyword publisher: Connector publisher name. Required.
        :paramtype publisher: str
        :keyword description_markdown: Connector description. Required.
        :paramtype description_markdown: str
        :keyword custom_image: An optional custom image to be used when displaying the connector within
         Azure Sentinel's connector's gallery.
        :paramtype custom_image: str
        :keyword graph_queries_table_name: Name of the table the connector will insert the data to.
         Required.
        :paramtype graph_queries_table_name: str
        :keyword graph_queries: The graph query to show the current data status. Required.
        :paramtype graph_queries:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesGraphQueriesItem]
        :keyword sample_queries: The sample queries for the connector. Required.
        :paramtype sample_queries:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesSampleQueriesItem]
        :keyword data_types: Data types to check for last data received. Required.
        :paramtype data_types:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesDataTypesItem]
        :keyword connectivity_criteria: Define the way the connector check connectivity. Required.
        :paramtype connectivity_criteria:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem]
        :keyword availability: Connector Availability Status. Required.
        :paramtype availability: ~azure.mgmt.securityinsight.models.Availability
        :keyword permissions: Permissions required for the connector. Required.
        :paramtype permissions: ~azure.mgmt.securityinsight.models.Permissions
        :keyword instruction_steps: Instruction steps to enable the connector. Required.
        :paramtype instruction_steps:
         list[~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigPropertiesInstructionStepsItem]
        """
        super().__init__(**kwargs)
        self.title = title
        self.publisher = publisher
        self.description_markdown = description_markdown
        self.custom_image = custom_image
        self.graph_queries_table_name = graph_queries_table_name
        self.graph_queries = graph_queries
        self.sample_queries = sample_queries
        self.data_types = data_types
        self.connectivity_criteria = connectivity_criteria
        self.availability = availability
        self.permissions = permissions
        self.instruction_steps = instruction_steps


class ConnectivityCriteria(_serialization.Model):
    """Setting for the connector check connectivity.

    :ivar type: type of connectivity. "IsConnectedQuery"
    :vartype type: str or ~azure.mgmt.securityinsight.models.ConnectivityType
    :ivar value: Queries for checking connectivity.
    :vartype value: list[str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ConnectivityType"]] = None,
        value: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: type of connectivity. "IsConnectedQuery"
        :paramtype type: str or ~azure.mgmt.securityinsight.models.ConnectivityType
        :keyword value: Queries for checking connectivity.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.value = value


class CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem(ConnectivityCriteria):
    """CodelessUiConnectorConfigPropertiesConnectivityCriteriaItem.

    :ivar type: type of connectivity. "IsConnectedQuery"
    :vartype type: str or ~azure.mgmt.securityinsight.models.ConnectivityType
    :ivar value: Queries for checking connectivity.
    :vartype value: list[str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ConnectivityType"]] = None,
        value: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: type of connectivity. "IsConnectedQuery"
        :paramtype type: str or ~azure.mgmt.securityinsight.models.ConnectivityType
        :keyword value: Queries for checking connectivity.
        :paramtype value: list[str]
        """
        super().__init__(type=type, value=value, **kwargs)


class LastDataReceivedDataType(_serialization.Model):
    """Data type for last data received.

    :ivar name: Name of the data type to show in the graph. can be use with
     {{graphQueriesTableName}} placeholder.
    :vartype name: str
    :ivar last_data_received_query: Query for indicate last data received.
    :vartype last_data_received_query: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "last_data_received_query": {"key": "lastDataReceivedQuery", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, last_data_received_query: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the data type to show in the graph. can be use with
         {{graphQueriesTableName}} placeholder.
        :paramtype name: str
        :keyword last_data_received_query: Query for indicate last data received.
        :paramtype last_data_received_query: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.last_data_received_query = last_data_received_query


class CodelessUiConnectorConfigPropertiesDataTypesItem(LastDataReceivedDataType):
    """CodelessUiConnectorConfigPropertiesDataTypesItem.

    :ivar name: Name of the data type to show in the graph. can be use with
     {{graphQueriesTableName}} placeholder.
    :vartype name: str
    :ivar last_data_received_query: Query for indicate last data received.
    :vartype last_data_received_query: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "last_data_received_query": {"key": "lastDataReceivedQuery", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, last_data_received_query: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the data type to show in the graph. can be use with
         {{graphQueriesTableName}} placeholder.
        :paramtype name: str
        :keyword last_data_received_query: Query for indicate last data received.
        :paramtype last_data_received_query: str
        """
        super().__init__(name=name, last_data_received_query=last_data_received_query, **kwargs)


class GraphQueries(_serialization.Model):
    """The graph query to show the current data status.

    :ivar metric_name: the metric that the query is checking.
    :vartype metric_name: str
    :ivar legend: The legend for the graph.
    :vartype legend: str
    :ivar base_query: The base query for the graph.
    :vartype base_query: str
    """

    _attribute_map = {
        "metric_name": {"key": "metricName", "type": "str"},
        "legend": {"key": "legend", "type": "str"},
        "base_query": {"key": "baseQuery", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric_name: Optional[str] = None,
        legend: Optional[str] = None,
        base_query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword metric_name: the metric that the query is checking.
        :paramtype metric_name: str
        :keyword legend: The legend for the graph.
        :paramtype legend: str
        :keyword base_query: The base query for the graph.
        :paramtype base_query: str
        """
        super().__init__(**kwargs)
        self.metric_name = metric_name
        self.legend = legend
        self.base_query = base_query


class CodelessUiConnectorConfigPropertiesGraphQueriesItem(GraphQueries):
    """CodelessUiConnectorConfigPropertiesGraphQueriesItem.

    :ivar metric_name: the metric that the query is checking.
    :vartype metric_name: str
    :ivar legend: The legend for the graph.
    :vartype legend: str
    :ivar base_query: The base query for the graph.
    :vartype base_query: str
    """

    _attribute_map = {
        "metric_name": {"key": "metricName", "type": "str"},
        "legend": {"key": "legend", "type": "str"},
        "base_query": {"key": "baseQuery", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric_name: Optional[str] = None,
        legend: Optional[str] = None,
        base_query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword metric_name: the metric that the query is checking.
        :paramtype metric_name: str
        :keyword legend: The legend for the graph.
        :paramtype legend: str
        :keyword base_query: The base query for the graph.
        :paramtype base_query: str
        """
        super().__init__(metric_name=metric_name, legend=legend, base_query=base_query, **kwargs)


class InstructionSteps(_serialization.Model):
    """Instruction steps to enable the connector.

    :ivar title: Instruction step title.
    :vartype title: str
    :ivar description: Instruction step description.
    :vartype description: str
    :ivar instructions: Instruction step details.
    :vartype instructions:
     list[~azure.mgmt.securityinsight.models.InstructionStepsInstructionsItem]
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "instructions": {"key": "instructions", "type": "[InstructionStepsInstructionsItem]"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        instructions: Optional[List["_models.InstructionStepsInstructionsItem"]] = None,
        **kwargs
    ):
        """
        :keyword title: Instruction step title.
        :paramtype title: str
        :keyword description: Instruction step description.
        :paramtype description: str
        :keyword instructions: Instruction step details.
        :paramtype instructions:
         list[~azure.mgmt.securityinsight.models.InstructionStepsInstructionsItem]
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
        self.instructions = instructions


class CodelessUiConnectorConfigPropertiesInstructionStepsItem(InstructionSteps):
    """CodelessUiConnectorConfigPropertiesInstructionStepsItem.

    :ivar title: Instruction step title.
    :vartype title: str
    :ivar description: Instruction step description.
    :vartype description: str
    :ivar instructions: Instruction step details.
    :vartype instructions:
     list[~azure.mgmt.securityinsight.models.InstructionStepsInstructionsItem]
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "instructions": {"key": "instructions", "type": "[InstructionStepsInstructionsItem]"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        instructions: Optional[List["_models.InstructionStepsInstructionsItem"]] = None,
        **kwargs
    ):
        """
        :keyword title: Instruction step title.
        :paramtype title: str
        :keyword description: Instruction step description.
        :paramtype description: str
        :keyword instructions: Instruction step details.
        :paramtype instructions:
         list[~azure.mgmt.securityinsight.models.InstructionStepsInstructionsItem]
        """
        super().__init__(title=title, description=description, instructions=instructions, **kwargs)


class SampleQueries(_serialization.Model):
    """The sample queries for the connector.

    :ivar description: The sample query description.
    :vartype description: str
    :ivar query: the sample query.
    :vartype query: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, query: Optional[str] = None, **kwargs):
        """
        :keyword description: The sample query description.
        :paramtype description: str
        :keyword query: the sample query.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.query = query


class CodelessUiConnectorConfigPropertiesSampleQueriesItem(SampleQueries):
    """CodelessUiConnectorConfigPropertiesSampleQueriesItem.

    :ivar description: The sample query description.
    :vartype description: str
    :ivar query: the sample query.
    :vartype query: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, query: Optional[str] = None, **kwargs):
        """
        :keyword description: The sample query description.
        :paramtype description: str
        :keyword query: the sample query.
        :paramtype query: str
        """
        super().__init__(description=description, query=query, **kwargs)


class CodelessUiDataConnector(DataConnector):
    """Represents Codeless UI data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar connector_ui_config: Config to describe the instructions blade.
    :vartype connector_ui_config:
     ~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "connector_ui_config": {"key": "properties.connectorUiConfig", "type": "CodelessUiConnectorConfigProperties"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        connector_ui_config: Optional["_models.CodelessUiConnectorConfigProperties"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword connector_ui_config: Config to describe the instructions blade.
        :paramtype connector_ui_config:
         ~azure.mgmt.securityinsight.models.CodelessUiConnectorConfigProperties
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "GenericUI"
        self.connector_ui_config = connector_ui_config


class ConnectedEntity(_serialization.Model):
    """Expansion result connected entities.

    :ivar target_entity_id: Entity Id of the connected entity.
    :vartype target_entity_id: str
    :ivar additional_data: key-value pairs for a connected entity mapping.
    :vartype additional_data: JSON
    """

    _attribute_map = {
        "target_entity_id": {"key": "targetEntityId", "type": "str"},
        "additional_data": {"key": "additionalData", "type": "object"},
    }

    def __init__(self, *, target_entity_id: Optional[str] = None, additional_data: Optional[JSON] = None, **kwargs):
        """
        :keyword target_entity_id: Entity Id of the connected entity.
        :paramtype target_entity_id: str
        :keyword additional_data: key-value pairs for a connected entity mapping.
        :paramtype additional_data: JSON
        """
        super().__init__(**kwargs)
        self.target_entity_id = target_entity_id
        self.additional_data = additional_data


class ConnectorInstructionModelBase(_serialization.Model):
    """Instruction step details.

    All required parameters must be populated in order to send to Azure.

    :ivar parameters: The parameters for the setting.
    :vartype parameters: JSON
    :ivar type: The kind of the setting. Required. Known values are: "CopyableLabel",
     "InstructionStepsGroup", and "InfoMessage".
    :vartype type: str or ~azure.mgmt.securityinsight.models.SettingType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "object"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.SettingType"], parameters: Optional[JSON] = None, **kwargs):
        """
        :keyword parameters: The parameters for the setting.
        :paramtype parameters: JSON
        :keyword type: The kind of the setting. Required. Known values are: "CopyableLabel",
         "InstructionStepsGroup", and "InfoMessage".
        :paramtype type: str or ~azure.mgmt.securityinsight.models.SettingType
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.type = type


class Content(_serialization.Model):
    """Content section of the recommendation.

    All required parameters must be populated in order to send to Azure.

    :ivar title: Title of the content. Required.
    :vartype title: str
    :ivar description: Description of the content. Required.
    :vartype description: str
    """

    _validation = {
        "title": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, title: str, description: str, **kwargs):
        """
        :keyword title: Title of the content. Required.
        :paramtype title: str
        :keyword description: Description of the content. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description


class ContentPathMap(_serialization.Model):
    """The mapping of content type to a repo path.

    :ivar content_type: Content type. Known values are: "AnalyticRule" and "Workbook".
    :vartype content_type: str or ~azure.mgmt.securityinsight.models.ContentType
    :ivar path: The path to the content.
    :vartype path: str
    """

    _attribute_map = {
        "content_type": {"key": "contentType", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self, *, content_type: Optional[Union[str, "_models.ContentType"]] = None, path: Optional[str] = None, **kwargs
    ):
        """
        :keyword content_type: Content type. Known values are: "AnalyticRule" and "Workbook".
        :paramtype content_type: str or ~azure.mgmt.securityinsight.models.ContentType
        :keyword path: The path to the content.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.content_type = content_type
        self.path = path


class CustomsPermission(_serialization.Model):
    """Customs permissions required for the connector.

    :ivar name: Customs permissions name.
    :vartype name: str
    :ivar description: Customs permissions description.
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs):
        """
        :keyword name: Customs permissions name.
        :paramtype name: str
        :keyword description: Customs permissions description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description


class Customs(CustomsPermission):
    """Customs permissions required for the connector.

    :ivar name: Customs permissions name.
    :vartype name: str
    :ivar description: Customs permissions description.
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs):
        """
        :keyword name: Customs permissions name.
        :paramtype name: str
        :keyword description: Customs permissions description.
        :paramtype description: str
        """
        super().__init__(name=name, description=description, **kwargs)


class DataConnectorConnectBody(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Represents Codeless API Polling data connector.

    :ivar kind: The authentication kind used to poll the data. Known values are: "Basic", "OAuth2",
     and "APIKey".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.ConnectAuthKind
    :ivar api_key: The API key of the audit server.
    :vartype api_key: str
    :ivar data_collection_endpoint: Used in v2 logs connector. Represents the data collection
     ingestion endpoint in log analytics.
    :vartype data_collection_endpoint: str
    :ivar data_collection_rule_immutable_id: Used in v2 logs connector. The data collection rule
     immutable id, the rule defines the transformation and data destination.
    :vartype data_collection_rule_immutable_id: str
    :ivar output_stream: Used in v2 logs connector. The stream we are sending the data to, this is
     the name of the streamDeclarations defined in the DCR.
    :vartype output_stream: str
    :ivar client_secret: The client secret of the OAuth 2.0 application.
    :vartype client_secret: str
    :ivar client_id: The client id of the OAuth 2.0 application.
    :vartype client_id: str
    :ivar authorization_code: The authorization code used in OAuth 2.0 code flow to issue a token.
    :vartype authorization_code: str
    :ivar user_name: The user name in the audit log server.
    :vartype user_name: str
    :ivar password: The user password in the audit log server.
    :vartype password: str
    :ivar request_config_user_input_values:
    :vartype request_config_user_input_values: list[JSON]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "api_key": {"key": "apiKey", "type": "str"},
        "data_collection_endpoint": {"key": "dataCollectionEndpoint", "type": "str"},
        "data_collection_rule_immutable_id": {"key": "dataCollectionRuleImmutableId", "type": "str"},
        "output_stream": {"key": "outputStream", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "authorization_code": {"key": "authorizationCode", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "request_config_user_input_values": {"key": "requestConfigUserInputValues", "type": "[object]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.ConnectAuthKind"]] = None,
        api_key: Optional[str] = None,
        data_collection_endpoint: Optional[str] = None,
        data_collection_rule_immutable_id: Optional[str] = None,
        output_stream: Optional[str] = None,
        client_secret: Optional[str] = None,
        client_id: Optional[str] = None,
        authorization_code: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        request_config_user_input_values: Optional[List[JSON]] = None,
        **kwargs
    ):
        """
        :keyword kind: The authentication kind used to poll the data. Known values are: "Basic",
         "OAuth2", and "APIKey".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.ConnectAuthKind
        :keyword api_key: The API key of the audit server.
        :paramtype api_key: str
        :keyword data_collection_endpoint: Used in v2 logs connector. Represents the data collection
         ingestion endpoint in log analytics.
        :paramtype data_collection_endpoint: str
        :keyword data_collection_rule_immutable_id: Used in v2 logs connector. The data collection rule
         immutable id, the rule defines the transformation and data destination.
        :paramtype data_collection_rule_immutable_id: str
        :keyword output_stream: Used in v2 logs connector. The stream we are sending the data to, this
         is the name of the streamDeclarations defined in the DCR.
        :paramtype output_stream: str
        :keyword client_secret: The client secret of the OAuth 2.0 application.
        :paramtype client_secret: str
        :keyword client_id: The client id of the OAuth 2.0 application.
        :paramtype client_id: str
        :keyword authorization_code: The authorization code used in OAuth 2.0 code flow to issue a
         token.
        :paramtype authorization_code: str
        :keyword user_name: The user name in the audit log server.
        :paramtype user_name: str
        :keyword password: The user password in the audit log server.
        :paramtype password: str
        :keyword request_config_user_input_values:
        :paramtype request_config_user_input_values: list[JSON]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.api_key = api_key
        self.data_collection_endpoint = data_collection_endpoint
        self.data_collection_rule_immutable_id = data_collection_rule_immutable_id
        self.output_stream = output_stream
        self.client_secret = client_secret
        self.client_id = client_id
        self.authorization_code = authorization_code
        self.user_name = user_name
        self.password = password
        self.request_config_user_input_values = request_config_user_input_values


class DataConnectorList(_serialization.Model):
    """List all the data connectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of data connectors.
    :vartype next_link: str
    :ivar value: Array of data connectors. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.DataConnector]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DataConnector]"},
    }

    def __init__(self, *, value: List["_models.DataConnector"], **kwargs):
        """
        :keyword value: Array of data connectors. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.DataConnector]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class DataConnectorRequirementsState(_serialization.Model):
    """Data connector requirements status.

    :ivar authorization_state: Authorization state for this connector. Known values are: "Valid"
     and "Invalid".
    :vartype authorization_state: str or
     ~azure.mgmt.securityinsight.models.DataConnectorAuthorizationState
    :ivar license_state: License state for this connector. Known values are: "Valid", "Invalid",
     and "Unknown".
    :vartype license_state: str or ~azure.mgmt.securityinsight.models.DataConnectorLicenseState
    """

    _attribute_map = {
        "authorization_state": {"key": "authorizationState", "type": "str"},
        "license_state": {"key": "licenseState", "type": "str"},
    }

    def __init__(
        self,
        *,
        authorization_state: Optional[Union[str, "_models.DataConnectorAuthorizationState"]] = None,
        license_state: Optional[Union[str, "_models.DataConnectorLicenseState"]] = None,
        **kwargs
    ):
        """
        :keyword authorization_state: Authorization state for this connector. Known values are: "Valid"
         and "Invalid".
        :paramtype authorization_state: str or
         ~azure.mgmt.securityinsight.models.DataConnectorAuthorizationState
        :keyword license_state: License state for this connector. Known values are: "Valid", "Invalid",
         and "Unknown".
        :paramtype license_state: str or ~azure.mgmt.securityinsight.models.DataConnectorLicenseState
        """
        super().__init__(**kwargs)
        self.authorization_state = authorization_state
        self.license_state = license_state


class DataTypeDefinitions(_serialization.Model):
    """The data type definition.

    :ivar data_type: The data type name.
    :vartype data_type: str
    """

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
    }

    def __init__(self, *, data_type: Optional[str] = None, **kwargs):
        """
        :keyword data_type: The data type name.
        :paramtype data_type: str
        """
        super().__init__(**kwargs)
        self.data_type = data_type


class Deployment(_serialization.Model):
    """Description about a deployment.

    :ivar deployment_id: Deployment identifier.
    :vartype deployment_id: str
    :ivar deployment_state: Current status of the deployment. Known values are: "In_Progress",
     "Completed", "Queued", and "Canceling".
    :vartype deployment_state: str or ~azure.mgmt.securityinsight.models.DeploymentState
    :ivar deployment_result: The outcome of the deployment. Known values are: "Success",
     "Canceled", and "Failed".
    :vartype deployment_result: str or ~azure.mgmt.securityinsight.models.DeploymentResult
    :ivar deployment_time: The time when the deployment finished.
    :vartype deployment_time: ~datetime.datetime
    :ivar deployment_logs_url: Url to access repository action logs.
    :vartype deployment_logs_url: str
    """

    _attribute_map = {
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "deployment_state": {"key": "deploymentState", "type": "str"},
        "deployment_result": {"key": "deploymentResult", "type": "str"},
        "deployment_time": {"key": "deploymentTime", "type": "iso-8601"},
        "deployment_logs_url": {"key": "deploymentLogsUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        deployment_id: Optional[str] = None,
        deployment_state: Optional[Union[str, "_models.DeploymentState"]] = None,
        deployment_result: Optional[Union[str, "_models.DeploymentResult"]] = None,
        deployment_time: Optional[datetime.datetime] = None,
        deployment_logs_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword deployment_id: Deployment identifier.
        :paramtype deployment_id: str
        :keyword deployment_state: Current status of the deployment. Known values are: "In_Progress",
         "Completed", "Queued", and "Canceling".
        :paramtype deployment_state: str or ~azure.mgmt.securityinsight.models.DeploymentState
        :keyword deployment_result: The outcome of the deployment. Known values are: "Success",
         "Canceled", and "Failed".
        :paramtype deployment_result: str or ~azure.mgmt.securityinsight.models.DeploymentResult
        :keyword deployment_time: The time when the deployment finished.
        :paramtype deployment_time: ~datetime.datetime
        :keyword deployment_logs_url: Url to access repository action logs.
        :paramtype deployment_logs_url: str
        """
        super().__init__(**kwargs)
        self.deployment_id = deployment_id
        self.deployment_state = deployment_state
        self.deployment_result = deployment_result
        self.deployment_time = deployment_time
        self.deployment_logs_url = deployment_logs_url


class DeploymentInfo(_serialization.Model):
    """Information regarding a deployment.

    :ivar deployment_fetch_status: Status while fetching the last deployment. Known values are:
     "Success", "Unauthorized", and "NotFound".
    :vartype deployment_fetch_status: str or
     ~azure.mgmt.securityinsight.models.DeploymentFetchStatus
    :ivar deployment: Deployment information.
    :vartype deployment: ~azure.mgmt.securityinsight.models.Deployment
    :ivar message: Additional details about the deployment that can be shown to the user.
    :vartype message: str
    """

    _attribute_map = {
        "deployment_fetch_status": {"key": "deploymentFetchStatus", "type": "str"},
        "deployment": {"key": "deployment", "type": "Deployment"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        deployment_fetch_status: Optional[Union[str, "_models.DeploymentFetchStatus"]] = None,
        deployment: Optional["_models.Deployment"] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword deployment_fetch_status: Status while fetching the last deployment. Known values are:
         "Success", "Unauthorized", and "NotFound".
        :paramtype deployment_fetch_status: str or
         ~azure.mgmt.securityinsight.models.DeploymentFetchStatus
        :keyword deployment: Deployment information.
        :paramtype deployment: ~azure.mgmt.securityinsight.models.Deployment
        :keyword message: Additional details about the deployment that can be shown to the user.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.deployment_fetch_status = deployment_fetch_status
        self.deployment = deployment
        self.message = message


class DnsEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a dns entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar dns_server_ip_entity_id: An ip entity id for the dns server resolving the request.
    :vartype dns_server_ip_entity_id: str
    :ivar domain_name: The name of the dns record associated with the alert.
    :vartype domain_name: str
    :ivar host_ip_address_entity_id: An ip entity id for the dns request client.
    :vartype host_ip_address_entity_id: str
    :ivar ip_address_entity_ids: Ip entity identifiers for the resolved ip address.
    :vartype ip_address_entity_ids: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "dns_server_ip_entity_id": {"readonly": True},
        "domain_name": {"readonly": True},
        "host_ip_address_entity_id": {"readonly": True},
        "ip_address_entity_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "dns_server_ip_entity_id": {"key": "properties.dnsServerIpEntityId", "type": "str"},
        "domain_name": {"key": "properties.domainName", "type": "str"},
        "host_ip_address_entity_id": {"key": "properties.hostIpAddressEntityId", "type": "str"},
        "ip_address_entity_ids": {"key": "properties.ipAddressEntityIds", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "DnsResolution"
        self.additional_data = None
        self.friendly_name = None
        self.dns_server_ip_entity_id = None
        self.domain_name = None
        self.host_ip_address_entity_id = None
        self.ip_address_entity_ids = None


class DnsEntityProperties(EntityCommonProperties):
    """Dns entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar dns_server_ip_entity_id: An ip entity id for the dns server resolving the request.
    :vartype dns_server_ip_entity_id: str
    :ivar domain_name: The name of the dns record associated with the alert.
    :vartype domain_name: str
    :ivar host_ip_address_entity_id: An ip entity id for the dns request client.
    :vartype host_ip_address_entity_id: str
    :ivar ip_address_entity_ids: Ip entity identifiers for the resolved ip address.
    :vartype ip_address_entity_ids: list[str]
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "dns_server_ip_entity_id": {"readonly": True},
        "domain_name": {"readonly": True},
        "host_ip_address_entity_id": {"readonly": True},
        "ip_address_entity_ids": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "dns_server_ip_entity_id": {"key": "dnsServerIpEntityId", "type": "str"},
        "domain_name": {"key": "domainName", "type": "str"},
        "host_ip_address_entity_id": {"key": "hostIpAddressEntityId", "type": "str"},
        "ip_address_entity_ids": {"key": "ipAddressEntityIds", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.dns_server_ip_entity_id = None
        self.domain_name = None
        self.host_ip_address_entity_id = None
        self.ip_address_entity_ids = None


class Dynamics365CheckRequirements(DataConnectorsCheckRequirements):
    """Represents Dynamics365 requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "Dynamics365"
        self.tenant_id = tenant_id


class Dynamics365CheckRequirementsProperties(DataConnectorTenantId):
    """Dynamics365 requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class Dynamics365DataConnector(DataConnector):
    """Represents Dynamics365 data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "Dynamics365DataConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.Dynamics365DataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Dynamics365"
        self.tenant_id = tenant_id
        self.data_types = data_types


class Dynamics365DataConnectorDataTypes(_serialization.Model):
    """The available data types for Dynamics365 data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar dynamics365_cds_activities: Common Data Service data type connection. Required.
    :vartype dynamics365_cds_activities:
     ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypesDynamics365CdsActivities
    """

    _validation = {
        "dynamics365_cds_activities": {"required": True},
    }

    _attribute_map = {
        "dynamics365_cds_activities": {
            "key": "dynamics365CdsActivities",
            "type": "Dynamics365DataConnectorDataTypesDynamics365CdsActivities",
        },
    }

    def __init__(
        self,
        *,
        dynamics365_cds_activities: "_models.Dynamics365DataConnectorDataTypesDynamics365CdsActivities",
        **kwargs
    ):
        """
        :keyword dynamics365_cds_activities: Common Data Service data type connection. Required.
        :paramtype dynamics365_cds_activities:
         ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypesDynamics365CdsActivities
        """
        super().__init__(**kwargs)
        self.dynamics365_cds_activities = dynamics365_cds_activities


class Dynamics365DataConnectorDataTypesDynamics365CdsActivities(DataConnectorDataTypeCommon):
    """Common Data Service data type connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class Dynamics365DataConnectorProperties(DataConnectorTenantId):
    """Dynamics365 data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector. Required.
    :vartype data_types: ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypes
    """

    _validation = {
        "tenant_id": {"required": True},
        "data_types": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "Dynamics365DataConnectorDataTypes"},
    }

    def __init__(self, *, tenant_id: str, data_types: "_models.Dynamics365DataConnectorDataTypes", **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector. Required.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.Dynamics365DataConnectorDataTypes
        """
        super().__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class EnrichmentDomainWhois(_serialization.Model):
    """Whois information for a given domain and associated metadata.

    :ivar domain: The domain for this whois record.
    :vartype domain: str
    :ivar server: The hostname of this registrar's whois server.
    :vartype server: str
    :ivar created: The timestamp at which this record was created.
    :vartype created: ~datetime.datetime
    :ivar updated: The timestamp at which this record was last updated.
    :vartype updated: ~datetime.datetime
    :ivar expires: The timestamp at which this record will expire.
    :vartype expires: ~datetime.datetime
    :ivar parsed_whois: The whois record for a given domain.
    :vartype parsed_whois: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisDetails
    """

    _attribute_map = {
        "domain": {"key": "domain", "type": "str"},
        "server": {"key": "server", "type": "str"},
        "created": {"key": "created", "type": "iso-8601"},
        "updated": {"key": "updated", "type": "iso-8601"},
        "expires": {"key": "expires", "type": "iso-8601"},
        "parsed_whois": {"key": "parsedWhois", "type": "EnrichmentDomainWhoisDetails"},
    }

    def __init__(
        self,
        *,
        domain: Optional[str] = None,
        server: Optional[str] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        parsed_whois: Optional["_models.EnrichmentDomainWhoisDetails"] = None,
        **kwargs
    ):
        """
        :keyword domain: The domain for this whois record.
        :paramtype domain: str
        :keyword server: The hostname of this registrar's whois server.
        :paramtype server: str
        :keyword created: The timestamp at which this record was created.
        :paramtype created: ~datetime.datetime
        :keyword updated: The timestamp at which this record was last updated.
        :paramtype updated: ~datetime.datetime
        :keyword expires: The timestamp at which this record will expire.
        :paramtype expires: ~datetime.datetime
        :keyword parsed_whois: The whois record for a given domain.
        :paramtype parsed_whois: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisDetails
        """
        super().__init__(**kwargs)
        self.domain = domain
        self.server = server
        self.created = created
        self.updated = updated
        self.expires = expires
        self.parsed_whois = parsed_whois


class EnrichmentDomainWhoisContact(_serialization.Model):
    """An individual contact associated with this domain.

    :ivar name: The name of this contact.
    :vartype name: str
    :ivar org: The organization for this contact.
    :vartype org: str
    :ivar street: A list describing the street address for this contact.
    :vartype street: list[str]
    :ivar city: The city for this contact.
    :vartype city: str
    :ivar state: The state for this contact.
    :vartype state: str
    :ivar postal: The postal code for this contact.
    :vartype postal: str
    :ivar country: The country for this contact.
    :vartype country: str
    :ivar phone: The phone number for this contact.
    :vartype phone: str
    :ivar fax: The fax number for this contact.
    :vartype fax: str
    :ivar email: The email address for this contact.
    :vartype email: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "org": {"key": "org", "type": "str"},
        "street": {"key": "street", "type": "[str]"},
        "city": {"key": "city", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "postal": {"key": "postal", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "fax": {"key": "fax", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        org: Optional[str] = None,
        street: Optional[List[str]] = None,
        city: Optional[str] = None,
        state: Optional[str] = None,
        postal: Optional[str] = None,
        country: Optional[str] = None,
        phone: Optional[str] = None,
        fax: Optional[str] = None,
        email: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of this contact.
        :paramtype name: str
        :keyword org: The organization for this contact.
        :paramtype org: str
        :keyword street: A list describing the street address for this contact.
        :paramtype street: list[str]
        :keyword city: The city for this contact.
        :paramtype city: str
        :keyword state: The state for this contact.
        :paramtype state: str
        :keyword postal: The postal code for this contact.
        :paramtype postal: str
        :keyword country: The country for this contact.
        :paramtype country: str
        :keyword phone: The phone number for this contact.
        :paramtype phone: str
        :keyword fax: The fax number for this contact.
        :paramtype fax: str
        :keyword email: The email address for this contact.
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.org = org
        self.street = street
        self.city = city
        self.state = state
        self.postal = postal
        self.country = country
        self.phone = phone
        self.fax = fax
        self.email = email


class EnrichmentDomainWhoisContacts(_serialization.Model):
    """The set of contacts associated with this domain.

    :ivar admin: The admin contact for this whois record.
    :vartype admin: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
    :ivar billing: The billing contact for this whois record.
    :vartype billing: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
    :ivar registrant: The registrant contact for this whois record.
    :vartype registrant: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
    :ivar tech: The technical contact for this whois record.
    :vartype tech: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
    """

    _attribute_map = {
        "admin": {"key": "admin", "type": "EnrichmentDomainWhoisContact"},
        "billing": {"key": "billing", "type": "EnrichmentDomainWhoisContact"},
        "registrant": {"key": "registrant", "type": "EnrichmentDomainWhoisContact"},
        "tech": {"key": "tech", "type": "EnrichmentDomainWhoisContact"},
    }

    def __init__(
        self,
        *,
        admin: Optional["_models.EnrichmentDomainWhoisContact"] = None,
        billing: Optional["_models.EnrichmentDomainWhoisContact"] = None,
        registrant: Optional["_models.EnrichmentDomainWhoisContact"] = None,
        tech: Optional["_models.EnrichmentDomainWhoisContact"] = None,
        **kwargs
    ):
        """
        :keyword admin: The admin contact for this whois record.
        :paramtype admin: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
        :keyword billing: The billing contact for this whois record.
        :paramtype billing: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
        :keyword registrant: The registrant contact for this whois record.
        :paramtype registrant: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
        :keyword tech: The technical contact for this whois record.
        :paramtype tech: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContact
        """
        super().__init__(**kwargs)
        self.admin = admin
        self.billing = billing
        self.registrant = registrant
        self.tech = tech


class EnrichmentDomainWhoisDetails(_serialization.Model):
    """The whois record for a given domain.

    :ivar registrar: The registrar associated with this domain.
    :vartype registrar: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisRegistrarDetails
    :ivar contacts: The set of contacts associated with this domain.
    :vartype contacts: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContacts
    :ivar name_servers: A list of name servers associated with this domain.
    :vartype name_servers: list[str]
    :ivar statuses: The set of status flags for this whois record.
    :vartype statuses: list[str]
    """

    _attribute_map = {
        "registrar": {"key": "registrar", "type": "EnrichmentDomainWhoisRegistrarDetails"},
        "contacts": {"key": "contacts", "type": "EnrichmentDomainWhoisContacts"},
        "name_servers": {"key": "nameServers", "type": "[str]"},
        "statuses": {"key": "statuses", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        registrar: Optional["_models.EnrichmentDomainWhoisRegistrarDetails"] = None,
        contacts: Optional["_models.EnrichmentDomainWhoisContacts"] = None,
        name_servers: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword registrar: The registrar associated with this domain.
        :paramtype registrar: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisRegistrarDetails
        :keyword contacts: The set of contacts associated with this domain.
        :paramtype contacts: ~azure.mgmt.securityinsight.models.EnrichmentDomainWhoisContacts
        :keyword name_servers: A list of name servers associated with this domain.
        :paramtype name_servers: list[str]
        :keyword statuses: The set of status flags for this whois record.
        :paramtype statuses: list[str]
        """
        super().__init__(**kwargs)
        self.registrar = registrar
        self.contacts = contacts
        self.name_servers = name_servers
        self.statuses = statuses


class EnrichmentDomainWhoisRegistrarDetails(_serialization.Model):
    """The registrar associated with this domain.

    :ivar name: The name of this registrar.
    :vartype name: str
    :ivar abuse_contact_email: This registrar's abuse contact email.
    :vartype abuse_contact_email: str
    :ivar abuse_contact_phone: This registrar's abuse contact phone number.
    :vartype abuse_contact_phone: str
    :ivar iana_id: This registrar's Internet Assigned Numbers Authority id.
    :vartype iana_id: str
    :ivar url: This registrar's URL.
    :vartype url: str
    :ivar whois_server: The hostname of this registrar's whois server.
    :vartype whois_server: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "abuse_contact_email": {"key": "abuseContactEmail", "type": "str"},
        "abuse_contact_phone": {"key": "abuseContactPhone", "type": "str"},
        "iana_id": {"key": "ianaId", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "whois_server": {"key": "whoisServer", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        abuse_contact_email: Optional[str] = None,
        abuse_contact_phone: Optional[str] = None,
        iana_id: Optional[str] = None,
        url: Optional[str] = None,
        whois_server: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of this registrar.
        :paramtype name: str
        :keyword abuse_contact_email: This registrar's abuse contact email.
        :paramtype abuse_contact_email: str
        :keyword abuse_contact_phone: This registrar's abuse contact phone number.
        :paramtype abuse_contact_phone: str
        :keyword iana_id: This registrar's Internet Assigned Numbers Authority id.
        :paramtype iana_id: str
        :keyword url: This registrar's URL.
        :paramtype url: str
        :keyword whois_server: The hostname of this registrar's whois server.
        :paramtype whois_server: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.abuse_contact_email = abuse_contact_email
        self.abuse_contact_phone = abuse_contact_phone
        self.iana_id = iana_id
        self.url = url
        self.whois_server = whois_server


class EnrichmentIpGeodata(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Geodata information for a given IP address.

    :ivar asn: The autonomous system number associated with this IP address.
    :vartype asn: str
    :ivar carrier: The name of the carrier for this IP address.
    :vartype carrier: str
    :ivar city: The city this IP address is located in.
    :vartype city: str
    :ivar city_cf: A numeric rating of confidence that the value in the 'city' field is correct, on
     a scale of 0-100.
    :vartype city_cf: int
    :ivar continent: The continent this IP address is located on.
    :vartype continent: str
    :ivar country: The county this IP address is located in.
    :vartype country: str
    :ivar country_cf: A numeric rating of confidence that the value in the 'country' field is
     correct on a scale of 0-100.
    :vartype country_cf: int
    :ivar ip_addr: The dotted-decimal or colon-separated string representation of the IP address.
    :vartype ip_addr: str
    :ivar ip_routing_type: A description of the connection type of this IP address.
    :vartype ip_routing_type: str
    :ivar latitude: The latitude of this IP address.
    :vartype latitude: str
    :ivar longitude: The longitude of this IP address.
    :vartype longitude: str
    :ivar organization: The name of the organization for this IP address.
    :vartype organization: str
    :ivar organization_type: The type of the organization for this IP address.
    :vartype organization_type: str
    :ivar region: The geographic region this IP address is located in.
    :vartype region: str
    :ivar state: The state this IP address is located in.
    :vartype state: str
    :ivar state_cf: A numeric rating of confidence that the value in the 'state' field is correct
     on a scale of 0-100.
    :vartype state_cf: int
    :ivar state_code: The abbreviated name for the state this IP address is located in.
    :vartype state_code: str
    """

    _attribute_map = {
        "asn": {"key": "asn", "type": "str"},
        "carrier": {"key": "carrier", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "city_cf": {"key": "cityCf", "type": "int"},
        "continent": {"key": "continent", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_cf": {"key": "countryCf", "type": "int"},
        "ip_addr": {"key": "ipAddr", "type": "str"},
        "ip_routing_type": {"key": "ipRoutingType", "type": "str"},
        "latitude": {"key": "latitude", "type": "str"},
        "longitude": {"key": "longitude", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "organization_type": {"key": "organizationType", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_cf": {"key": "stateCf", "type": "int"},
        "state_code": {"key": "stateCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        asn: Optional[str] = None,
        carrier: Optional[str] = None,
        city: Optional[str] = None,
        city_cf: Optional[int] = None,
        continent: Optional[str] = None,
        country: Optional[str] = None,
        country_cf: Optional[int] = None,
        ip_addr: Optional[str] = None,
        ip_routing_type: Optional[str] = None,
        latitude: Optional[str] = None,
        longitude: Optional[str] = None,
        organization: Optional[str] = None,
        organization_type: Optional[str] = None,
        region: Optional[str] = None,
        state: Optional[str] = None,
        state_cf: Optional[int] = None,
        state_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword asn: The autonomous system number associated with this IP address.
        :paramtype asn: str
        :keyword carrier: The name of the carrier for this IP address.
        :paramtype carrier: str
        :keyword city: The city this IP address is located in.
        :paramtype city: str
        :keyword city_cf: A numeric rating of confidence that the value in the 'city' field is correct,
         on a scale of 0-100.
        :paramtype city_cf: int
        :keyword continent: The continent this IP address is located on.
        :paramtype continent: str
        :keyword country: The county this IP address is located in.
        :paramtype country: str
        :keyword country_cf: A numeric rating of confidence that the value in the 'country' field is
         correct on a scale of 0-100.
        :paramtype country_cf: int
        :keyword ip_addr: The dotted-decimal or colon-separated string representation of the IP
         address.
        :paramtype ip_addr: str
        :keyword ip_routing_type: A description of the connection type of this IP address.
        :paramtype ip_routing_type: str
        :keyword latitude: The latitude of this IP address.
        :paramtype latitude: str
        :keyword longitude: The longitude of this IP address.
        :paramtype longitude: str
        :keyword organization: The name of the organization for this IP address.
        :paramtype organization: str
        :keyword organization_type: The type of the organization for this IP address.
        :paramtype organization_type: str
        :keyword region: The geographic region this IP address is located in.
        :paramtype region: str
        :keyword state: The state this IP address is located in.
        :paramtype state: str
        :keyword state_cf: A numeric rating of confidence that the value in the 'state' field is
         correct on a scale of 0-100.
        :paramtype state_cf: int
        :keyword state_code: The abbreviated name for the state this IP address is located in.
        :paramtype state_code: str
        """
        super().__init__(**kwargs)
        self.asn = asn
        self.carrier = carrier
        self.city = city
        self.city_cf = city_cf
        self.continent = continent
        self.country = country
        self.country_cf = country_cf
        self.ip_addr = ip_addr
        self.ip_routing_type = ip_routing_type
        self.latitude = latitude
        self.longitude = longitude
        self.organization = organization
        self.organization_type = organization_type
        self.region = region
        self.state = state
        self.state_cf = state_cf
        self.state_code = state_code


class EntityAnalytics(Settings):
    """Settings with single toggle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the setting. Required. Known values are: "Anomalies", "EyesOn",
     "EntityAnalytics", and "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :ivar entity_providers: The relevant entity providers that are synced.
    :vartype entity_providers: list[str or ~azure.mgmt.securityinsight.models.EntityProviders]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "entity_providers": {"key": "properties.entityProviders", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        entity_providers: Optional[List[Union[str, "_models.EntityProviders"]]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword entity_providers: The relevant entity providers that are synced.
        :paramtype entity_providers: list[str or ~azure.mgmt.securityinsight.models.EntityProviders]
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "EntityAnalytics"
        self.entity_providers = entity_providers


class EntityEdges(_serialization.Model):
    """The edge that connects the entity to the other entity.

    :ivar target_entity_id: The target entity Id.
    :vartype target_entity_id: str
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    """

    _attribute_map = {
        "target_entity_id": {"key": "targetEntityId", "type": "str"},
        "additional_data": {"key": "additionalData", "type": "{object}"},
    }

    def __init__(
        self, *, target_entity_id: Optional[str] = None, additional_data: Optional[Dict[str, Any]] = None, **kwargs
    ):
        """
        :keyword target_entity_id: The target entity Id.
        :paramtype target_entity_id: str
        :keyword additional_data: A bag of custom fields that should be part of the entity and will be
         presented to the user.
        :paramtype additional_data: dict[str, any]
        """
        super().__init__(**kwargs)
        self.target_entity_id = target_entity_id
        self.additional_data = additional_data


class EntityExpandParameters(_serialization.Model):
    """The parameters required to execute an expand operation on the given entity.

    :ivar end_time: The end date filter, so the only expansion results returned are before this
     date.
    :vartype end_time: ~datetime.datetime
    :ivar expansion_id: The Id of the expansion to perform.
    :vartype expansion_id: str
    :ivar start_time: The start date filter, so the only expansion results returned are after this
     date.
    :vartype start_time: ~datetime.datetime
    """

    _attribute_map = {
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "expansion_id": {"key": "expansionId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        end_time: Optional[datetime.datetime] = None,
        expansion_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword end_time: The end date filter, so the only expansion results returned are before this
         date.
        :paramtype end_time: ~datetime.datetime
        :keyword expansion_id: The Id of the expansion to perform.
        :paramtype expansion_id: str
        :keyword start_time: The start date filter, so the only expansion results returned are after
         this date.
        :paramtype start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.end_time = end_time
        self.expansion_id = expansion_id
        self.start_time = start_time


class EntityExpandResponse(_serialization.Model):
    """The entity expansion result operation response.

    :ivar meta_data: The metadata from the expansion operation results.
    :vartype meta_data: ~azure.mgmt.securityinsight.models.ExpansionResultsMetadata
    :ivar value: The expansion result values.
    :vartype value: ~azure.mgmt.securityinsight.models.EntityExpandResponseValue
    """

    _attribute_map = {
        "meta_data": {"key": "metaData", "type": "ExpansionResultsMetadata"},
        "value": {"key": "value", "type": "EntityExpandResponseValue"},
    }

    def __init__(
        self,
        *,
        meta_data: Optional["_models.ExpansionResultsMetadata"] = None,
        value: Optional["_models.EntityExpandResponseValue"] = None,
        **kwargs
    ):
        """
        :keyword meta_data: The metadata from the expansion operation results.
        :paramtype meta_data: ~azure.mgmt.securityinsight.models.ExpansionResultsMetadata
        :keyword value: The expansion result values.
        :paramtype value: ~azure.mgmt.securityinsight.models.EntityExpandResponseValue
        """
        super().__init__(**kwargs)
        self.meta_data = meta_data
        self.value = value


class EntityExpandResponseValue(_serialization.Model):
    """The expansion result values.

    :ivar entities: Array of the expansion result entities.
    :vartype entities: list[~azure.mgmt.securityinsight.models.Entity]
    :ivar edges: Array of edges that connects the entity to the list of entities.
    :vartype edges: list[~azure.mgmt.securityinsight.models.EntityEdges]
    """

    _attribute_map = {
        "entities": {"key": "entities", "type": "[Entity]"},
        "edges": {"key": "edges", "type": "[EntityEdges]"},
    }

    def __init__(
        self,
        *,
        entities: Optional[List["_models.Entity"]] = None,
        edges: Optional[List["_models.EntityEdges"]] = None,
        **kwargs
    ):
        """
        :keyword entities: Array of the expansion result entities.
        :paramtype entities: list[~azure.mgmt.securityinsight.models.Entity]
        :keyword edges: Array of edges that connects the entity to the list of entities.
        :paramtype edges: list[~azure.mgmt.securityinsight.models.EntityEdges]
        """
        super().__init__(**kwargs)
        self.entities = entities
        self.edges = edges


class EntityFieldMapping(_serialization.Model):
    """Map identifiers of a single entity.

    :ivar identifier: Alert V3 identifier.
    :vartype identifier: str
    :ivar value: The value of the identifier.
    :vartype value: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, identifier: Optional[str] = None, value: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Alert V3 identifier.
        :paramtype identifier: str
        :keyword value: The value of the identifier.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.identifier = identifier
        self.value = value


class EntityGetInsightsParameters(_serialization.Model):
    """The parameters required to execute insights operation on the given entity.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time: The start timeline date, so the results returned are after this date.
     Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end timeline date, so the results returned are before this date. Required.
    :vartype end_time: ~datetime.datetime
    :ivar add_default_extended_time_range: Indicates if query time range should be extended with
     default time range of the query. Default value is false.
    :vartype add_default_extended_time_range: bool
    :ivar insight_query_ids: List of Insights Query Id. If empty, default value is all insights of
     this entity.
    :vartype insight_query_ids: list[str]
    """

    _validation = {
        "start_time": {"required": True},
        "end_time": {"required": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "add_default_extended_time_range": {"key": "addDefaultExtendedTimeRange", "type": "bool"},
        "insight_query_ids": {"key": "insightQueryIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        add_default_extended_time_range: Optional[bool] = None,
        insight_query_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start timeline date, so the results returned are after this date.
         Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end timeline date, so the results returned are before this date.
         Required.
        :paramtype end_time: ~datetime.datetime
        :keyword add_default_extended_time_range: Indicates if query time range should be extended with
         default time range of the query. Default value is false.
        :paramtype add_default_extended_time_range: bool
        :keyword insight_query_ids: List of Insights Query Id. If empty, default value is all insights
         of this entity.
        :paramtype insight_query_ids: list[str]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.add_default_extended_time_range = add_default_extended_time_range
        self.insight_query_ids = insight_query_ids


class EntityGetInsightsResponse(_serialization.Model):
    """The Get Insights result operation response.

    :ivar meta_data: The metadata from the get insights operation results.
    :vartype meta_data: ~azure.mgmt.securityinsight.models.GetInsightsResultsMetadata
    :ivar value: The insights result values.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityInsightItem]
    """

    _attribute_map = {
        "meta_data": {"key": "metaData", "type": "GetInsightsResultsMetadata"},
        "value": {"key": "value", "type": "[EntityInsightItem]"},
    }

    def __init__(
        self,
        *,
        meta_data: Optional["_models.GetInsightsResultsMetadata"] = None,
        value: Optional[List["_models.EntityInsightItem"]] = None,
        **kwargs
    ):
        """
        :keyword meta_data: The metadata from the get insights operation results.
        :paramtype meta_data: ~azure.mgmt.securityinsight.models.GetInsightsResultsMetadata
        :keyword value: The insights result values.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityInsightItem]
        """
        super().__init__(**kwargs)
        self.meta_data = meta_data
        self.value = value


class EntityInsightItem(_serialization.Model):
    """Entity insight Item.

    :ivar query_id: The query id of the insight.
    :vartype query_id: str
    :ivar query_time_interval: The Time interval that the query actually executed on.
    :vartype query_time_interval:
     ~azure.mgmt.securityinsight.models.EntityInsightItemQueryTimeInterval
    :ivar table_query_results: Query results for table insights query.
    :vartype table_query_results: ~azure.mgmt.securityinsight.models.InsightsTableResult
    :ivar chart_query_results: Query results for table insights query.
    :vartype chart_query_results: list[~azure.mgmt.securityinsight.models.InsightsTableResult]
    """

    _attribute_map = {
        "query_id": {"key": "queryId", "type": "str"},
        "query_time_interval": {"key": "queryTimeInterval", "type": "EntityInsightItemQueryTimeInterval"},
        "table_query_results": {"key": "tableQueryResults", "type": "InsightsTableResult"},
        "chart_query_results": {"key": "chartQueryResults", "type": "[InsightsTableResult]"},
    }

    def __init__(
        self,
        *,
        query_id: Optional[str] = None,
        query_time_interval: Optional["_models.EntityInsightItemQueryTimeInterval"] = None,
        table_query_results: Optional["_models.InsightsTableResult"] = None,
        chart_query_results: Optional[List["_models.InsightsTableResult"]] = None,
        **kwargs
    ):
        """
        :keyword query_id: The query id of the insight.
        :paramtype query_id: str
        :keyword query_time_interval: The Time interval that the query actually executed on.
        :paramtype query_time_interval:
         ~azure.mgmt.securityinsight.models.EntityInsightItemQueryTimeInterval
        :keyword table_query_results: Query results for table insights query.
        :paramtype table_query_results: ~azure.mgmt.securityinsight.models.InsightsTableResult
        :keyword chart_query_results: Query results for table insights query.
        :paramtype chart_query_results: list[~azure.mgmt.securityinsight.models.InsightsTableResult]
        """
        super().__init__(**kwargs)
        self.query_id = query_id
        self.query_time_interval = query_time_interval
        self.table_query_results = table_query_results
        self.chart_query_results = chart_query_results


class EntityInsightItemQueryTimeInterval(_serialization.Model):
    """The Time interval that the query actually executed on.

    :ivar start_time: Insight query start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Insight query end time.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self, *, start_time: Optional[datetime.datetime] = None, end_time: Optional[datetime.datetime] = None, **kwargs
    ):
        """
        :keyword start_time: Insight query start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Insight query end time.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time


class EntityList(_serialization.Model):
    """List of all the entities.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of entities.
    :vartype next_link: str
    :ivar value: Array of entities. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.Entity]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Entity]"},
    }

    def __init__(self, *, value: List["_models.Entity"], **kwargs):
        """
        :keyword value: Array of entities. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Entity]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class EntityMapping(_serialization.Model):
    """Single entity mapping for the alert rule.

    :ivar entity_type: The V3 type of the mapped entity. Known values are: "Account", "Host", "IP",
     "Malware", "File", "Process", "CloudApplication", "DNS", "AzureResource", "FileHash",
     "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "Mailbox", "MailCluster",
     "MailMessage", and "SubmissionMail".
    :vartype entity_type: str or ~azure.mgmt.securityinsight.models.EntityMappingType
    :ivar field_mappings: array of field mappings for the given entity mapping.
    :vartype field_mappings: list[~azure.mgmt.securityinsight.models.FieldMapping]
    """

    _attribute_map = {
        "entity_type": {"key": "entityType", "type": "str"},
        "field_mappings": {"key": "fieldMappings", "type": "[FieldMapping]"},
    }

    def __init__(
        self,
        *,
        entity_type: Optional[Union[str, "_models.EntityMappingType"]] = None,
        field_mappings: Optional[List["_models.FieldMapping"]] = None,
        **kwargs
    ):
        """
        :keyword entity_type: The V3 type of the mapped entity. Known values are: "Account", "Host",
         "IP", "Malware", "File", "Process", "CloudApplication", "DNS", "AzureResource", "FileHash",
         "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "Mailbox", "MailCluster",
         "MailMessage", and "SubmissionMail".
        :paramtype entity_type: str or ~azure.mgmt.securityinsight.models.EntityMappingType
        :keyword field_mappings: array of field mappings for the given entity mapping.
        :paramtype field_mappings: list[~azure.mgmt.securityinsight.models.FieldMapping]
        """
        super().__init__(**kwargs)
        self.entity_type = entity_type
        self.field_mappings = field_mappings


class EntityQueryItem(_serialization.Model):
    """An abstract Query item for entity.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InsightQueryItem

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Query Template ARM ID.
    :vartype id: str
    :ivar name: Query Template ARM Name.
    :vartype name: str
    :ivar type: ARM Type.
    :vartype type: str
    :ivar kind: The kind of the entity query. Required. Known values are: "Expansion", "Insight",
     and "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    """

    _validation = {
        "id": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Insight": "InsightQueryItem"}}

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs):
        """
        :keyword name: Query Template ARM Name.
        :paramtype name: str
        :keyword type: ARM Type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = type
        self.kind: Optional[str] = None


class EntityQueryItemProperties(_serialization.Model):
    """An properties abstract Query item for entity.

    :ivar data_types: Data types for template.
    :vartype data_types:
     list[~azure.mgmt.securityinsight.models.EntityQueryItemPropertiesDataTypesItem]
    :ivar input_entity_type: The type of the entity. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice", "SecurityAlert",
     "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: Data types for template.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: JSON
    """

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "[EntityQueryItemPropertiesDataTypesItem]"},
        "input_entity_type": {"key": "inputEntityType", "type": "str"},
        "required_input_fields_sets": {"key": "requiredInputFieldsSets", "type": "[[str]]"},
        "entities_filter": {"key": "entitiesFilter", "type": "object"},
    }

    def __init__(
        self,
        *,
        data_types: Optional[List["_models.EntityQueryItemPropertiesDataTypesItem"]] = None,
        input_entity_type: Optional[Union[str, "_models.EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword data_types: Data types for template.
        :paramtype data_types:
         list[~azure.mgmt.securityinsight.models.EntityQueryItemPropertiesDataTypesItem]
        :keyword input_entity_type: The type of the entity. Known values are: "Account", "Host",
         "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware", "Process",
         "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice", "SecurityAlert",
         "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: Data types for template.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: JSON
        """
        super().__init__(**kwargs)
        self.data_types = data_types
        self.input_entity_type = input_entity_type
        self.required_input_fields_sets = required_input_fields_sets
        self.entities_filter = entities_filter


class EntityQueryItemPropertiesDataTypesItem(_serialization.Model):
    """EntityQueryItemPropertiesDataTypesItem.

    :ivar data_type: Data type name.
    :vartype data_type: str
    """

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
    }

    def __init__(self, *, data_type: Optional[str] = None, **kwargs):
        """
        :keyword data_type: Data type name.
        :paramtype data_type: str
        """
        super().__init__(**kwargs)
        self.data_type = data_type


class EntityQueryList(_serialization.Model):
    """List of all the entity queries.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of entity queries.
    :vartype next_link: str
    :ivar value: Array of entity queries. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityQuery]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[EntityQuery]"},
    }

    def __init__(self, *, value: List["_models.EntityQuery"], **kwargs):
        """
        :keyword value: Array of entity queries. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityQuery]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class EntityQueryTemplateList(_serialization.Model):
    """List of all the entity query templates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of entity query templates.
    :vartype next_link: str
    :ivar value: Array of entity query templates. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityQueryTemplate]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[EntityQueryTemplate]"},
    }

    def __init__(self, *, value: List["_models.EntityQueryTemplate"], **kwargs):
        """
        :keyword value: Array of entity query templates. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityQueryTemplate]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class EntityTimelineParameters(_serialization.Model):
    """The parameters required to execute s timeline operation on the given entity.

    All required parameters must be populated in order to send to Azure.

    :ivar kinds: Array of timeline Item kinds.
    :vartype kinds: list[str or ~azure.mgmt.securityinsight.models.EntityTimelineKind]
    :ivar start_time: The start timeline date, so the results returned are after this date.
     Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end timeline date, so the results returned are before this date. Required.
    :vartype end_time: ~datetime.datetime
    :ivar number_of_bucket: The number of bucket for timeline queries aggregation.
    :vartype number_of_bucket: int
    """

    _validation = {
        "start_time": {"required": True},
        "end_time": {"required": True},
    }

    _attribute_map = {
        "kinds": {"key": "kinds", "type": "[str]"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "number_of_bucket": {"key": "numberOfBucket", "type": "int"},
    }

    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        kinds: Optional[List[Union[str, "_models.EntityTimelineKind"]]] = None,
        number_of_bucket: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword kinds: Array of timeline Item kinds.
        :paramtype kinds: list[str or ~azure.mgmt.securityinsight.models.EntityTimelineKind]
        :keyword start_time: The start timeline date, so the results returned are after this date.
         Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end timeline date, so the results returned are before this date.
         Required.
        :paramtype end_time: ~datetime.datetime
        :keyword number_of_bucket: The number of bucket for timeline queries aggregation.
        :paramtype number_of_bucket: int
        """
        super().__init__(**kwargs)
        self.kinds = kinds
        self.start_time = start_time
        self.end_time = end_time
        self.number_of_bucket = number_of_bucket


class EntityTimelineResponse(_serialization.Model):
    """The entity timeline result operation response.

    :ivar meta_data: The metadata from the timeline operation results.
    :vartype meta_data: ~azure.mgmt.securityinsight.models.TimelineResultsMetadata
    :ivar value: The timeline result values.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityTimelineItem]
    """

    _attribute_map = {
        "meta_data": {"key": "metaData", "type": "TimelineResultsMetadata"},
        "value": {"key": "value", "type": "[EntityTimelineItem]"},
    }

    def __init__(
        self,
        *,
        meta_data: Optional["_models.TimelineResultsMetadata"] = None,
        value: Optional[List["_models.EntityTimelineItem"]] = None,
        **kwargs
    ):
        """
        :keyword meta_data: The metadata from the timeline operation results.
        :paramtype meta_data: ~azure.mgmt.securityinsight.models.TimelineResultsMetadata
        :keyword value: The timeline result values.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityTimelineItem]
        """
        super().__init__(**kwargs)
        self.meta_data = meta_data
        self.value = value


class EventGroupingSettings(_serialization.Model):
    """Event grouping settings property bag.

    :ivar aggregation_kind: The event grouping aggregation kinds. Known values are: "SingleAlert"
     and "AlertPerResult".
    :vartype aggregation_kind: str or
     ~azure.mgmt.securityinsight.models.EventGroupingAggregationKind
    """

    _attribute_map = {
        "aggregation_kind": {"key": "aggregationKind", "type": "str"},
    }

    def __init__(
        self, *, aggregation_kind: Optional[Union[str, "_models.EventGroupingAggregationKind"]] = None, **kwargs
    ):
        """
        :keyword aggregation_kind: The event grouping aggregation kinds. Known values are:
         "SingleAlert" and "AlertPerResult".
        :paramtype aggregation_kind: str or
         ~azure.mgmt.securityinsight.models.EventGroupingAggregationKind
        """
        super().__init__(**kwargs)
        self.aggregation_kind = aggregation_kind


class ExpansionEntityQuery(EntityQuery):  # pylint: disable=too-many-instance-attributes
    """Represents Expansion entity query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: the entity query kind. Required. Known values are: "Expansion", "Insight", and
     "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    :ivar data_sources: List of the data sources that are required to run the query.
    :vartype data_sources: list[str]
    :ivar display_name: The query display name.
    :vartype display_name: str
    :ivar input_entity_type: The type of the query's source entity. Known values are: "Account",
     "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware",
     "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
     "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail",
     and "Nic".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar input_fields: List of the fields of the source entity that are required to run the query.
    :vartype input_fields: list[str]
    :ivar output_entity_types: List of the desired output types to be constructed from the result.
    :vartype output_entity_types: list[str or ~azure.mgmt.securityinsight.models.EntityType]
    :ivar query_template: The template query string to be parsed and formatted.
    :vartype query_template: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_sources": {"key": "properties.dataSources", "type": "[str]"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "input_entity_type": {"key": "properties.inputEntityType", "type": "str"},
        "input_fields": {"key": "properties.inputFields", "type": "[str]"},
        "output_entity_types": {"key": "properties.outputEntityTypes", "type": "[str]"},
        "query_template": {"key": "properties.queryTemplate", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        data_sources: Optional[List[str]] = None,
        display_name: Optional[str] = None,
        input_entity_type: Optional[Union[str, "_models.EntityType"]] = None,
        input_fields: Optional[List[str]] = None,
        output_entity_types: Optional[List[Union[str, "_models.EntityType"]]] = None,
        query_template: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword data_sources: List of the data sources that are required to run the query.
        :paramtype data_sources: list[str]
        :keyword display_name: The query display name.
        :paramtype display_name: str
        :keyword input_entity_type: The type of the query's source entity. Known values are: "Account",
         "Host", "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware",
         "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice",
         "SecurityAlert", "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail",
         and "Nic".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword input_fields: List of the fields of the source entity that are required to run the
         query.
        :paramtype input_fields: list[str]
        :keyword output_entity_types: List of the desired output types to be constructed from the
         result.
        :paramtype output_entity_types: list[str or ~azure.mgmt.securityinsight.models.EntityType]
        :keyword query_template: The template query string to be parsed and formatted.
        :paramtype query_template: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Expansion"
        self.data_sources = data_sources
        self.display_name = display_name
        self.input_entity_type = input_entity_type
        self.input_fields = input_fields
        self.output_entity_types = output_entity_types
        self.query_template = query_template


class ExpansionResultAggregation(_serialization.Model):
    """Information of a specific aggregation in the expansion result.

    All required parameters must be populated in order to send to Azure.

    :ivar aggregation_type: The common type of the aggregation. (for e.g. entity field name).
    :vartype aggregation_type: str
    :ivar count: Total number of aggregations of the given kind (and aggregationType if given) in
     the expansion result. Required.
    :vartype count: int
    :ivar display_name: The display name of the aggregation by type.
    :vartype display_name: str
    :ivar entity_kind: The kind of the aggregated entity. Required. Known values are: "Account",
     "Host", "File", "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip",
     "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice",
     "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and
     "Nic".
    :vartype entity_kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    """

    _validation = {
        "count": {"required": True},
        "entity_kind": {"required": True},
    }

    _attribute_map = {
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "display_name": {"key": "displayName", "type": "str"},
        "entity_kind": {"key": "entityKind", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        entity_kind: Union[str, "_models.EntityKind"],
        aggregation_type: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword aggregation_type: The common type of the aggregation. (for e.g. entity field name).
        :paramtype aggregation_type: str
        :keyword count: Total number of aggregations of the given kind (and aggregationType if given)
         in the expansion result. Required.
        :paramtype count: int
        :keyword display_name: The display name of the aggregation by type.
        :paramtype display_name: str
        :keyword entity_kind: The kind of the aggregated entity. Required. Known values are: "Account",
         "Host", "File", "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip",
         "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice",
         "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and
         "Nic".
        :paramtype entity_kind: str or ~azure.mgmt.securityinsight.models.EntityKind
        """
        super().__init__(**kwargs)
        self.aggregation_type = aggregation_type
        self.count = count
        self.display_name = display_name
        self.entity_kind = entity_kind


class ExpansionResultsMetadata(_serialization.Model):
    """Expansion result metadata.

    :ivar aggregations: Information of the aggregated nodes in the expansion result.
    :vartype aggregations: list[~azure.mgmt.securityinsight.models.ExpansionResultAggregation]
    """

    _attribute_map = {
        "aggregations": {"key": "aggregations", "type": "[ExpansionResultAggregation]"},
    }

    def __init__(self, *, aggregations: Optional[List["_models.ExpansionResultAggregation"]] = None, **kwargs):
        """
        :keyword aggregations: Information of the aggregated nodes in the expansion result.
        :paramtype aggregations: list[~azure.mgmt.securityinsight.models.ExpansionResultAggregation]
        """
        super().__init__(**kwargs)
        self.aggregations = aggregations


class EyesOn(Settings):
    """Settings with single toggle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the setting. Required. Known values are: "Anomalies", "EyesOn",
     "EntityAnalytics", and "Ueba".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :ivar is_enabled: Determines whether the setting is enable or disabled.
    :vartype is_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "is_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "EyesOn"
        self.is_enabled = None


class FieldMapping(_serialization.Model):
    """A single field mapping of the mapped entity.

    :ivar identifier: the V3 identifier of the entity.
    :vartype identifier: str
    :ivar column_name: the column name to be mapped to the identifier.
    :vartype column_name: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "column_name": {"key": "columnName", "type": "str"},
    }

    def __init__(self, *, identifier: Optional[str] = None, column_name: Optional[str] = None, **kwargs):
        """
        :keyword identifier: the V3 identifier of the entity.
        :paramtype identifier: str
        :keyword column_name: the column name to be mapped to the identifier.
        :paramtype column_name: str
        """
        super().__init__(**kwargs)
        self.identifier = identifier
        self.column_name = column_name


class FileEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a file entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar directory: The full path to the file.
    :vartype directory: str
    :ivar file_hash_entity_ids: The file hash entity identifiers associated with this file.
    :vartype file_hash_entity_ids: list[str]
    :ivar file_name: The file name without path (some alerts might not include path).
    :vartype file_name: str
    :ivar host_entity_id: The Host entity id which the file belongs to.
    :vartype host_entity_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "directory": {"readonly": True},
        "file_hash_entity_ids": {"readonly": True},
        "file_name": {"readonly": True},
        "host_entity_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "directory": {"key": "properties.directory", "type": "str"},
        "file_hash_entity_ids": {"key": "properties.fileHashEntityIds", "type": "[str]"},
        "file_name": {"key": "properties.fileName", "type": "str"},
        "host_entity_id": {"key": "properties.hostEntityId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "File"
        self.additional_data = None
        self.friendly_name = None
        self.directory = None
        self.file_hash_entity_ids = None
        self.file_name = None
        self.host_entity_id = None


class FileEntityProperties(EntityCommonProperties):
    """File entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar directory: The full path to the file.
    :vartype directory: str
    :ivar file_hash_entity_ids: The file hash entity identifiers associated with this file.
    :vartype file_hash_entity_ids: list[str]
    :ivar file_name: The file name without path (some alerts might not include path).
    :vartype file_name: str
    :ivar host_entity_id: The Host entity id which the file belongs to.
    :vartype host_entity_id: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "directory": {"readonly": True},
        "file_hash_entity_ids": {"readonly": True},
        "file_name": {"readonly": True},
        "host_entity_id": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "directory": {"key": "directory", "type": "str"},
        "file_hash_entity_ids": {"key": "fileHashEntityIds", "type": "[str]"},
        "file_name": {"key": "fileName", "type": "str"},
        "host_entity_id": {"key": "hostEntityId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.directory = None
        self.file_hash_entity_ids = None
        self.file_name = None
        self.host_entity_id = None


class FileHashEntity(Entity):
    """Represents a file hash entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar algorithm: The hash algorithm type. Known values are: "Unknown", "MD5", "SHA1", "SHA256",
     and "SHA256AC".
    :vartype algorithm: str or ~azure.mgmt.securityinsight.models.FileHashAlgorithm
    :ivar hash_value: The file hash value.
    :vartype hash_value: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "algorithm": {"readonly": True},
        "hash_value": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "algorithm": {"key": "properties.algorithm", "type": "str"},
        "hash_value": {"key": "properties.hashValue", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "FileHash"
        self.additional_data = None
        self.friendly_name = None
        self.algorithm = None
        self.hash_value = None


class FileHashEntityProperties(EntityCommonProperties):
    """FileHash entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar algorithm: The hash algorithm type. Known values are: "Unknown", "MD5", "SHA1", "SHA256",
     and "SHA256AC".
    :vartype algorithm: str or ~azure.mgmt.securityinsight.models.FileHashAlgorithm
    :ivar hash_value: The file hash value.
    :vartype hash_value: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "algorithm": {"readonly": True},
        "hash_value": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "algorithm": {"key": "algorithm", "type": "str"},
        "hash_value": {"key": "hashValue", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.algorithm = None
        self.hash_value = None


class FileImport(Resource):  # pylint: disable=too-many-instance-attributes
    """Represents a file import in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar ingestion_mode: Describes how to ingest the records in the file. Known values are:
     "IngestOnlyIfAllAreValid", "IngestAnyValidRecords", and "Unspecified".
    :vartype ingestion_mode: str or ~azure.mgmt.securityinsight.models.IngestionMode
    :ivar content_type: The content type of this file. Known values are: "BasicIndicator",
     "StixIndicator", and "Unspecified".
    :vartype content_type: str or ~azure.mgmt.securityinsight.models.FileImportContentType
    :ivar created_time_utc: The time the file was imported.
    :vartype created_time_utc: ~datetime.datetime
    :ivar error_file: Represents the error file (if the import was ingested with errors or failed
     the validation).
    :vartype error_file: ~azure.mgmt.securityinsight.models.FileMetadata
    :ivar errors_preview: An ordered list of some of the errors that were encountered during
     validation.
    :vartype errors_preview: list[~azure.mgmt.securityinsight.models.ValidationError]
    :ivar import_file: Represents the imported file.
    :vartype import_file: ~azure.mgmt.securityinsight.models.FileMetadata
    :ivar ingested_record_count: The number of records that have been successfully ingested.
    :vartype ingested_record_count: int
    :ivar source: The source for the data in the file.
    :vartype source: str
    :ivar state: The state of the file import. Known values are: "FatalError", "Ingested",
     "IngestedWithErrors", "InProgress", "Invalid", "WaitingForUpload", and "Unspecified".
    :vartype state: str or ~azure.mgmt.securityinsight.models.FileImportState
    :ivar total_record_count: The number of records in the file.
    :vartype total_record_count: int
    :ivar valid_record_count: The number of records that have passed validation.
    :vartype valid_record_count: int
    :ivar files_valid_until_time_utc: The time the files associated with this import are deleted
     from the storage account.
    :vartype files_valid_until_time_utc: ~datetime.datetime
    :ivar import_valid_until_time_utc: The time the file import record is soft deleted from the
     database and history.
    :vartype import_valid_until_time_utc: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_time_utc": {"readonly": True},
        "error_file": {"readonly": True},
        "errors_preview": {"readonly": True},
        "ingested_record_count": {"readonly": True},
        "state": {"readonly": True},
        "total_record_count": {"readonly": True},
        "valid_record_count": {"readonly": True},
        "files_valid_until_time_utc": {"readonly": True},
        "import_valid_until_time_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "ingestion_mode": {"key": "properties.ingestionMode", "type": "str"},
        "content_type": {"key": "properties.contentType", "type": "str"},
        "created_time_utc": {"key": "properties.createdTimeUTC", "type": "iso-8601"},
        "error_file": {"key": "properties.errorFile", "type": "FileMetadata"},
        "errors_preview": {"key": "properties.errorsPreview", "type": "[ValidationError]"},
        "import_file": {"key": "properties.importFile", "type": "FileMetadata"},
        "ingested_record_count": {"key": "properties.ingestedRecordCount", "type": "int"},
        "source": {"key": "properties.source", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "total_record_count": {"key": "properties.totalRecordCount", "type": "int"},
        "valid_record_count": {"key": "properties.validRecordCount", "type": "int"},
        "files_valid_until_time_utc": {"key": "properties.filesValidUntilTimeUTC", "type": "iso-8601"},
        "import_valid_until_time_utc": {"key": "properties.importValidUntilTimeUTC", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        ingestion_mode: Optional[Union[str, "_models.IngestionMode"]] = None,
        content_type: Optional[Union[str, "_models.FileImportContentType"]] = None,
        import_file: Optional["_models.FileMetadata"] = None,
        source: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ingestion_mode: Describes how to ingest the records in the file. Known values are:
         "IngestOnlyIfAllAreValid", "IngestAnyValidRecords", and "Unspecified".
        :paramtype ingestion_mode: str or ~azure.mgmt.securityinsight.models.IngestionMode
        :keyword content_type: The content type of this file. Known values are: "BasicIndicator",
         "StixIndicator", and "Unspecified".
        :paramtype content_type: str or ~azure.mgmt.securityinsight.models.FileImportContentType
        :keyword import_file: Represents the imported file.
        :paramtype import_file: ~azure.mgmt.securityinsight.models.FileMetadata
        :keyword source: The source for the data in the file.
        :paramtype source: str
        """
        super().__init__(**kwargs)
        self.ingestion_mode = ingestion_mode
        self.content_type = content_type
        self.created_time_utc = None
        self.error_file = None
        self.errors_preview = None
        self.import_file = import_file
        self.ingested_record_count = None
        self.source = source
        self.state = None
        self.total_record_count = None
        self.valid_record_count = None
        self.files_valid_until_time_utc = None
        self.import_valid_until_time_utc = None


class FileImportList(_serialization.Model):
    """List all the file imports.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of file imports.
    :vartype next_link: str
    :ivar value: Array of file imports. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.FileImport]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[FileImport]"},
    }

    def __init__(self, *, value: List["_models.FileImport"], **kwargs):
        """
        :keyword value: Array of file imports. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.FileImport]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class FileMetadata(_serialization.Model):
    """Represents a file.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar file_format: The format of the file. Known values are: "CSV", "JSON", and "Unspecified".
    :vartype file_format: str or ~azure.mgmt.securityinsight.models.FileFormat
    :ivar file_name: The name of the file.
    :vartype file_name: str
    :ivar file_size: The size of the file.
    :vartype file_size: int
    :ivar file_content_uri: A URI with a valid SAS token to allow uploading / downloading the file.
    :vartype file_content_uri: str
    :ivar delete_status: Indicates whether the file was deleted from the storage account. Known
     values are: "Deleted", "NotDeleted", and "Unspecified".
    :vartype delete_status: str or ~azure.mgmt.securityinsight.models.DeleteStatus
    """

    _validation = {
        "file_content_uri": {"readonly": True},
        "delete_status": {"readonly": True},
    }

    _attribute_map = {
        "file_format": {"key": "fileFormat", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "file_size": {"key": "fileSize", "type": "int"},
        "file_content_uri": {"key": "fileContentUri", "type": "str"},
        "delete_status": {"key": "deleteStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        file_format: Optional[Union[str, "_models.FileFormat"]] = None,
        file_name: Optional[str] = None,
        file_size: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword file_format: The format of the file. Known values are: "CSV", "JSON", and
         "Unspecified".
        :paramtype file_format: str or ~azure.mgmt.securityinsight.models.FileFormat
        :keyword file_name: The name of the file.
        :paramtype file_name: str
        :keyword file_size: The size of the file.
        :paramtype file_size: int
        """
        super().__init__(**kwargs)
        self.file_format = file_format
        self.file_name = file_name
        self.file_size = file_size
        self.file_content_uri = None
        self.delete_status = None


class FusionAlertRule(AlertRule):  # pylint: disable=too-many-instance-attributes
    """Represents Fusion alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar source_settings: Configuration for all supported source signals in fusion detection.
    :vartype source_settings: list[~azure.mgmt.securityinsight.models.FusionSourceSettings]
    :ivar scenario_exclusion_patterns: Configuration to exclude scenarios in fusion detection.
    :vartype scenario_exclusion_patterns:
     list[~azure.mgmt.securityinsight.models.FusionScenarioExclusionPattern]
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "description": {"readonly": True},
        "display_name": {"readonly": True},
        "last_modified_utc": {"readonly": True},
        "severity": {"readonly": True},
        "tactics": {"readonly": True},
        "techniques": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rule_template_name": {"key": "properties.alertRuleTemplateName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "source_settings": {"key": "properties.sourceSettings", "type": "[FusionSourceSettings]"},
        "scenario_exclusion_patterns": {
            "key": "properties.scenarioExclusionPatterns",
            "type": "[FusionScenarioExclusionPattern]",
        },
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "severity": {"key": "properties.severity", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        source_settings: Optional[List["_models.FusionSourceSettings"]] = None,
        scenario_exclusion_patterns: Optional[List["_models.FusionScenarioExclusionPattern"]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        :keyword source_settings: Configuration for all supported source signals in fusion detection.
        :paramtype source_settings: list[~azure.mgmt.securityinsight.models.FusionSourceSettings]
        :keyword scenario_exclusion_patterns: Configuration to exclude scenarios in fusion detection.
        :paramtype scenario_exclusion_patterns:
         list[~azure.mgmt.securityinsight.models.FusionScenarioExclusionPattern]
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Fusion"
        self.alert_rule_template_name = alert_rule_template_name
        self.description = None
        self.display_name = None
        self.enabled = enabled
        self.source_settings = source_settings
        self.scenario_exclusion_patterns = scenario_exclusion_patterns
        self.last_modified_utc = None
        self.severity = None
        self.tactics = None
        self.techniques = None


class FusionAlertRuleTemplate(AlertRuleTemplate):  # pylint: disable=too-many-instance-attributes
    """Represents Fusion alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar last_updated_date_utc: The time that this alert rule template was last updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data connectors for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule template.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar source_settings: All supported source signal configurations consumed in fusion detection.
    :vartype source_settings: list[~azure.mgmt.securityinsight.models.FusionTemplateSourceSetting]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "created_date_utc": {"readonly": True},
        "last_updated_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rules_created_by_template_count": {"key": "properties.alertRulesCreatedByTemplateCount", "type": "int"},
        "created_date_utc": {"key": "properties.createdDateUTC", "type": "iso-8601"},
        "last_updated_date_utc": {"key": "properties.lastUpdatedDateUTC", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "required_data_connectors": {
            "key": "properties.requiredDataConnectors",
            "type": "[AlertRuleTemplateDataSource]",
        },
        "status": {"key": "properties.status", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "source_settings": {"key": "properties.sourceSettings", "type": "[FusionTemplateSourceSetting]"},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        source_settings: Optional[List["_models.FusionTemplateSourceSetting"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data connectors for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword tactics: The tactics of the alert rule template.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword source_settings: All supported source signal configurations consumed in fusion
         detection.
        :paramtype source_settings:
         list[~azure.mgmt.securityinsight.models.FusionTemplateSourceSetting]
        """
        super().__init__(**kwargs)
        self.kind: str = "Fusion"
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.created_date_utc = None
        self.last_updated_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.severity = severity
        self.tactics = tactics
        self.techniques = techniques
        self.source_settings = source_settings


class FusionScenarioExclusionPattern(_serialization.Model):
    """Represents a Fusion scenario exclusion patterns in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar exclusion_pattern: Scenario exclusion pattern. Required.
    :vartype exclusion_pattern: str
    :ivar date_added_in_utc: DateTime when scenario exclusion pattern is added in UTC. Required.
    :vartype date_added_in_utc: str
    """

    _validation = {
        "exclusion_pattern": {"required": True},
        "date_added_in_utc": {"required": True},
    }

    _attribute_map = {
        "exclusion_pattern": {"key": "exclusionPattern", "type": "str"},
        "date_added_in_utc": {"key": "dateAddedInUTC", "type": "str"},
    }

    def __init__(self, *, exclusion_pattern: str, date_added_in_utc: str, **kwargs):
        """
        :keyword exclusion_pattern: Scenario exclusion pattern. Required.
        :paramtype exclusion_pattern: str
        :keyword date_added_in_utc: DateTime when scenario exclusion pattern is added in UTC. Required.
        :paramtype date_added_in_utc: str
        """
        super().__init__(**kwargs)
        self.exclusion_pattern = exclusion_pattern
        self.date_added_in_utc = date_added_in_utc


class FusionSourceSettings(_serialization.Model):
    """Represents a supported source signal configuration in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Determines whether this source signal is enabled or disabled in Fusion
     detection. Required.
    :vartype enabled: bool
    :ivar source_name: Name of the Fusion source signal. Refer to Fusion alert rule template for
     supported values. Required.
    :vartype source_name: str
    :ivar source_sub_types: Configuration for all source subtypes under this source signal consumed
     in fusion detection.
    :vartype source_sub_types: list[~azure.mgmt.securityinsight.models.FusionSourceSubTypeSetting]
    """

    _validation = {
        "enabled": {"required": True},
        "source_name": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "source_name": {"key": "sourceName", "type": "str"},
        "source_sub_types": {"key": "sourceSubTypes", "type": "[FusionSourceSubTypeSetting]"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        source_name: str,
        source_sub_types: Optional[List["_models.FusionSourceSubTypeSetting"]] = None,
        **kwargs
    ):
        """
        :keyword enabled: Determines whether this source signal is enabled or disabled in Fusion
         detection. Required.
        :paramtype enabled: bool
        :keyword source_name: Name of the Fusion source signal. Refer to Fusion alert rule template for
         supported values. Required.
        :paramtype source_name: str
        :keyword source_sub_types: Configuration for all source subtypes under this source signal
         consumed in fusion detection.
        :paramtype source_sub_types:
         list[~azure.mgmt.securityinsight.models.FusionSourceSubTypeSetting]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.source_name = source_name
        self.source_sub_types = source_sub_types


class FusionSourceSubTypeSetting(_serialization.Model):
    """Represents a supported source subtype configuration under a source signal in Fusion detection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Determines whether this source subtype under source signal is enabled or
     disabled in Fusion detection. Required.
    :vartype enabled: bool
    :ivar source_sub_type_name: The Name of the source subtype under a given source signal in
     Fusion detection. Refer to Fusion alert rule template for supported values. Required.
    :vartype source_sub_type_name: str
    :ivar source_sub_type_display_name: The display name of source subtype under a source signal
     consumed in Fusion detection.
    :vartype source_sub_type_display_name: str
    :ivar severity_filters: Severity configuration for a source subtype consumed in fusion
     detection. Required.
    :vartype severity_filters: ~azure.mgmt.securityinsight.models.FusionSubTypeSeverityFilter
    """

    _validation = {
        "enabled": {"required": True},
        "source_sub_type_name": {"required": True},
        "source_sub_type_display_name": {"readonly": True},
        "severity_filters": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "source_sub_type_name": {"key": "sourceSubTypeName", "type": "str"},
        "source_sub_type_display_name": {"key": "sourceSubTypeDisplayName", "type": "str"},
        "severity_filters": {"key": "severityFilters", "type": "FusionSubTypeSeverityFilter"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        source_sub_type_name: str,
        severity_filters: "_models.FusionSubTypeSeverityFilter",
        **kwargs
    ):
        """
        :keyword enabled: Determines whether this source subtype under source signal is enabled or
         disabled in Fusion detection. Required.
        :paramtype enabled: bool
        :keyword source_sub_type_name: The Name of the source subtype under a given source signal in
         Fusion detection. Refer to Fusion alert rule template for supported values. Required.
        :paramtype source_sub_type_name: str
        :keyword severity_filters: Severity configuration for a source subtype consumed in fusion
         detection. Required.
        :paramtype severity_filters: ~azure.mgmt.securityinsight.models.FusionSubTypeSeverityFilter
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.source_sub_type_name = source_sub_type_name
        self.source_sub_type_display_name = None
        self.severity_filters = severity_filters


class FusionSubTypeSeverityFilter(_serialization.Model):
    """Represents severity configuration for a source subtype consumed in Fusion detection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_supported: Determines whether this source subtype supports severity configuration or
     not.
    :vartype is_supported: bool
    :ivar filters: Individual Severity configuration settings for a given source subtype consumed
     in Fusion detection.
    :vartype filters: list[~azure.mgmt.securityinsight.models.FusionSubTypeSeverityFiltersItem]
    """

    _validation = {
        "is_supported": {"readonly": True},
    }

    _attribute_map = {
        "is_supported": {"key": "isSupported", "type": "bool"},
        "filters": {"key": "filters", "type": "[FusionSubTypeSeverityFiltersItem]"},
    }

    def __init__(self, *, filters: Optional[List["_models.FusionSubTypeSeverityFiltersItem"]] = None, **kwargs):
        """
        :keyword filters: Individual Severity configuration settings for a given source subtype
         consumed in Fusion detection.
        :paramtype filters: list[~azure.mgmt.securityinsight.models.FusionSubTypeSeverityFiltersItem]
        """
        super().__init__(**kwargs)
        self.is_supported = None
        self.filters = filters


class FusionSubTypeSeverityFiltersItem(_serialization.Model):
    """Represents a Severity filter setting for a given source subtype consumed in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar severity: The Severity for a given source subtype consumed in Fusion detection. Required.
     Known values are: "High", "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar enabled: Determines whether this severity is enabled or disabled for this source subtype
     consumed in Fusion detection. Required.
    :vartype enabled: bool
    """

    _validation = {
        "severity": {"required": True},
        "enabled": {"required": True},
    }

    _attribute_map = {
        "severity": {"key": "severity", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, severity: Union[str, "_models.AlertSeverity"], enabled: bool, **kwargs):
        """
        :keyword severity: The Severity for a given source subtype consumed in Fusion detection.
         Required. Known values are: "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword enabled: Determines whether this severity is enabled or disabled for this source
         subtype consumed in Fusion detection. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.severity = severity
        self.enabled = enabled


class FusionTemplateSourceSetting(_serialization.Model):
    """Represents a source signal consumed in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar source_name: The name of a source signal consumed in Fusion detection. Required.
    :vartype source_name: str
    :ivar source_sub_types: All supported source subtypes under this source signal consumed in
     fusion detection.
    :vartype source_sub_types: list[~azure.mgmt.securityinsight.models.FusionTemplateSourceSubType]
    """

    _validation = {
        "source_name": {"required": True},
    }

    _attribute_map = {
        "source_name": {"key": "sourceName", "type": "str"},
        "source_sub_types": {"key": "sourceSubTypes", "type": "[FusionTemplateSourceSubType]"},
    }

    def __init__(
        self,
        *,
        source_name: str,
        source_sub_types: Optional[List["_models.FusionTemplateSourceSubType"]] = None,
        **kwargs
    ):
        """
        :keyword source_name: The name of a source signal consumed in Fusion detection. Required.
        :paramtype source_name: str
        :keyword source_sub_types: All supported source subtypes under this source signal consumed in
         fusion detection.
        :paramtype source_sub_types:
         list[~azure.mgmt.securityinsight.models.FusionTemplateSourceSubType]
        """
        super().__init__(**kwargs)
        self.source_name = source_name
        self.source_sub_types = source_sub_types


class FusionTemplateSourceSubType(_serialization.Model):
    """Represents a source subtype under a source signal consumed in Fusion detection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar source_sub_type_name: The name of source subtype under a source signal consumed in Fusion
     detection. Required.
    :vartype source_sub_type_name: str
    :ivar source_sub_type_display_name: The display name of source subtype under a source signal
     consumed in Fusion detection.
    :vartype source_sub_type_display_name: str
    :ivar severity_filter: Severity configuration available for a source subtype consumed in fusion
     detection. Required.
    :vartype severity_filter:
     ~azure.mgmt.securityinsight.models.FusionTemplateSubTypeSeverityFilter
    """

    _validation = {
        "source_sub_type_name": {"required": True},
        "source_sub_type_display_name": {"readonly": True},
        "severity_filter": {"required": True},
    }

    _attribute_map = {
        "source_sub_type_name": {"key": "sourceSubTypeName", "type": "str"},
        "source_sub_type_display_name": {"key": "sourceSubTypeDisplayName", "type": "str"},
        "severity_filter": {"key": "severityFilter", "type": "FusionTemplateSubTypeSeverityFilter"},
    }

    def __init__(
        self, *, source_sub_type_name: str, severity_filter: "_models.FusionTemplateSubTypeSeverityFilter", **kwargs
    ):
        """
        :keyword source_sub_type_name: The name of source subtype under a source signal consumed in
         Fusion detection. Required.
        :paramtype source_sub_type_name: str
        :keyword severity_filter: Severity configuration available for a source subtype consumed in
         fusion detection. Required.
        :paramtype severity_filter:
         ~azure.mgmt.securityinsight.models.FusionTemplateSubTypeSeverityFilter
        """
        super().__init__(**kwargs)
        self.source_sub_type_name = source_sub_type_name
        self.source_sub_type_display_name = None
        self.severity_filter = severity_filter


class FusionTemplateSubTypeSeverityFilter(_serialization.Model):
    """Represents severity configurations available for a source subtype consumed in Fusion detection.

    All required parameters must be populated in order to send to Azure.

    :ivar is_supported: Determines whether severity configuration is supported for this source
     subtype consumed in Fusion detection. Required.
    :vartype is_supported: bool
    :ivar severity_filters: List of all supported severities for this source subtype consumed in
     Fusion detection.
    :vartype severity_filters: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        "is_supported": {"required": True},
    }

    _attribute_map = {
        "is_supported": {"key": "isSupported", "type": "bool"},
        "severity_filters": {"key": "severityFilters", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        is_supported: bool,
        severity_filters: Optional[List[Union[str, "_models.AlertSeverity"]]] = None,
        **kwargs
    ):
        """
        :keyword is_supported: Determines whether severity configuration is supported for this source
         subtype consumed in Fusion detection. Required.
        :paramtype is_supported: bool
        :keyword severity_filters: List of all supported severities for this source subtype consumed in
         Fusion detection.
        :paramtype severity_filters: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        """
        super().__init__(**kwargs)
        self.is_supported = is_supported
        self.severity_filters = severity_filters


class GeoLocation(_serialization.Model):
    """The geo-location context attached to the ip entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asn: Autonomous System Number.
    :vartype asn: int
    :ivar city: City name.
    :vartype city: str
    :ivar country_code: The country code according to ISO 3166 format.
    :vartype country_code: str
    :ivar country_name: Country name according to ISO 3166 Alpha 2: the lowercase of the English
     Short Name.
    :vartype country_name: str
    :ivar latitude: The longitude of the identified location, expressed as a floating point number
     with range of -180 to 180, with positive numbers representing East and negative numbers
     representing West. Latitude and longitude are derived from the city or postal code.
    :vartype latitude: float
    :ivar longitude: The latitude of the identified location, expressed as a floating point number
     with range of - 90 to 90, with positive numbers representing North and negative numbers
     representing South. Latitude and longitude are derived from the city or postal code.
    :vartype longitude: float
    :ivar state: State name.
    :vartype state: str
    """

    _validation = {
        "asn": {"readonly": True},
        "city": {"readonly": True},
        "country_code": {"readonly": True},
        "country_name": {"readonly": True},
        "latitude": {"readonly": True},
        "longitude": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "asn": {"key": "asn", "type": "int"},
        "city": {"key": "city", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "country_name": {"key": "countryName", "type": "str"},
        "latitude": {"key": "latitude", "type": "float"},
        "longitude": {"key": "longitude", "type": "float"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.asn = None
        self.city = None
        self.country_code = None
        self.country_name = None
        self.latitude = None
        self.longitude = None
        self.state = None


class GetInsightsErrorKind(_serialization.Model):
    """GetInsights Query Errors.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: the query kind. Required. "Insight"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.GetInsightsError
    :ivar query_id: the query id.
    :vartype query_id: str
    :ivar error_message: the error message. Required.
    :vartype error_message: str
    """

    _validation = {
        "kind": {"required": True},
        "error_message": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "query_id": {"key": "queryId", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "_models.GetInsightsError"],
        error_message: str,
        query_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: the query kind. Required. "Insight"
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.GetInsightsError
        :keyword query_id: the query id.
        :paramtype query_id: str
        :keyword error_message: the error message. Required.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.query_id = query_id
        self.error_message = error_message


class GetInsightsResultsMetadata(_serialization.Model):
    """Get Insights result metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar total_count: the total items found for the insights request. Required.
    :vartype total_count: int
    :ivar errors: information about the failed queries.
    :vartype errors: list[~azure.mgmt.securityinsight.models.GetInsightsErrorKind]
    """

    _validation = {
        "total_count": {"required": True},
    }

    _attribute_map = {
        "total_count": {"key": "totalCount", "type": "int"},
        "errors": {"key": "errors", "type": "[GetInsightsErrorKind]"},
    }

    def __init__(self, *, total_count: int, errors: Optional[List["_models.GetInsightsErrorKind"]] = None, **kwargs):
        """
        :keyword total_count: the total items found for the insights request. Required.
        :paramtype total_count: int
        :keyword errors: information about the failed queries.
        :paramtype errors: list[~azure.mgmt.securityinsight.models.GetInsightsErrorKind]
        """
        super().__init__(**kwargs)
        self.total_count = total_count
        self.errors = errors


class GetQueriesResponse(_serialization.Model):
    """Retrieve queries for entity result operation response.

    :ivar value: The query result values.
    :vartype value: list[~azure.mgmt.securityinsight.models.EntityQueryItem]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EntityQueryItem]"},
    }

    def __init__(self, *, value: Optional[List["_models.EntityQueryItem"]] = None, **kwargs):
        """
        :keyword value: The query result values.
        :paramtype value: list[~azure.mgmt.securityinsight.models.EntityQueryItem]
        """
        super().__init__(**kwargs)
        self.value = value


class GitHubResourceInfo(_serialization.Model):
    """Resources created in GitHub repository.

    :ivar app_installation_id: GitHub application installation id.
    :vartype app_installation_id: str
    """

    _attribute_map = {
        "app_installation_id": {"key": "appInstallationId", "type": "str"},
    }

    def __init__(self, *, app_installation_id: Optional[str] = None, **kwargs):
        """
        :keyword app_installation_id: GitHub application installation id.
        :paramtype app_installation_id: str
        """
        super().__init__(**kwargs)
        self.app_installation_id = app_installation_id


class GroupingConfiguration(_serialization.Model):
    """Grouping configuration property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Grouping enabled. Required.
    :vartype enabled: bool
    :ivar reopen_closed_incident: Re-open closed matching incidents. Required.
    :vartype reopen_closed_incident: bool
    :ivar lookback_duration: Limit the group to alerts created within the lookback duration (in ISO
     8601 duration format). Required.
    :vartype lookback_duration: ~datetime.timedelta
    :ivar matching_method: Grouping matching method. When method is Selected at least one of
     groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
     Required. Known values are: "AllEntities", "AnyAlert", and "Selected".
    :vartype matching_method: str or ~azure.mgmt.securityinsight.models.MatchingMethod
    :ivar group_by_entities: A list of entity types to group by (when matchingMethod is Selected).
     Only entities defined in the current alert rule may be used.
    :vartype group_by_entities: list[str or ~azure.mgmt.securityinsight.models.EntityMappingType]
    :ivar group_by_alert_details: A list of alert details to group by (when matchingMethod is
     Selected).
    :vartype group_by_alert_details: list[str or ~azure.mgmt.securityinsight.models.AlertDetail]
    :ivar group_by_custom_details: A list of custom details keys to group by (when matchingMethod
     is Selected). Only keys defined in the current alert rule may be used.
    :vartype group_by_custom_details: list[str]
    """

    _validation = {
        "enabled": {"required": True},
        "reopen_closed_incident": {"required": True},
        "lookback_duration": {"required": True},
        "matching_method": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "reopen_closed_incident": {"key": "reopenClosedIncident", "type": "bool"},
        "lookback_duration": {"key": "lookbackDuration", "type": "duration"},
        "matching_method": {"key": "matchingMethod", "type": "str"},
        "group_by_entities": {"key": "groupByEntities", "type": "[str]"},
        "group_by_alert_details": {"key": "groupByAlertDetails", "type": "[str]"},
        "group_by_custom_details": {"key": "groupByCustomDetails", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        reopen_closed_incident: bool,
        lookback_duration: datetime.timedelta,
        matching_method: Union[str, "_models.MatchingMethod"],
        group_by_entities: Optional[List[Union[str, "_models.EntityMappingType"]]] = None,
        group_by_alert_details: Optional[List[Union[str, "_models.AlertDetail"]]] = None,
        group_by_custom_details: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword enabled: Grouping enabled. Required.
        :paramtype enabled: bool
        :keyword reopen_closed_incident: Re-open closed matching incidents. Required.
        :paramtype reopen_closed_incident: bool
        :keyword lookback_duration: Limit the group to alerts created within the lookback duration (in
         ISO 8601 duration format). Required.
        :paramtype lookback_duration: ~datetime.timedelta
        :keyword matching_method: Grouping matching method. When method is Selected at least one of
         groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
         Required. Known values are: "AllEntities", "AnyAlert", and "Selected".
        :paramtype matching_method: str or ~azure.mgmt.securityinsight.models.MatchingMethod
        :keyword group_by_entities: A list of entity types to group by (when matchingMethod is
         Selected). Only entities defined in the current alert rule may be used.
        :paramtype group_by_entities: list[str or ~azure.mgmt.securityinsight.models.EntityMappingType]
        :keyword group_by_alert_details: A list of alert details to group by (when matchingMethod is
         Selected).
        :paramtype group_by_alert_details: list[str or ~azure.mgmt.securityinsight.models.AlertDetail]
        :keyword group_by_custom_details: A list of custom details keys to group by (when
         matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        :paramtype group_by_custom_details: list[str]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.reopen_closed_incident = reopen_closed_incident
        self.lookback_duration = lookback_duration
        self.matching_method = matching_method
        self.group_by_entities = group_by_entities
        self.group_by_alert_details = group_by_alert_details
        self.group_by_custom_details = group_by_custom_details


class HostEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a host entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar azure_id: The azure resource id of the VM.
    :vartype azure_id: str
    :ivar dns_domain: The DNS domain that this host belongs to. Should contain the compete DNS
     suffix for the domain.
    :vartype dns_domain: str
    :ivar host_name: The hostname without the domain suffix.
    :vartype host_name: str
    :ivar is_domain_joined: Determines whether this host belongs to a domain.
    :vartype is_domain_joined: bool
    :ivar net_bios_name: The host name (pre-windows2000).
    :vartype net_bios_name: str
    :ivar nt_domain: The NT domain that this host belongs to.
    :vartype nt_domain: str
    :ivar oms_agent_id: The OMS agent id, if the host has OMS agent installed.
    :vartype oms_agent_id: str
    :ivar os_family: The operating system type. Known values are: "Linux", "Windows", "Android",
     "IOS", and "Unknown".
    :vartype os_family: str or ~azure.mgmt.securityinsight.models.OSFamily
    :ivar os_version: A free text representation of the operating system. This field is meant to
     hold specific versions the are more fine grained than OSFamily or future values not supported
     by OSFamily enumeration.
    :vartype os_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "azure_id": {"readonly": True},
        "dns_domain": {"readonly": True},
        "host_name": {"readonly": True},
        "is_domain_joined": {"readonly": True},
        "net_bios_name": {"readonly": True},
        "nt_domain": {"readonly": True},
        "oms_agent_id": {"readonly": True},
        "os_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "azure_id": {"key": "properties.azureID", "type": "str"},
        "dns_domain": {"key": "properties.dnsDomain", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "is_domain_joined": {"key": "properties.isDomainJoined", "type": "bool"},
        "net_bios_name": {"key": "properties.netBiosName", "type": "str"},
        "nt_domain": {"key": "properties.ntDomain", "type": "str"},
        "oms_agent_id": {"key": "properties.omsAgentID", "type": "str"},
        "os_family": {"key": "properties.osFamily", "type": "str"},
        "os_version": {"key": "properties.osVersion", "type": "str"},
    }

    def __init__(self, *, os_family: Optional[Union[str, "_models.OSFamily"]] = None, **kwargs):
        """
        :keyword os_family: The operating system type. Known values are: "Linux", "Windows", "Android",
         "IOS", and "Unknown".
        :paramtype os_family: str or ~azure.mgmt.securityinsight.models.OSFamily
        """
        super().__init__(**kwargs)
        self.kind: str = "Host"
        self.additional_data = None
        self.friendly_name = None
        self.azure_id = None
        self.dns_domain = None
        self.host_name = None
        self.is_domain_joined = None
        self.net_bios_name = None
        self.nt_domain = None
        self.oms_agent_id = None
        self.os_family = os_family
        self.os_version = None


class HostEntityProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Host entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar azure_id: The azure resource id of the VM.
    :vartype azure_id: str
    :ivar dns_domain: The DNS domain that this host belongs to. Should contain the compete DNS
     suffix for the domain.
    :vartype dns_domain: str
    :ivar host_name: The hostname without the domain suffix.
    :vartype host_name: str
    :ivar is_domain_joined: Determines whether this host belongs to a domain.
    :vartype is_domain_joined: bool
    :ivar net_bios_name: The host name (pre-windows2000).
    :vartype net_bios_name: str
    :ivar nt_domain: The NT domain that this host belongs to.
    :vartype nt_domain: str
    :ivar oms_agent_id: The OMS agent id, if the host has OMS agent installed.
    :vartype oms_agent_id: str
    :ivar os_family: The operating system type. Known values are: "Linux", "Windows", "Android",
     "IOS", and "Unknown".
    :vartype os_family: str or ~azure.mgmt.securityinsight.models.OSFamily
    :ivar os_version: A free text representation of the operating system. This field is meant to
     hold specific versions the are more fine grained than OSFamily or future values not supported
     by OSFamily enumeration.
    :vartype os_version: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "azure_id": {"readonly": True},
        "dns_domain": {"readonly": True},
        "host_name": {"readonly": True},
        "is_domain_joined": {"readonly": True},
        "net_bios_name": {"readonly": True},
        "nt_domain": {"readonly": True},
        "oms_agent_id": {"readonly": True},
        "os_version": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "azure_id": {"key": "azureID", "type": "str"},
        "dns_domain": {"key": "dnsDomain", "type": "str"},
        "host_name": {"key": "hostName", "type": "str"},
        "is_domain_joined": {"key": "isDomainJoined", "type": "bool"},
        "net_bios_name": {"key": "netBiosName", "type": "str"},
        "nt_domain": {"key": "ntDomain", "type": "str"},
        "oms_agent_id": {"key": "omsAgentID", "type": "str"},
        "os_family": {"key": "osFamily", "type": "str"},
        "os_version": {"key": "osVersion", "type": "str"},
    }

    def __init__(self, *, os_family: Optional[Union[str, "_models.OSFamily"]] = None, **kwargs):
        """
        :keyword os_family: The operating system type. Known values are: "Linux", "Windows", "Android",
         "IOS", and "Unknown".
        :paramtype os_family: str or ~azure.mgmt.securityinsight.models.OSFamily
        """
        super().__init__(**kwargs)
        self.azure_id = None
        self.dns_domain = None
        self.host_name = None
        self.is_domain_joined = None
        self.net_bios_name = None
        self.nt_domain = None
        self.oms_agent_id = None
        self.os_family = os_family
        self.os_version = None


class HuntingBookmark(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a Hunting bookmark entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar created: The time the bookmark was created.
    :vartype created: ~datetime.datetime
    :ivar created_by: Describes a user that created the bookmark.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar display_name: The display name of the bookmark.
    :vartype display_name: str
    :ivar event_time: The time of the event.
    :vartype event_time: ~datetime.datetime
    :ivar labels: List of labels relevant to this bookmark.
    :vartype labels: list[str]
    :ivar notes: The notes of the bookmark.
    :vartype notes: str
    :ivar query: The query of the bookmark.
    :vartype query: str
    :ivar query_result: The query result of the bookmark.
    :vartype query_result: str
    :ivar updated: The last time the bookmark was updated.
    :vartype updated: ~datetime.datetime
    :ivar updated_by: Describes a user that updated the bookmark.
    :vartype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar incident_info: Describes an incident that relates to bookmark.
    :vartype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "created_by": {"key": "properties.createdBy", "type": "UserInfo"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "event_time": {"key": "properties.eventTime", "type": "iso-8601"},
        "labels": {"key": "properties.labels", "type": "[str]"},
        "notes": {"key": "properties.notes", "type": "str"},
        "query": {"key": "properties.query", "type": "str"},
        "query_result": {"key": "properties.queryResult", "type": "str"},
        "updated": {"key": "properties.updated", "type": "iso-8601"},
        "updated_by": {"key": "properties.updatedBy", "type": "UserInfo"},
        "incident_info": {"key": "properties.incidentInfo", "type": "IncidentInfo"},
    }

    def __init__(
        self,
        *,
        created: Optional[datetime.datetime] = None,
        created_by: Optional["_models.UserInfo"] = None,
        display_name: Optional[str] = None,
        event_time: Optional[datetime.datetime] = None,
        labels: Optional[List[str]] = None,
        notes: Optional[str] = None,
        query: Optional[str] = None,
        query_result: Optional[str] = None,
        updated: Optional[datetime.datetime] = None,
        updated_by: Optional["_models.UserInfo"] = None,
        incident_info: Optional["_models.IncidentInfo"] = None,
        **kwargs
    ):
        """
        :keyword created: The time the bookmark was created.
        :paramtype created: ~datetime.datetime
        :keyword created_by: Describes a user that created the bookmark.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword display_name: The display name of the bookmark.
        :paramtype display_name: str
        :keyword event_time: The time of the event.
        :paramtype event_time: ~datetime.datetime
        :keyword labels: List of labels relevant to this bookmark.
        :paramtype labels: list[str]
        :keyword notes: The notes of the bookmark.
        :paramtype notes: str
        :keyword query: The query of the bookmark.
        :paramtype query: str
        :keyword query_result: The query result of the bookmark.
        :paramtype query_result: str
        :keyword updated: The last time the bookmark was updated.
        :paramtype updated: ~datetime.datetime
        :keyword updated_by: Describes a user that updated the bookmark.
        :paramtype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword incident_info: Describes an incident that relates to bookmark.
        :paramtype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
        """
        super().__init__(**kwargs)
        self.kind: str = "Bookmark"
        self.additional_data = None
        self.friendly_name = None
        self.created = created
        self.created_by = created_by
        self.display_name = display_name
        self.event_time = event_time
        self.labels = labels
        self.notes = notes
        self.query = query
        self.query_result = query_result
        self.updated = updated
        self.updated_by = updated_by
        self.incident_info = incident_info


class HuntingBookmarkProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Describes bookmark properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar created: The time the bookmark was created.
    :vartype created: ~datetime.datetime
    :ivar created_by: Describes a user that created the bookmark.
    :vartype created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar display_name: The display name of the bookmark. Required.
    :vartype display_name: str
    :ivar event_time: The time of the event.
    :vartype event_time: ~datetime.datetime
    :ivar labels: List of labels relevant to this bookmark.
    :vartype labels: list[str]
    :ivar notes: The notes of the bookmark.
    :vartype notes: str
    :ivar query: The query of the bookmark. Required.
    :vartype query: str
    :ivar query_result: The query result of the bookmark.
    :vartype query_result: str
    :ivar updated: The last time the bookmark was updated.
    :vartype updated: ~datetime.datetime
    :ivar updated_by: Describes a user that updated the bookmark.
    :vartype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :ivar incident_info: Describes an incident that relates to bookmark.
    :vartype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "display_name": {"required": True},
        "query": {"required": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "created": {"key": "created", "type": "iso-8601"},
        "created_by": {"key": "createdBy", "type": "UserInfo"},
        "display_name": {"key": "displayName", "type": "str"},
        "event_time": {"key": "eventTime", "type": "iso-8601"},
        "labels": {"key": "labels", "type": "[str]"},
        "notes": {"key": "notes", "type": "str"},
        "query": {"key": "query", "type": "str"},
        "query_result": {"key": "queryResult", "type": "str"},
        "updated": {"key": "updated", "type": "iso-8601"},
        "updated_by": {"key": "updatedBy", "type": "UserInfo"},
        "incident_info": {"key": "incidentInfo", "type": "IncidentInfo"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        query: str,
        created: Optional[datetime.datetime] = None,
        created_by: Optional["_models.UserInfo"] = None,
        event_time: Optional[datetime.datetime] = None,
        labels: Optional[List[str]] = None,
        notes: Optional[str] = None,
        query_result: Optional[str] = None,
        updated: Optional[datetime.datetime] = None,
        updated_by: Optional["_models.UserInfo"] = None,
        incident_info: Optional["_models.IncidentInfo"] = None,
        **kwargs
    ):
        """
        :keyword created: The time the bookmark was created.
        :paramtype created: ~datetime.datetime
        :keyword created_by: Describes a user that created the bookmark.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword display_name: The display name of the bookmark. Required.
        :paramtype display_name: str
        :keyword event_time: The time of the event.
        :paramtype event_time: ~datetime.datetime
        :keyword labels: List of labels relevant to this bookmark.
        :paramtype labels: list[str]
        :keyword notes: The notes of the bookmark.
        :paramtype notes: str
        :keyword query: The query of the bookmark. Required.
        :paramtype query: str
        :keyword query_result: The query result of the bookmark.
        :paramtype query_result: str
        :keyword updated: The last time the bookmark was updated.
        :paramtype updated: ~datetime.datetime
        :keyword updated_by: Describes a user that updated the bookmark.
        :paramtype updated_by: ~azure.mgmt.securityinsight.models.UserInfo
        :keyword incident_info: Describes an incident that relates to bookmark.
        :paramtype incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
        """
        super().__init__(**kwargs)
        self.created = created
        self.created_by = created_by
        self.display_name = display_name
        self.event_time = event_time
        self.labels = labels
        self.notes = notes
        self.query = query
        self.query_result = query_result
        self.updated = updated
        self.updated_by = updated_by
        self.incident_info = incident_info


class Incident(ResourceWithEtag):  # pylint: disable=too-many-instance-attributes
    """Incident.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar title: The title of the incident.
    :vartype title: str
    :ivar description: The description of the incident.
    :vartype description: str
    :ivar severity: The severity of the incident. Known values are: "High", "Medium", "Low", and
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
    :ivar status: The status of the incident. Known values are: "New", "Active", and "Closed".
    :vartype status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
    :ivar classification: The reason the incident was closed. Known values are: "Undetermined",
     "TruePositive", "BenignPositive", and "FalsePositive".
    :vartype classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
    :ivar classification_reason: The classification reason the incident was closed with. Known
     values are: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic", and
     "InaccurateData".
    :vartype classification_reason: str or
     ~azure.mgmt.securityinsight.models.IncidentClassificationReason
    :ivar classification_comment: Describes the reason the incident was closed.
    :vartype classification_comment: str
    :ivar owner: Describes a user that the incident is assigned to.
    :vartype owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
    :ivar labels: List of labels relevant to this incident.
    :vartype labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
    :ivar first_activity_time_utc: The time of the first activity in the incident.
    :vartype first_activity_time_utc: ~datetime.datetime
    :ivar last_activity_time_utc: The time of the last activity in the incident.
    :vartype last_activity_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The last time the incident was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar created_time_utc: The time the incident was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar incident_number: A sequential number.
    :vartype incident_number: int
    :ivar additional_data: Additional data on the incident.
    :vartype additional_data: ~azure.mgmt.securityinsight.models.IncidentAdditionalData
    :ivar related_analytic_rule_ids: List of resource ids of Analytic rules related to the
     incident.
    :vartype related_analytic_rule_ids: list[str]
    :ivar incident_url: The deep-link url to the incident in Azure portal.
    :vartype incident_url: str
    :ivar provider_name: The name of the source provider that generated the incident.
    :vartype provider_name: str
    :ivar provider_incident_id: The incident ID assigned by the incident provider.
    :vartype provider_incident_id: str
    :ivar team_information: Describes a team for the incident.
    :vartype team_information: ~azure.mgmt.securityinsight.models.TeamInformation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "created_time_utc": {"readonly": True},
        "incident_number": {"readonly": True},
        "additional_data": {"readonly": True},
        "related_analytic_rule_ids": {"readonly": True},
        "incident_url": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "classification": {"key": "properties.classification", "type": "str"},
        "classification_reason": {"key": "properties.classificationReason", "type": "str"},
        "classification_comment": {"key": "properties.classificationComment", "type": "str"},
        "owner": {"key": "properties.owner", "type": "IncidentOwnerInfo"},
        "labels": {"key": "properties.labels", "type": "[IncidentLabel]"},
        "first_activity_time_utc": {"key": "properties.firstActivityTimeUtc", "type": "iso-8601"},
        "last_activity_time_utc": {"key": "properties.lastActivityTimeUtc", "type": "iso-8601"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "created_time_utc": {"key": "properties.createdTimeUtc", "type": "iso-8601"},
        "incident_number": {"key": "properties.incidentNumber", "type": "int"},
        "additional_data": {"key": "properties.additionalData", "type": "IncidentAdditionalData"},
        "related_analytic_rule_ids": {"key": "properties.relatedAnalyticRuleIds", "type": "[str]"},
        "incident_url": {"key": "properties.incidentUrl", "type": "str"},
        "provider_name": {"key": "properties.providerName", "type": "str"},
        "provider_incident_id": {"key": "properties.providerIncidentId", "type": "str"},
        "team_information": {"key": "properties.teamInformation", "type": "TeamInformation"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        etag: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        severity: Optional[Union[str, "_models.IncidentSeverity"]] = None,
        status: Optional[Union[str, "_models.IncidentStatus"]] = None,
        classification: Optional[Union[str, "_models.IncidentClassification"]] = None,
        classification_reason: Optional[Union[str, "_models.IncidentClassificationReason"]] = None,
        classification_comment: Optional[str] = None,
        owner: Optional["_models.IncidentOwnerInfo"] = None,
        labels: Optional[List["_models.IncidentLabel"]] = None,
        first_activity_time_utc: Optional[datetime.datetime] = None,
        last_activity_time_utc: Optional[datetime.datetime] = None,
        provider_name: Optional[str] = None,
        provider_incident_id: Optional[str] = None,
        team_information: Optional["_models.TeamInformation"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword title: The title of the incident.
        :paramtype title: str
        :keyword description: The description of the incident.
        :paramtype description: str
        :keyword severity: The severity of the incident. Known values are: "High", "Medium", "Low", and
         "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
        :keyword status: The status of the incident. Known values are: "New", "Active", and "Closed".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
        :keyword classification: The reason the incident was closed. Known values are: "Undetermined",
         "TruePositive", "BenignPositive", and "FalsePositive".
        :paramtype classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
        :keyword classification_reason: The classification reason the incident was closed with. Known
         values are: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic", and
         "InaccurateData".
        :paramtype classification_reason: str or
         ~azure.mgmt.securityinsight.models.IncidentClassificationReason
        :keyword classification_comment: Describes the reason the incident was closed.
        :paramtype classification_comment: str
        :keyword owner: Describes a user that the incident is assigned to.
        :paramtype owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
        :keyword labels: List of labels relevant to this incident.
        :paramtype labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
        :keyword first_activity_time_utc: The time of the first activity in the incident.
        :paramtype first_activity_time_utc: ~datetime.datetime
        :keyword last_activity_time_utc: The time of the last activity in the incident.
        :paramtype last_activity_time_utc: ~datetime.datetime
        :keyword provider_name: The name of the source provider that generated the incident.
        :paramtype provider_name: str
        :keyword provider_incident_id: The incident ID assigned by the incident provider.
        :paramtype provider_incident_id: str
        :keyword team_information: Describes a team for the incident.
        :paramtype team_information: ~azure.mgmt.securityinsight.models.TeamInformation
        """
        super().__init__(etag=etag, **kwargs)
        self.title = title
        self.description = description
        self.severity = severity
        self.status = status
        self.classification = classification
        self.classification_reason = classification_reason
        self.classification_comment = classification_comment
        self.owner = owner
        self.labels = labels
        self.first_activity_time_utc = first_activity_time_utc
        self.last_activity_time_utc = last_activity_time_utc
        self.last_modified_time_utc = None
        self.created_time_utc = None
        self.incident_number = None
        self.additional_data = None
        self.related_analytic_rule_ids = None
        self.incident_url = None
        self.provider_name = provider_name
        self.provider_incident_id = provider_incident_id
        self.team_information = team_information


class IncidentAdditionalData(_serialization.Model):
    """Incident additional data property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alerts_count: The number of alerts in the incident.
    :vartype alerts_count: int
    :ivar bookmarks_count: The number of bookmarks in the incident.
    :vartype bookmarks_count: int
    :ivar comments_count: The number of comments in the incident.
    :vartype comments_count: int
    :ivar alert_product_names: List of product names of alerts in the incident.
    :vartype alert_product_names: list[str]
    :ivar tactics: The tactics associated with incident.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques associated with incident's tactics.
    :vartype techniques: list[str]
    :ivar provider_incident_url: The provider incident url to the incident in Microsoft 365
     Defender portal.
    :vartype provider_incident_url: str
    """

    _validation = {
        "alerts_count": {"readonly": True},
        "bookmarks_count": {"readonly": True},
        "comments_count": {"readonly": True},
        "alert_product_names": {"readonly": True},
        "tactics": {"readonly": True},
        "techniques": {"readonly": True},
        "provider_incident_url": {"readonly": True},
    }

    _attribute_map = {
        "alerts_count": {"key": "alertsCount", "type": "int"},
        "bookmarks_count": {"key": "bookmarksCount", "type": "int"},
        "comments_count": {"key": "commentsCount", "type": "int"},
        "alert_product_names": {"key": "alertProductNames", "type": "[str]"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "techniques": {"key": "techniques", "type": "[str]"},
        "provider_incident_url": {"key": "providerIncidentUrl", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.alerts_count = None
        self.bookmarks_count = None
        self.comments_count = None
        self.alert_product_names = None
        self.tactics = None
        self.techniques = None
        self.provider_incident_url = None


class IncidentAlertList(_serialization.Model):
    """List of incident alerts.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Array of incident alerts. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.SecurityAlert]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityAlert]"},
    }

    def __init__(self, *, value: List["_models.SecurityAlert"], **kwargs):
        """
        :keyword value: Array of incident alerts. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.SecurityAlert]
        """
        super().__init__(**kwargs)
        self.value = value


class IncidentBookmarkList(_serialization.Model):
    """List of incident bookmarks.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Array of incident bookmarks. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.HuntingBookmark]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HuntingBookmark]"},
    }

    def __init__(self, *, value: List["_models.HuntingBookmark"], **kwargs):
        """
        :keyword value: Array of incident bookmarks. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.HuntingBookmark]
        """
        super().__init__(**kwargs)
        self.value = value


class IncidentComment(ResourceWithEtag):
    """Represents an incident comment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar message: The comment message.
    :vartype message: str
    :ivar created_time_utc: The time the comment was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The time the comment was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar author: Describes the client that created the comment.
    :vartype author: ~azure.mgmt.securityinsight.models.ClientInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_time_utc": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "author": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "created_time_utc": {"key": "properties.createdTimeUtc", "type": "iso-8601"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "author": {"key": "properties.author", "type": "ClientInfo"},
    }

    def __init__(self, *, etag: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword message: The comment message.
        :paramtype message: str
        """
        super().__init__(etag=etag, **kwargs)
        self.message = message
        self.created_time_utc = None
        self.last_modified_time_utc = None
        self.author = None


class IncidentCommentList(_serialization.Model):
    """IncidentCommentList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.IncidentComment]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IncidentComment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IncidentComment"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.IncidentComment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IncidentConfiguration(_serialization.Model):
    """Incident Configuration property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar create_incident: Create incidents from alerts triggered by this analytics rule. Required.
    :vartype create_incident: bool
    :ivar grouping_configuration: Set how the alerts that are triggered by this analytics rule, are
     grouped into incidents.
    :vartype grouping_configuration: ~azure.mgmt.securityinsight.models.GroupingConfiguration
    """

    _validation = {
        "create_incident": {"required": True},
    }

    _attribute_map = {
        "create_incident": {"key": "createIncident", "type": "bool"},
        "grouping_configuration": {"key": "groupingConfiguration", "type": "GroupingConfiguration"},
    }

    def __init__(
        self,
        *,
        create_incident: bool,
        grouping_configuration: Optional["_models.GroupingConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword create_incident: Create incidents from alerts triggered by this analytics rule.
         Required.
        :paramtype create_incident: bool
        :keyword grouping_configuration: Set how the alerts that are triggered by this analytics rule,
         are grouped into incidents.
        :paramtype grouping_configuration: ~azure.mgmt.securityinsight.models.GroupingConfiguration
        """
        super().__init__(**kwargs)
        self.create_incident = create_incident
        self.grouping_configuration = grouping_configuration


class IncidentEntitiesResponse(_serialization.Model):
    """The incident related entities response.

    :ivar entities: Array of the incident related entities.
    :vartype entities: list[~azure.mgmt.securityinsight.models.Entity]
    :ivar meta_data: The metadata from the incident related entities results.
    :vartype meta_data: list[~azure.mgmt.securityinsight.models.IncidentEntitiesResultsMetadata]
    """

    _attribute_map = {
        "entities": {"key": "entities", "type": "[Entity]"},
        "meta_data": {"key": "metaData", "type": "[IncidentEntitiesResultsMetadata]"},
    }

    def __init__(
        self,
        *,
        entities: Optional[List["_models.Entity"]] = None,
        meta_data: Optional[List["_models.IncidentEntitiesResultsMetadata"]] = None,
        **kwargs
    ):
        """
        :keyword entities: Array of the incident related entities.
        :paramtype entities: list[~azure.mgmt.securityinsight.models.Entity]
        :keyword meta_data: The metadata from the incident related entities results.
        :paramtype meta_data: list[~azure.mgmt.securityinsight.models.IncidentEntitiesResultsMetadata]
        """
        super().__init__(**kwargs)
        self.entities = entities
        self.meta_data = meta_data


class IncidentEntitiesResultsMetadata(_serialization.Model):
    """Information of a specific aggregation in the incident related entities result.

    All required parameters must be populated in order to send to Azure.

    :ivar entity_kind: The kind of the aggregated entity. Required. Known values are: "Account",
     "Host", "File", "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip",
     "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice",
     "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and
     "Nic".
    :vartype entity_kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar count: Total number of aggregations of the given kind in the incident related entities
     result. Required.
    :vartype count: int
    """

    _validation = {
        "entity_kind": {"required": True},
        "count": {"required": True},
    }

    _attribute_map = {
        "entity_kind": {"key": "entityKind", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, entity_kind: Union[str, "_models.EntityKind"], count: int, **kwargs):
        """
        :keyword entity_kind: The kind of the aggregated entity. Required. Known values are: "Account",
         "Host", "File", "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip",
         "Malware", "Process", "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice",
         "SecurityAlert", "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and
         "Nic".
        :paramtype entity_kind: str or ~azure.mgmt.securityinsight.models.EntityKind
        :keyword count: Total number of aggregations of the given kind in the incident related entities
         result. Required.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.entity_kind = entity_kind
        self.count = count


class IncidentInfo(_serialization.Model):
    """Describes related incident information for the bookmark.

    :ivar incident_id: Incident Id.
    :vartype incident_id: str
    :ivar severity: The severity of the incident. Known values are: "High", "Medium", "Low", and
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
    :ivar title: The title of the incident.
    :vartype title: str
    :ivar relation_name: Relation Name.
    :vartype relation_name: str
    """

    _attribute_map = {
        "incident_id": {"key": "incidentId", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "relation_name": {"key": "relationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        incident_id: Optional[str] = None,
        severity: Optional[Union[str, "_models.IncidentSeverity"]] = None,
        title: Optional[str] = None,
        relation_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword incident_id: Incident Id.
        :paramtype incident_id: str
        :keyword severity: The severity of the incident. Known values are: "High", "Medium", "Low", and
         "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
        :keyword title: The title of the incident.
        :paramtype title: str
        :keyword relation_name: Relation Name.
        :paramtype relation_name: str
        """
        super().__init__(**kwargs)
        self.incident_id = incident_id
        self.severity = severity
        self.title = title
        self.relation_name = relation_name


class IncidentLabel(_serialization.Model):
    """Represents an incident label.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar label_name: The name of the label. Required.
    :vartype label_name: str
    :ivar label_type: The type of the label. Known values are: "User" and "AutoAssigned".
    :vartype label_type: str or ~azure.mgmt.securityinsight.models.IncidentLabelType
    """

    _validation = {
        "label_name": {"required": True},
        "label_type": {"readonly": True},
    }

    _attribute_map = {
        "label_name": {"key": "labelName", "type": "str"},
        "label_type": {"key": "labelType", "type": "str"},
    }

    def __init__(self, *, label_name: str, **kwargs):
        """
        :keyword label_name: The name of the label. Required.
        :paramtype label_name: str
        """
        super().__init__(**kwargs)
        self.label_name = label_name
        self.label_type = None


class IncidentList(_serialization.Model):
    """List all the incidents.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.Incident]
    :ivar next_link: URL to fetch the next set of incidents.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Incident]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Incident"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Incident]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IncidentOwnerInfo(_serialization.Model):
    """Information on the user an incident is assigned to.

    :ivar email: The email of the user the incident is assigned to.
    :vartype email: str
    :ivar assigned_to: The name of the user the incident is assigned to.
    :vartype assigned_to: str
    :ivar object_id: The object id of the user the incident is assigned to.
    :vartype object_id: str
    :ivar user_principal_name: The user principal name of the user the incident is assigned to.
    :vartype user_principal_name: str
    :ivar owner_type: The type of the owner the incident is assigned to. Known values are:
     "Unknown", "User", and "Group".
    :vartype owner_type: str or ~azure.mgmt.securityinsight.models.OwnerType
    """

    _attribute_map = {
        "email": {"key": "email", "type": "str"},
        "assigned_to": {"key": "assignedTo", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "user_principal_name": {"key": "userPrincipalName", "type": "str"},
        "owner_type": {"key": "ownerType", "type": "str"},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        assigned_to: Optional[str] = None,
        object_id: Optional[str] = None,
        user_principal_name: Optional[str] = None,
        owner_type: Optional[Union[str, "_models.OwnerType"]] = None,
        **kwargs
    ):
        """
        :keyword email: The email of the user the incident is assigned to.
        :paramtype email: str
        :keyword assigned_to: The name of the user the incident is assigned to.
        :paramtype assigned_to: str
        :keyword object_id: The object id of the user the incident is assigned to.
        :paramtype object_id: str
        :keyword user_principal_name: The user principal name of the user the incident is assigned to.
        :paramtype user_principal_name: str
        :keyword owner_type: The type of the owner the incident is assigned to. Known values are:
         "Unknown", "User", and "Group".
        :paramtype owner_type: str or ~azure.mgmt.securityinsight.models.OwnerType
        """
        super().__init__(**kwargs)
        self.email = email
        self.assigned_to = assigned_to
        self.object_id = object_id
        self.user_principal_name = user_principal_name
        self.owner_type = owner_type


class IncidentPropertiesAction(_serialization.Model):
    """IncidentPropertiesAction.

    :ivar severity: The severity of the incident. Known values are: "High", "Medium", "Low", and
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
    :ivar status: The status of the incident. Known values are: "New", "Active", and "Closed".
    :vartype status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
    :ivar classification: The reason the incident was closed. Known values are: "Undetermined",
     "TruePositive", "BenignPositive", and "FalsePositive".
    :vartype classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
    :ivar classification_reason: The classification reason the incident was closed with. Known
     values are: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic", and
     "InaccurateData".
    :vartype classification_reason: str or
     ~azure.mgmt.securityinsight.models.IncidentClassificationReason
    :ivar classification_comment: Describes the reason the incident was closed.
    :vartype classification_comment: str
    :ivar owner: Information on the user an incident is assigned to.
    :vartype owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
    :ivar labels: List of labels to add to the incident.
    :vartype labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
    """

    _attribute_map = {
        "severity": {"key": "severity", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "classification": {"key": "classification", "type": "str"},
        "classification_reason": {"key": "classificationReason", "type": "str"},
        "classification_comment": {"key": "classificationComment", "type": "str"},
        "owner": {"key": "owner", "type": "IncidentOwnerInfo"},
        "labels": {"key": "labels", "type": "[IncidentLabel]"},
    }

    def __init__(
        self,
        *,
        severity: Optional[Union[str, "_models.IncidentSeverity"]] = None,
        status: Optional[Union[str, "_models.IncidentStatus"]] = None,
        classification: Optional[Union[str, "_models.IncidentClassification"]] = None,
        classification_reason: Optional[Union[str, "_models.IncidentClassificationReason"]] = None,
        classification_comment: Optional[str] = None,
        owner: Optional["_models.IncidentOwnerInfo"] = None,
        labels: Optional[List["_models.IncidentLabel"]] = None,
        **kwargs
    ):
        """
        :keyword severity: The severity of the incident. Known values are: "High", "Medium", "Low", and
         "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
        :keyword status: The status of the incident. Known values are: "New", "Active", and "Closed".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
        :keyword classification: The reason the incident was closed. Known values are: "Undetermined",
         "TruePositive", "BenignPositive", and "FalsePositive".
        :paramtype classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
        :keyword classification_reason: The classification reason the incident was closed with. Known
         values are: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic", and
         "InaccurateData".
        :paramtype classification_reason: str or
         ~azure.mgmt.securityinsight.models.IncidentClassificationReason
        :keyword classification_comment: Describes the reason the incident was closed.
        :paramtype classification_comment: str
        :keyword owner: Information on the user an incident is assigned to.
        :paramtype owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
        :keyword labels: List of labels to add to the incident.
        :paramtype labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
        """
        super().__init__(**kwargs)
        self.severity = severity
        self.status = status
        self.classification = classification
        self.classification_reason = classification_reason
        self.classification_comment = classification_comment
        self.owner = owner
        self.labels = labels


class IncidentTask(ResourceWithEtag):  # pylint: disable=too-many-instance-attributes
    """IncidentTask.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar title: The title of the task. Required.
    :vartype title: str
    :ivar description: The description of the task.
    :vartype description: str
    :ivar status: Required. Known values are: "New" and "Completed".
    :vartype status: str or ~azure.mgmt.securityinsight.models.IncidentTaskStatus
    :ivar created_time_utc: The time the task was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The last time the task was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar created_by: Information on the client (user or application) that made some action.
    :vartype created_by: ~azure.mgmt.securityinsight.models.ClientInfo
    :ivar last_modified_by: Information on the client (user or application) that made some action.
    :vartype last_modified_by: ~azure.mgmt.securityinsight.models.ClientInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "title": {"required": True},
        "status": {"required": True},
        "created_time_utc": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "created_time_utc": {"key": "properties.createdTimeUtc", "type": "iso-8601"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "created_by": {"key": "properties.createdBy", "type": "ClientInfo"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "ClientInfo"},
    }

    def __init__(
        self,
        *,
        title: str,
        status: Union[str, "_models.IncidentTaskStatus"],
        etag: Optional[str] = None,
        description: Optional[str] = None,
        created_by: Optional["_models.ClientInfo"] = None,
        last_modified_by: Optional["_models.ClientInfo"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword title: The title of the task. Required.
        :paramtype title: str
        :keyword description: The description of the task.
        :paramtype description: str
        :keyword status: Required. Known values are: "New" and "Completed".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.IncidentTaskStatus
        :keyword created_by: Information on the client (user or application) that made some action.
        :paramtype created_by: ~azure.mgmt.securityinsight.models.ClientInfo
        :keyword last_modified_by: Information on the client (user or application) that made some
         action.
        :paramtype last_modified_by: ~azure.mgmt.securityinsight.models.ClientInfo
        """
        super().__init__(etag=etag, **kwargs)
        self.title = title
        self.description = description
        self.status = status
        self.created_time_utc = None
        self.last_modified_time_utc = None
        self.created_by = created_by
        self.last_modified_by = last_modified_by


class IncidentTaskList(_serialization.Model):
    """IncidentTaskList.

    :ivar value:
    :vartype value: list[~azure.mgmt.securityinsight.models.IncidentTask]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IncidentTask]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.IncidentTask"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.securityinsight.models.IncidentTask]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class InsightQueryItem(EntityQueryItem):
    """Represents Insight Query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Query Template ARM ID.
    :vartype id: str
    :ivar name: Query Template ARM Name.
    :vartype name: str
    :ivar type: ARM Type.
    :vartype type: str
    :ivar kind: The kind of the entity query. Required. Known values are: "Expansion", "Insight",
     and "Activity".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityQueryKind
    :ivar properties: Properties bag for InsightQueryItem.
    :vartype properties: ~azure.mgmt.securityinsight.models.InsightQueryItemProperties
    """

    _validation = {
        "id": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "properties": {"key": "properties", "type": "InsightQueryItemProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        properties: Optional["_models.InsightQueryItemProperties"] = None,
        **kwargs
    ):
        """
        :keyword name: Query Template ARM Name.
        :paramtype name: str
        :keyword type: ARM Type.
        :paramtype type: str
        :keyword properties: Properties bag for InsightQueryItem.
        :paramtype properties: ~azure.mgmt.securityinsight.models.InsightQueryItemProperties
        """
        super().__init__(name=name, type=type, **kwargs)
        self.kind: str = "Insight"
        self.properties = properties


class InsightQueryItemProperties(EntityQueryItemProperties):  # pylint: disable=too-many-instance-attributes
    """Represents Insight Query.

    :ivar data_types: Data types for template.
    :vartype data_types:
     list[~azure.mgmt.securityinsight.models.EntityQueryItemPropertiesDataTypesItem]
    :ivar input_entity_type: The type of the entity. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice", "SecurityAlert",
     "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
    :ivar required_input_fields_sets: Data types for template.
    :vartype required_input_fields_sets: list[list[str]]
    :ivar entities_filter: The query applied only to entities matching to all filters.
    :vartype entities_filter: JSON
    :ivar display_name: The insight display name.
    :vartype display_name: str
    :ivar description: The insight description.
    :vartype description: str
    :ivar base_query: The base query of the insight.
    :vartype base_query: str
    :ivar table_query: The insight table query.
    :vartype table_query: ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQuery
    :ivar chart_query: The insight chart query.
    :vartype chart_query: JSON
    :ivar additional_query: The activity query definitions.
    :vartype additional_query:
     ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesAdditionalQuery
    :ivar default_time_range: The insight chart query.
    :vartype default_time_range:
     ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesDefaultTimeRange
    :ivar reference_time_range: The insight chart query.
    :vartype reference_time_range:
     ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesReferenceTimeRange
    """

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "[EntityQueryItemPropertiesDataTypesItem]"},
        "input_entity_type": {"key": "inputEntityType", "type": "str"},
        "required_input_fields_sets": {"key": "requiredInputFieldsSets", "type": "[[str]]"},
        "entities_filter": {"key": "entitiesFilter", "type": "object"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "base_query": {"key": "baseQuery", "type": "str"},
        "table_query": {"key": "tableQuery", "type": "InsightQueryItemPropertiesTableQuery"},
        "chart_query": {"key": "chartQuery", "type": "object"},
        "additional_query": {"key": "additionalQuery", "type": "InsightQueryItemPropertiesAdditionalQuery"},
        "default_time_range": {"key": "defaultTimeRange", "type": "InsightQueryItemPropertiesDefaultTimeRange"},
        "reference_time_range": {"key": "referenceTimeRange", "type": "InsightQueryItemPropertiesReferenceTimeRange"},
    }

    def __init__(
        self,
        *,
        data_types: Optional[List["_models.EntityQueryItemPropertiesDataTypesItem"]] = None,
        input_entity_type: Optional[Union[str, "_models.EntityType"]] = None,
        required_input_fields_sets: Optional[List[List[str]]] = None,
        entities_filter: Optional[JSON] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        base_query: Optional[str] = None,
        table_query: Optional["_models.InsightQueryItemPropertiesTableQuery"] = None,
        chart_query: Optional[JSON] = None,
        additional_query: Optional["_models.InsightQueryItemPropertiesAdditionalQuery"] = None,
        default_time_range: Optional["_models.InsightQueryItemPropertiesDefaultTimeRange"] = None,
        reference_time_range: Optional["_models.InsightQueryItemPropertiesReferenceTimeRange"] = None,
        **kwargs
    ):
        """
        :keyword data_types: Data types for template.
        :paramtype data_types:
         list[~azure.mgmt.securityinsight.models.EntityQueryItemPropertiesDataTypesItem]
        :keyword input_entity_type: The type of the entity. Known values are: "Account", "Host",
         "File", "AzureResource", "CloudApplication", "DNS", "FileHash", "IP", "Malware", "Process",
         "RegistryKey", "RegistryValue", "SecurityGroup", "URL", "IoTDevice", "SecurityAlert",
         "HuntingBookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
        :paramtype input_entity_type: str or ~azure.mgmt.securityinsight.models.EntityType
        :keyword required_input_fields_sets: Data types for template.
        :paramtype required_input_fields_sets: list[list[str]]
        :keyword entities_filter: The query applied only to entities matching to all filters.
        :paramtype entities_filter: JSON
        :keyword display_name: The insight display name.
        :paramtype display_name: str
        :keyword description: The insight description.
        :paramtype description: str
        :keyword base_query: The base query of the insight.
        :paramtype base_query: str
        :keyword table_query: The insight table query.
        :paramtype table_query: ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQuery
        :keyword chart_query: The insight chart query.
        :paramtype chart_query: JSON
        :keyword additional_query: The activity query definitions.
        :paramtype additional_query:
         ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesAdditionalQuery
        :keyword default_time_range: The insight chart query.
        :paramtype default_time_range:
         ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesDefaultTimeRange
        :keyword reference_time_range: The insight chart query.
        :paramtype reference_time_range:
         ~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesReferenceTimeRange
        """
        super().__init__(
            data_types=data_types,
            input_entity_type=input_entity_type,
            required_input_fields_sets=required_input_fields_sets,
            entities_filter=entities_filter,
            **kwargs
        )
        self.display_name = display_name
        self.description = description
        self.base_query = base_query
        self.table_query = table_query
        self.chart_query = chart_query
        self.additional_query = additional_query
        self.default_time_range = default_time_range
        self.reference_time_range = reference_time_range


class InsightQueryItemPropertiesAdditionalQuery(_serialization.Model):
    """The activity query definitions.

    :ivar query: The insight query.
    :vartype query: str
    :ivar text: The insight text.
    :vartype text: str
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(self, *, query: Optional[str] = None, text: Optional[str] = None, **kwargs):
        """
        :keyword query: The insight query.
        :paramtype query: str
        :keyword text: The insight text.
        :paramtype text: str
        """
        super().__init__(**kwargs)
        self.query = query
        self.text = text


class InsightQueryItemPropertiesDefaultTimeRange(_serialization.Model):
    """The insight chart query.

    :ivar before_range: The padding for the start time of the query.
    :vartype before_range: str
    :ivar after_range: The padding for the end time of the query.
    :vartype after_range: str
    """

    _attribute_map = {
        "before_range": {"key": "beforeRange", "type": "str"},
        "after_range": {"key": "afterRange", "type": "str"},
    }

    def __init__(self, *, before_range: Optional[str] = None, after_range: Optional[str] = None, **kwargs):
        """
        :keyword before_range: The padding for the start time of the query.
        :paramtype before_range: str
        :keyword after_range: The padding for the end time of the query.
        :paramtype after_range: str
        """
        super().__init__(**kwargs)
        self.before_range = before_range
        self.after_range = after_range


class InsightQueryItemPropertiesReferenceTimeRange(_serialization.Model):
    """The insight chart query.

    :ivar before_range: Additional query time for looking back.
    :vartype before_range: str
    """

    _attribute_map = {
        "before_range": {"key": "beforeRange", "type": "str"},
    }

    def __init__(self, *, before_range: Optional[str] = None, **kwargs):
        """
        :keyword before_range: Additional query time for looking back.
        :paramtype before_range: str
        """
        super().__init__(**kwargs)
        self.before_range = before_range


class InsightQueryItemPropertiesTableQuery(_serialization.Model):
    """The insight table query.

    :ivar columns_definitions: List of insight column definitions.
    :vartype columns_definitions:
     list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem]
    :ivar queries_definitions: List of insight queries definitions.
    :vartype queries_definitions:
     list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem]
    """

    _attribute_map = {
        "columns_definitions": {
            "key": "columnsDefinitions",
            "type": "[InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem]",
        },
        "queries_definitions": {
            "key": "queriesDefinitions",
            "type": "[InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem]",
        },
    }

    def __init__(
        self,
        *,
        columns_definitions: Optional[
            List["_models.InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem"]
        ] = None,
        queries_definitions: Optional[
            List["_models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem"]
        ] = None,
        **kwargs
    ):
        """
        :keyword columns_definitions: List of insight column definitions.
        :paramtype columns_definitions:
         list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem]
        :keyword queries_definitions: List of insight queries definitions.
        :paramtype queries_definitions:
         list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem]
        """
        super().__init__(**kwargs)
        self.columns_definitions = columns_definitions
        self.queries_definitions = queries_definitions


class InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem(_serialization.Model):
    """InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem.

    :ivar header: Insight column header.
    :vartype header: str
    :ivar output_type: Insights Column type. Known values are: "Number", "String", "Date", and
     "Entity".
    :vartype output_type: str or ~azure.mgmt.securityinsight.models.OutputType
    :ivar support_deep_link: Is query supports deep-link.
    :vartype support_deep_link: bool
    """

    _attribute_map = {
        "header": {"key": "header", "type": "str"},
        "output_type": {"key": "outputType", "type": "str"},
        "support_deep_link": {"key": "supportDeepLink", "type": "bool"},
    }

    def __init__(
        self,
        *,
        header: Optional[str] = None,
        output_type: Optional[Union[str, "_models.OutputType"]] = None,
        support_deep_link: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword header: Insight column header.
        :paramtype header: str
        :keyword output_type: Insights Column type. Known values are: "Number", "String", "Date", and
         "Entity".
        :paramtype output_type: str or ~azure.mgmt.securityinsight.models.OutputType
        :keyword support_deep_link: Is query supports deep-link.
        :paramtype support_deep_link: bool
        """
        super().__init__(**kwargs)
        self.header = header
        self.output_type = output_type
        self.support_deep_link = support_deep_link


class InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem(_serialization.Model):
    """InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem.

    :ivar filter: Insight column header.
    :vartype filter: str
    :ivar summarize: Insight column header.
    :vartype summarize: str
    :ivar project: Insight column header.
    :vartype project: str
    :ivar link_columns_definitions: Insight column header.
    :vartype link_columns_definitions:
     list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem]
    """

    _attribute_map = {
        "filter": {"key": "filter", "type": "str"},
        "summarize": {"key": "summarize", "type": "str"},
        "project": {"key": "project", "type": "str"},
        "link_columns_definitions": {
            "key": "linkColumnsDefinitions",
            "type": "[InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem]",
        },
    }

    def __init__(
        self,
        *,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        summarize: Optional[str] = None,
        project: Optional[str] = None,
        link_columns_definitions: Optional[
            List["_models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem"]
        ] = None,
        **kwargs
    ):
        """
        :keyword filter: Insight column header.
        :paramtype filter: str
        :keyword summarize: Insight column header.
        :paramtype summarize: str
        :keyword project: Insight column header.
        :paramtype project: str
        :keyword link_columns_definitions: Insight column header.
        :paramtype link_columns_definitions:
         list[~azure.mgmt.securityinsight.models.InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem]
        """
        super().__init__(**kwargs)
        self.filter = filter
        self.summarize = summarize
        self.project = project
        self.link_columns_definitions = link_columns_definitions


class InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem(_serialization.Model):
    """InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem.

    :ivar projected_name: Insight Link Definition Projected Name.
    :vartype projected_name: str
    :ivar query: Insight Link Definition Query.
    :vartype query: str
    """

    _attribute_map = {
        "projected_name": {"key": "projectedName", "type": "str"},
        "query": {"key": "Query", "type": "str"},
    }

    def __init__(self, *, projected_name: Optional[str] = None, query: Optional[str] = None, **kwargs):
        """
        :keyword projected_name: Insight Link Definition Projected Name.
        :paramtype projected_name: str
        :keyword query: Insight Link Definition Query.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.projected_name = projected_name
        self.query = query


class InsightsTableResult(_serialization.Model):
    """Query results for table insights query.

    :ivar columns: Columns Metadata of the table.
    :vartype columns: list[~azure.mgmt.securityinsight.models.InsightsTableResultColumnsItem]
    :ivar rows: Rows data of the table.
    :vartype rows: list[list[str]]
    """

    _attribute_map = {
        "columns": {"key": "columns", "type": "[InsightsTableResultColumnsItem]"},
        "rows": {"key": "rows", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        columns: Optional[List["_models.InsightsTableResultColumnsItem"]] = None,
        rows: Optional[List[List[str]]] = None,
        **kwargs
    ):
        """
        :keyword columns: Columns Metadata of the table.
        :paramtype columns: list[~azure.mgmt.securityinsight.models.InsightsTableResultColumnsItem]
        :keyword rows: Rows data of the table.
        :paramtype rows: list[list[str]]
        """
        super().__init__(**kwargs)
        self.columns = columns
        self.rows = rows


class InsightsTableResultColumnsItem(_serialization.Model):
    """InsightsTableResultColumnsItem.

    :ivar type: the type of the colum.
    :vartype type: str
    :ivar name: the name of the colum.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, name: Optional[str] = None, **kwargs):
        """
        :keyword type: the type of the colum.
        :paramtype type: str
        :keyword name: the name of the colum.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class Instructions(_serialization.Model):
    """Instructions section of a recommendation.

    All required parameters must be populated in order to send to Azure.

    :ivar actions_to_be_performed: What actions should be taken to complete the recommendation.
     Required.
    :vartype actions_to_be_performed: str
    :ivar recommendation_importance: Explains why the recommendation is important. Required.
    :vartype recommendation_importance: str
    :ivar how_to_perform_action_details: How should the user complete the recommendation.
    :vartype how_to_perform_action_details: str
    """

    _validation = {
        "actions_to_be_performed": {"required": True},
        "recommendation_importance": {"required": True},
    }

    _attribute_map = {
        "actions_to_be_performed": {"key": "actionsToBePerformed", "type": "str"},
        "recommendation_importance": {"key": "recommendationImportance", "type": "str"},
        "how_to_perform_action_details": {"key": "howToPerformActionDetails", "type": "str"},
    }

    def __init__(
        self,
        *,
        actions_to_be_performed: str,
        recommendation_importance: str,
        how_to_perform_action_details: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword actions_to_be_performed: What actions should be taken to complete the recommendation.
         Required.
        :paramtype actions_to_be_performed: str
        :keyword recommendation_importance: Explains why the recommendation is important. Required.
        :paramtype recommendation_importance: str
        :keyword how_to_perform_action_details: How should the user complete the recommendation.
        :paramtype how_to_perform_action_details: str
        """
        super().__init__(**kwargs)
        self.actions_to_be_performed = actions_to_be_performed
        self.recommendation_importance = recommendation_importance
        self.how_to_perform_action_details = how_to_perform_action_details


class InstructionStepsInstructionsItem(ConnectorInstructionModelBase):
    """InstructionStepsInstructionsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar parameters: The parameters for the setting.
    :vartype parameters: JSON
    :ivar type: The kind of the setting. Required. Known values are: "CopyableLabel",
     "InstructionStepsGroup", and "InfoMessage".
    :vartype type: str or ~azure.mgmt.securityinsight.models.SettingType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "object"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.SettingType"], parameters: Optional[JSON] = None, **kwargs):
        """
        :keyword parameters: The parameters for the setting.
        :paramtype parameters: JSON
        :keyword type: The kind of the setting. Required. Known values are: "CopyableLabel",
         "InstructionStepsGroup", and "InfoMessage".
        :paramtype type: str or ~azure.mgmt.securityinsight.models.SettingType
        """
        super().__init__(parameters=parameters, type=type, **kwargs)


class IoTCheckRequirements(DataConnectorsCheckRequirements):
    """Represents IoT requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(self, *, subscription_id: Optional[str] = None, **kwargs):
        """
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "IOT"
        self.subscription_id = subscription_id


class IoTDataConnector(DataConnector):
    """Represents IoT data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "IOT"
        self.data_types = data_types
        self.subscription_id = subscription_id


class IoTDataConnectorProperties(DataConnectorWithAlertsProperties):
    """IoT data connector properties.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar subscription_id: The subscription id to connect to, and get the data from.
    :vartype subscription_id: str
    """

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword subscription_id: The subscription id to connect to, and get the data from.
        :paramtype subscription_id: str
        """
        super().__init__(data_types=data_types, **kwargs)
        self.subscription_id = subscription_id


class IoTDeviceEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents an IoT device entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar device_id: The ID of the IoT Device in the IoT Hub.
    :vartype device_id: str
    :ivar device_name: The friendly name of the device.
    :vartype device_name: str
    :ivar source: The source of the device.
    :vartype source: str
    :ivar iot_security_agent_id: The ID of the security agent running on the device.
    :vartype iot_security_agent_id: str
    :ivar device_type: The type of the device.
    :vartype device_type: str
    :ivar vendor: The vendor of the device.
    :vartype vendor: str
    :ivar edge_id: The ID of the edge device.
    :vartype edge_id: str
    :ivar mac_address: The MAC address of the device.
    :vartype mac_address: str
    :ivar model: The model of the device.
    :vartype model: str
    :ivar serial_number: The serial number of the device.
    :vartype serial_number: str
    :ivar firmware_version: The firmware version of the device.
    :vartype firmware_version: str
    :ivar operating_system: The operating system of the device.
    :vartype operating_system: str
    :ivar iot_hub_entity_id: The AzureResource entity id of the IoT Hub.
    :vartype iot_hub_entity_id: str
    :ivar host_entity_id: The Host entity id of this device.
    :vartype host_entity_id: str
    :ivar ip_address_entity_id: The IP entity if of this device.
    :vartype ip_address_entity_id: str
    :ivar threat_intelligence: A list of TI contexts attached to the IoTDevice entity.
    :vartype threat_intelligence: list[~azure.mgmt.securityinsight.models.ThreatIntelligence]
    :ivar protocols: A list of protocols of the IoTDevice entity.
    :vartype protocols: list[str]
    :ivar owners: A list of owners of the IoTDevice entity.
    :vartype owners: list[str]
    :ivar nic_entity_ids: A list of Nic entity ids of the IoTDevice entity.
    :vartype nic_entity_ids: list[str]
    :ivar site: The site of the device.
    :vartype site: str
    :ivar zone: The zone location of the device within a site.
    :vartype zone: str
    :ivar sensor: The sensor the device is monitored by.
    :vartype sensor: str
    :ivar device_sub_type: The subType of the device ('PLC', 'HMI', 'EWS', etc.).
    :vartype device_sub_type: str
    :ivar importance: Device importance, determines if the device classified as 'crown jewel'.
     Known values are: "Unknown", "Low", "Normal", and "High".
    :vartype importance: str or ~azure.mgmt.securityinsight.models.DeviceImportance
    :ivar purdue_layer: The Purdue Layer of the device.
    :vartype purdue_layer: str
    :ivar is_authorized: Determines whether the device classified as authorized device.
    :vartype is_authorized: bool
    :ivar is_programming: Determines whether the device classified as programming device.
    :vartype is_programming: bool
    :ivar is_scanner: Is the device classified as a scanner device.
    :vartype is_scanner: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "device_id": {"readonly": True},
        "device_name": {"readonly": True},
        "source": {"readonly": True},
        "iot_security_agent_id": {"readonly": True},
        "device_type": {"readonly": True},
        "vendor": {"readonly": True},
        "edge_id": {"readonly": True},
        "mac_address": {"readonly": True},
        "model": {"readonly": True},
        "serial_number": {"readonly": True},
        "firmware_version": {"readonly": True},
        "operating_system": {"readonly": True},
        "iot_hub_entity_id": {"readonly": True},
        "host_entity_id": {"readonly": True},
        "ip_address_entity_id": {"readonly": True},
        "threat_intelligence": {"readonly": True},
        "protocols": {"readonly": True},
        "owners": {"readonly": True},
        "nic_entity_ids": {"readonly": True},
        "site": {"readonly": True},
        "zone": {"readonly": True},
        "sensor": {"readonly": True},
        "device_sub_type": {"readonly": True},
        "purdue_layer": {"readonly": True},
        "is_authorized": {"readonly": True},
        "is_programming": {"readonly": True},
        "is_scanner": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "device_id": {"key": "properties.deviceId", "type": "str"},
        "device_name": {"key": "properties.deviceName", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "iot_security_agent_id": {"key": "properties.iotSecurityAgentId", "type": "str"},
        "device_type": {"key": "properties.deviceType", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "edge_id": {"key": "properties.edgeId", "type": "str"},
        "mac_address": {"key": "properties.macAddress", "type": "str"},
        "model": {"key": "properties.model", "type": "str"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "firmware_version": {"key": "properties.firmwareVersion", "type": "str"},
        "operating_system": {"key": "properties.operatingSystem", "type": "str"},
        "iot_hub_entity_id": {"key": "properties.iotHubEntityId", "type": "str"},
        "host_entity_id": {"key": "properties.hostEntityId", "type": "str"},
        "ip_address_entity_id": {"key": "properties.ipAddressEntityId", "type": "str"},
        "threat_intelligence": {"key": "properties.threatIntelligence", "type": "[ThreatIntelligence]"},
        "protocols": {"key": "properties.protocols", "type": "[str]"},
        "owners": {"key": "properties.owners", "type": "[str]"},
        "nic_entity_ids": {"key": "properties.nicEntityIds", "type": "[str]"},
        "site": {"key": "properties.site", "type": "str"},
        "zone": {"key": "properties.zone", "type": "str"},
        "sensor": {"key": "properties.sensor", "type": "str"},
        "device_sub_type": {"key": "properties.deviceSubType", "type": "str"},
        "importance": {"key": "properties.importance", "type": "str"},
        "purdue_layer": {"key": "properties.purdueLayer", "type": "str"},
        "is_authorized": {"key": "properties.isAuthorized", "type": "bool"},
        "is_programming": {"key": "properties.isProgramming", "type": "bool"},
        "is_scanner": {"key": "properties.isScanner", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self, *, importance: Optional[Union[str, "_models.DeviceImportance"]] = None, **kwargs
    ):
        """
        :keyword importance: Device importance, determines if the device classified as 'crown jewel'.
         Known values are: "Unknown", "Low", "Normal", and "High".
        :paramtype importance: str or ~azure.mgmt.securityinsight.models.DeviceImportance
        """
        super().__init__(**kwargs)
        self.kind: str = "IoTDevice"
        self.additional_data = None
        self.friendly_name = None
        self.device_id = None
        self.device_name = None
        self.source = None
        self.iot_security_agent_id = None
        self.device_type = None
        self.vendor = None
        self.edge_id = None
        self.mac_address = None
        self.model = None
        self.serial_number = None
        self.firmware_version = None
        self.operating_system = None
        self.iot_hub_entity_id = None
        self.host_entity_id = None
        self.ip_address_entity_id = None
        self.threat_intelligence = None
        self.protocols = None
        self.owners = None
        self.nic_entity_ids = None
        self.site = None
        self.zone = None
        self.sensor = None
        self.device_sub_type = None
        self.importance = importance
        self.purdue_layer = None
        self.is_authorized = None
        self.is_programming = None
        self.is_scanner = None


class IoTDeviceEntityProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """IoTDevice entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar device_id: The ID of the IoT Device in the IoT Hub.
    :vartype device_id: str
    :ivar device_name: The friendly name of the device.
    :vartype device_name: str
    :ivar source: The source of the device.
    :vartype source: str
    :ivar iot_security_agent_id: The ID of the security agent running on the device.
    :vartype iot_security_agent_id: str
    :ivar device_type: The type of the device.
    :vartype device_type: str
    :ivar vendor: The vendor of the device.
    :vartype vendor: str
    :ivar edge_id: The ID of the edge device.
    :vartype edge_id: str
    :ivar mac_address: The MAC address of the device.
    :vartype mac_address: str
    :ivar model: The model of the device.
    :vartype model: str
    :ivar serial_number: The serial number of the device.
    :vartype serial_number: str
    :ivar firmware_version: The firmware version of the device.
    :vartype firmware_version: str
    :ivar operating_system: The operating system of the device.
    :vartype operating_system: str
    :ivar iot_hub_entity_id: The AzureResource entity id of the IoT Hub.
    :vartype iot_hub_entity_id: str
    :ivar host_entity_id: The Host entity id of this device.
    :vartype host_entity_id: str
    :ivar ip_address_entity_id: The IP entity if of this device.
    :vartype ip_address_entity_id: str
    :ivar threat_intelligence: A list of TI contexts attached to the IoTDevice entity.
    :vartype threat_intelligence: list[~azure.mgmt.securityinsight.models.ThreatIntelligence]
    :ivar protocols: A list of protocols of the IoTDevice entity.
    :vartype protocols: list[str]
    :ivar owners: A list of owners of the IoTDevice entity.
    :vartype owners: list[str]
    :ivar nic_entity_ids: A list of Nic entity ids of the IoTDevice entity.
    :vartype nic_entity_ids: list[str]
    :ivar site: The site of the device.
    :vartype site: str
    :ivar zone: The zone location of the device within a site.
    :vartype zone: str
    :ivar sensor: The sensor the device is monitored by.
    :vartype sensor: str
    :ivar device_sub_type: The subType of the device ('PLC', 'HMI', 'EWS', etc.).
    :vartype device_sub_type: str
    :ivar importance: Device importance, determines if the device classified as 'crown jewel'.
     Known values are: "Unknown", "Low", "Normal", and "High".
    :vartype importance: str or ~azure.mgmt.securityinsight.models.DeviceImportance
    :ivar purdue_layer: The Purdue Layer of the device.
    :vartype purdue_layer: str
    :ivar is_authorized: Determines whether the device classified as authorized device.
    :vartype is_authorized: bool
    :ivar is_programming: Determines whether the device classified as programming device.
    :vartype is_programming: bool
    :ivar is_scanner: Is the device classified as a scanner device.
    :vartype is_scanner: bool
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "device_id": {"readonly": True},
        "device_name": {"readonly": True},
        "source": {"readonly": True},
        "iot_security_agent_id": {"readonly": True},
        "device_type": {"readonly": True},
        "vendor": {"readonly": True},
        "edge_id": {"readonly": True},
        "mac_address": {"readonly": True},
        "model": {"readonly": True},
        "serial_number": {"readonly": True},
        "firmware_version": {"readonly": True},
        "operating_system": {"readonly": True},
        "iot_hub_entity_id": {"readonly": True},
        "host_entity_id": {"readonly": True},
        "ip_address_entity_id": {"readonly": True},
        "threat_intelligence": {"readonly": True},
        "protocols": {"readonly": True},
        "owners": {"readonly": True},
        "nic_entity_ids": {"readonly": True},
        "site": {"readonly": True},
        "zone": {"readonly": True},
        "sensor": {"readonly": True},
        "device_sub_type": {"readonly": True},
        "purdue_layer": {"readonly": True},
        "is_authorized": {"readonly": True},
        "is_programming": {"readonly": True},
        "is_scanner": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "device_id": {"key": "deviceId", "type": "str"},
        "device_name": {"key": "deviceName", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "iot_security_agent_id": {"key": "iotSecurityAgentId", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "vendor": {"key": "vendor", "type": "str"},
        "edge_id": {"key": "edgeId", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "firmware_version": {"key": "firmwareVersion", "type": "str"},
        "operating_system": {"key": "operatingSystem", "type": "str"},
        "iot_hub_entity_id": {"key": "iotHubEntityId", "type": "str"},
        "host_entity_id": {"key": "hostEntityId", "type": "str"},
        "ip_address_entity_id": {"key": "ipAddressEntityId", "type": "str"},
        "threat_intelligence": {"key": "threatIntelligence", "type": "[ThreatIntelligence]"},
        "protocols": {"key": "protocols", "type": "[str]"},
        "owners": {"key": "owners", "type": "[str]"},
        "nic_entity_ids": {"key": "nicEntityIds", "type": "[str]"},
        "site": {"key": "site", "type": "str"},
        "zone": {"key": "zone", "type": "str"},
        "sensor": {"key": "sensor", "type": "str"},
        "device_sub_type": {"key": "deviceSubType", "type": "str"},
        "importance": {"key": "importance", "type": "str"},
        "purdue_layer": {"key": "purdueLayer", "type": "str"},
        "is_authorized": {"key": "isAuthorized", "type": "bool"},
        "is_programming": {"key": "isProgramming", "type": "bool"},
        "is_scanner": {"key": "isScanner", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self, *, importance: Optional[Union[str, "_models.DeviceImportance"]] = None, **kwargs
    ):
        """
        :keyword importance: Device importance, determines if the device classified as 'crown jewel'.
         Known values are: "Unknown", "Low", "Normal", and "High".
        :paramtype importance: str or ~azure.mgmt.securityinsight.models.DeviceImportance
        """
        super().__init__(**kwargs)
        self.device_id = None
        self.device_name = None
        self.source = None
        self.iot_security_agent_id = None
        self.device_type = None
        self.vendor = None
        self.edge_id = None
        self.mac_address = None
        self.model = None
        self.serial_number = None
        self.firmware_version = None
        self.operating_system = None
        self.iot_hub_entity_id = None
        self.host_entity_id = None
        self.ip_address_entity_id = None
        self.threat_intelligence = None
        self.protocols = None
        self.owners = None
        self.nic_entity_ids = None
        self.site = None
        self.zone = None
        self.sensor = None
        self.device_sub_type = None
        self.importance = importance
        self.purdue_layer = None
        self.is_authorized = None
        self.is_programming = None
        self.is_scanner = None


class IpEntity(Entity):
    """Represents an ip entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar address: The IP address as string, e.g. 127.0.0.1 (either in Ipv4 or Ipv6).
    :vartype address: str
    :ivar location: The geo-location context attached to the ip entity.
    :vartype location: ~azure.mgmt.securityinsight.models.GeoLocation
    :ivar threat_intelligence: A list of TI contexts attached to the ip entity.
    :vartype threat_intelligence: list[~azure.mgmt.securityinsight.models.ThreatIntelligence]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "address": {"readonly": True},
        "location": {"readonly": True},
        "threat_intelligence": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "address": {"key": "properties.address", "type": "str"},
        "location": {"key": "properties.location", "type": "GeoLocation"},
        "threat_intelligence": {"key": "properties.threatIntelligence", "type": "[ThreatIntelligence]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "Ip"
        self.additional_data = None
        self.friendly_name = None
        self.address = None
        self.location = None
        self.threat_intelligence = None


class IpEntityProperties(EntityCommonProperties):
    """Ip entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar address: The IP address as string, e.g. 127.0.0.1 (either in Ipv4 or Ipv6).
    :vartype address: str
    :ivar location: The geo-location context attached to the ip entity.
    :vartype location: ~azure.mgmt.securityinsight.models.GeoLocation
    :ivar threat_intelligence: A list of TI contexts attached to the ip entity.
    :vartype threat_intelligence: list[~azure.mgmt.securityinsight.models.ThreatIntelligence]
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "address": {"readonly": True},
        "location": {"readonly": True},
        "threat_intelligence": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "location": {"key": "location", "type": "GeoLocation"},
        "threat_intelligence": {"key": "threatIntelligence", "type": "[ThreatIntelligence]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.address = None
        self.location = None
        self.threat_intelligence = None


class MailboxEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a mailbox entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar mailbox_primary_address: The mailbox's primary address.
    :vartype mailbox_primary_address: str
    :ivar display_name: The mailbox's display name.
    :vartype display_name: str
    :ivar upn: The mailbox's UPN.
    :vartype upn: str
    :ivar external_directory_object_id: The AzureAD identifier of mailbox. Similar to AadUserId in
     account entity but this property is specific to mailbox object on office side.
    :vartype external_directory_object_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "mailbox_primary_address": {"readonly": True},
        "display_name": {"readonly": True},
        "upn": {"readonly": True},
        "external_directory_object_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "mailbox_primary_address": {"key": "properties.mailboxPrimaryAddress", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "upn": {"key": "properties.upn", "type": "str"},
        "external_directory_object_id": {"key": "properties.externalDirectoryObjectId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "Mailbox"
        self.additional_data = None
        self.friendly_name = None
        self.mailbox_primary_address = None
        self.display_name = None
        self.upn = None
        self.external_directory_object_id = None


class MailboxEntityProperties(EntityCommonProperties):
    """Mailbox entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar mailbox_primary_address: The mailbox's primary address.
    :vartype mailbox_primary_address: str
    :ivar display_name: The mailbox's display name.
    :vartype display_name: str
    :ivar upn: The mailbox's UPN.
    :vartype upn: str
    :ivar external_directory_object_id: The AzureAD identifier of mailbox. Similar to AadUserId in
     account entity but this property is specific to mailbox object on office side.
    :vartype external_directory_object_id: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "mailbox_primary_address": {"readonly": True},
        "display_name": {"readonly": True},
        "upn": {"readonly": True},
        "external_directory_object_id": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "mailbox_primary_address": {"key": "mailboxPrimaryAddress", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "external_directory_object_id": {"key": "externalDirectoryObjectId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.mailbox_primary_address = None
        self.display_name = None
        self.upn = None
        self.external_directory_object_id = None


class MailClusterEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a mail cluster entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar network_message_ids: The mail message IDs that are part of the mail cluster.
    :vartype network_message_ids: list[str]
    :ivar count_by_delivery_status: Count of mail messages by DeliveryStatus string representation.
    :vartype count_by_delivery_status: JSON
    :ivar count_by_threat_type: Count of mail messages by ThreatType string representation.
    :vartype count_by_threat_type: JSON
    :ivar count_by_protection_status: Count of mail messages by ProtectionStatus string
     representation.
    :vartype count_by_protection_status: JSON
    :ivar threats: The threats of mail messages that are part of the mail cluster.
    :vartype threats: list[str]
    :ivar query: The query that was used to identify the messages of the mail cluster.
    :vartype query: str
    :ivar query_time: The query time.
    :vartype query_time: ~datetime.datetime
    :ivar mail_count: The number of mail messages that are part of the mail cluster.
    :vartype mail_count: int
    :ivar is_volume_anomaly: Is this a volume anomaly mail cluster.
    :vartype is_volume_anomaly: bool
    :ivar source: The source of the mail cluster (default is 'O365 ATP').
    :vartype source: str
    :ivar cluster_source_identifier: The id of the cluster source.
    :vartype cluster_source_identifier: str
    :ivar cluster_source_type: The type of the cluster source.
    :vartype cluster_source_type: str
    :ivar cluster_query_start_time: The cluster query start time.
    :vartype cluster_query_start_time: ~datetime.datetime
    :ivar cluster_query_end_time: The cluster query end time.
    :vartype cluster_query_end_time: ~datetime.datetime
    :ivar cluster_group: The cluster group.
    :vartype cluster_group: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "network_message_ids": {"readonly": True},
        "count_by_delivery_status": {"readonly": True},
        "count_by_threat_type": {"readonly": True},
        "count_by_protection_status": {"readonly": True},
        "threats": {"readonly": True},
        "query": {"readonly": True},
        "query_time": {"readonly": True},
        "mail_count": {"readonly": True},
        "is_volume_anomaly": {"readonly": True},
        "source": {"readonly": True},
        "cluster_source_identifier": {"readonly": True},
        "cluster_source_type": {"readonly": True},
        "cluster_query_start_time": {"readonly": True},
        "cluster_query_end_time": {"readonly": True},
        "cluster_group": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "network_message_ids": {"key": "properties.networkMessageIds", "type": "[str]"},
        "count_by_delivery_status": {"key": "properties.countByDeliveryStatus", "type": "object"},
        "count_by_threat_type": {"key": "properties.countByThreatType", "type": "object"},
        "count_by_protection_status": {"key": "properties.countByProtectionStatus", "type": "object"},
        "threats": {"key": "properties.threats", "type": "[str]"},
        "query": {"key": "properties.query", "type": "str"},
        "query_time": {"key": "properties.queryTime", "type": "iso-8601"},
        "mail_count": {"key": "properties.mailCount", "type": "int"},
        "is_volume_anomaly": {"key": "properties.isVolumeAnomaly", "type": "bool"},
        "source": {"key": "properties.source", "type": "str"},
        "cluster_source_identifier": {"key": "properties.clusterSourceIdentifier", "type": "str"},
        "cluster_source_type": {"key": "properties.clusterSourceType", "type": "str"},
        "cluster_query_start_time": {"key": "properties.clusterQueryStartTime", "type": "iso-8601"},
        "cluster_query_end_time": {"key": "properties.clusterQueryEndTime", "type": "iso-8601"},
        "cluster_group": {"key": "properties.clusterGroup", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "MailCluster"
        self.additional_data = None
        self.friendly_name = None
        self.network_message_ids = None
        self.count_by_delivery_status = None
        self.count_by_threat_type = None
        self.count_by_protection_status = None
        self.threats = None
        self.query = None
        self.query_time = None
        self.mail_count = None
        self.is_volume_anomaly = None
        self.source = None
        self.cluster_source_identifier = None
        self.cluster_source_type = None
        self.cluster_query_start_time = None
        self.cluster_query_end_time = None
        self.cluster_group = None


class MailClusterEntityProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Mail cluster entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar network_message_ids: The mail message IDs that are part of the mail cluster.
    :vartype network_message_ids: list[str]
    :ivar count_by_delivery_status: Count of mail messages by DeliveryStatus string representation.
    :vartype count_by_delivery_status: JSON
    :ivar count_by_threat_type: Count of mail messages by ThreatType string representation.
    :vartype count_by_threat_type: JSON
    :ivar count_by_protection_status: Count of mail messages by ProtectionStatus string
     representation.
    :vartype count_by_protection_status: JSON
    :ivar threats: The threats of mail messages that are part of the mail cluster.
    :vartype threats: list[str]
    :ivar query: The query that was used to identify the messages of the mail cluster.
    :vartype query: str
    :ivar query_time: The query time.
    :vartype query_time: ~datetime.datetime
    :ivar mail_count: The number of mail messages that are part of the mail cluster.
    :vartype mail_count: int
    :ivar is_volume_anomaly: Is this a volume anomaly mail cluster.
    :vartype is_volume_anomaly: bool
    :ivar source: The source of the mail cluster (default is 'O365 ATP').
    :vartype source: str
    :ivar cluster_source_identifier: The id of the cluster source.
    :vartype cluster_source_identifier: str
    :ivar cluster_source_type: The type of the cluster source.
    :vartype cluster_source_type: str
    :ivar cluster_query_start_time: The cluster query start time.
    :vartype cluster_query_start_time: ~datetime.datetime
    :ivar cluster_query_end_time: The cluster query end time.
    :vartype cluster_query_end_time: ~datetime.datetime
    :ivar cluster_group: The cluster group.
    :vartype cluster_group: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "network_message_ids": {"readonly": True},
        "count_by_delivery_status": {"readonly": True},
        "count_by_threat_type": {"readonly": True},
        "count_by_protection_status": {"readonly": True},
        "threats": {"readonly": True},
        "query": {"readonly": True},
        "query_time": {"readonly": True},
        "mail_count": {"readonly": True},
        "is_volume_anomaly": {"readonly": True},
        "source": {"readonly": True},
        "cluster_source_identifier": {"readonly": True},
        "cluster_source_type": {"readonly": True},
        "cluster_query_start_time": {"readonly": True},
        "cluster_query_end_time": {"readonly": True},
        "cluster_group": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "network_message_ids": {"key": "networkMessageIds", "type": "[str]"},
        "count_by_delivery_status": {"key": "countByDeliveryStatus", "type": "object"},
        "count_by_threat_type": {"key": "countByThreatType", "type": "object"},
        "count_by_protection_status": {"key": "countByProtectionStatus", "type": "object"},
        "threats": {"key": "threats", "type": "[str]"},
        "query": {"key": "query", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "mail_count": {"key": "mailCount", "type": "int"},
        "is_volume_anomaly": {"key": "isVolumeAnomaly", "type": "bool"},
        "source": {"key": "source", "type": "str"},
        "cluster_source_identifier": {"key": "clusterSourceIdentifier", "type": "str"},
        "cluster_source_type": {"key": "clusterSourceType", "type": "str"},
        "cluster_query_start_time": {"key": "clusterQueryStartTime", "type": "iso-8601"},
        "cluster_query_end_time": {"key": "clusterQueryEndTime", "type": "iso-8601"},
        "cluster_group": {"key": "clusterGroup", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.network_message_ids = None
        self.count_by_delivery_status = None
        self.count_by_threat_type = None
        self.count_by_protection_status = None
        self.threats = None
        self.query = None
        self.query_time = None
        self.mail_count = None
        self.is_volume_anomaly = None
        self.source = None
        self.cluster_source_identifier = None
        self.cluster_source_type = None
        self.cluster_query_start_time = None
        self.cluster_query_end_time = None
        self.cluster_group = None


class MailMessageEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a mail message entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar file_entity_ids: The File entity ids of this mail message's attachments.
    :vartype file_entity_ids: list[str]
    :ivar recipient: The recipient of this mail message. Note that in case of multiple recipients
     the mail message is forked and each copy has one recipient.
    :vartype recipient: str
    :ivar urls: The Urls contained in this mail message.
    :vartype urls: list[str]
    :ivar threats: The threats of this mail message.
    :vartype threats: list[str]
    :ivar p1_sender: The p1 sender's email address.
    :vartype p1_sender: str
    :ivar p1_sender_display_name: The p1 sender's display name.
    :vartype p1_sender_display_name: str
    :ivar p1_sender_domain: The p1 sender's domain.
    :vartype p1_sender_domain: str
    :ivar sender_ip: The sender's IP address.
    :vartype sender_ip: str
    :ivar p2_sender: The p2 sender's email address.
    :vartype p2_sender: str
    :ivar p2_sender_display_name: The p2 sender's display name.
    :vartype p2_sender_display_name: str
    :ivar p2_sender_domain: The p2 sender's domain.
    :vartype p2_sender_domain: str
    :ivar receive_date: The receive date of this message.
    :vartype receive_date: ~datetime.datetime
    :ivar network_message_id: The network message id of this mail message.
    :vartype network_message_id: str
    :ivar internet_message_id: The internet message id of this mail message.
    :vartype internet_message_id: str
    :ivar subject: The subject of this mail message.
    :vartype subject: str
    :ivar language: The language of this mail message.
    :vartype language: str
    :ivar threat_detection_methods: The threat detection methods.
    :vartype threat_detection_methods: list[str]
    :ivar body_fingerprint_bin1: The bodyFingerprintBin1.
    :vartype body_fingerprint_bin1: int
    :ivar body_fingerprint_bin2: The bodyFingerprintBin2.
    :vartype body_fingerprint_bin2: int
    :ivar body_fingerprint_bin3: The bodyFingerprintBin3.
    :vartype body_fingerprint_bin3: int
    :ivar body_fingerprint_bin4: The bodyFingerprintBin4.
    :vartype body_fingerprint_bin4: int
    :ivar body_fingerprint_bin5: The bodyFingerprintBin5.
    :vartype body_fingerprint_bin5: int
    :ivar antispam_direction: The directionality of this mail message. Known values are: "Unknown",
     "Inbound", "Outbound", and "Intraorg".
    :vartype antispam_direction: str or ~azure.mgmt.securityinsight.models.AntispamMailDirection
    :ivar delivery_action: The delivery action of this mail message like Delivered, Blocked,
     Replaced etc. Known values are: "Unknown", "DeliveredAsSpam", "Delivered", "Blocked", and
     "Replaced".
    :vartype delivery_action: str or ~azure.mgmt.securityinsight.models.DeliveryAction
    :ivar delivery_location: The delivery location of this mail message like Inbox, JunkFolder etc.
     Known values are: "Unknown", "Inbox", "JunkFolder", "DeletedFolder", "Quarantine", "External",
     "Failed", "Dropped", and "Forwarded".
    :vartype delivery_location: str or ~azure.mgmt.securityinsight.models.DeliveryLocation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "file_entity_ids": {"readonly": True},
        "recipient": {"readonly": True},
        "urls": {"readonly": True},
        "threats": {"readonly": True},
        "p1_sender": {"readonly": True},
        "p1_sender_display_name": {"readonly": True},
        "p1_sender_domain": {"readonly": True},
        "sender_ip": {"readonly": True},
        "p2_sender": {"readonly": True},
        "p2_sender_display_name": {"readonly": True},
        "p2_sender_domain": {"readonly": True},
        "receive_date": {"readonly": True},
        "network_message_id": {"readonly": True},
        "internet_message_id": {"readonly": True},
        "subject": {"readonly": True},
        "language": {"readonly": True},
        "threat_detection_methods": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "file_entity_ids": {"key": "properties.fileEntityIds", "type": "[str]"},
        "recipient": {"key": "properties.recipient", "type": "str"},
        "urls": {"key": "properties.urls", "type": "[str]"},
        "threats": {"key": "properties.threats", "type": "[str]"},
        "p1_sender": {"key": "properties.p1Sender", "type": "str"},
        "p1_sender_display_name": {"key": "properties.p1SenderDisplayName", "type": "str"},
        "p1_sender_domain": {"key": "properties.p1SenderDomain", "type": "str"},
        "sender_ip": {"key": "properties.senderIP", "type": "str"},
        "p2_sender": {"key": "properties.p2Sender", "type": "str"},
        "p2_sender_display_name": {"key": "properties.p2SenderDisplayName", "type": "str"},
        "p2_sender_domain": {"key": "properties.p2SenderDomain", "type": "str"},
        "receive_date": {"key": "properties.receiveDate", "type": "iso-8601"},
        "network_message_id": {"key": "properties.networkMessageId", "type": "str"},
        "internet_message_id": {"key": "properties.internetMessageId", "type": "str"},
        "subject": {"key": "properties.subject", "type": "str"},
        "language": {"key": "properties.language", "type": "str"},
        "threat_detection_methods": {"key": "properties.threatDetectionMethods", "type": "[str]"},
        "body_fingerprint_bin1": {"key": "properties.bodyFingerprintBin1", "type": "int"},
        "body_fingerprint_bin2": {"key": "properties.bodyFingerprintBin2", "type": "int"},
        "body_fingerprint_bin3": {"key": "properties.bodyFingerprintBin3", "type": "int"},
        "body_fingerprint_bin4": {"key": "properties.bodyFingerprintBin4", "type": "int"},
        "body_fingerprint_bin5": {"key": "properties.bodyFingerprintBin5", "type": "int"},
        "antispam_direction": {"key": "properties.antispamDirection", "type": "str"},
        "delivery_action": {"key": "properties.deliveryAction", "type": "str"},
        "delivery_location": {"key": "properties.deliveryLocation", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        body_fingerprint_bin1: Optional[int] = None,
        body_fingerprint_bin2: Optional[int] = None,
        body_fingerprint_bin3: Optional[int] = None,
        body_fingerprint_bin4: Optional[int] = None,
        body_fingerprint_bin5: Optional[int] = None,
        antispam_direction: Optional[Union[str, "_models.AntispamMailDirection"]] = None,
        delivery_action: Optional[Union[str, "_models.DeliveryAction"]] = None,
        delivery_location: Optional[Union[str, "_models.DeliveryLocation"]] = None,
        **kwargs
    ):
        """
        :keyword body_fingerprint_bin1: The bodyFingerprintBin1.
        :paramtype body_fingerprint_bin1: int
        :keyword body_fingerprint_bin2: The bodyFingerprintBin2.
        :paramtype body_fingerprint_bin2: int
        :keyword body_fingerprint_bin3: The bodyFingerprintBin3.
        :paramtype body_fingerprint_bin3: int
        :keyword body_fingerprint_bin4: The bodyFingerprintBin4.
        :paramtype body_fingerprint_bin4: int
        :keyword body_fingerprint_bin5: The bodyFingerprintBin5.
        :paramtype body_fingerprint_bin5: int
        :keyword antispam_direction: The directionality of this mail message. Known values are:
         "Unknown", "Inbound", "Outbound", and "Intraorg".
        :paramtype antispam_direction: str or ~azure.mgmt.securityinsight.models.AntispamMailDirection
        :keyword delivery_action: The delivery action of this mail message like Delivered, Blocked,
         Replaced etc. Known values are: "Unknown", "DeliveredAsSpam", "Delivered", "Blocked", and
         "Replaced".
        :paramtype delivery_action: str or ~azure.mgmt.securityinsight.models.DeliveryAction
        :keyword delivery_location: The delivery location of this mail message like Inbox, JunkFolder
         etc. Known values are: "Unknown", "Inbox", "JunkFolder", "DeletedFolder", "Quarantine",
         "External", "Failed", "Dropped", and "Forwarded".
        :paramtype delivery_location: str or ~azure.mgmt.securityinsight.models.DeliveryLocation
        """
        super().__init__(**kwargs)
        self.kind: str = "MailMessage"
        self.additional_data = None
        self.friendly_name = None
        self.file_entity_ids = None
        self.recipient = None
        self.urls = None
        self.threats = None
        self.p1_sender = None
        self.p1_sender_display_name = None
        self.p1_sender_domain = None
        self.sender_ip = None
        self.p2_sender = None
        self.p2_sender_display_name = None
        self.p2_sender_domain = None
        self.receive_date = None
        self.network_message_id = None
        self.internet_message_id = None
        self.subject = None
        self.language = None
        self.threat_detection_methods = None
        self.body_fingerprint_bin1 = body_fingerprint_bin1
        self.body_fingerprint_bin2 = body_fingerprint_bin2
        self.body_fingerprint_bin3 = body_fingerprint_bin3
        self.body_fingerprint_bin4 = body_fingerprint_bin4
        self.body_fingerprint_bin5 = body_fingerprint_bin5
        self.antispam_direction = antispam_direction
        self.delivery_action = delivery_action
        self.delivery_location = delivery_location


class MailMessageEntityProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Mail message entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar file_entity_ids: The File entity ids of this mail message's attachments.
    :vartype file_entity_ids: list[str]
    :ivar recipient: The recipient of this mail message. Note that in case of multiple recipients
     the mail message is forked and each copy has one recipient.
    :vartype recipient: str
    :ivar urls: The Urls contained in this mail message.
    :vartype urls: list[str]
    :ivar threats: The threats of this mail message.
    :vartype threats: list[str]
    :ivar p1_sender: The p1 sender's email address.
    :vartype p1_sender: str
    :ivar p1_sender_display_name: The p1 sender's display name.
    :vartype p1_sender_display_name: str
    :ivar p1_sender_domain: The p1 sender's domain.
    :vartype p1_sender_domain: str
    :ivar sender_ip: The sender's IP address.
    :vartype sender_ip: str
    :ivar p2_sender: The p2 sender's email address.
    :vartype p2_sender: str
    :ivar p2_sender_display_name: The p2 sender's display name.
    :vartype p2_sender_display_name: str
    :ivar p2_sender_domain: The p2 sender's domain.
    :vartype p2_sender_domain: str
    :ivar receive_date: The receive date of this message.
    :vartype receive_date: ~datetime.datetime
    :ivar network_message_id: The network message id of this mail message.
    :vartype network_message_id: str
    :ivar internet_message_id: The internet message id of this mail message.
    :vartype internet_message_id: str
    :ivar subject: The subject of this mail message.
    :vartype subject: str
    :ivar language: The language of this mail message.
    :vartype language: str
    :ivar threat_detection_methods: The threat detection methods.
    :vartype threat_detection_methods: list[str]
    :ivar body_fingerprint_bin1: The bodyFingerprintBin1.
    :vartype body_fingerprint_bin1: int
    :ivar body_fingerprint_bin2: The bodyFingerprintBin2.
    :vartype body_fingerprint_bin2: int
    :ivar body_fingerprint_bin3: The bodyFingerprintBin3.
    :vartype body_fingerprint_bin3: int
    :ivar body_fingerprint_bin4: The bodyFingerprintBin4.
    :vartype body_fingerprint_bin4: int
    :ivar body_fingerprint_bin5: The bodyFingerprintBin5.
    :vartype body_fingerprint_bin5: int
    :ivar antispam_direction: The directionality of this mail message. Known values are: "Unknown",
     "Inbound", "Outbound", and "Intraorg".
    :vartype antispam_direction: str or ~azure.mgmt.securityinsight.models.AntispamMailDirection
    :ivar delivery_action: The delivery action of this mail message like Delivered, Blocked,
     Replaced etc. Known values are: "Unknown", "DeliveredAsSpam", "Delivered", "Blocked", and
     "Replaced".
    :vartype delivery_action: str or ~azure.mgmt.securityinsight.models.DeliveryAction
    :ivar delivery_location: The delivery location of this mail message like Inbox, JunkFolder etc.
     Known values are: "Unknown", "Inbox", "JunkFolder", "DeletedFolder", "Quarantine", "External",
     "Failed", "Dropped", and "Forwarded".
    :vartype delivery_location: str or ~azure.mgmt.securityinsight.models.DeliveryLocation
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "file_entity_ids": {"readonly": True},
        "recipient": {"readonly": True},
        "urls": {"readonly": True},
        "threats": {"readonly": True},
        "p1_sender": {"readonly": True},
        "p1_sender_display_name": {"readonly": True},
        "p1_sender_domain": {"readonly": True},
        "sender_ip": {"readonly": True},
        "p2_sender": {"readonly": True},
        "p2_sender_display_name": {"readonly": True},
        "p2_sender_domain": {"readonly": True},
        "receive_date": {"readonly": True},
        "network_message_id": {"readonly": True},
        "internet_message_id": {"readonly": True},
        "subject": {"readonly": True},
        "language": {"readonly": True},
        "threat_detection_methods": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "file_entity_ids": {"key": "fileEntityIds", "type": "[str]"},
        "recipient": {"key": "recipient", "type": "str"},
        "urls": {"key": "urls", "type": "[str]"},
        "threats": {"key": "threats", "type": "[str]"},
        "p1_sender": {"key": "p1Sender", "type": "str"},
        "p1_sender_display_name": {"key": "p1SenderDisplayName", "type": "str"},
        "p1_sender_domain": {"key": "p1SenderDomain", "type": "str"},
        "sender_ip": {"key": "senderIP", "type": "str"},
        "p2_sender": {"key": "p2Sender", "type": "str"},
        "p2_sender_display_name": {"key": "p2SenderDisplayName", "type": "str"},
        "p2_sender_domain": {"key": "p2SenderDomain", "type": "str"},
        "receive_date": {"key": "receiveDate", "type": "iso-8601"},
        "network_message_id": {"key": "networkMessageId", "type": "str"},
        "internet_message_id": {"key": "internetMessageId", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "language": {"key": "language", "type": "str"},
        "threat_detection_methods": {"key": "threatDetectionMethods", "type": "[str]"},
        "body_fingerprint_bin1": {"key": "bodyFingerprintBin1", "type": "int"},
        "body_fingerprint_bin2": {"key": "bodyFingerprintBin2", "type": "int"},
        "body_fingerprint_bin3": {"key": "bodyFingerprintBin3", "type": "int"},
        "body_fingerprint_bin4": {"key": "bodyFingerprintBin4", "type": "int"},
        "body_fingerprint_bin5": {"key": "bodyFingerprintBin5", "type": "int"},
        "antispam_direction": {"key": "antispamDirection", "type": "str"},
        "delivery_action": {"key": "deliveryAction", "type": "str"},
        "delivery_location": {"key": "deliveryLocation", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        body_fingerprint_bin1: Optional[int] = None,
        body_fingerprint_bin2: Optional[int] = None,
        body_fingerprint_bin3: Optional[int] = None,
        body_fingerprint_bin4: Optional[int] = None,
        body_fingerprint_bin5: Optional[int] = None,
        antispam_direction: Optional[Union[str, "_models.AntispamMailDirection"]] = None,
        delivery_action: Optional[Union[str, "_models.DeliveryAction"]] = None,
        delivery_location: Optional[Union[str, "_models.DeliveryLocation"]] = None,
        **kwargs
    ):
        """
        :keyword body_fingerprint_bin1: The bodyFingerprintBin1.
        :paramtype body_fingerprint_bin1: int
        :keyword body_fingerprint_bin2: The bodyFingerprintBin2.
        :paramtype body_fingerprint_bin2: int
        :keyword body_fingerprint_bin3: The bodyFingerprintBin3.
        :paramtype body_fingerprint_bin3: int
        :keyword body_fingerprint_bin4: The bodyFingerprintBin4.
        :paramtype body_fingerprint_bin4: int
        :keyword body_fingerprint_bin5: The bodyFingerprintBin5.
        :paramtype body_fingerprint_bin5: int
        :keyword antispam_direction: The directionality of this mail message. Known values are:
         "Unknown", "Inbound", "Outbound", and "Intraorg".
        :paramtype antispam_direction: str or ~azure.mgmt.securityinsight.models.AntispamMailDirection
        :keyword delivery_action: The delivery action of this mail message like Delivered, Blocked,
         Replaced etc. Known values are: "Unknown", "DeliveredAsSpam", "Delivered", "Blocked", and
         "Replaced".
        :paramtype delivery_action: str or ~azure.mgmt.securityinsight.models.DeliveryAction
        :keyword delivery_location: The delivery location of this mail message like Inbox, JunkFolder
         etc. Known values are: "Unknown", "Inbox", "JunkFolder", "DeletedFolder", "Quarantine",
         "External", "Failed", "Dropped", and "Forwarded".
        :paramtype delivery_location: str or ~azure.mgmt.securityinsight.models.DeliveryLocation
        """
        super().__init__(**kwargs)
        self.file_entity_ids = None
        self.recipient = None
        self.urls = None
        self.threats = None
        self.p1_sender = None
        self.p1_sender_display_name = None
        self.p1_sender_domain = None
        self.sender_ip = None
        self.p2_sender = None
        self.p2_sender_display_name = None
        self.p2_sender_domain = None
        self.receive_date = None
        self.network_message_id = None
        self.internet_message_id = None
        self.subject = None
        self.language = None
        self.threat_detection_methods = None
        self.body_fingerprint_bin1 = body_fingerprint_bin1
        self.body_fingerprint_bin2 = body_fingerprint_bin2
        self.body_fingerprint_bin3 = body_fingerprint_bin3
        self.body_fingerprint_bin4 = body_fingerprint_bin4
        self.body_fingerprint_bin5 = body_fingerprint_bin5
        self.antispam_direction = antispam_direction
        self.delivery_action = delivery_action
        self.delivery_location = delivery_location


class MalwareEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a malware entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar category: The malware category by the vendor, e.g. Trojan.
    :vartype category: str
    :ivar file_entity_ids: List of linked file entity identifiers on which the malware was found.
    :vartype file_entity_ids: list[str]
    :ivar malware_name: The malware name by the vendor, e.g. Win32/Toga!rfn.
    :vartype malware_name: str
    :ivar process_entity_ids: List of linked process entity identifiers on which the malware was
     found.
    :vartype process_entity_ids: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "category": {"readonly": True},
        "file_entity_ids": {"readonly": True},
        "malware_name": {"readonly": True},
        "process_entity_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "file_entity_ids": {"key": "properties.fileEntityIds", "type": "[str]"},
        "malware_name": {"key": "properties.malwareName", "type": "str"},
        "process_entity_ids": {"key": "properties.processEntityIds", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "Malware"
        self.additional_data = None
        self.friendly_name = None
        self.category = None
        self.file_entity_ids = None
        self.malware_name = None
        self.process_entity_ids = None


class MalwareEntityProperties(EntityCommonProperties):
    """Malware entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar category: The malware category by the vendor, e.g. Trojan.
    :vartype category: str
    :ivar file_entity_ids: List of linked file entity identifiers on which the malware was found.
    :vartype file_entity_ids: list[str]
    :ivar malware_name: The malware name by the vendor, e.g. Win32/Toga!rfn.
    :vartype malware_name: str
    :ivar process_entity_ids: List of linked process entity identifiers on which the malware was
     found.
    :vartype process_entity_ids: list[str]
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "category": {"readonly": True},
        "file_entity_ids": {"readonly": True},
        "malware_name": {"readonly": True},
        "process_entity_ids": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "file_entity_ids": {"key": "fileEntityIds", "type": "[str]"},
        "malware_name": {"key": "malwareName", "type": "str"},
        "process_entity_ids": {"key": "processEntityIds", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.category = None
        self.file_entity_ids = None
        self.malware_name = None
        self.process_entity_ids = None


class ManualTriggerRequestBody(_serialization.Model):
    """ManualTriggerRequestBody.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar logic_apps_resource_id: Required.
    :vartype logic_apps_resource_id: str
    """

    _validation = {
        "logic_apps_resource_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "logic_apps_resource_id": {"key": "logicAppsResourceId", "type": "str"},
    }

    def __init__(self, *, logic_apps_resource_id: str, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword logic_apps_resource_id: Required.
        :paramtype logic_apps_resource_id: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.logic_apps_resource_id = logic_apps_resource_id


class MCASCheckRequirements(DataConnectorsCheckRequirements):
    """Represents MCAS (Microsoft Cloud App Security) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "MicrosoftCloudAppSecurity"
        self.tenant_id = tenant_id


class MCASCheckRequirementsProperties(DataConnectorTenantId):
    """MCAS (Microsoft Cloud App Security) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class MCASDataConnector(DataConnector):
    """Represents MCAS (Microsoft Cloud App Security) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "MCASDataConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.MCASDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "MicrosoftCloudAppSecurity"
        self.tenant_id = tenant_id
        self.data_types = data_types


class MCASDataConnectorDataTypes(AlertsDataTypeOfDataConnector):
    """The available data types for MCAS (Microsoft Cloud App Security) data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar alerts: Alerts data type connection. Required.
    :vartype alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    :ivar discovery_logs: Discovery log data type connection.
    :vartype discovery_logs: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _validation = {
        "alerts": {"required": True},
    }

    _attribute_map = {
        "alerts": {"key": "alerts", "type": "DataConnectorDataTypeCommon"},
        "discovery_logs": {"key": "discoveryLogs", "type": "DataConnectorDataTypeCommon"},
    }

    def __init__(
        self,
        *,
        alerts: "_models.DataConnectorDataTypeCommon",
        discovery_logs: Optional["_models.DataConnectorDataTypeCommon"] = None,
        **kwargs
    ):
        """
        :keyword alerts: Alerts data type connection. Required.
        :paramtype alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
        :keyword discovery_logs: Discovery log data type connection.
        :paramtype discovery_logs: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
        """
        super().__init__(alerts=alerts, **kwargs)
        self.discovery_logs = discovery_logs


class MCASDataConnectorProperties(DataConnectorTenantId):
    """MCAS (Microsoft Cloud App Security) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector. Required.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
    """

    _validation = {
        "tenant_id": {"required": True},
        "data_types": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "MCASDataConnectorDataTypes"},
    }

    def __init__(self, *, tenant_id: str, data_types: "_models.MCASDataConnectorDataTypes", **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector. Required.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
        """
        super().__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class MDATPCheckRequirements(DataConnectorsCheckRequirements):
    """Represents MDATP (Microsoft Defender Advanced Threat Protection) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "MicrosoftDefenderAdvancedThreatProtection"
        self.tenant_id = tenant_id


class MDATPCheckRequirementsProperties(DataConnectorTenantId):
    """MDATP (Microsoft Defender Advanced Threat Protection) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class MDATPDataConnector(DataConnector):
    """Represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AlertsDataTypeOfDataConnector"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "MicrosoftDefenderAdvancedThreatProtection"
        self.tenant_id = tenant_id
        self.data_types = data_types


class MDATPDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """MDATP (Microsoft Defender Advanced Threat Protection) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self, *, tenant_id: str, data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None, **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class MetadataAuthor(_serialization.Model):
    """Publisher or creator of the content item.

    :ivar name: Name of the author. Company or person.
    :vartype name: str
    :ivar email: Email of author contact.
    :vartype email: str
    :ivar link: Link for author/vendor page.
    :vartype link: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "link": {"key": "link", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, email: Optional[str] = None, link: Optional[str] = None, **kwargs
    ):
        """
        :keyword name: Name of the author. Company or person.
        :paramtype name: str
        :keyword email: Email of author contact.
        :paramtype email: str
        :keyword link: Link for author/vendor page.
        :paramtype link: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.email = email
        self.link = link


class MetadataCategories(_serialization.Model):
    """ies for the solution content item.

    :ivar domains: domain for the solution content item.
    :vartype domains: list[str]
    :ivar verticals: Industry verticals for the solution content item.
    :vartype verticals: list[str]
    """

    _attribute_map = {
        "domains": {"key": "domains", "type": "[str]"},
        "verticals": {"key": "verticals", "type": "[str]"},
    }

    def __init__(self, *, domains: Optional[List[str]] = None, verticals: Optional[List[str]] = None, **kwargs):
        """
        :keyword domains: domain for the solution content item.
        :paramtype domains: list[str]
        :keyword verticals: Industry verticals for the solution content item.
        :paramtype verticals: list[str]
        """
        super().__init__(**kwargs)
        self.domains = domains
        self.verticals = verticals


class MetadataDependencies(_serialization.Model):
    """Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.

    :ivar content_id: Id of the content item we depend on.
    :vartype content_id: str
    :ivar kind: Type of the content item we depend on. Known values are: "DataConnector",
     "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
     "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
     "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector", and
     "AutomationRule".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.Kind
    :ivar version: Version of the the content item we depend on.  Can be blank, * or missing to
     indicate any version fulfills the dependency.  If version does not match our defined numeric
     format then an exact match is required.
    :vartype version: str
    :ivar name: Name of the content item.
    :vartype name: str
    :ivar operator: Operator used for list of dependencies in criteria array. Known values are:
     "AND" and "OR".
    :vartype operator: str or ~azure.mgmt.securityinsight.models.Operator
    :ivar criteria: This is the list of dependencies we must fulfill, according to the AND/OR
     operator.
    :vartype criteria: list[~azure.mgmt.securityinsight.models.MetadataDependencies]
    """

    _attribute_map = {
        "content_id": {"key": "contentId", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "criteria": {"key": "criteria", "type": "[MetadataDependencies]"},
    }

    def __init__(
        self,
        *,
        content_id: Optional[str] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        version: Optional[str] = None,
        name: Optional[str] = None,
        operator: Optional[Union[str, "_models.Operator"]] = None,
        criteria: Optional[List["_models.MetadataDependencies"]] = None,
        **kwargs
    ):
        """
        :keyword content_id: Id of the content item we depend on.
        :paramtype content_id: str
        :keyword kind: Type of the content item we depend on. Known values are: "DataConnector",
         "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
         "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
         "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector", and
         "AutomationRule".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.Kind
        :keyword version: Version of the the content item we depend on.  Can be blank, * or missing to
         indicate any version fulfills the dependency.  If version does not match our defined numeric
         format then an exact match is required.
        :paramtype version: str
        :keyword name: Name of the content item.
        :paramtype name: str
        :keyword operator: Operator used for list of dependencies in criteria array. Known values are:
         "AND" and "OR".
        :paramtype operator: str or ~azure.mgmt.securityinsight.models.Operator
        :keyword criteria: This is the list of dependencies we must fulfill, according to the AND/OR
         operator.
        :paramtype criteria: list[~azure.mgmt.securityinsight.models.MetadataDependencies]
        """
        super().__init__(**kwargs)
        self.content_id = content_id
        self.kind = kind
        self.version = version
        self.name = name
        self.operator = operator
        self.criteria = criteria


class MetadataList(_serialization.Model):
    """List of all the metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Array of metadata. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.MetadataModel]
    :ivar next_link: URL to fetch the next page of metadata.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MetadataModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.MetadataModel"], **kwargs):
        """
        :keyword value: Array of metadata. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.MetadataModel]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class MetadataModel(ResourceWithEtag):  # pylint: disable=too-many-instance-attributes
    """Metadata resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar content_id: Static ID for the content.  Used to identify dependencies and content from
     solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic
     for user-created.  This is the resource name.
    :vartype content_id: str
    :ivar parent_id: Full parent resource ID of the content item the metadata is for.  This is the
     full resource ID including the scope (subscription and resource group).
    :vartype parent_id: str
    :ivar version: Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0,
     1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then we
     cannot guarantee any version checks.
    :vartype version: str
    :ivar kind: The kind of content the metadata is for. Known values are: "DataConnector",
     "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
     "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
     "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector", and
     "AutomationRule".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.Kind
    :ivar source: Source of the content.  This is where/how it was created.
    :vartype source: ~azure.mgmt.securityinsight.models.MetadataSource
    :ivar author: The creator of the content item.
    :vartype author: ~azure.mgmt.securityinsight.models.MetadataAuthor
    :ivar support: Support information for the metadata - type, name, contact information.
    :vartype support: ~azure.mgmt.securityinsight.models.MetadataSupport
    :ivar dependencies: Dependencies for the content item, what other content items it requires to
     work.  Can describe more complex dependencies using a recursive/nested structure. For a single
     dependency an id/kind/version can be supplied or operator/criteria for complex formats.
    :vartype dependencies: ~azure.mgmt.securityinsight.models.MetadataDependencies
    :ivar categories: Categories for the solution content item.
    :vartype categories: ~azure.mgmt.securityinsight.models.MetadataCategories
    :ivar providers: Providers for the solution content item.
    :vartype providers: list[str]
    :ivar first_publish_date: first publish date solution content item.
    :vartype first_publish_date: ~datetime.date
    :ivar last_publish_date: last publish date for the solution content item.
    :vartype last_publish_date: ~datetime.date
    :ivar custom_version: The custom version of the content. A optional free text.
    :vartype custom_version: str
    :ivar content_schema_version: Schema version of the content. Can be used to distinguish between
     different flow based on the schema version.
    :vartype content_schema_version: str
    :ivar icon: the icon identifier. this id can later be fetched from the solution template.
    :vartype icon: str
    :ivar threat_analysis_tactics: the tactics the resource covers.
    :vartype threat_analysis_tactics: list[str]
    :ivar threat_analysis_techniques: the techniques the resource covers, these have to be aligned
     with the tactics being used.
    :vartype threat_analysis_techniques: list[str]
    :ivar preview_images: preview image file names. These will be taken from the solution
     artifacts.
    :vartype preview_images: list[str]
    :ivar preview_images_dark: preview image file names. These will be taken from the solution
     artifacts. used for dark theme support.
    :vartype preview_images_dark: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "content_id": {"key": "properties.contentId", "type": "str"},
        "parent_id": {"key": "properties.parentId", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "kind": {"key": "properties.kind", "type": "str"},
        "source": {"key": "properties.source", "type": "MetadataSource"},
        "author": {"key": "properties.author", "type": "MetadataAuthor"},
        "support": {"key": "properties.support", "type": "MetadataSupport"},
        "dependencies": {"key": "properties.dependencies", "type": "MetadataDependencies"},
        "categories": {"key": "properties.categories", "type": "MetadataCategories"},
        "providers": {"key": "properties.providers", "type": "[str]"},
        "first_publish_date": {"key": "properties.firstPublishDate", "type": "date"},
        "last_publish_date": {"key": "properties.lastPublishDate", "type": "date"},
        "custom_version": {"key": "properties.customVersion", "type": "str"},
        "content_schema_version": {"key": "properties.contentSchemaVersion", "type": "str"},
        "icon": {"key": "properties.icon", "type": "str"},
        "threat_analysis_tactics": {"key": "properties.threatAnalysisTactics", "type": "[str]"},
        "threat_analysis_techniques": {"key": "properties.threatAnalysisTechniques", "type": "[str]"},
        "preview_images": {"key": "properties.previewImages", "type": "[str]"},
        "preview_images_dark": {"key": "properties.previewImagesDark", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        etag: Optional[str] = None,
        content_id: Optional[str] = None,
        parent_id: Optional[str] = None,
        version: Optional[str] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        source: Optional["_models.MetadataSource"] = None,
        author: Optional["_models.MetadataAuthor"] = None,
        support: Optional["_models.MetadataSupport"] = None,
        dependencies: Optional["_models.MetadataDependencies"] = None,
        categories: Optional["_models.MetadataCategories"] = None,
        providers: Optional[List[str]] = None,
        first_publish_date: Optional[datetime.date] = None,
        last_publish_date: Optional[datetime.date] = None,
        custom_version: Optional[str] = None,
        content_schema_version: Optional[str] = None,
        icon: Optional[str] = None,
        threat_analysis_tactics: Optional[List[str]] = None,
        threat_analysis_techniques: Optional[List[str]] = None,
        preview_images: Optional[List[str]] = None,
        preview_images_dark: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword content_id: Static ID for the content.  Used to identify dependencies and content from
         solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic
         for user-created.  This is the resource name.
        :paramtype content_id: str
        :keyword parent_id: Full parent resource ID of the content item the metadata is for.  This is
         the full resource ID including the scope (subscription and resource group).
        :paramtype parent_id: str
        :keyword version: Version of the content.  Default and recommended format is numeric (e.g. 1,
         1.0, 1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then
         we cannot guarantee any version checks.
        :paramtype version: str
        :keyword kind: The kind of content the metadata is for. Known values are: "DataConnector",
         "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
         "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
         "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector", and
         "AutomationRule".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.Kind
        :keyword source: Source of the content.  This is where/how it was created.
        :paramtype source: ~azure.mgmt.securityinsight.models.MetadataSource
        :keyword author: The creator of the content item.
        :paramtype author: ~azure.mgmt.securityinsight.models.MetadataAuthor
        :keyword support: Support information for the metadata - type, name, contact information.
        :paramtype support: ~azure.mgmt.securityinsight.models.MetadataSupport
        :keyword dependencies: Dependencies for the content item, what other content items it requires
         to work.  Can describe more complex dependencies using a recursive/nested structure. For a
         single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
        :paramtype dependencies: ~azure.mgmt.securityinsight.models.MetadataDependencies
        :keyword categories: Categories for the solution content item.
        :paramtype categories: ~azure.mgmt.securityinsight.models.MetadataCategories
        :keyword providers: Providers for the solution content item.
        :paramtype providers: list[str]
        :keyword first_publish_date: first publish date solution content item.
        :paramtype first_publish_date: ~datetime.date
        :keyword last_publish_date: last publish date for the solution content item.
        :paramtype last_publish_date: ~datetime.date
        :keyword custom_version: The custom version of the content. A optional free text.
        :paramtype custom_version: str
        :keyword content_schema_version: Schema version of the content. Can be used to distinguish
         between different flow based on the schema version.
        :paramtype content_schema_version: str
        :keyword icon: the icon identifier. this id can later be fetched from the solution template.
        :paramtype icon: str
        :keyword threat_analysis_tactics: the tactics the resource covers.
        :paramtype threat_analysis_tactics: list[str]
        :keyword threat_analysis_techniques: the techniques the resource covers, these have to be
         aligned with the tactics being used.
        :paramtype threat_analysis_techniques: list[str]
        :keyword preview_images: preview image file names. These will be taken from the solution
         artifacts.
        :paramtype preview_images: list[str]
        :keyword preview_images_dark: preview image file names. These will be taken from the solution
         artifacts. used for dark theme support.
        :paramtype preview_images_dark: list[str]
        """
        super().__init__(etag=etag, **kwargs)
        self.content_id = content_id
        self.parent_id = parent_id
        self.version = version
        self.kind = kind
        self.source = source
        self.author = author
        self.support = support
        self.dependencies = dependencies
        self.categories = categories
        self.providers = providers
        self.first_publish_date = first_publish_date
        self.last_publish_date = last_publish_date
        self.custom_version = custom_version
        self.content_schema_version = content_schema_version
        self.icon = icon
        self.threat_analysis_tactics = threat_analysis_tactics
        self.threat_analysis_techniques = threat_analysis_techniques
        self.preview_images = preview_images
        self.preview_images_dark = preview_images_dark


class MetadataPatch(ResourceWithEtag):  # pylint: disable=too-many-instance-attributes
    """Metadata patch request body.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar content_id: Static ID for the content.  Used to identify dependencies and content from
     solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic
     for user-created.  This is the resource name.
    :vartype content_id: str
    :ivar parent_id: Full parent resource ID of the content item the metadata is for.  This is the
     full resource ID including the scope (subscription and resource group).
    :vartype parent_id: str
    :ivar version: Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0,
     1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then we
     cannot guarantee any version checks.
    :vartype version: str
    :ivar kind: The kind of content the metadata is for. Known values are: "DataConnector",
     "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
     "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
     "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector", and
     "AutomationRule".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.Kind
    :ivar source: Source of the content.  This is where/how it was created.
    :vartype source: ~azure.mgmt.securityinsight.models.MetadataSource
    :ivar author: The creator of the content item.
    :vartype author: ~azure.mgmt.securityinsight.models.MetadataAuthor
    :ivar support: Support information for the metadata - type, name, contact information.
    :vartype support: ~azure.mgmt.securityinsight.models.MetadataSupport
    :ivar dependencies: Dependencies for the content item, what other content items it requires to
     work.  Can describe more complex dependencies using a recursive/nested structure. For a single
     dependency an id/kind/version can be supplied or operator/criteria for complex formats.
    :vartype dependencies: ~azure.mgmt.securityinsight.models.MetadataDependencies
    :ivar categories: Categories for the solution content item.
    :vartype categories: ~azure.mgmt.securityinsight.models.MetadataCategories
    :ivar providers: Providers for the solution content item.
    :vartype providers: list[str]
    :ivar first_publish_date: first publish date solution content item.
    :vartype first_publish_date: ~datetime.date
    :ivar last_publish_date: last publish date for the solution content item.
    :vartype last_publish_date: ~datetime.date
    :ivar custom_version: The custom version of the content. A optional free text.
    :vartype custom_version: str
    :ivar content_schema_version: Schema version of the content. Can be used to distinguish between
     different flow based on the schema version.
    :vartype content_schema_version: str
    :ivar icon: the icon identifier. this id can later be fetched from the solution template.
    :vartype icon: str
    :ivar threat_analysis_tactics: the tactics the resource covers.
    :vartype threat_analysis_tactics: list[str]
    :ivar threat_analysis_techniques: the techniques the resource covers, these have to be aligned
     with the tactics being used.
    :vartype threat_analysis_techniques: list[str]
    :ivar preview_images: preview image file names. These will be taken from the solution
     artifacts.
    :vartype preview_images: list[str]
    :ivar preview_images_dark: preview image file names. These will be taken from the solution
     artifacts. used for dark theme support.
    :vartype preview_images_dark: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "content_id": {"key": "properties.contentId", "type": "str"},
        "parent_id": {"key": "properties.parentId", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "kind": {"key": "properties.kind", "type": "str"},
        "source": {"key": "properties.source", "type": "MetadataSource"},
        "author": {"key": "properties.author", "type": "MetadataAuthor"},
        "support": {"key": "properties.support", "type": "MetadataSupport"},
        "dependencies": {"key": "properties.dependencies", "type": "MetadataDependencies"},
        "categories": {"key": "properties.categories", "type": "MetadataCategories"},
        "providers": {"key": "properties.providers", "type": "[str]"},
        "first_publish_date": {"key": "properties.firstPublishDate", "type": "date"},
        "last_publish_date": {"key": "properties.lastPublishDate", "type": "date"},
        "custom_version": {"key": "properties.customVersion", "type": "str"},
        "content_schema_version": {"key": "properties.contentSchemaVersion", "type": "str"},
        "icon": {"key": "properties.icon", "type": "str"},
        "threat_analysis_tactics": {"key": "properties.threatAnalysisTactics", "type": "[str]"},
        "threat_analysis_techniques": {"key": "properties.threatAnalysisTechniques", "type": "[str]"},
        "preview_images": {"key": "properties.previewImages", "type": "[str]"},
        "preview_images_dark": {"key": "properties.previewImagesDark", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        etag: Optional[str] = None,
        content_id: Optional[str] = None,
        parent_id: Optional[str] = None,
        version: Optional[str] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        source: Optional["_models.MetadataSource"] = None,
        author: Optional["_models.MetadataAuthor"] = None,
        support: Optional["_models.MetadataSupport"] = None,
        dependencies: Optional["_models.MetadataDependencies"] = None,
        categories: Optional["_models.MetadataCategories"] = None,
        providers: Optional[List[str]] = None,
        first_publish_date: Optional[datetime.date] = None,
        last_publish_date: Optional[datetime.date] = None,
        custom_version: Optional[str] = None,
        content_schema_version: Optional[str] = None,
        icon: Optional[str] = None,
        threat_analysis_tactics: Optional[List[str]] = None,
        threat_analysis_techniques: Optional[List[str]] = None,
        preview_images: Optional[List[str]] = None,
        preview_images_dark: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword content_id: Static ID for the content.  Used to identify dependencies and content from
         solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic
         for user-created.  This is the resource name.
        :paramtype content_id: str
        :keyword parent_id: Full parent resource ID of the content item the metadata is for.  This is
         the full resource ID including the scope (subscription and resource group).
        :paramtype parent_id: str
        :keyword version: Version of the content.  Default and recommended format is numeric (e.g. 1,
         1.0, 1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then
         we cannot guarantee any version checks.
        :paramtype version: str
        :keyword kind: The kind of content the metadata is for. Known values are: "DataConnector",
         "DataType", "Workbook", "WorkbookTemplate", "Playbook", "PlaybookTemplate",
         "AnalyticsRuleTemplate", "AnalyticsRule", "HuntingQuery", "InvestigationQuery", "Parser",
         "Watchlist", "WatchlistTemplate", "Solution", "AzureFunction", "LogicAppsCustomConnector", and
         "AutomationRule".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.Kind
        :keyword source: Source of the content.  This is where/how it was created.
        :paramtype source: ~azure.mgmt.securityinsight.models.MetadataSource
        :keyword author: The creator of the content item.
        :paramtype author: ~azure.mgmt.securityinsight.models.MetadataAuthor
        :keyword support: Support information for the metadata - type, name, contact information.
        :paramtype support: ~azure.mgmt.securityinsight.models.MetadataSupport
        :keyword dependencies: Dependencies for the content item, what other content items it requires
         to work.  Can describe more complex dependencies using a recursive/nested structure. For a
         single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
        :paramtype dependencies: ~azure.mgmt.securityinsight.models.MetadataDependencies
        :keyword categories: Categories for the solution content item.
        :paramtype categories: ~azure.mgmt.securityinsight.models.MetadataCategories
        :keyword providers: Providers for the solution content item.
        :paramtype providers: list[str]
        :keyword first_publish_date: first publish date solution content item.
        :paramtype first_publish_date: ~datetime.date
        :keyword last_publish_date: last publish date for the solution content item.
        :paramtype last_publish_date: ~datetime.date
        :keyword custom_version: The custom version of the content. A optional free text.
        :paramtype custom_version: str
        :keyword content_schema_version: Schema version of the content. Can be used to distinguish
         between different flow based on the schema version.
        :paramtype content_schema_version: str
        :keyword icon: the icon identifier. this id can later be fetched from the solution template.
        :paramtype icon: str
        :keyword threat_analysis_tactics: the tactics the resource covers.
        :paramtype threat_analysis_tactics: list[str]
        :keyword threat_analysis_techniques: the techniques the resource covers, these have to be
         aligned with the tactics being used.
        :paramtype threat_analysis_techniques: list[str]
        :keyword preview_images: preview image file names. These will be taken from the solution
         artifacts.
        :paramtype preview_images: list[str]
        :keyword preview_images_dark: preview image file names. These will be taken from the solution
         artifacts. used for dark theme support.
        :paramtype preview_images_dark: list[str]
        """
        super().__init__(etag=etag, **kwargs)
        self.content_id = content_id
        self.parent_id = parent_id
        self.version = version
        self.kind = kind
        self.source = source
        self.author = author
        self.support = support
        self.dependencies = dependencies
        self.categories = categories
        self.providers = providers
        self.first_publish_date = first_publish_date
        self.last_publish_date = last_publish_date
        self.custom_version = custom_version
        self.content_schema_version = content_schema_version
        self.icon = icon
        self.threat_analysis_tactics = threat_analysis_tactics
        self.threat_analysis_techniques = threat_analysis_techniques
        self.preview_images = preview_images
        self.preview_images_dark = preview_images_dark


class MetadataSource(_serialization.Model):
    """The original source of the content item, where it comes from.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Source type of the content. Required. Known values are: "LocalWorkspace",
     "Community", "Solution", and "SourceRepository".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.SourceKind
    :ivar name: Name of the content source.  The repo name, solution name, LA workspace name etc.
    :vartype name: str
    :ivar source_id: ID of the content source.  The solution ID, workspace ID, etc.
    :vartype source_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "source_id": {"key": "sourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "_models.SourceKind"],
        name: Optional[str] = None,
        source_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Source type of the content. Required. Known values are: "LocalWorkspace",
         "Community", "Solution", and "SourceRepository".
        :paramtype kind: str or ~azure.mgmt.securityinsight.models.SourceKind
        :keyword name: Name of the content source.  The repo name, solution name, LA workspace name
         etc.
        :paramtype name: str
        :keyword source_id: ID of the content source.  The solution ID, workspace ID, etc.
        :paramtype source_id: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.name = name
        self.source_id = source_id


class MetadataSupport(_serialization.Model):
    """Support information for the content item.

    All required parameters must be populated in order to send to Azure.

    :ivar tier: Type of support for content item. Required. Known values are: "Microsoft",
     "Partner", and "Community".
    :vartype tier: str or ~azure.mgmt.securityinsight.models.SupportTier
    :ivar name: Name of the support contact. Company or person.
    :vartype name: str
    :ivar email: Email of support contact.
    :vartype email: str
    :ivar link: Link for support help, like to support page to open a ticket etc.
    :vartype link: str
    """

    _validation = {
        "tier": {"required": True},
    }

    _attribute_map = {
        "tier": {"key": "tier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "link": {"key": "link", "type": "str"},
    }

    def __init__(
        self,
        *,
        tier: Union[str, "_models.SupportTier"],
        name: Optional[str] = None,
        email: Optional[str] = None,
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tier: Type of support for content item. Required. Known values are: "Microsoft",
         "Partner", and "Community".
        :paramtype tier: str or ~azure.mgmt.securityinsight.models.SupportTier
        :keyword name: Name of the support contact. Company or person.
        :paramtype name: str
        :keyword email: Email of support contact.
        :paramtype email: str
        :keyword link: Link for support help, like to support page to open a ticket etc.
        :paramtype link: str
        """
        super().__init__(**kwargs)
        self.tier = tier
        self.name = name
        self.email = email
        self.link = link


class MicrosoftSecurityIncidentCreationAlertRule(AlertRule):  # pylint: disable=too-many-instance-attributes
    """Represents MicrosoftSecurityIncidentCreation rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: The alerts' productName on which the cases will be generated. Known
     values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
     Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
     "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced Threat Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "last_modified_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "display_names_filter": {"key": "properties.displayNamesFilter", "type": "[str]"},
        "display_names_exclude_filter": {"key": "properties.displayNamesExcludeFilter", "type": "[str]"},
        "product_filter": {"key": "properties.productFilter", "type": "str"},
        "severities_filter": {"key": "properties.severitiesFilter", "type": "[str]"},
        "alert_rule_template_name": {"key": "properties.alertRuleTemplateName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        product_filter: Optional[Union[str, "_models.MicrosoftSecurityProductName"]] = None,
        severities_filter: Optional[List[Union[str, "_models.AlertSeverity"]]] = None,
        alert_rule_template_name: Optional[str] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: The alerts' productName on which the cases will be generated. Known
         values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
         Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
         "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword display_name: The display name for alerts created by this alert rule.
        :paramtype display_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "MicrosoftSecurityIncidentCreation"
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter
        self.alert_rule_template_name = alert_rule_template_name
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None


class MicrosoftSecurityIncidentCreationAlertRuleCommonProperties(_serialization.Model):
    """MicrosoftSecurityIncidentCreation rule common property bag.

    All required parameters must be populated in order to send to Azure.

    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: The alerts' productName on which the cases will be generated. Required.
     Known values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced
     Threat Protection", "Azure Active Directory Identity Protection", "Azure Security Center for
     IoT", "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced Threat
     Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        "product_filter": {"required": True},
    }

    _attribute_map = {
        "display_names_filter": {"key": "displayNamesFilter", "type": "[str]"},
        "display_names_exclude_filter": {"key": "displayNamesExcludeFilter", "type": "[str]"},
        "product_filter": {"key": "productFilter", "type": "str"},
        "severities_filter": {"key": "severitiesFilter", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        product_filter: Union[str, "_models.MicrosoftSecurityProductName"],
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        severities_filter: Optional[List[Union[str, "_models.AlertSeverity"]]] = None,
        **kwargs
    ):
        """
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: The alerts' productName on which the cases will be generated.
         Required. Known values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure
         Advanced Threat Protection", "Azure Active Directory Identity Protection", "Azure Security
         Center for IoT", "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced
         Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        """
        super().__init__(**kwargs)
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter


class MicrosoftSecurityIncidentCreationAlertRuleProperties(MicrosoftSecurityIncidentCreationAlertRuleCommonProperties):
    """MicrosoftSecurityIncidentCreation rule property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: The alerts' productName on which the cases will be generated. Required.
     Known values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced
     Threat Protection", "Azure Active Directory Identity Protection", "Azure Security Center for
     IoT", "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced Threat
     Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule. Required.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled. Required.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    """

    _validation = {
        "product_filter": {"required": True},
        "display_name": {"required": True},
        "enabled": {"required": True},
        "last_modified_utc": {"readonly": True},
    }

    _attribute_map = {
        "display_names_filter": {"key": "displayNamesFilter", "type": "[str]"},
        "display_names_exclude_filter": {"key": "displayNamesExcludeFilter", "type": "[str]"},
        "product_filter": {"key": "productFilter", "type": "str"},
        "severities_filter": {"key": "severitiesFilter", "type": "[str]"},
        "alert_rule_template_name": {"key": "alertRuleTemplateName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "last_modified_utc": {"key": "lastModifiedUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        product_filter: Union[str, "_models.MicrosoftSecurityProductName"],
        display_name: str,
        enabled: bool,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        severities_filter: Optional[List[Union[str, "_models.AlertSeverity"]]] = None,
        alert_rule_template_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: The alerts' productName on which the cases will be generated.
         Required. Known values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure
         Advanced Threat Protection", "Azure Active Directory Identity Protection", "Azure Security
         Center for IoT", "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced
         Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword display_name: The display name for alerts created by this alert rule. Required.
        :paramtype display_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled. Required.
        :paramtype enabled: bool
        """
        super().__init__(
            display_names_filter=display_names_filter,
            display_names_exclude_filter=display_names_exclude_filter,
            product_filter=product_filter,
            severities_filter=severities_filter,
            **kwargs
        )
        self.alert_rule_template_name = alert_rule_template_name
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None


class MicrosoftSecurityIncidentCreationAlertRuleTemplate(
    AlertRuleTemplate
):  # pylint: disable=too-many-instance-attributes
    """Represents MicrosoftSecurityIncidentCreation rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: The alerts' productName on which the cases will be generated. Known
     values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
     Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
     "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced Threat Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rules_created_by_template_count": {"key": "properties.alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "properties.lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "properties.createdDateUTC", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "required_data_connectors": {
            "key": "properties.requiredDataConnectors",
            "type": "[AlertRuleTemplateDataSource]",
        },
        "status": {"key": "properties.status", "type": "str"},
        "display_names_filter": {"key": "properties.displayNamesFilter", "type": "[str]"},
        "display_names_exclude_filter": {"key": "properties.displayNamesExcludeFilter", "type": "[str]"},
        "product_filter": {"key": "properties.productFilter", "type": "str"},
        "severities_filter": {"key": "properties.severitiesFilter", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        product_filter: Optional[Union[str, "_models.MicrosoftSecurityProductName"]] = None,
        severities_filter: Optional[List[Union[str, "_models.AlertSeverity"]]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: The alerts' productName on which the cases will be generated. Known
         values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
         Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
         "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        """
        super().__init__(**kwargs)
        self.kind: str = "MicrosoftSecurityIncidentCreation"
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter


class MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties(
    AlertRuleTemplatePropertiesBase
):  # pylint: disable=too-many-instance-attributes
    """MicrosoftSecurityIncidentCreation rule template properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar display_names_filter: the alerts' displayNames on which the cases will be generated.
    :vartype display_names_filter: list[str]
    :ivar display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :vartype display_names_exclude_filter: list[str]
    :ivar product_filter: The alerts' productName on which the cases will be generated. Known
     values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
     Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
     "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced Threat Protection".
    :vartype product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :ivar severities_filter: the alerts' severities on which the cases will be generated.
    :vartype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "alert_rules_created_by_template_count": {"key": "alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "createdDateUTC", "type": "iso-8601"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "required_data_connectors": {"key": "requiredDataConnectors", "type": "[AlertRuleTemplateDataSource]"},
        "status": {"key": "status", "type": "str"},
        "display_names_filter": {"key": "displayNamesFilter", "type": "[str]"},
        "display_names_exclude_filter": {"key": "displayNamesExcludeFilter", "type": "[str]"},
        "product_filter": {"key": "productFilter", "type": "str"},
        "severities_filter": {"key": "severitiesFilter", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        product_filter: Optional[Union[str, "_models.MicrosoftSecurityProductName"]] = None,
        severities_filter: Optional[List[Union[str, "_models.AlertSeverity"]]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword display_names_filter: the alerts' displayNames on which the cases will be generated.
        :paramtype display_names_filter: list[str]
        :keyword display_names_exclude_filter: the alerts' displayNames on which the cases will not be
         generated.
        :paramtype display_names_exclude_filter: list[str]
        :keyword product_filter: The alerts' productName on which the cases will be generated. Known
         values are: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
         Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT",
         "Office 365 Advanced Threat Protection", and "Microsoft Defender Advanced Threat Protection".
        :paramtype product_filter: str or
         ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
        :keyword severities_filter: the alerts' severities on which the cases will be generated.
        :paramtype severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
        """
        super().__init__(
            alert_rules_created_by_template_count=alert_rules_created_by_template_count,
            description=description,
            display_name=display_name,
            required_data_connectors=required_data_connectors,
            status=status,
            **kwargs
        )
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter


class MLBehaviorAnalyticsAlertRule(AlertRule):  # pylint: disable=too-many-instance-attributes
    """Represents MLBehaviorAnalytics alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "description": {"readonly": True},
        "display_name": {"readonly": True},
        "last_modified_utc": {"readonly": True},
        "severity": {"readonly": True},
        "tactics": {"readonly": True},
        "techniques": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rule_template_name": {"key": "properties.alertRuleTemplateName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "severity": {"key": "properties.severity", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "MLBehaviorAnalytics"
        self.alert_rule_template_name = alert_rule_template_name
        self.description = None
        self.display_name = None
        self.enabled = enabled
        self.last_modified_utc = None
        self.severity = None
        self.tactics = None
        self.techniques = None


class MLBehaviorAnalyticsAlertRuleTemplate(AlertRuleTemplate):  # pylint: disable=too-many-instance-attributes
    """Represents MLBehaviorAnalytics alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rules_created_by_template_count": {"key": "properties.alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "properties.lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "properties.createdDateUTC", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "required_data_connectors": {
            "key": "properties.requiredDataConnectors",
            "type": "[AlertRuleTemplateDataSource]",
        },
        "status": {"key": "properties.status", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super().__init__(**kwargs)
        self.kind: str = "MLBehaviorAnalytics"
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.tactics = tactics
        self.techniques = techniques
        self.severity = severity


class MLBehaviorAnalyticsAlertRuleTemplateProperties(AlertRuleTemplateWithMitreProperties):
    """MLBehaviorAnalytics alert rule template properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar severity: The severity for alerts created by this alert rule. Required. Known values are:
     "High", "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    """

    _validation = {
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
        "severity": {"required": True},
    }

    _attribute_map = {
        "alert_rules_created_by_template_count": {"key": "alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "createdDateUTC", "type": "iso-8601"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "required_data_connectors": {"key": "requiredDataConnectors", "type": "[AlertRuleTemplateDataSource]"},
        "status": {"key": "status", "type": "str"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "techniques": {"key": "techniques", "type": "[str]"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(
        self,
        *,
        severity: Union[str, "_models.AlertSeverity"],
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword severity: The severity for alerts created by this alert rule. Required. Known values
         are: "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super().__init__(
            alert_rules_created_by_template_count=alert_rules_created_by_template_count,
            description=description,
            display_name=display_name,
            required_data_connectors=required_data_connectors,
            status=status,
            tactics=tactics,
            techniques=techniques,
            **kwargs
        )
        self.severity = severity


class MSTICheckRequirements(DataConnectorsCheckRequirements):
    """Represents Microsoft Threat Intelligence requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "MicrosoftThreatIntelligence"
        self.tenant_id = tenant_id


class MSTICheckRequirementsProperties(DataConnectorTenantId):
    """Microsoft Threat Intelligence requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class MSTIDataConnector(DataConnector):
    """Represents Microsoft Threat Intelligence data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "MSTIDataConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.MSTIDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "MicrosoftThreatIntelligence"
        self.tenant_id = tenant_id
        self.data_types = data_types


class MSTIDataConnectorDataTypes(_serialization.Model):
    """The available data types for Microsoft Threat Intelligence Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar bing_safety_phishing_url: Data type for Microsoft Threat Intelligence Platforms data
     connector. Required.
    :vartype bing_safety_phishing_url:
     ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypesBingSafetyPhishingURL
    :ivar microsoft_emerging_threat_feed: Data type for Microsoft Threat Intelligence Platforms
     data connector. Required.
    :vartype microsoft_emerging_threat_feed:
     ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed
    """

    _validation = {
        "bing_safety_phishing_url": {"required": True},
        "microsoft_emerging_threat_feed": {"required": True},
    }

    _attribute_map = {
        "bing_safety_phishing_url": {
            "key": "bingSafetyPhishingURL",
            "type": "MSTIDataConnectorDataTypesBingSafetyPhishingURL",
        },
        "microsoft_emerging_threat_feed": {
            "key": "microsoftEmergingThreatFeed",
            "type": "MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed",
        },
    }

    def __init__(
        self,
        *,
        bing_safety_phishing_url: "_models.MSTIDataConnectorDataTypesBingSafetyPhishingURL",
        microsoft_emerging_threat_feed: "_models.MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed",
        **kwargs
    ):
        """
        :keyword bing_safety_phishing_url: Data type for Microsoft Threat Intelligence Platforms data
         connector. Required.
        :paramtype bing_safety_phishing_url:
         ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypesBingSafetyPhishingURL
        :keyword microsoft_emerging_threat_feed: Data type for Microsoft Threat Intelligence Platforms
         data connector. Required.
        :paramtype microsoft_emerging_threat_feed:
         ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed
        """
        super().__init__(**kwargs)
        self.bing_safety_phishing_url = bing_safety_phishing_url
        self.microsoft_emerging_threat_feed = microsoft_emerging_threat_feed


class MSTIDataConnectorDataTypesBingSafetyPhishingURL(DataConnectorDataTypeCommon):
    """Data type for Microsoft Threat Intelligence Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    :ivar lookback_period: lookback period. Required.
    :vartype lookback_period: str
    """

    _validation = {
        "state": {"required": True},
        "lookback_period": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "lookback_period": {"key": "lookbackPeriod", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], lookback_period: str, **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        :keyword lookback_period: lookback period. Required.
        :paramtype lookback_period: str
        """
        super().__init__(state=state, **kwargs)
        self.lookback_period = lookback_period


class MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed(DataConnectorDataTypeCommon):
    """Data type for Microsoft Threat Intelligence Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    :ivar lookback_period: lookback period. Required.
    :vartype lookback_period: str
    """

    _validation = {
        "state": {"required": True},
        "lookback_period": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "lookback_period": {"key": "lookbackPeriod", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], lookback_period: str, **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        :keyword lookback_period: lookback period. Required.
        :paramtype lookback_period: str
        """
        super().__init__(state=state, **kwargs)
        self.lookback_period = lookback_period


class MSTIDataConnectorProperties(DataConnectorTenantId):
    """Microsoft Threat Intelligence data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector. Required.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypes
    """

    _validation = {
        "tenant_id": {"required": True},
        "data_types": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "MSTIDataConnectorDataTypes"},
    }

    def __init__(self, *, tenant_id: str, data_types: "_models.MSTIDataConnectorDataTypes", **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector. Required.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MSTIDataConnectorDataTypes
        """
        super().__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class MtpCheckRequirements(DataConnectorsCheckRequirements):
    """Represents MTP (Microsoft Threat Protection) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "MicrosoftThreatProtection"
        self.tenant_id = tenant_id


class MTPCheckRequirementsProperties(DataConnectorTenantId):
    """MTP (Microsoft Threat Protection) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class MTPDataConnector(DataConnector):
    """Represents MTP (Microsoft Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "MTPDataConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.MTPDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "MicrosoftThreatProtection"
        self.tenant_id = tenant_id
        self.data_types = data_types


class MTPDataConnectorDataTypes(_serialization.Model):
    """The available data types for Microsoft Threat Protection Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar incidents: Data type for Microsoft Threat Protection Platforms data connector. Required.
    :vartype incidents: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypesIncidents
    """

    _validation = {
        "incidents": {"required": True},
    }

    _attribute_map = {
        "incidents": {"key": "incidents", "type": "MTPDataConnectorDataTypesIncidents"},
    }

    def __init__(self, *, incidents: "_models.MTPDataConnectorDataTypesIncidents", **kwargs):
        """
        :keyword incidents: Data type for Microsoft Threat Protection Platforms data connector.
         Required.
        :paramtype incidents: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypesIncidents
        """
        super().__init__(**kwargs)
        self.incidents = incidents


class MTPDataConnectorDataTypesIncidents(DataConnectorDataTypeCommon):
    """Data type for Microsoft Threat Protection Platforms data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class MTPDataConnectorProperties(DataConnectorTenantId):
    """MTP (Microsoft Threat Protection) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector. Required.
    :vartype data_types: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypes
    """

    _validation = {
        "tenant_id": {"required": True},
        "data_types": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "MTPDataConnectorDataTypes"},
    }

    def __init__(self, *, tenant_id: str, data_types: "_models.MTPDataConnectorDataTypes", **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector. Required.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.MTPDataConnectorDataTypes
        """
        super().__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class NicEntity(Entity):
    """Represents an network interface entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar mac_address: The MAC address of this network interface.
    :vartype mac_address: str
    :ivar ip_address_entity_id: The IP entity id of this network interface.
    :vartype ip_address_entity_id: str
    :ivar vlans: A list of VLANs of the network interface entity.
    :vartype vlans: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "mac_address": {"readonly": True},
        "ip_address_entity_id": {"readonly": True},
        "vlans": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "mac_address": {"key": "properties.macAddress", "type": "str"},
        "ip_address_entity_id": {"key": "properties.ipAddressEntityId", "type": "str"},
        "vlans": {"key": "properties.vlans", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "Nic"
        self.additional_data = None
        self.friendly_name = None
        self.mac_address = None
        self.ip_address_entity_id = None
        self.vlans = None


class NicEntityProperties(EntityCommonProperties):
    """Nic entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar mac_address: The MAC address of this network interface.
    :vartype mac_address: str
    :ivar ip_address_entity_id: The IP entity id of this network interface.
    :vartype ip_address_entity_id: str
    :ivar vlans: A list of VLANs of the network interface entity.
    :vartype vlans: list[str]
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "mac_address": {"readonly": True},
        "ip_address_entity_id": {"readonly": True},
        "vlans": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "ip_address_entity_id": {"key": "ipAddressEntityId", "type": "str"},
        "vlans": {"key": "vlans", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.mac_address = None
        self.ip_address_entity_id = None
        self.vlans = None


class NrtAlertRule(AlertRule):  # pylint: disable=too-many-instance-attributes
    """Represents NRT alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar template_version: The version of the alert rule template used to create this rule - in
     format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
    :vartype template_version: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
     time this alert rule been triggered.
    :vartype suppression_duration: ~datetime.timedelta
    :ivar suppression_enabled: Determines whether the suppression for this alert rule is enabled or
     disabled.
    :vartype suppression_enabled: bool
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar incident_configuration: The settings of the incidents that created from alerts triggered
     by this analytics rule.
    :vartype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
    :vartype sentinel_entities_mappings:
     list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "last_modified_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rule_template_name": {"key": "properties.alertRuleTemplateName", "type": "str"},
        "template_version": {"key": "properties.templateVersion", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "query": {"key": "properties.query", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "suppression_duration": {"key": "properties.suppressionDuration", "type": "duration"},
        "suppression_enabled": {"key": "properties.suppressionEnabled", "type": "bool"},
        "severity": {"key": "properties.severity", "type": "str"},
        "incident_configuration": {"key": "properties.incidentConfiguration", "type": "IncidentConfiguration"},
        "custom_details": {"key": "properties.customDetails", "type": "{str}"},
        "entity_mappings": {"key": "properties.entityMappings", "type": "[EntityMapping]"},
        "alert_details_override": {"key": "properties.alertDetailsOverride", "type": "AlertDetailsOverride"},
        "event_grouping_settings": {"key": "properties.eventGroupingSettings", "type": "EventGroupingSettings"},
        "sentinel_entities_mappings": {"key": "properties.sentinelEntitiesMappings", "type": "[SentinelEntityMapping]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        template_version: Optional[str] = None,
        description: Optional[str] = None,
        query: Optional[str] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        suppression_duration: Optional[datetime.timedelta] = None,
        suppression_enabled: Optional[bool] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        incident_configuration: Optional["_models.IncidentConfiguration"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["_models.EntityMapping"]] = None,
        alert_details_override: Optional["_models.AlertDetailsOverride"] = None,
        event_grouping_settings: Optional["_models.EventGroupingSettings"] = None,
        sentinel_entities_mappings: Optional[List["_models.SentinelEntityMapping"]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword template_version: The version of the alert rule template used to create this rule - in
         format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
        :paramtype template_version: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword display_name: The display name for alerts created by this alert rule.
        :paramtype display_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        :keyword suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
         time this alert rule been triggered.
        :paramtype suppression_duration: ~datetime.timedelta
        :keyword suppression_enabled: Determines whether the suppression for this alert rule is enabled
         or disabled.
        :paramtype suppression_enabled: bool
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword incident_configuration: The settings of the incidents that created from alerts
         triggered by this analytics rule.
        :paramtype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
        :paramtype sentinel_entities_mappings:
         list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "NRT"
        self.alert_rule_template_name = alert_rule_template_name
        self.template_version = template_version
        self.description = description
        self.query = query
        self.tactics = tactics
        self.techniques = techniques
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.suppression_duration = suppression_duration
        self.suppression_enabled = suppression_enabled
        self.severity = severity
        self.incident_configuration = incident_configuration
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.event_grouping_settings = event_grouping_settings
        self.sentinel_entities_mappings = sentinel_entities_mappings


class NrtAlertRuleTemplate(AlertRuleTemplate):  # pylint: disable=too-many-instance-attributes
    """Represents NRT alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar version: The version of this template - in format <a.b.c>, where all are numbers. For
     example <1.0.2>.
    :vartype version: str
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
    :vartype sentinel_entities_mappings:
     list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rules_created_by_template_count": {"key": "properties.alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "properties.lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "properties.createdDateUTC", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "required_data_connectors": {
            "key": "properties.requiredDataConnectors",
            "type": "[AlertRuleTemplateDataSource]",
        },
        "status": {"key": "properties.status", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "query": {"key": "properties.query", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "custom_details": {"key": "properties.customDetails", "type": "{str}"},
        "entity_mappings": {"key": "properties.entityMappings", "type": "[EntityMapping]"},
        "alert_details_override": {"key": "properties.alertDetailsOverride", "type": "AlertDetailsOverride"},
        "event_grouping_settings": {"key": "properties.eventGroupingSettings", "type": "EventGroupingSettings"},
        "sentinel_entities_mappings": {"key": "properties.sentinelEntitiesMappings", "type": "[SentinelEntityMapping]"},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        query: Optional[str] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        version: Optional[str] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["_models.EntityMapping"]] = None,
        alert_details_override: Optional["_models.AlertDetailsOverride"] = None,
        event_grouping_settings: Optional["_models.EventGroupingSettings"] = None,
        sentinel_entities_mappings: Optional[List["_models.SentinelEntityMapping"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword version: The version of this template - in format <a.b.c>, where all are numbers. For
         example <1.0.2>.
        :paramtype version: str
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
        :paramtype sentinel_entities_mappings:
         list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
        """
        super().__init__(**kwargs)
        self.kind: str = "NRT"
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.tactics = tactics
        self.techniques = techniques
        self.query = query
        self.severity = severity
        self.version = version
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.event_grouping_settings = event_grouping_settings
        self.sentinel_entities_mappings = sentinel_entities_mappings


class QueryBasedAlertRuleTemplateProperties(_serialization.Model):
    """Query based alert rule template base property bag.

    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar version: The version of this template - in format <a.b.c>, where all are numbers. For
     example <1.0.2>.
    :vartype version: str
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
    :vartype sentinel_entities_mappings:
     list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "custom_details": {"key": "customDetails", "type": "{str}"},
        "entity_mappings": {"key": "entityMappings", "type": "[EntityMapping]"},
        "alert_details_override": {"key": "alertDetailsOverride", "type": "AlertDetailsOverride"},
        "event_grouping_settings": {"key": "eventGroupingSettings", "type": "EventGroupingSettings"},
        "sentinel_entities_mappings": {"key": "sentinelEntitiesMappings", "type": "[SentinelEntityMapping]"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        version: Optional[str] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["_models.EntityMapping"]] = None,
        alert_details_override: Optional["_models.AlertDetailsOverride"] = None,
        event_grouping_settings: Optional["_models.EventGroupingSettings"] = None,
        sentinel_entities_mappings: Optional[List["_models.SentinelEntityMapping"]] = None,
        **kwargs
    ):
        """
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword version: The version of this template - in format <a.b.c>, where all are numbers. For
         example <1.0.2>.
        :paramtype version: str
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
        :paramtype sentinel_entities_mappings:
         list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
        """
        super().__init__(**kwargs)
        self.query = query
        self.severity = severity
        self.version = version
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.event_grouping_settings = event_grouping_settings
        self.sentinel_entities_mappings = sentinel_entities_mappings


class NrtAlertRuleTemplateProperties(
    AlertRuleTemplateWithMitreProperties, QueryBasedAlertRuleTemplateProperties
):  # pylint: disable=too-many-instance-attributes
    """NRT alert rule template properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar version: The version of this template - in format <a.b.c>, where all are numbers. For
     example <1.0.2>.
    :vartype version: str
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
    :vartype sentinel_entities_mappings:
     list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "custom_details": {"key": "customDetails", "type": "{str}"},
        "entity_mappings": {"key": "entityMappings", "type": "[EntityMapping]"},
        "alert_details_override": {"key": "alertDetailsOverride", "type": "AlertDetailsOverride"},
        "event_grouping_settings": {"key": "eventGroupingSettings", "type": "EventGroupingSettings"},
        "sentinel_entities_mappings": {"key": "sentinelEntitiesMappings", "type": "[SentinelEntityMapping]"},
        "alert_rules_created_by_template_count": {"key": "alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "createdDateUTC", "type": "iso-8601"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "required_data_connectors": {"key": "requiredDataConnectors", "type": "[AlertRuleTemplateDataSource]"},
        "status": {"key": "status", "type": "str"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "techniques": {"key": "techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        version: Optional[str] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["_models.EntityMapping"]] = None,
        alert_details_override: Optional["_models.AlertDetailsOverride"] = None,
        event_grouping_settings: Optional["_models.EventGroupingSettings"] = None,
        sentinel_entities_mappings: Optional[List["_models.SentinelEntityMapping"]] = None,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword version: The version of this template - in format <a.b.c>, where all are numbers. For
         example <1.0.2>.
        :paramtype version: str
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
        :paramtype sentinel_entities_mappings:
         list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        """
        super().__init__(
            alert_rules_created_by_template_count=alert_rules_created_by_template_count,
            description=description,
            display_name=display_name,
            required_data_connectors=required_data_connectors,
            status=status,
            tactics=tactics,
            techniques=techniques,
            query=query,
            severity=severity,
            version=version,
            custom_details=custom_details,
            entity_mappings=entity_mappings,
            alert_details_override=alert_details_override,
            event_grouping_settings=event_grouping_settings,
            sentinel_entities_mappings=sentinel_entities_mappings,
            **kwargs
        )
        self.query = query
        self.severity = severity
        self.version = version
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.event_grouping_settings = event_grouping_settings
        self.sentinel_entities_mappings = sentinel_entities_mappings
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.tactics = tactics
        self.techniques = techniques


class Office365ProjectCheckRequirements(DataConnectorsCheckRequirements):
    """Represents Office365 Project requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "Office365Project"
        self.tenant_id = tenant_id


class Office365ProjectCheckRequirementsProperties(DataConnectorTenantId):
    """Office365 Project requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class Office365ProjectConnectorDataTypes(_serialization.Model):
    """The available data types for Office Microsoft Project data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar logs: Logs data type. Required.
    :vartype logs: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypesLogs
    """

    _validation = {
        "logs": {"required": True},
    }

    _attribute_map = {
        "logs": {"key": "logs", "type": "Office365ProjectConnectorDataTypesLogs"},
    }

    def __init__(self, *, logs: "_models.Office365ProjectConnectorDataTypesLogs", **kwargs):
        """
        :keyword logs: Logs data type. Required.
        :paramtype logs: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypesLogs
        """
        super().__init__(**kwargs)
        self.logs = logs


class Office365ProjectConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class Office365ProjectDataConnector(DataConnector):
    """Represents Office Microsoft Project data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "Office365ProjectConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.Office365ProjectConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Office365Project"
        self.tenant_id = tenant_id
        self.data_types = data_types


class Office365ProjectDataConnectorProperties(DataConnectorTenantId):
    """Office Microsoft Project data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector. Required.
    :vartype data_types: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypes
    """

    _validation = {
        "tenant_id": {"required": True},
        "data_types": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "Office365ProjectConnectorDataTypes"},
    }

    def __init__(self, *, tenant_id: str, data_types: "_models.Office365ProjectConnectorDataTypes", **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector. Required.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.Office365ProjectConnectorDataTypes
        """
        super().__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class OfficeATPCheckRequirements(DataConnectorsCheckRequirements):
    """Represents OfficeATP (Office 365 Advanced Threat Protection) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "OfficeATP"
        self.tenant_id = tenant_id


class OfficeATPCheckRequirementsProperties(DataConnectorTenantId):
    """OfficeATP (Office 365 Advanced Threat Protection) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class OfficeATPDataConnector(DataConnector):
    """Represents OfficeATP (Office 365 Advanced Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AlertsDataTypeOfDataConnector"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "OfficeATP"
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficeATPDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """OfficeATP (Office 365 Advanced Threat Protection) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self, *, tenant_id: str, data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None, **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class OfficeConsent(Resource):
    """Consent for Office365 tenant that already made.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar tenant_id: The tenantId of the Office365 with the consent.
    :vartype tenant_id: str
    :ivar consent_id: Help to easily cascade among the data layers.
    :vartype consent_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "consent_id": {"key": "properties.consentId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, consent_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenantId of the Office365 with the consent.
        :paramtype tenant_id: str
        :keyword consent_id: Help to easily cascade among the data layers.
        :paramtype consent_id: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.consent_id = consent_id


class OfficeConsentList(_serialization.Model):
    """List of all the office365 consents.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of office consents.
    :vartype next_link: str
    :ivar value: Array of the consents. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.OfficeConsent]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[OfficeConsent]"},
    }

    def __init__(self, *, value: List["_models.OfficeConsent"], **kwargs):
        """
        :keyword value: Array of the consents. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.OfficeConsent]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class OfficeDataConnector(DataConnector):
    """Represents office data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "OfficeDataConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.OfficeDataConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Office365"
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficeDataConnectorDataTypes(_serialization.Model):
    """The available data types for office data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar exchange: Exchange data type connection. Required.
    :vartype exchange: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesExchange
    :ivar share_point: SharePoint data type connection. Required.
    :vartype share_point: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesSharePoint
    :ivar teams: Teams data type connection. Required.
    :vartype teams: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesTeams
    """

    _validation = {
        "exchange": {"required": True},
        "share_point": {"required": True},
        "teams": {"required": True},
    }

    _attribute_map = {
        "exchange": {"key": "exchange", "type": "OfficeDataConnectorDataTypesExchange"},
        "share_point": {"key": "sharePoint", "type": "OfficeDataConnectorDataTypesSharePoint"},
        "teams": {"key": "teams", "type": "OfficeDataConnectorDataTypesTeams"},
    }

    def __init__(
        self,
        *,
        exchange: "_models.OfficeDataConnectorDataTypesExchange",
        share_point: "_models.OfficeDataConnectorDataTypesSharePoint",
        teams: "_models.OfficeDataConnectorDataTypesTeams",
        **kwargs
    ):
        """
        :keyword exchange: Exchange data type connection. Required.
        :paramtype exchange: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesExchange
        :keyword share_point: SharePoint data type connection. Required.
        :paramtype share_point:
         ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesSharePoint
        :keyword teams: Teams data type connection. Required.
        :paramtype teams: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypesTeams
        """
        super().__init__(**kwargs)
        self.exchange = exchange
        self.share_point = share_point
        self.teams = teams


class OfficeDataConnectorDataTypesExchange(DataConnectorDataTypeCommon):
    """Exchange data type connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class OfficeDataConnectorDataTypesSharePoint(DataConnectorDataTypeCommon):
    """SharePoint data type connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class OfficeDataConnectorDataTypesTeams(DataConnectorDataTypeCommon):
    """Teams data type connection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class OfficeDataConnectorProperties(DataConnectorTenantId):
    """Office data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector. Required.
    :vartype data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
    """

    _validation = {
        "tenant_id": {"required": True},
        "data_types": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "OfficeDataConnectorDataTypes"},
    }

    def __init__(self, *, tenant_id: str, data_types: "_models.OfficeDataConnectorDataTypes", **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector. Required.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
        """
        super().__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class OfficeIRMCheckRequirements(DataConnectorsCheckRequirements):
    """Represents OfficeIRM (Microsoft Insider Risk Management) requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "OfficeIRM"
        self.tenant_id = tenant_id


class OfficeIRMCheckRequirementsProperties(DataConnectorTenantId):
    """OfficeIRM (Microsoft Insider Risk Management) requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class OfficeIRMDataConnector(DataConnector):
    """Represents OfficeIRM (Microsoft Insider Risk Management) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "AlertsDataTypeOfDataConnector"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "OfficeIRM"
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficeIRMDataConnectorProperties(DataConnectorTenantId, DataConnectorWithAlertsProperties):
    """OfficeIRM (Microsoft Insider Risk Management) data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "data_types": {"key": "dataTypes", "type": "AlertsDataTypeOfDataConnector"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self, *, tenant_id: str, data_types: Optional["_models.AlertsDataTypeOfDataConnector"] = None, **kwargs
    ):
        """
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, data_types=data_types, **kwargs)
        self.data_types = data_types
        self.tenant_id = tenant_id


class OfficePowerBICheckRequirements(DataConnectorsCheckRequirements):
    """Represents Office PowerBI requirements check request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Describes the kind of connector to be checked. Required. Known values are:
     "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM",
     "Office365Project", "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.kind: str = "OfficePowerBI"
        self.tenant_id = tenant_id


class OfficePowerBICheckRequirementsProperties(DataConnectorTenantId):
    """Office PowerBI requirements check properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        """
        super().__init__(tenant_id=tenant_id, **kwargs)


class OfficePowerBIConnectorDataTypes(_serialization.Model):
    """The available data types for Office Microsoft PowerBI data connector.

    All required parameters must be populated in order to send to Azure.

    :ivar logs: Logs data type. Required.
    :vartype logs: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypesLogs
    """

    _validation = {
        "logs": {"required": True},
    }

    _attribute_map = {
        "logs": {"key": "logs", "type": "OfficePowerBIConnectorDataTypesLogs"},
    }

    def __init__(self, *, logs: "_models.OfficePowerBIConnectorDataTypesLogs", **kwargs):
        """
        :keyword logs: Logs data type. Required.
        :paramtype logs: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypesLogs
        """
        super().__init__(**kwargs)
        self.logs = logs


class OfficePowerBIConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Describe whether this data type connection is enabled or not. Required. Known
     values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DataTypeState"], **kwargs):
        """
        :keyword state: Describe whether this data type connection is enabled or not. Required. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.DataTypeState
        """
        super().__init__(state=state, **kwargs)


class OfficePowerBIDataConnector(DataConnector):
    """Represents Office Microsoft PowerBI data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The data connector kind. Required. Known values are: "AzureActiveDirectory",
     "AzureSecurityCenter", "MicrosoftCloudAppSecurity", "ThreatIntelligence",
     "ThreatIntelligenceTaxii", "Office365", "OfficeATP", "OfficeIRM", "Office365Project",
     "OfficePowerBI", "AmazonWebServicesCloudTrail", "AmazonWebServicesS3",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection", "Dynamics365",
     "MicrosoftThreatProtection", "MicrosoftThreatIntelligence", "GenericUI", "APIPolling", and
     "IOT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :ivar tenant_id: The tenant id to connect to, and get the data from.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector.
    :vartype data_types: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "data_types": {"key": "properties.dataTypes", "type": "OfficePowerBIConnectorDataTypes"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["_models.OfficePowerBIConnectorDataTypes"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword tenant_id: The tenant id to connect to, and get the data from.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypes
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "OfficePowerBI"
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficePowerBIDataConnectorProperties(DataConnectorTenantId):
    """Office Microsoft PowerBI data connector properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id to connect to, and get the data from. Required.
    :vartype tenant_id: str
    :ivar data_types: The available data types for the connector. Required.
    :vartype data_types: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypes
    """

    _validation = {
        "tenant_id": {"required": True},
        "data_types": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "OfficePowerBIConnectorDataTypes"},
    }

    def __init__(self, *, tenant_id: str, data_types: "_models.OfficePowerBIConnectorDataTypes", **kwargs):
        """
        :keyword tenant_id: The tenant id to connect to, and get the data from. Required.
        :paramtype tenant_id: str
        :keyword data_types: The available data types for the connector. Required.
        :paramtype data_types: ~azure.mgmt.securityinsight.models.OfficePowerBIConnectorDataTypes
        """
        super().__init__(tenant_id=tenant_id, **kwargs)
        self.data_types = data_types


class Operation(_serialization.Model):
    """Operation provided by provider.

    :ivar display: Properties of the operation.
    :vartype display: ~azure.mgmt.securityinsight.models.OperationDisplay
    :ivar name: Name of the operation.
    :vartype name: str
    :ivar origin: The origin of the operation.
    :vartype origin: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        "display": {"key": "display", "type": "OperationDisplay"},
        "name": {"key": "name", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
        name: Optional[str] = None,
        origin: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword display: Properties of the operation.
        :paramtype display: ~azure.mgmt.securityinsight.models.OperationDisplay
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword origin: The origin of the operation.
        :paramtype origin: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.display = display
        self.name = name
        self.origin = origin
        self.is_data_action = is_data_action


class OperationDisplay(_serialization.Model):
    """Properties of the operation.

    :ivar description: Description of the operation.
    :vartype description: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the operation.
        :paramtype description: str
        :keyword operation: Operation name.
        :paramtype operation: str
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationsList(_serialization.Model):
    """Lists the operations available in the SecurityInsights RP.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of operations.
    :vartype next_link: str
    :ivar value: Array of operations. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.Operation]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: List["_models.Operation"], **kwargs):
        """
        :keyword value: Array of operations. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Operation]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class Permissions(_serialization.Model):
    """Permissions required for the connector.

    :ivar resource_provider: Resource provider permissions required for the connector.
    :vartype resource_provider:
     list[~azure.mgmt.securityinsight.models.PermissionsResourceProviderItem]
    :ivar customs: Customs permissions required for the connector.
    :vartype customs: list[~azure.mgmt.securityinsight.models.PermissionsCustomsItem]
    """

    _attribute_map = {
        "resource_provider": {"key": "resourceProvider", "type": "[PermissionsResourceProviderItem]"},
        "customs": {"key": "customs", "type": "[PermissionsCustomsItem]"},
    }

    def __init__(
        self,
        *,
        resource_provider: Optional[List["_models.PermissionsResourceProviderItem"]] = None,
        customs: Optional[List["_models.PermissionsCustomsItem"]] = None,
        **kwargs
    ):
        """
        :keyword resource_provider: Resource provider permissions required for the connector.
        :paramtype resource_provider:
         list[~azure.mgmt.securityinsight.models.PermissionsResourceProviderItem]
        :keyword customs: Customs permissions required for the connector.
        :paramtype customs: list[~azure.mgmt.securityinsight.models.PermissionsCustomsItem]
        """
        super().__init__(**kwargs)
        self.resource_provider = resource_provider
        self.customs = customs


class PermissionsCustomsItem(Customs):
    """PermissionsCustomsItem.

    :ivar name: Customs permissions name.
    :vartype name: str
    :ivar description: Customs permissions description.
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs):
        """
        :keyword name: Customs permissions name.
        :paramtype name: str
        :keyword description: Customs permissions description.
        :paramtype description: str
        """
        super().__init__(name=name, description=description, **kwargs)


class ResourceProvider(_serialization.Model):
    """Resource provider permissions required for the connector.

    :ivar provider: Provider name. Known values are: "Microsoft.OperationalInsights/solutions",
     "Microsoft.OperationalInsights/workspaces",
     "Microsoft.OperationalInsights/workspaces/datasources", "microsoft.aadiam/diagnosticSettings",
     "Microsoft.OperationalInsights/workspaces/sharedKeys", and
     "Microsoft.Authorization/policyAssignments".
    :vartype provider: str or ~azure.mgmt.securityinsight.models.ProviderName
    :ivar permissions_display_text: Permission description text.
    :vartype permissions_display_text: str
    :ivar provider_display_name: Permission provider display name.
    :vartype provider_display_name: str
    :ivar scope: Permission provider scope. Known values are: "ResourceGroup", "Subscription", and
     "Workspace".
    :vartype scope: str or ~azure.mgmt.securityinsight.models.PermissionProviderScope
    :ivar required_permissions: Required permissions for the connector.
    :vartype required_permissions: ~azure.mgmt.securityinsight.models.RequiredPermissions
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "permissions_display_text": {"key": "permissionsDisplayText", "type": "str"},
        "provider_display_name": {"key": "providerDisplayName", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "required_permissions": {"key": "requiredPermissions", "type": "RequiredPermissions"},
    }

    def __init__(
        self,
        *,
        provider: Optional[Union[str, "_models.ProviderName"]] = None,
        permissions_display_text: Optional[str] = None,
        provider_display_name: Optional[str] = None,
        scope: Optional[Union[str, "_models.PermissionProviderScope"]] = None,
        required_permissions: Optional["_models.RequiredPermissions"] = None,
        **kwargs
    ):
        """
        :keyword provider: Provider name. Known values are: "Microsoft.OperationalInsights/solutions",
         "Microsoft.OperationalInsights/workspaces",
         "Microsoft.OperationalInsights/workspaces/datasources", "microsoft.aadiam/diagnosticSettings",
         "Microsoft.OperationalInsights/workspaces/sharedKeys", and
         "Microsoft.Authorization/policyAssignments".
        :paramtype provider: str or ~azure.mgmt.securityinsight.models.ProviderName
        :keyword permissions_display_text: Permission description text.
        :paramtype permissions_display_text: str
        :keyword provider_display_name: Permission provider display name.
        :paramtype provider_display_name: str
        :keyword scope: Permission provider scope. Known values are: "ResourceGroup", "Subscription",
         and "Workspace".
        :paramtype scope: str or ~azure.mgmt.securityinsight.models.PermissionProviderScope
        :keyword required_permissions: Required permissions for the connector.
        :paramtype required_permissions: ~azure.mgmt.securityinsight.models.RequiredPermissions
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.permissions_display_text = permissions_display_text
        self.provider_display_name = provider_display_name
        self.scope = scope
        self.required_permissions = required_permissions


class PermissionsResourceProviderItem(ResourceProvider):
    """PermissionsResourceProviderItem.

    :ivar provider: Provider name. Known values are: "Microsoft.OperationalInsights/solutions",
     "Microsoft.OperationalInsights/workspaces",
     "Microsoft.OperationalInsights/workspaces/datasources", "microsoft.aadiam/diagnosticSettings",
     "Microsoft.OperationalInsights/workspaces/sharedKeys", and
     "Microsoft.Authorization/policyAssignments".
    :vartype provider: str or ~azure.mgmt.securityinsight.models.ProviderName
    :ivar permissions_display_text: Permission description text.
    :vartype permissions_display_text: str
    :ivar provider_display_name: Permission provider display name.
    :vartype provider_display_name: str
    :ivar scope: Permission provider scope. Known values are: "ResourceGroup", "Subscription", and
     "Workspace".
    :vartype scope: str or ~azure.mgmt.securityinsight.models.PermissionProviderScope
    :ivar required_permissions: Required permissions for the connector.
    :vartype required_permissions: ~azure.mgmt.securityinsight.models.RequiredPermissions
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "permissions_display_text": {"key": "permissionsDisplayText", "type": "str"},
        "provider_display_name": {"key": "providerDisplayName", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "required_permissions": {"key": "requiredPermissions", "type": "RequiredPermissions"},
    }

    def __init__(
        self,
        *,
        provider: Optional[Union[str, "_models.ProviderName"]] = None,
        permissions_display_text: Optional[str] = None,
        provider_display_name: Optional[str] = None,
        scope: Optional[Union[str, "_models.PermissionProviderScope"]] = None,
        required_permissions: Optional["_models.RequiredPermissions"] = None,
        **kwargs
    ):
        """
        :keyword provider: Provider name. Known values are: "Microsoft.OperationalInsights/solutions",
         "Microsoft.OperationalInsights/workspaces",
         "Microsoft.OperationalInsights/workspaces/datasources", "microsoft.aadiam/diagnosticSettings",
         "Microsoft.OperationalInsights/workspaces/sharedKeys", and
         "Microsoft.Authorization/policyAssignments".
        :paramtype provider: str or ~azure.mgmt.securityinsight.models.ProviderName
        :keyword permissions_display_text: Permission description text.
        :paramtype permissions_display_text: str
        :keyword provider_display_name: Permission provider display name.
        :paramtype provider_display_name: str
        :keyword scope: Permission provider scope. Known values are: "ResourceGroup", "Subscription",
         and "Workspace".
        :paramtype scope: str or ~azure.mgmt.securityinsight.models.PermissionProviderScope
        :keyword required_permissions: Required permissions for the connector.
        :paramtype required_permissions: ~azure.mgmt.securityinsight.models.RequiredPermissions
        """
        super().__init__(
            provider=provider,
            permissions_display_text=permissions_display_text,
            provider_display_name=provider_display_name,
            scope=scope,
            required_permissions=required_permissions,
            **kwargs
        )


class PlaybookActionProperties(_serialization.Model):
    """PlaybookActionProperties.

    :ivar logic_app_resource_id: The resource id of the playbook resource.
    :vartype logic_app_resource_id: str
    :ivar tenant_id: The tenant id of the playbook resource.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "logic_app_resource_id": {"key": "logicAppResourceId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, logic_app_resource_id: Optional[str] = None, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword logic_app_resource_id: The resource id of the playbook resource.
        :paramtype logic_app_resource_id: str
        :keyword tenant_id: The tenant id of the playbook resource.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.logic_app_resource_id = logic_app_resource_id
        self.tenant_id = tenant_id


class ProcessEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a process entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar account_entity_id: The account entity id running the processes.
    :vartype account_entity_id: str
    :ivar command_line: The command line used to create the process.
    :vartype command_line: str
    :ivar creation_time_utc: The time when the process started to run.
    :vartype creation_time_utc: ~datetime.datetime
    :ivar elevation_token: The elevation token associated with the process. Known values are:
     "Default", "Full", and "Limited".
    :vartype elevation_token: str or ~azure.mgmt.securityinsight.models.ElevationToken
    :ivar host_entity_id: The host entity id on which the process was running.
    :vartype host_entity_id: str
    :ivar host_logon_session_entity_id: The session entity id in which the process was running.
    :vartype host_logon_session_entity_id: str
    :ivar image_file_entity_id: Image file entity id.
    :vartype image_file_entity_id: str
    :ivar parent_process_entity_id: The parent process entity id.
    :vartype parent_process_entity_id: str
    :ivar process_id: The process ID.
    :vartype process_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "account_entity_id": {"readonly": True},
        "command_line": {"readonly": True},
        "creation_time_utc": {"readonly": True},
        "host_entity_id": {"readonly": True},
        "host_logon_session_entity_id": {"readonly": True},
        "image_file_entity_id": {"readonly": True},
        "parent_process_entity_id": {"readonly": True},
        "process_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "account_entity_id": {"key": "properties.accountEntityId", "type": "str"},
        "command_line": {"key": "properties.commandLine", "type": "str"},
        "creation_time_utc": {"key": "properties.creationTimeUtc", "type": "iso-8601"},
        "elevation_token": {"key": "properties.elevationToken", "type": "str"},
        "host_entity_id": {"key": "properties.hostEntityId", "type": "str"},
        "host_logon_session_entity_id": {"key": "properties.hostLogonSessionEntityId", "type": "str"},
        "image_file_entity_id": {"key": "properties.imageFileEntityId", "type": "str"},
        "parent_process_entity_id": {"key": "properties.parentProcessEntityId", "type": "str"},
        "process_id": {"key": "properties.processId", "type": "str"},
    }

    def __init__(self, *, elevation_token: Optional[Union[str, "_models.ElevationToken"]] = None, **kwargs):
        """
        :keyword elevation_token: The elevation token associated with the process. Known values are:
         "Default", "Full", and "Limited".
        :paramtype elevation_token: str or ~azure.mgmt.securityinsight.models.ElevationToken
        """
        super().__init__(**kwargs)
        self.kind: str = "Process"
        self.additional_data = None
        self.friendly_name = None
        self.account_entity_id = None
        self.command_line = None
        self.creation_time_utc = None
        self.elevation_token = elevation_token
        self.host_entity_id = None
        self.host_logon_session_entity_id = None
        self.image_file_entity_id = None
        self.parent_process_entity_id = None
        self.process_id = None


class ProcessEntityProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Process entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar account_entity_id: The account entity id running the processes.
    :vartype account_entity_id: str
    :ivar command_line: The command line used to create the process.
    :vartype command_line: str
    :ivar creation_time_utc: The time when the process started to run.
    :vartype creation_time_utc: ~datetime.datetime
    :ivar elevation_token: The elevation token associated with the process. Known values are:
     "Default", "Full", and "Limited".
    :vartype elevation_token: str or ~azure.mgmt.securityinsight.models.ElevationToken
    :ivar host_entity_id: The host entity id on which the process was running.
    :vartype host_entity_id: str
    :ivar host_logon_session_entity_id: The session entity id in which the process was running.
    :vartype host_logon_session_entity_id: str
    :ivar image_file_entity_id: Image file entity id.
    :vartype image_file_entity_id: str
    :ivar parent_process_entity_id: The parent process entity id.
    :vartype parent_process_entity_id: str
    :ivar process_id: The process ID.
    :vartype process_id: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "account_entity_id": {"readonly": True},
        "command_line": {"readonly": True},
        "creation_time_utc": {"readonly": True},
        "host_entity_id": {"readonly": True},
        "host_logon_session_entity_id": {"readonly": True},
        "image_file_entity_id": {"readonly": True},
        "parent_process_entity_id": {"readonly": True},
        "process_id": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "account_entity_id": {"key": "accountEntityId", "type": "str"},
        "command_line": {"key": "commandLine", "type": "str"},
        "creation_time_utc": {"key": "creationTimeUtc", "type": "iso-8601"},
        "elevation_token": {"key": "elevationToken", "type": "str"},
        "host_entity_id": {"key": "hostEntityId", "type": "str"},
        "host_logon_session_entity_id": {"key": "hostLogonSessionEntityId", "type": "str"},
        "image_file_entity_id": {"key": "imageFileEntityId", "type": "str"},
        "parent_process_entity_id": {"key": "parentProcessEntityId", "type": "str"},
        "process_id": {"key": "processId", "type": "str"},
    }

    def __init__(self, *, elevation_token: Optional[Union[str, "_models.ElevationToken"]] = None, **kwargs):
        """
        :keyword elevation_token: The elevation token associated with the process. Known values are:
         "Default", "Full", and "Limited".
        :paramtype elevation_token: str or ~azure.mgmt.securityinsight.models.ElevationToken
        """
        super().__init__(**kwargs)
        self.account_entity_id = None
        self.command_line = None
        self.creation_time_utc = None
        self.elevation_token = elevation_token
        self.host_entity_id = None
        self.host_logon_session_entity_id = None
        self.image_file_entity_id = None
        self.parent_process_entity_id = None
        self.process_id = None


class PropertyArrayChangedConditionProperties(AutomationRuleCondition):
    """Describes an automation rule condition that evaluates an array property's value change.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_type: Required. Known values are: "Property", "PropertyArray",
     "PropertyChanged", "PropertyArrayChanged", and "Boolean".
    :vartype condition_type: str or ~azure.mgmt.securityinsight.models.ConditionType
    :ivar condition_properties:
    :vartype condition_properties:
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayChangedValuesCondition
    """

    _validation = {
        "condition_type": {"required": True},
    }

    _attribute_map = {
        "condition_type": {"key": "conditionType", "type": "str"},
        "condition_properties": {
            "key": "conditionProperties",
            "type": "AutomationRulePropertyArrayChangedValuesCondition",
        },
    }

    def __init__(
        self,
        *,
        condition_properties: Optional["_models.AutomationRulePropertyArrayChangedValuesCondition"] = None,
        **kwargs
    ):
        """
        :keyword condition_properties:
        :paramtype condition_properties:
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayChangedValuesCondition
        """
        super().__init__(**kwargs)
        self.condition_type: str = "PropertyArrayChanged"
        self.condition_properties = condition_properties


class PropertyArrayConditionProperties(AutomationRuleCondition):
    """Describes an automation rule condition that evaluates an array property's value.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_type: Required. Known values are: "Property", "PropertyArray",
     "PropertyChanged", "PropertyArrayChanged", and "Boolean".
    :vartype condition_type: str or ~azure.mgmt.securityinsight.models.ConditionType
    :ivar condition_properties:
    :vartype condition_properties:
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayValuesCondition
    """

    _validation = {
        "condition_type": {"required": True},
    }

    _attribute_map = {
        "condition_type": {"key": "conditionType", "type": "str"},
        "condition_properties": {"key": "conditionProperties", "type": "AutomationRulePropertyArrayValuesCondition"},
    }

    def __init__(
        self, *, condition_properties: Optional["_models.AutomationRulePropertyArrayValuesCondition"] = None, **kwargs
    ):
        """
        :keyword condition_properties:
        :paramtype condition_properties:
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyArrayValuesCondition
        """
        super().__init__(**kwargs)
        self.condition_type: str = "PropertyArray"
        self.condition_properties = condition_properties


class PropertyChangedConditionProperties(AutomationRuleCondition):
    """Describes an automation rule condition that evaluates a property's value change.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_type: Required. Known values are: "Property", "PropertyArray",
     "PropertyChanged", "PropertyArrayChanged", and "Boolean".
    :vartype condition_type: str or ~azure.mgmt.securityinsight.models.ConditionType
    :ivar condition_properties:
    :vartype condition_properties:
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyValuesChangedCondition
    """

    _validation = {
        "condition_type": {"required": True},
    }

    _attribute_map = {
        "condition_type": {"key": "conditionType", "type": "str"},
        "condition_properties": {"key": "conditionProperties", "type": "AutomationRulePropertyValuesChangedCondition"},
    }

    def __init__(
        self, *, condition_properties: Optional["_models.AutomationRulePropertyValuesChangedCondition"] = None, **kwargs
    ):
        """
        :keyword condition_properties:
        :paramtype condition_properties:
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyValuesChangedCondition
        """
        super().__init__(**kwargs)
        self.condition_type: str = "PropertyChanged"
        self.condition_properties = condition_properties


class PropertyConditionProperties(AutomationRuleCondition):
    """Describes an automation rule condition that evaluates a property's value.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_type: Required. Known values are: "Property", "PropertyArray",
     "PropertyChanged", "PropertyArrayChanged", and "Boolean".
    :vartype condition_type: str or ~azure.mgmt.securityinsight.models.ConditionType
    :ivar condition_properties:
    :vartype condition_properties:
     ~azure.mgmt.securityinsight.models.AutomationRulePropertyValuesCondition
    """

    _validation = {
        "condition_type": {"required": True},
    }

    _attribute_map = {
        "condition_type": {"key": "conditionType", "type": "str"},
        "condition_properties": {"key": "conditionProperties", "type": "AutomationRulePropertyValuesCondition"},
    }

    def __init__(
        self, *, condition_properties: Optional["_models.AutomationRulePropertyValuesCondition"] = None, **kwargs
    ):
        """
        :keyword condition_properties:
        :paramtype condition_properties:
         ~azure.mgmt.securityinsight.models.AutomationRulePropertyValuesCondition
        """
        super().__init__(**kwargs)
        self.condition_type: str = "Property"
        self.condition_properties = condition_properties


class Recommendation(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Recommendation object.

    All required parameters must be populated in order to send to Azure.

    :ivar id: id of recommendation. Required.
    :vartype id: str
    :ivar instructions: Instructions of the recommendation. Required.
    :vartype instructions: ~azure.mgmt.securityinsight.models.Instructions
    :ivar content: Content of the recommendation.
    :vartype content: ~azure.mgmt.securityinsight.models.Content
    :ivar resource_id: Id of the resource this recommendation refers to.
    :vartype resource_id: str
    :ivar additional_properties: Collection of additional properties for the recommendation.
    :vartype additional_properties: dict[str, str]
    :ivar title: Title of the recommendation. Required.
    :vartype title: str
    :ivar description: Description of the recommendation. Required.
    :vartype description: str
    :ivar recommendation_type_title: Title of the recommendation type. Required.
    :vartype recommendation_type_title: str
    :ivar recommendation_type_id: Id of the recommendation type. Required.
    :vartype recommendation_type_id: str
    :ivar category: Category of the recommendation. Required. Known values are: "Onboarding",
     "NewFeature", "SocEfficiency", "CostOptimization", and "Demo".
    :vartype category: str or ~azure.mgmt.securityinsight.models.Category
    :ivar context: Context of the recommendation. Required. Known values are: "Analytics",
     "Incidents", "Overview", and "None".
    :vartype context: str or ~azure.mgmt.securityinsight.models.Context
    :ivar workspace_id: Id of the workspace this recommendation refers to. Required.
    :vartype workspace_id: str
    :ivar actions: List of actions to take for this recommendation. Required.
    :vartype actions: list[~azure.mgmt.securityinsight.models.RecommendedAction]
    :ivar state: State of the recommendation. Required. Known values are: "Active", "Disabled",
     "CompletedByUser", "CompletedByAction", and "Hidden".
    :vartype state: str or ~azure.mgmt.securityinsight.models.State
    :ivar priority: Priority of the recommendation. Required. Known values are: "Low", "Medium",
     and "High".
    :vartype priority: str or ~azure.mgmt.securityinsight.models.Priority
    :ivar last_evaluated_time_utc: The time stamp (UTC) when the recommendation was last evaluated.
     Required.
    :vartype last_evaluated_time_utc: ~datetime.datetime
    :ivar hide_until_time_utc: The time stamp (UTC) when the recommendation should be displayed
     again.
    :vartype hide_until_time_utc: ~datetime.datetime
    :ivar display_until_time_utc: The timestamp (UTC) after which the recommendation should not be
     displayed anymore.
    :vartype display_until_time_utc: ~datetime.datetime
    :ivar visible: Value indicating if the recommendation should be displayed or not.
    :vartype visible: bool
    """

    _validation = {
        "id": {"required": True},
        "instructions": {"required": True},
        "title": {"required": True},
        "description": {"required": True},
        "recommendation_type_title": {"required": True},
        "recommendation_type_id": {"required": True},
        "category": {"required": True},
        "context": {"required": True},
        "workspace_id": {"required": True},
        "actions": {"required": True},
        "state": {"required": True},
        "priority": {"required": True},
        "last_evaluated_time_utc": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "instructions": {"key": "instructions", "type": "Instructions"},
        "content": {"key": "content", "type": "Content"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "additional_properties": {"key": "additionalProperties", "type": "{str}"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "recommendation_type_title": {"key": "recommendationTypeTitle", "type": "str"},
        "recommendation_type_id": {"key": "recommendationTypeId", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "context": {"key": "context", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "actions": {"key": "actions", "type": "[RecommendedAction]"},
        "state": {"key": "state", "type": "str"},
        "priority": {"key": "priority", "type": "str"},
        "last_evaluated_time_utc": {"key": "lastEvaluatedTimeUtc", "type": "iso-8601"},
        "hide_until_time_utc": {"key": "hideUntilTimeUtc", "type": "iso-8601"},
        "display_until_time_utc": {"key": "displayUntilTimeUtc", "type": "iso-8601"},
        "visible": {"key": "visible", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        instructions: "_models.Instructions",
        title: str,
        description: str,
        recommendation_type_title: str,
        recommendation_type_id: str,
        category: Union[str, "_models.Category"],
        context: Union[str, "_models.Context"],
        workspace_id: str,
        actions: List["_models.RecommendedAction"],
        state: Union[str, "_models.State"],
        priority: Union[str, "_models.Priority"],
        last_evaluated_time_utc: datetime.datetime,
        content: Optional["_models.Content"] = None,
        resource_id: Optional[str] = None,
        additional_properties: Optional[Dict[str, str]] = None,
        hide_until_time_utc: Optional[datetime.datetime] = None,
        display_until_time_utc: Optional[datetime.datetime] = None,
        visible: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: id of recommendation. Required.
        :paramtype id: str
        :keyword instructions: Instructions of the recommendation. Required.
        :paramtype instructions: ~azure.mgmt.securityinsight.models.Instructions
        :keyword content: Content of the recommendation.
        :paramtype content: ~azure.mgmt.securityinsight.models.Content
        :keyword resource_id: Id of the resource this recommendation refers to.
        :paramtype resource_id: str
        :keyword additional_properties: Collection of additional properties for the recommendation.
        :paramtype additional_properties: dict[str, str]
        :keyword title: Title of the recommendation. Required.
        :paramtype title: str
        :keyword description: Description of the recommendation. Required.
        :paramtype description: str
        :keyword recommendation_type_title: Title of the recommendation type. Required.
        :paramtype recommendation_type_title: str
        :keyword recommendation_type_id: Id of the recommendation type. Required.
        :paramtype recommendation_type_id: str
        :keyword category: Category of the recommendation. Required. Known values are: "Onboarding",
         "NewFeature", "SocEfficiency", "CostOptimization", and "Demo".
        :paramtype category: str or ~azure.mgmt.securityinsight.models.Category
        :keyword context: Context of the recommendation. Required. Known values are: "Analytics",
         "Incidents", "Overview", and "None".
        :paramtype context: str or ~azure.mgmt.securityinsight.models.Context
        :keyword workspace_id: Id of the workspace this recommendation refers to. Required.
        :paramtype workspace_id: str
        :keyword actions: List of actions to take for this recommendation. Required.
        :paramtype actions: list[~azure.mgmt.securityinsight.models.RecommendedAction]
        :keyword state: State of the recommendation. Required. Known values are: "Active", "Disabled",
         "CompletedByUser", "CompletedByAction", and "Hidden".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.State
        :keyword priority: Priority of the recommendation. Required. Known values are: "Low", "Medium",
         and "High".
        :paramtype priority: str or ~azure.mgmt.securityinsight.models.Priority
        :keyword last_evaluated_time_utc: The time stamp (UTC) when the recommendation was last
         evaluated. Required.
        :paramtype last_evaluated_time_utc: ~datetime.datetime
        :keyword hide_until_time_utc: The time stamp (UTC) when the recommendation should be displayed
         again.
        :paramtype hide_until_time_utc: ~datetime.datetime
        :keyword display_until_time_utc: The timestamp (UTC) after which the recommendation should not
         be displayed anymore.
        :paramtype display_until_time_utc: ~datetime.datetime
        :keyword visible: Value indicating if the recommendation should be displayed or not.
        :paramtype visible: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.instructions = instructions
        self.content = content
        self.resource_id = resource_id
        self.additional_properties = additional_properties
        self.title = title
        self.description = description
        self.recommendation_type_title = recommendation_type_title
        self.recommendation_type_id = recommendation_type_id
        self.category = category
        self.context = context
        self.workspace_id = workspace_id
        self.actions = actions
        self.state = state
        self.priority = priority
        self.last_evaluated_time_utc = last_evaluated_time_utc
        self.hide_until_time_utc = hide_until_time_utc
        self.display_until_time_utc = display_until_time_utc
        self.visible = visible


class RecommendationList(_serialization.Model):
    """A list of recommendations.

    :ivar value: An list of recommendations.
    :vartype value: list[~azure.mgmt.securityinsight.models.Recommendation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Recommendation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Recommendation"]] = None, **kwargs):
        """
        :keyword value: An list of recommendations.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Recommendation]
        """
        super().__init__(**kwargs)
        self.value = value


class RecommendationPatch(_serialization.Model):
    """Recommendation Fields to update.

    :ivar state: State of the recommendation. Known values are: "Active", "Disabled",
     "CompletedByUser", "CompletedByAction", and "Hidden".
    :vartype state: str or ~azure.mgmt.securityinsight.models.State
    :ivar hide_until_time_utc: The time stamp (UTC) when the recommendation should be displayed
     again.
    :vartype hide_until_time_utc: ~datetime.datetime
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "hide_until_time_utc": {"key": "hideUntilTimeUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.State"]] = None,
        hide_until_time_utc: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword state: State of the recommendation. Known values are: "Active", "Disabled",
         "CompletedByUser", "CompletedByAction", and "Hidden".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.State
        :keyword hide_until_time_utc: The time stamp (UTC) when the recommendation should be displayed
         again.
        :paramtype hide_until_time_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.state = state
        self.hide_until_time_utc = hide_until_time_utc


class RecommendedAction(_serialization.Model):
    """What actions should be taken to complete the recommendation.

    All required parameters must be populated in order to send to Azure.

    :ivar link_text: Text of the link to complete the action. Required.
    :vartype link_text: str
    :ivar link_url: The Link to complete the action. Required.
    :vartype link_url: str
    :ivar state: The state of the action. Known values are: "Low", "Medium", and "High".
    :vartype state: str or ~azure.mgmt.securityinsight.models.Priority
    """

    _validation = {
        "link_text": {"required": True},
        "link_url": {"required": True},
    }

    _attribute_map = {
        "link_text": {"key": "linkText", "type": "str"},
        "link_url": {"key": "linkUrl", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self, *, link_text: str, link_url: str, state: Optional[Union[str, "_models.Priority"]] = None, **kwargs
    ):
        """
        :keyword link_text: Text of the link to complete the action. Required.
        :paramtype link_text: str
        :keyword link_url: The Link to complete the action. Required.
        :paramtype link_url: str
        :keyword state: The state of the action. Known values are: "Low", "Medium", and "High".
        :paramtype state: str or ~azure.mgmt.securityinsight.models.Priority
        """
        super().__init__(**kwargs)
        self.link_text = link_text
        self.link_url = link_url
        self.state = state


class RegistryKeyEntity(Entity):
    """Represents a registry key entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar hive: the hive that holds the registry key. Known values are: "HKEY_LOCAL_MACHINE",
     "HKEY_CLASSES_ROOT", "HKEY_CURRENT_CONFIG", "HKEY_USERS", "HKEY_CURRENT_USER_LOCAL_SETTINGS",
     "HKEY_PERFORMANCE_DATA", "HKEY_PERFORMANCE_NLSTEXT", "HKEY_PERFORMANCE_TEXT", "HKEY_A", and
     "HKEY_CURRENT_USER".
    :vartype hive: str or ~azure.mgmt.securityinsight.models.RegistryHive
    :ivar key: The registry key path.
    :vartype key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "hive": {"readonly": True},
        "key": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "hive": {"key": "properties.hive", "type": "str"},
        "key": {"key": "properties.key", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "RegistryKey"
        self.additional_data = None
        self.friendly_name = None
        self.hive = None
        self.key = None


class RegistryKeyEntityProperties(EntityCommonProperties):
    """RegistryKey entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar hive: the hive that holds the registry key. Known values are: "HKEY_LOCAL_MACHINE",
     "HKEY_CLASSES_ROOT", "HKEY_CURRENT_CONFIG", "HKEY_USERS", "HKEY_CURRENT_USER_LOCAL_SETTINGS",
     "HKEY_PERFORMANCE_DATA", "HKEY_PERFORMANCE_NLSTEXT", "HKEY_PERFORMANCE_TEXT", "HKEY_A", and
     "HKEY_CURRENT_USER".
    :vartype hive: str or ~azure.mgmt.securityinsight.models.RegistryHive
    :ivar key: The registry key path.
    :vartype key: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "hive": {"readonly": True},
        "key": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "hive": {"key": "hive", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.hive = None
        self.key = None


class RegistryValueEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a registry value entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar key_entity_id: The registry key entity id.
    :vartype key_entity_id: str
    :ivar value_data: String formatted representation of the value data.
    :vartype value_data: str
    :ivar value_name: The registry value name.
    :vartype value_name: str
    :ivar value_type: Specifies the data types to use when storing values in the registry, or
     identifies the data type of a value in the registry. Known values are: "None", "Unknown",
     "String", "ExpandString", "Binary", "DWord", "MultiString", and "QWord".
    :vartype value_type: str or ~azure.mgmt.securityinsight.models.RegistryValueKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "key_entity_id": {"readonly": True},
        "value_data": {"readonly": True},
        "value_name": {"readonly": True},
        "value_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "key_entity_id": {"key": "properties.keyEntityId", "type": "str"},
        "value_data": {"key": "properties.valueData", "type": "str"},
        "value_name": {"key": "properties.valueName", "type": "str"},
        "value_type": {"key": "properties.valueType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "RegistryValue"
        self.additional_data = None
        self.friendly_name = None
        self.key_entity_id = None
        self.value_data = None
        self.value_name = None
        self.value_type = None


class RegistryValueEntityProperties(EntityCommonProperties):
    """RegistryValue entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar key_entity_id: The registry key entity id.
    :vartype key_entity_id: str
    :ivar value_data: String formatted representation of the value data.
    :vartype value_data: str
    :ivar value_name: The registry value name.
    :vartype value_name: str
    :ivar value_type: Specifies the data types to use when storing values in the registry, or
     identifies the data type of a value in the registry. Known values are: "None", "Unknown",
     "String", "ExpandString", "Binary", "DWord", "MultiString", and "QWord".
    :vartype value_type: str or ~azure.mgmt.securityinsight.models.RegistryValueKind
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "key_entity_id": {"readonly": True},
        "value_data": {"readonly": True},
        "value_name": {"readonly": True},
        "value_type": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "key_entity_id": {"key": "keyEntityId", "type": "str"},
        "value_data": {"key": "valueData", "type": "str"},
        "value_name": {"key": "valueName", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.key_entity_id = None
        self.value_data = None
        self.value_name = None
        self.value_type = None


class Relation(ResourceWithEtag):
    """Represents a relation between two resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar related_resource_id: The resource ID of the related resource.
    :vartype related_resource_id: str
    :ivar related_resource_name: The name of the related resource.
    :vartype related_resource_name: str
    :ivar related_resource_type: The resource type of the related resource.
    :vartype related_resource_type: str
    :ivar related_resource_kind: The resource kind of the related resource.
    :vartype related_resource_kind: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "related_resource_name": {"readonly": True},
        "related_resource_type": {"readonly": True},
        "related_resource_kind": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "related_resource_id": {"key": "properties.relatedResourceId", "type": "str"},
        "related_resource_name": {"key": "properties.relatedResourceName", "type": "str"},
        "related_resource_type": {"key": "properties.relatedResourceType", "type": "str"},
        "related_resource_kind": {"key": "properties.relatedResourceKind", "type": "str"},
    }

    def __init__(self, *, etag: Optional[str] = None, related_resource_id: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword related_resource_id: The resource ID of the related resource.
        :paramtype related_resource_id: str
        """
        super().__init__(etag=etag, **kwargs)
        self.related_resource_id = related_resource_id
        self.related_resource_name = None
        self.related_resource_type = None
        self.related_resource_kind = None


class RelationList(_serialization.Model):
    """List of relations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of relations.
    :vartype next_link: str
    :ivar value: Array of relations. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.Relation]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Relation]"},
    }

    def __init__(self, *, value: List["_models.Relation"], **kwargs):
        """
        :keyword value: Array of relations. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Relation]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class Repo(_serialization.Model):
    """Represents a repository.

    :ivar url: The url to access the repository.
    :vartype url: str
    :ivar full_name: The name of the repository.
    :vartype full_name: str
    :ivar branches: Array of branches.
    :vartype branches: list[str]
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "full_name": {"key": "fullName", "type": "str"},
        "branches": {"key": "branches", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        full_name: Optional[str] = None,
        branches: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword url: The url to access the repository.
        :paramtype url: str
        :keyword full_name: The name of the repository.
        :paramtype full_name: str
        :keyword branches: Array of branches.
        :paramtype branches: list[str]
        """
        super().__init__(**kwargs)
        self.url = url
        self.full_name = full_name
        self.branches = branches


class RepoList(_serialization.Model):
    """List all the source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of repositories.
    :vartype next_link: str
    :ivar value: Array of repositories. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.Repo]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Repo]"},
    }

    def __init__(self, *, value: List["_models.Repo"], **kwargs):
        """
        :keyword value: Array of repositories. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Repo]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class Repository(_serialization.Model):
    """metadata of a repository.

    :ivar url: Url of repository.
    :vartype url: str
    :ivar branch: Branch name of repository.
    :vartype branch: str
    :ivar display_url: Display url of repository.
    :vartype display_url: str
    :ivar deployment_logs_url: Url to access repository action logs.
    :vartype deployment_logs_url: str
    :ivar path_mapping: Dictionary of source control content type and path mapping.
    :vartype path_mapping: list[~azure.mgmt.securityinsight.models.ContentPathMap]
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "branch": {"key": "branch", "type": "str"},
        "display_url": {"key": "displayUrl", "type": "str"},
        "deployment_logs_url": {"key": "deploymentLogsUrl", "type": "str"},
        "path_mapping": {"key": "pathMapping", "type": "[ContentPathMap]"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        branch: Optional[str] = None,
        display_url: Optional[str] = None,
        deployment_logs_url: Optional[str] = None,
        path_mapping: Optional[List["_models.ContentPathMap"]] = None,
        **kwargs
    ):
        """
        :keyword url: Url of repository.
        :paramtype url: str
        :keyword branch: Branch name of repository.
        :paramtype branch: str
        :keyword display_url: Display url of repository.
        :paramtype display_url: str
        :keyword deployment_logs_url: Url to access repository action logs.
        :paramtype deployment_logs_url: str
        :keyword path_mapping: Dictionary of source control content type and path mapping.
        :paramtype path_mapping: list[~azure.mgmt.securityinsight.models.ContentPathMap]
        """
        super().__init__(**kwargs)
        self.url = url
        self.branch = branch
        self.display_url = display_url
        self.deployment_logs_url = deployment_logs_url
        self.path_mapping = path_mapping


class RepositoryResourceInfo(_serialization.Model):
    """Resources created in user's repository for the source-control.

    :ivar webhook: The webhook object created for the source-control.
    :vartype webhook: ~azure.mgmt.securityinsight.models.Webhook
    :ivar git_hub_resource_info: Resources created in GitHub for this source-control.
    :vartype git_hub_resource_info: ~azure.mgmt.securityinsight.models.GitHubResourceInfo
    :ivar azure_dev_ops_resource_info: Resources created in Azure DevOps for this source-control.
    :vartype azure_dev_ops_resource_info:
     ~azure.mgmt.securityinsight.models.AzureDevOpsResourceInfo
    """

    _attribute_map = {
        "webhook": {"key": "webhook", "type": "Webhook"},
        "git_hub_resource_info": {"key": "gitHubResourceInfo", "type": "GitHubResourceInfo"},
        "azure_dev_ops_resource_info": {"key": "azureDevOpsResourceInfo", "type": "AzureDevOpsResourceInfo"},
    }

    def __init__(
        self,
        *,
        webhook: Optional["_models.Webhook"] = None,
        git_hub_resource_info: Optional["_models.GitHubResourceInfo"] = None,
        azure_dev_ops_resource_info: Optional["_models.AzureDevOpsResourceInfo"] = None,
        **kwargs
    ):
        """
        :keyword webhook: The webhook object created for the source-control.
        :paramtype webhook: ~azure.mgmt.securityinsight.models.Webhook
        :keyword git_hub_resource_info: Resources created in GitHub for this source-control.
        :paramtype git_hub_resource_info: ~azure.mgmt.securityinsight.models.GitHubResourceInfo
        :keyword azure_dev_ops_resource_info: Resources created in Azure DevOps for this
         source-control.
        :paramtype azure_dev_ops_resource_info:
         ~azure.mgmt.securityinsight.models.AzureDevOpsResourceInfo
        """
        super().__init__(**kwargs)
        self.webhook = webhook
        self.git_hub_resource_info = git_hub_resource_info
        self.azure_dev_ops_resource_info = azure_dev_ops_resource_info


class RequiredPermissions(_serialization.Model):
    """Required permissions for the connector.

    :ivar action: action permission.
    :vartype action: bool
    :ivar write: write permission.
    :vartype write: bool
    :ivar read: read permission.
    :vartype read: bool
    :ivar delete: delete permission.
    :vartype delete: bool
    """

    _attribute_map = {
        "action": {"key": "action", "type": "bool"},
        "write": {"key": "write", "type": "bool"},
        "read": {"key": "read", "type": "bool"},
        "delete": {"key": "delete", "type": "bool"},
    }

    def __init__(
        self,
        *,
        action: Optional[bool] = None,
        write: Optional[bool] = None,
        read: Optional[bool] = None,
        delete: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword action: action permission.
        :paramtype action: bool
        :keyword write: write permission.
        :paramtype write: bool
        :keyword read: read permission.
        :paramtype read: bool
        :keyword delete: delete permission.
        :paramtype delete: bool
        """
        super().__init__(**kwargs)
        self.action = action
        self.write = write
        self.read = read
        self.delete = delete


class ScheduledAlertRule(AlertRule):  # pylint: disable=too-many-instance-attributes
    """Represents scheduled alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :vartype query_frequency: ~datetime.timedelta
    :ivar query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :vartype query_period: ~datetime.timedelta
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar trigger_operator: The operation against the threshold that triggers alert rule. Known
     values are: "GreaterThan", "LessThan", "Equal", and "NotEqual".
    :vartype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :ivar trigger_threshold: The threshold triggers this alert rule.
    :vartype trigger_threshold: int
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
    :vartype sentinel_entities_mappings:
     list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar template_version: The version of the alert rule template used to create this rule - in
     format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
    :vartype template_version: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
     time this alert rule been triggered.
    :vartype suppression_duration: ~datetime.timedelta
    :ivar suppression_enabled: Determines whether the suppression for this alert rule is enabled or
     disabled.
    :vartype suppression_enabled: bool
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar incident_configuration: The settings of the incidents that created from alerts triggered
     by this analytics rule.
    :vartype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "last_modified_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "query": {"key": "properties.query", "type": "str"},
        "query_frequency": {"key": "properties.queryFrequency", "type": "duration"},
        "query_period": {"key": "properties.queryPeriod", "type": "duration"},
        "severity": {"key": "properties.severity", "type": "str"},
        "trigger_operator": {"key": "properties.triggerOperator", "type": "str"},
        "trigger_threshold": {"key": "properties.triggerThreshold", "type": "int"},
        "event_grouping_settings": {"key": "properties.eventGroupingSettings", "type": "EventGroupingSettings"},
        "custom_details": {"key": "properties.customDetails", "type": "{str}"},
        "entity_mappings": {"key": "properties.entityMappings", "type": "[EntityMapping]"},
        "alert_details_override": {"key": "properties.alertDetailsOverride", "type": "AlertDetailsOverride"},
        "sentinel_entities_mappings": {"key": "properties.sentinelEntitiesMappings", "type": "[SentinelEntityMapping]"},
        "alert_rule_template_name": {"key": "properties.alertRuleTemplateName", "type": "str"},
        "template_version": {"key": "properties.templateVersion", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "suppression_duration": {"key": "properties.suppressionDuration", "type": "duration"},
        "suppression_enabled": {"key": "properties.suppressionEnabled", "type": "bool"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "incident_configuration": {"key": "properties.incidentConfiguration", "type": "IncidentConfiguration"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        etag: Optional[str] = None,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "_models.TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        event_grouping_settings: Optional["_models.EventGroupingSettings"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["_models.EntityMapping"]] = None,
        alert_details_override: Optional["_models.AlertDetailsOverride"] = None,
        sentinel_entities_mappings: Optional[List["_models.SentinelEntityMapping"]] = None,
        alert_rule_template_name: Optional[str] = None,
        template_version: Optional[str] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        suppression_duration: Optional[datetime.timedelta] = None,
        suppression_enabled: Optional[bool] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        incident_configuration: Optional["_models.IncidentConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to
         run.
        :paramtype query_frequency: ~datetime.timedelta
        :keyword query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
        :paramtype query_period: ~datetime.timedelta
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword trigger_operator: The operation against the threshold that triggers alert rule. Known
         values are: "GreaterThan", "LessThan", "Equal", and "NotEqual".
        :paramtype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
        :keyword trigger_threshold: The threshold triggers this alert rule.
        :paramtype trigger_threshold: int
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
        :paramtype sentinel_entities_mappings:
         list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword template_version: The version of the alert rule template used to create this rule - in
         format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
        :paramtype template_version: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword display_name: The display name for alerts created by this alert rule.
        :paramtype display_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        :keyword suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
         time this alert rule been triggered.
        :paramtype suppression_duration: ~datetime.timedelta
        :keyword suppression_enabled: Determines whether the suppression for this alert rule is enabled
         or disabled.
        :paramtype suppression_enabled: bool
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword incident_configuration: The settings of the incidents that created from alerts
         triggered by this analytics rule.
        :paramtype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "Scheduled"
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold
        self.event_grouping_settings = event_grouping_settings
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.sentinel_entities_mappings = sentinel_entities_mappings
        self.alert_rule_template_name = alert_rule_template_name
        self.template_version = template_version
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.suppression_duration = suppression_duration
        self.suppression_enabled = suppression_enabled
        self.tactics = tactics
        self.techniques = techniques
        self.incident_configuration = incident_configuration


class ScheduledAlertRuleCommonProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Scheduled alert rule template property bag.

    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :vartype query_frequency: ~datetime.timedelta
    :ivar query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :vartype query_period: ~datetime.timedelta
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar trigger_operator: The operation against the threshold that triggers alert rule. Known
     values are: "GreaterThan", "LessThan", "Equal", and "NotEqual".
    :vartype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :ivar trigger_threshold: The threshold triggers this alert rule.
    :vartype trigger_threshold: int
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
    :vartype sentinel_entities_mappings:
     list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "query_frequency": {"key": "queryFrequency", "type": "duration"},
        "query_period": {"key": "queryPeriod", "type": "duration"},
        "severity": {"key": "severity", "type": "str"},
        "trigger_operator": {"key": "triggerOperator", "type": "str"},
        "trigger_threshold": {"key": "triggerThreshold", "type": "int"},
        "event_grouping_settings": {"key": "eventGroupingSettings", "type": "EventGroupingSettings"},
        "custom_details": {"key": "customDetails", "type": "{str}"},
        "entity_mappings": {"key": "entityMappings", "type": "[EntityMapping]"},
        "alert_details_override": {"key": "alertDetailsOverride", "type": "AlertDetailsOverride"},
        "sentinel_entities_mappings": {"key": "sentinelEntitiesMappings", "type": "[SentinelEntityMapping]"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "_models.TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        event_grouping_settings: Optional["_models.EventGroupingSettings"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["_models.EntityMapping"]] = None,
        alert_details_override: Optional["_models.AlertDetailsOverride"] = None,
        sentinel_entities_mappings: Optional[List["_models.SentinelEntityMapping"]] = None,
        **kwargs
    ):
        """
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to
         run.
        :paramtype query_frequency: ~datetime.timedelta
        :keyword query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
        :paramtype query_period: ~datetime.timedelta
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword trigger_operator: The operation against the threshold that triggers alert rule. Known
         values are: "GreaterThan", "LessThan", "Equal", and "NotEqual".
        :paramtype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
        :keyword trigger_threshold: The threshold triggers this alert rule.
        :paramtype trigger_threshold: int
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
        :paramtype sentinel_entities_mappings:
         list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
        """
        super().__init__(**kwargs)
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold
        self.event_grouping_settings = event_grouping_settings
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.sentinel_entities_mappings = sentinel_entities_mappings


class ScheduledAlertRuleProperties(ScheduledAlertRuleCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Scheduled alert rule base property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :vartype query_frequency: ~datetime.timedelta
    :ivar query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :vartype query_period: ~datetime.timedelta
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar trigger_operator: The operation against the threshold that triggers alert rule. Known
     values are: "GreaterThan", "LessThan", "Equal", and "NotEqual".
    :vartype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :ivar trigger_threshold: The threshold triggers this alert rule.
    :vartype trigger_threshold: int
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
    :vartype sentinel_entities_mappings:
     list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar template_version: The version of the alert rule template used to create this rule - in
     format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
    :vartype template_version: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule. Required.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled. Required.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
     time this alert rule been triggered. Required.
    :vartype suppression_duration: ~datetime.timedelta
    :ivar suppression_enabled: Determines whether the suppression for this alert rule is enabled or
     disabled. Required.
    :vartype suppression_enabled: bool
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar incident_configuration: The settings of the incidents that created from alerts triggered
     by this analytics rule.
    :vartype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
    """

    _validation = {
        "display_name": {"required": True},
        "enabled": {"required": True},
        "last_modified_utc": {"readonly": True},
        "suppression_duration": {"required": True},
        "suppression_enabled": {"required": True},
    }

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "query_frequency": {"key": "queryFrequency", "type": "duration"},
        "query_period": {"key": "queryPeriod", "type": "duration"},
        "severity": {"key": "severity", "type": "str"},
        "trigger_operator": {"key": "triggerOperator", "type": "str"},
        "trigger_threshold": {"key": "triggerThreshold", "type": "int"},
        "event_grouping_settings": {"key": "eventGroupingSettings", "type": "EventGroupingSettings"},
        "custom_details": {"key": "customDetails", "type": "{str}"},
        "entity_mappings": {"key": "entityMappings", "type": "[EntityMapping]"},
        "alert_details_override": {"key": "alertDetailsOverride", "type": "AlertDetailsOverride"},
        "sentinel_entities_mappings": {"key": "sentinelEntitiesMappings", "type": "[SentinelEntityMapping]"},
        "alert_rule_template_name": {"key": "alertRuleTemplateName", "type": "str"},
        "template_version": {"key": "templateVersion", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "last_modified_utc": {"key": "lastModifiedUtc", "type": "iso-8601"},
        "suppression_duration": {"key": "suppressionDuration", "type": "duration"},
        "suppression_enabled": {"key": "suppressionEnabled", "type": "bool"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "techniques": {"key": "techniques", "type": "[str]"},
        "incident_configuration": {"key": "incidentConfiguration", "type": "IncidentConfiguration"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        enabled: bool,
        suppression_duration: datetime.timedelta,
        suppression_enabled: bool,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "_models.TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        event_grouping_settings: Optional["_models.EventGroupingSettings"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["_models.EntityMapping"]] = None,
        alert_details_override: Optional["_models.AlertDetailsOverride"] = None,
        sentinel_entities_mappings: Optional[List["_models.SentinelEntityMapping"]] = None,
        alert_rule_template_name: Optional[str] = None,
        template_version: Optional[str] = None,
        description: Optional[str] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        incident_configuration: Optional["_models.IncidentConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to
         run.
        :paramtype query_frequency: ~datetime.timedelta
        :keyword query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
        :paramtype query_period: ~datetime.timedelta
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword trigger_operator: The operation against the threshold that triggers alert rule. Known
         values are: "GreaterThan", "LessThan", "Equal", and "NotEqual".
        :paramtype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
        :keyword trigger_threshold: The threshold triggers this alert rule.
        :paramtype trigger_threshold: int
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
        :paramtype sentinel_entities_mappings:
         list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword template_version: The version of the alert rule template used to create this rule - in
         format <a.b.c>, where all are numbers, for example 0 <1.0.2>.
        :paramtype template_version: str
        :keyword description: The description of the alert rule.
        :paramtype description: str
        :keyword display_name: The display name for alerts created by this alert rule. Required.
        :paramtype display_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled. Required.
        :paramtype enabled: bool
        :keyword suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
         time this alert rule been triggered. Required.
        :paramtype suppression_duration: ~datetime.timedelta
        :keyword suppression_enabled: Determines whether the suppression for this alert rule is enabled
         or disabled. Required.
        :paramtype suppression_enabled: bool
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword incident_configuration: The settings of the incidents that created from alerts
         triggered by this analytics rule.
        :paramtype incident_configuration: ~azure.mgmt.securityinsight.models.IncidentConfiguration
        """
        super().__init__(
            query=query,
            query_frequency=query_frequency,
            query_period=query_period,
            severity=severity,
            trigger_operator=trigger_operator,
            trigger_threshold=trigger_threshold,
            event_grouping_settings=event_grouping_settings,
            custom_details=custom_details,
            entity_mappings=entity_mappings,
            alert_details_override=alert_details_override,
            sentinel_entities_mappings=sentinel_entities_mappings,
            **kwargs
        )
        self.alert_rule_template_name = alert_rule_template_name
        self.template_version = template_version
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.suppression_duration = suppression_duration
        self.suppression_enabled = suppression_enabled
        self.tactics = tactics
        self.techniques = techniques
        self.incident_configuration = incident_configuration


class ScheduledAlertRuleTemplate(AlertRuleTemplate):  # pylint: disable=too-many-instance-attributes
    """Represents scheduled alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar last_updated_date_utc: The time that this alert rule template was last updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data connectors for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar query: The query that creates alerts for this rule.
    :vartype query: str
    :ivar query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :vartype query_frequency: ~datetime.timedelta
    :ivar query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :vartype query_period: ~datetime.timedelta
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar trigger_operator: The operation against the threshold that triggers alert rule. Known
     values are: "GreaterThan", "LessThan", "Equal", and "NotEqual".
    :vartype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :ivar trigger_threshold: The threshold triggers this alert rule.
    :vartype trigger_threshold: int
    :ivar tactics: The tactics of the alert rule template.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar version: The version of this template - in format <a.b.c>, where all are numbers. For
     example <1.0.2>.
    :vartype version: str
    :ivar event_grouping_settings: The event grouping settings.
    :vartype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
    :ivar custom_details: Dictionary of string key-value pairs of columns to be attached to the
     alert.
    :vartype custom_details: dict[str, str]
    :ivar entity_mappings: Array of the entity mappings of the alert rule.
    :vartype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
    :ivar alert_details_override: The alert details override settings.
    :vartype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
    :ivar sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
    :vartype sentinel_entities_mappings:
     list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "created_date_utc": {"readonly": True},
        "last_updated_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rules_created_by_template_count": {"key": "properties.alertRulesCreatedByTemplateCount", "type": "int"},
        "created_date_utc": {"key": "properties.createdDateUTC", "type": "iso-8601"},
        "last_updated_date_utc": {"key": "properties.lastUpdatedDateUTC", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "required_data_connectors": {
            "key": "properties.requiredDataConnectors",
            "type": "[AlertRuleTemplateDataSource]",
        },
        "status": {"key": "properties.status", "type": "str"},
        "query": {"key": "properties.query", "type": "str"},
        "query_frequency": {"key": "properties.queryFrequency", "type": "duration"},
        "query_period": {"key": "properties.queryPeriod", "type": "duration"},
        "severity": {"key": "properties.severity", "type": "str"},
        "trigger_operator": {"key": "properties.triggerOperator", "type": "str"},
        "trigger_threshold": {"key": "properties.triggerThreshold", "type": "int"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "version": {"key": "properties.version", "type": "str"},
        "event_grouping_settings": {"key": "properties.eventGroupingSettings", "type": "EventGroupingSettings"},
        "custom_details": {"key": "properties.customDetails", "type": "{str}"},
        "entity_mappings": {"key": "properties.entityMappings", "type": "[EntityMapping]"},
        "alert_details_override": {"key": "properties.alertDetailsOverride", "type": "AlertDetailsOverride"},
        "sentinel_entities_mappings": {"key": "properties.sentinelEntitiesMappings", "type": "[SentinelEntityMapping]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "_models.TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        version: Optional[str] = None,
        event_grouping_settings: Optional["_models.EventGroupingSettings"] = None,
        custom_details: Optional[Dict[str, str]] = None,
        entity_mappings: Optional[List["_models.EntityMapping"]] = None,
        alert_details_override: Optional["_models.AlertDetailsOverride"] = None,
        sentinel_entities_mappings: Optional[List["_models.SentinelEntityMapping"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data connectors for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword query: The query that creates alerts for this rule.
        :paramtype query: str
        :keyword query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to
         run.
        :paramtype query_frequency: ~datetime.timedelta
        :keyword query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
        :paramtype query_period: ~datetime.timedelta
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword trigger_operator: The operation against the threshold that triggers alert rule. Known
         values are: "GreaterThan", "LessThan", "Equal", and "NotEqual".
        :paramtype trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
        :keyword trigger_threshold: The threshold triggers this alert rule.
        :paramtype trigger_threshold: int
        :keyword tactics: The tactics of the alert rule template.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword version: The version of this template - in format <a.b.c>, where all are numbers. For
         example <1.0.2>.
        :paramtype version: str
        :keyword event_grouping_settings: The event grouping settings.
        :paramtype event_grouping_settings: ~azure.mgmt.securityinsight.models.EventGroupingSettings
        :keyword custom_details: Dictionary of string key-value pairs of columns to be attached to the
         alert.
        :paramtype custom_details: dict[str, str]
        :keyword entity_mappings: Array of the entity mappings of the alert rule.
        :paramtype entity_mappings: list[~azure.mgmt.securityinsight.models.EntityMapping]
        :keyword alert_details_override: The alert details override settings.
        :paramtype alert_details_override: ~azure.mgmt.securityinsight.models.AlertDetailsOverride
        :keyword sentinel_entities_mappings: Array of the sentinel entity mappings of the alert rule.
        :paramtype sentinel_entities_mappings:
         list[~azure.mgmt.securityinsight.models.SentinelEntityMapping]
        """
        super().__init__(**kwargs)
        self.kind: str = "Scheduled"
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.created_date_utc = None
        self.last_updated_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold
        self.tactics = tactics
        self.techniques = techniques
        self.version = version
        self.event_grouping_settings = event_grouping_settings
        self.custom_details = custom_details
        self.entity_mappings = entity_mappings
        self.alert_details_override = alert_details_override
        self.sentinel_entities_mappings = sentinel_entities_mappings


class SecurityAlert(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a security alert entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar alert_display_name: The display name of the alert.
    :vartype alert_display_name: str
    :ivar alert_type: The type name of the alert.
    :vartype alert_type: str
    :ivar compromised_entity: Display name of the main entity being reported on.
    :vartype compromised_entity: str
    :ivar confidence_level: The confidence level of this alert. Known values are: "Unknown", "Low",
     and "High".
    :vartype confidence_level: str or ~azure.mgmt.securityinsight.models.ConfidenceLevel
    :ivar confidence_reasons: The confidence reasons.
    :vartype confidence_reasons:
     list[~azure.mgmt.securityinsight.models.SecurityAlertPropertiesConfidenceReasonsItem]
    :ivar confidence_score: The confidence score of the alert.
    :vartype confidence_score: float
    :ivar confidence_score_status: The confidence score calculation status, i.e. indicating if
     score calculation is pending for this alert, not applicable or final. Known values are:
     "NotApplicable", "InProcess", "NotFinal", and "Final".
    :vartype confidence_score_status: str or
     ~azure.mgmt.securityinsight.models.ConfidenceScoreStatus
    :ivar description: Alert description.
    :vartype description: str
    :ivar end_time_utc: The impact end time of the alert (the time of the last event contributing
     to the alert).
    :vartype end_time_utc: ~datetime.datetime
    :ivar intent: Holds the alert intent stage(s) mapping for this alert. Known values are:
     "Unknown", "Probing", "Exploitation", "Persistence", "PrivilegeEscalation", "DefenseEvasion",
     "CredentialAccess", "Discovery", "LateralMovement", "Execution", "Collection", "Exfiltration",
     "CommandAndControl", and "Impact".
    :vartype intent: str or ~azure.mgmt.securityinsight.models.KillChainIntent
    :ivar provider_alert_id: The identifier of the alert inside the product which generated the
     alert.
    :vartype provider_alert_id: str
    :ivar processing_end_time: The time the alert was made available for consumption.
    :vartype processing_end_time: ~datetime.datetime
    :ivar product_component_name: The name of a component inside the product which generated the
     alert.
    :vartype product_component_name: str
    :ivar product_name: The name of the product which published this alert.
    :vartype product_name: str
    :ivar product_version: The version of the product generating the alert.
    :vartype product_version: str
    :ivar remediation_steps: Manual action items to take to remediate the alert.
    :vartype remediation_steps: list[str]
    :ivar severity: The severity of the alert. Known values are: "High", "Medium", "Low", and
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar start_time_utc: The impact start time of the alert (the time of the first event
     contributing to the alert).
    :vartype start_time_utc: ~datetime.datetime
    :ivar status: The lifecycle status of the alert. Known values are: "Unknown", "New",
     "Resolved", "Dismissed", and "InProgress".
    :vartype status: str or ~azure.mgmt.securityinsight.models.AlertStatus
    :ivar system_alert_id: Holds the product identifier of the alert for the product.
    :vartype system_alert_id: str
    :ivar tactics: The tactics of the alert.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar time_generated: The time the alert was generated.
    :vartype time_generated: ~datetime.datetime
    :ivar vendor_name: The name of the vendor that raise the alert.
    :vartype vendor_name: str
    :ivar alert_link: The uri link of the alert.
    :vartype alert_link: str
    :ivar resource_identifiers: The list of resource identifiers of the alert.
    :vartype resource_identifiers: list[JSON]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "alert_display_name": {"readonly": True},
        "alert_type": {"readonly": True},
        "compromised_entity": {"readonly": True},
        "confidence_level": {"readonly": True},
        "confidence_reasons": {"readonly": True},
        "confidence_score": {"readonly": True},
        "confidence_score_status": {"readonly": True},
        "description": {"readonly": True},
        "end_time_utc": {"readonly": True},
        "intent": {"readonly": True},
        "provider_alert_id": {"readonly": True},
        "processing_end_time": {"readonly": True},
        "product_component_name": {"readonly": True},
        "product_name": {"readonly": True},
        "product_version": {"readonly": True},
        "remediation_steps": {"readonly": True},
        "start_time_utc": {"readonly": True},
        "status": {"readonly": True},
        "system_alert_id": {"readonly": True},
        "tactics": {"readonly": True},
        "time_generated": {"readonly": True},
        "vendor_name": {"readonly": True},
        "alert_link": {"readonly": True},
        "resource_identifiers": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "alert_display_name": {"key": "properties.alertDisplayName", "type": "str"},
        "alert_type": {"key": "properties.alertType", "type": "str"},
        "compromised_entity": {"key": "properties.compromisedEntity", "type": "str"},
        "confidence_level": {"key": "properties.confidenceLevel", "type": "str"},
        "confidence_reasons": {
            "key": "properties.confidenceReasons",
            "type": "[SecurityAlertPropertiesConfidenceReasonsItem]",
        },
        "confidence_score": {"key": "properties.confidenceScore", "type": "float"},
        "confidence_score_status": {"key": "properties.confidenceScoreStatus", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "end_time_utc": {"key": "properties.endTimeUtc", "type": "iso-8601"},
        "intent": {"key": "properties.intent", "type": "str"},
        "provider_alert_id": {"key": "properties.providerAlertId", "type": "str"},
        "processing_end_time": {"key": "properties.processingEndTime", "type": "iso-8601"},
        "product_component_name": {"key": "properties.productComponentName", "type": "str"},
        "product_name": {"key": "properties.productName", "type": "str"},
        "product_version": {"key": "properties.productVersion", "type": "str"},
        "remediation_steps": {"key": "properties.remediationSteps", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
        "start_time_utc": {"key": "properties.startTimeUtc", "type": "iso-8601"},
        "status": {"key": "properties.status", "type": "str"},
        "system_alert_id": {"key": "properties.systemAlertId", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "time_generated": {"key": "properties.timeGenerated", "type": "iso-8601"},
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "alert_link": {"key": "properties.alertLink", "type": "str"},
        "resource_identifiers": {"key": "properties.resourceIdentifiers", "type": "[object]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self, *, severity: Optional[Union[str, "_models.AlertSeverity"]] = None, **kwargs
    ):
        """
        :keyword severity: The severity of the alert. Known values are: "High", "Medium", "Low", and
         "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super().__init__(**kwargs)
        self.kind: str = "SecurityAlert"
        self.additional_data = None
        self.friendly_name = None
        self.alert_display_name = None
        self.alert_type = None
        self.compromised_entity = None
        self.confidence_level = None
        self.confidence_reasons = None
        self.confidence_score = None
        self.confidence_score_status = None
        self.description = None
        self.end_time_utc = None
        self.intent = None
        self.provider_alert_id = None
        self.processing_end_time = None
        self.product_component_name = None
        self.product_name = None
        self.product_version = None
        self.remediation_steps = None
        self.severity = severity
        self.start_time_utc = None
        self.status = None
        self.system_alert_id = None
        self.tactics = None
        self.time_generated = None
        self.vendor_name = None
        self.alert_link = None
        self.resource_identifiers = None


class SecurityAlertProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """SecurityAlert entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar alert_display_name: The display name of the alert.
    :vartype alert_display_name: str
    :ivar alert_type: The type name of the alert.
    :vartype alert_type: str
    :ivar compromised_entity: Display name of the main entity being reported on.
    :vartype compromised_entity: str
    :ivar confidence_level: The confidence level of this alert. Known values are: "Unknown", "Low",
     and "High".
    :vartype confidence_level: str or ~azure.mgmt.securityinsight.models.ConfidenceLevel
    :ivar confidence_reasons: The confidence reasons.
    :vartype confidence_reasons:
     list[~azure.mgmt.securityinsight.models.SecurityAlertPropertiesConfidenceReasonsItem]
    :ivar confidence_score: The confidence score of the alert.
    :vartype confidence_score: float
    :ivar confidence_score_status: The confidence score calculation status, i.e. indicating if
     score calculation is pending for this alert, not applicable or final. Known values are:
     "NotApplicable", "InProcess", "NotFinal", and "Final".
    :vartype confidence_score_status: str or
     ~azure.mgmt.securityinsight.models.ConfidenceScoreStatus
    :ivar description: Alert description.
    :vartype description: str
    :ivar end_time_utc: The impact end time of the alert (the time of the last event contributing
     to the alert).
    :vartype end_time_utc: ~datetime.datetime
    :ivar intent: Holds the alert intent stage(s) mapping for this alert. Known values are:
     "Unknown", "Probing", "Exploitation", "Persistence", "PrivilegeEscalation", "DefenseEvasion",
     "CredentialAccess", "Discovery", "LateralMovement", "Execution", "Collection", "Exfiltration",
     "CommandAndControl", and "Impact".
    :vartype intent: str or ~azure.mgmt.securityinsight.models.KillChainIntent
    :ivar provider_alert_id: The identifier of the alert inside the product which generated the
     alert.
    :vartype provider_alert_id: str
    :ivar processing_end_time: The time the alert was made available for consumption.
    :vartype processing_end_time: ~datetime.datetime
    :ivar product_component_name: The name of a component inside the product which generated the
     alert.
    :vartype product_component_name: str
    :ivar product_name: The name of the product which published this alert.
    :vartype product_name: str
    :ivar product_version: The version of the product generating the alert.
    :vartype product_version: str
    :ivar remediation_steps: Manual action items to take to remediate the alert.
    :vartype remediation_steps: list[str]
    :ivar severity: The severity of the alert. Known values are: "High", "Medium", "Low", and
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar start_time_utc: The impact start time of the alert (the time of the first event
     contributing to the alert).
    :vartype start_time_utc: ~datetime.datetime
    :ivar status: The lifecycle status of the alert. Known values are: "Unknown", "New",
     "Resolved", "Dismissed", and "InProgress".
    :vartype status: str or ~azure.mgmt.securityinsight.models.AlertStatus
    :ivar system_alert_id: Holds the product identifier of the alert for the product.
    :vartype system_alert_id: str
    :ivar tactics: The tactics of the alert.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar time_generated: The time the alert was generated.
    :vartype time_generated: ~datetime.datetime
    :ivar vendor_name: The name of the vendor that raise the alert.
    :vartype vendor_name: str
    :ivar alert_link: The uri link of the alert.
    :vartype alert_link: str
    :ivar resource_identifiers: The list of resource identifiers of the alert.
    :vartype resource_identifiers: list[JSON]
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "alert_display_name": {"readonly": True},
        "alert_type": {"readonly": True},
        "compromised_entity": {"readonly": True},
        "confidence_level": {"readonly": True},
        "confidence_reasons": {"readonly": True},
        "confidence_score": {"readonly": True},
        "confidence_score_status": {"readonly": True},
        "description": {"readonly": True},
        "end_time_utc": {"readonly": True},
        "intent": {"readonly": True},
        "provider_alert_id": {"readonly": True},
        "processing_end_time": {"readonly": True},
        "product_component_name": {"readonly": True},
        "product_name": {"readonly": True},
        "product_version": {"readonly": True},
        "remediation_steps": {"readonly": True},
        "start_time_utc": {"readonly": True},
        "status": {"readonly": True},
        "system_alert_id": {"readonly": True},
        "tactics": {"readonly": True},
        "time_generated": {"readonly": True},
        "vendor_name": {"readonly": True},
        "alert_link": {"readonly": True},
        "resource_identifiers": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "alert_display_name": {"key": "alertDisplayName", "type": "str"},
        "alert_type": {"key": "alertType", "type": "str"},
        "compromised_entity": {"key": "compromisedEntity", "type": "str"},
        "confidence_level": {"key": "confidenceLevel", "type": "str"},
        "confidence_reasons": {"key": "confidenceReasons", "type": "[SecurityAlertPropertiesConfidenceReasonsItem]"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "confidence_score_status": {"key": "confidenceScoreStatus", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
        "intent": {"key": "intent", "type": "str"},
        "provider_alert_id": {"key": "providerAlertId", "type": "str"},
        "processing_end_time": {"key": "processingEndTime", "type": "iso-8601"},
        "product_component_name": {"key": "productComponentName", "type": "str"},
        "product_name": {"key": "productName", "type": "str"},
        "product_version": {"key": "productVersion", "type": "str"},
        "remediation_steps": {"key": "remediationSteps", "type": "[str]"},
        "severity": {"key": "severity", "type": "str"},
        "start_time_utc": {"key": "startTimeUtc", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "system_alert_id": {"key": "systemAlertId", "type": "str"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "time_generated": {"key": "timeGenerated", "type": "iso-8601"},
        "vendor_name": {"key": "vendorName", "type": "str"},
        "alert_link": {"key": "alertLink", "type": "str"},
        "resource_identifiers": {"key": "resourceIdentifiers", "type": "[object]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self, *, severity: Optional[Union[str, "_models.AlertSeverity"]] = None, **kwargs
    ):
        """
        :keyword severity: The severity of the alert. Known values are: "High", "Medium", "Low", and
         "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super().__init__(**kwargs)
        self.alert_display_name = None
        self.alert_type = None
        self.compromised_entity = None
        self.confidence_level = None
        self.confidence_reasons = None
        self.confidence_score = None
        self.confidence_score_status = None
        self.description = None
        self.end_time_utc = None
        self.intent = None
        self.provider_alert_id = None
        self.processing_end_time = None
        self.product_component_name = None
        self.product_name = None
        self.product_version = None
        self.remediation_steps = None
        self.severity = severity
        self.start_time_utc = None
        self.status = None
        self.system_alert_id = None
        self.tactics = None
        self.time_generated = None
        self.vendor_name = None
        self.alert_link = None
        self.resource_identifiers = None


class SecurityAlertPropertiesConfidenceReasonsItem(_serialization.Model):
    """confidence reason item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar reason: The reason's description.
    :vartype reason: str
    :ivar reason_type: The type (category) of the reason.
    :vartype reason_type: str
    """

    _validation = {
        "reason": {"readonly": True},
        "reason_type": {"readonly": True},
    }

    _attribute_map = {
        "reason": {"key": "reason", "type": "str"},
        "reason_type": {"key": "reasonType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.reason = None
        self.reason_type = None


class SecurityAlertTimelineItem(EntityTimelineItem):  # pylint: disable=too-many-instance-attributes
    """Represents security alert timeline item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The entity query kind type. Required. Known values are: "Activity", "Bookmark",
     "SecurityAlert", and "Anomaly".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityTimelineKind
    :ivar azure_resource_id: The alert azure resource id. Required.
    :vartype azure_resource_id: str
    :ivar product_name: The alert product name.
    :vartype product_name: str
    :ivar description: The alert description.
    :vartype description: str
    :ivar display_name: The alert name. Required.
    :vartype display_name: str
    :ivar severity: The alert severity. Required. Known values are: "High", "Medium", "Low", and
     "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar end_time_utc: The alert end time. Required.
    :vartype end_time_utc: ~datetime.datetime
    :ivar start_time_utc: The alert start time. Required.
    :vartype start_time_utc: ~datetime.datetime
    :ivar time_generated: The alert generated time. Required.
    :vartype time_generated: ~datetime.datetime
    :ivar alert_type: The name of the alert type. Required.
    :vartype alert_type: str
    :ivar intent: The intent of the alert. Known values are: "Unknown", "Probing", "Exploitation",
     "Persistence", "PrivilegeEscalation", "DefenseEvasion", "CredentialAccess", "Discovery",
     "LateralMovement", "Execution", "Collection", "Exfiltration", "CommandAndControl", and
     "Impact".
    :vartype intent: str or ~azure.mgmt.securityinsight.models.KillChainIntent
    :ivar techniques: The techniques of the alert.
    :vartype techniques: list[str]
    """

    _validation = {
        "kind": {"required": True},
        "azure_resource_id": {"required": True},
        "display_name": {"required": True},
        "severity": {"required": True},
        "end_time_utc": {"required": True},
        "start_time_utc": {"required": True},
        "time_generated": {"required": True},
        "alert_type": {"required": True},
        "intent": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "azure_resource_id": {"key": "azureResourceId", "type": "str"},
        "product_name": {"key": "productName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
        "start_time_utc": {"key": "startTimeUtc", "type": "iso-8601"},
        "time_generated": {"key": "timeGenerated", "type": "iso-8601"},
        "alert_type": {"key": "alertType", "type": "str"},
        "intent": {"key": "intent", "type": "str"},
        "techniques": {"key": "techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        azure_resource_id: str,
        display_name: str,
        severity: Union[str, "_models.AlertSeverity"],
        end_time_utc: datetime.datetime,
        start_time_utc: datetime.datetime,
        time_generated: datetime.datetime,
        alert_type: str,
        product_name: Optional[str] = None,
        description: Optional[str] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword azure_resource_id: The alert azure resource id. Required.
        :paramtype azure_resource_id: str
        :keyword product_name: The alert product name.
        :paramtype product_name: str
        :keyword description: The alert description.
        :paramtype description: str
        :keyword display_name: The alert name. Required.
        :paramtype display_name: str
        :keyword severity: The alert severity. Required. Known values are: "High", "Medium", "Low", and
         "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        :keyword end_time_utc: The alert end time. Required.
        :paramtype end_time_utc: ~datetime.datetime
        :keyword start_time_utc: The alert start time. Required.
        :paramtype start_time_utc: ~datetime.datetime
        :keyword time_generated: The alert generated time. Required.
        :paramtype time_generated: ~datetime.datetime
        :keyword alert_type: The name of the alert type. Required.
        :paramtype alert_type: str
        :keyword techniques: The techniques of the alert.
        :paramtype techniques: list[str]
        """
        super().__init__(**kwargs)
        self.kind: str = "SecurityAlert"
        self.azure_resource_id = azure_resource_id
        self.product_name = product_name
        self.description = description
        self.display_name = display_name
        self.severity = severity
        self.end_time_utc = end_time_utc
        self.start_time_utc = start_time_utc
        self.time_generated = time_generated
        self.alert_type = alert_type
        self.intent = None
        self.techniques = techniques


class SecurityGroupEntity(Entity):
    """Represents a security group entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar distinguished_name: The group distinguished name.
    :vartype distinguished_name: str
    :ivar object_guid: A single-value attribute that is the unique identifier for the object,
     assigned by active directory.
    :vartype object_guid: str
    :ivar sid: The SID attribute is a single-value attribute that specifies the security identifier
     (SID) of the group.
    :vartype sid: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "distinguished_name": {"readonly": True},
        "object_guid": {"readonly": True},
        "sid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "object_guid": {"key": "properties.objectGuid", "type": "str"},
        "sid": {"key": "properties.sid", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "SecurityGroup"
        self.additional_data = None
        self.friendly_name = None
        self.distinguished_name = None
        self.object_guid = None
        self.sid = None


class SecurityGroupEntityProperties(EntityCommonProperties):
    """SecurityGroup entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar distinguished_name: The group distinguished name.
    :vartype distinguished_name: str
    :ivar object_guid: A single-value attribute that is the unique identifier for the object,
     assigned by active directory.
    :vartype object_guid: str
    :ivar sid: The SID attribute is a single-value attribute that specifies the security identifier
     (SID) of the group.
    :vartype sid: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "distinguished_name": {"readonly": True},
        "object_guid": {"readonly": True},
        "sid": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "distinguished_name": {"key": "distinguishedName", "type": "str"},
        "object_guid": {"key": "objectGuid", "type": "str"},
        "sid": {"key": "sid", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.distinguished_name = None
        self.object_guid = None
        self.sid = None


class SecurityMLAnalyticsSettingsDataSource(_serialization.Model):
    """security ml analytics settings data sources.

    :ivar connector_id: The connector id that provides the following data types.
    :vartype connector_id: str
    :ivar data_types: The data types used by the security ml analytics settings.
    :vartype data_types: list[str]
    """

    _attribute_map = {
        "connector_id": {"key": "connectorId", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "[str]"},
    }

    def __init__(self, *, connector_id: Optional[str] = None, data_types: Optional[List[str]] = None, **kwargs):
        """
        :keyword connector_id: The connector id that provides the following data types.
        :paramtype connector_id: str
        :keyword data_types: The data types used by the security ml analytics settings.
        :paramtype data_types: list[str]
        """
        super().__init__(**kwargs)
        self.connector_id = connector_id
        self.data_types = data_types


class SecurityMLAnalyticsSettingsList(_serialization.Model):
    """List all the SecurityMLAnalyticsSettings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of SecurityMLAnalyticsSettings.
    :vartype next_link: str
    :ivar value: Array of SecurityMLAnalyticsSettings. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.SecurityMLAnalyticsSetting]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[SecurityMLAnalyticsSetting]"},
    }

    def __init__(self, *, value: List["_models.SecurityMLAnalyticsSetting"], **kwargs):
        """
        :keyword value: Array of SecurityMLAnalyticsSettings. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.SecurityMLAnalyticsSetting]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class SentinelEntityMapping(_serialization.Model):
    """A single sentinel entity mapping.

    :ivar column_name: the column name to be mapped to the SentinelEntities.
    :vartype column_name: str
    """

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
    }

    def __init__(self, *, column_name: Optional[str] = None, **kwargs):
        """
        :keyword column_name: the column name to be mapped to the SentinelEntities.
        :paramtype column_name: str
        """
        super().__init__(**kwargs)
        self.column_name = column_name


class SentinelOnboardingState(ResourceWithEtag):
    """Sentinel onboarding state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar customer_managed_key: Flag that indicates the status of the CMK setting.
    :vartype customer_managed_key: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "customer_managed_key": {"key": "properties.customerManagedKey", "type": "bool"},
    }

    def __init__(self, *, etag: Optional[str] = None, customer_managed_key: Optional[bool] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword customer_managed_key: Flag that indicates the status of the CMK setting.
        :paramtype customer_managed_key: bool
        """
        super().__init__(etag=etag, **kwargs)
        self.customer_managed_key = customer_managed_key


class SentinelOnboardingStatesList(_serialization.Model):
    """List of the Sentinel onboarding states.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Array of Sentinel onboarding states. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.SentinelOnboardingState]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SentinelOnboardingState]"},
    }

    def __init__(self, *, value: List["_models.SentinelOnboardingState"], **kwargs):
        """
        :keyword value: Array of Sentinel onboarding states. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.SentinelOnboardingState]
        """
        super().__init__(**kwargs)
        self.value = value


class SettingList(_serialization.Model):
    """List of all the settings.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Array of settings. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.Settings]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Settings]"},
    }

    def __init__(self, *, value: List["_models.Settings"], **kwargs):
        """
        :keyword value: Array of settings. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.Settings]
        """
        super().__init__(**kwargs)
        self.value = value


class SourceControl(ResourceWithEtag):  # pylint: disable=too-many-instance-attributes
    """Represents a SourceControl in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar id_properties_id: The id (a Guid) of the source control.
    :vartype id_properties_id: str
    :ivar version: The version number associated with the source control. Known values are: "V1"
     and "V2".
    :vartype version: str or ~azure.mgmt.securityinsight.models.Version
    :ivar display_name: The display name of the source control.
    :vartype display_name: str
    :ivar description: A description of the source control.
    :vartype description: str
    :ivar repo_type: The repository type of the source control. Known values are: "Github" and
     "DevOps".
    :vartype repo_type: str or ~azure.mgmt.securityinsight.models.RepoType
    :ivar content_types: Array of source control content types.
    :vartype content_types: list[str or ~azure.mgmt.securityinsight.models.ContentType]
    :ivar repository: Repository metadata.
    :vartype repository: ~azure.mgmt.securityinsight.models.Repository
    :ivar repository_resource_info: Information regarding the resources created in user's
     repository.
    :vartype repository_resource_info: ~azure.mgmt.securityinsight.models.RepositoryResourceInfo
    :ivar last_deployment_info: Information regarding the latest deployment for the source control.
    :vartype last_deployment_info: ~azure.mgmt.securityinsight.models.DeploymentInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "id_properties_id": {"key": "properties.id", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "repo_type": {"key": "properties.repoType", "type": "str"},
        "content_types": {"key": "properties.contentTypes", "type": "[str]"},
        "repository": {"key": "properties.repository", "type": "Repository"},
        "repository_resource_info": {"key": "properties.repositoryResourceInfo", "type": "RepositoryResourceInfo"},
        "last_deployment_info": {"key": "properties.lastDeploymentInfo", "type": "DeploymentInfo"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        id_properties_id: Optional[str] = None,
        version: Optional[Union[str, "_models.Version"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        repo_type: Optional[Union[str, "_models.RepoType"]] = None,
        content_types: Optional[List[Union[str, "_models.ContentType"]]] = None,
        repository: Optional["_models.Repository"] = None,
        repository_resource_info: Optional["_models.RepositoryResourceInfo"] = None,
        last_deployment_info: Optional["_models.DeploymentInfo"] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword id_properties_id: The id (a Guid) of the source control.
        :paramtype id_properties_id: str
        :keyword version: The version number associated with the source control. Known values are: "V1"
         and "V2".
        :paramtype version: str or ~azure.mgmt.securityinsight.models.Version
        :keyword display_name: The display name of the source control.
        :paramtype display_name: str
        :keyword description: A description of the source control.
        :paramtype description: str
        :keyword repo_type: The repository type of the source control. Known values are: "Github" and
         "DevOps".
        :paramtype repo_type: str or ~azure.mgmt.securityinsight.models.RepoType
        :keyword content_types: Array of source control content types.
        :paramtype content_types: list[str or ~azure.mgmt.securityinsight.models.ContentType]
        :keyword repository: Repository metadata.
        :paramtype repository: ~azure.mgmt.securityinsight.models.Repository
        :keyword repository_resource_info: Information regarding the resources created in user's
         repository.
        :paramtype repository_resource_info: ~azure.mgmt.securityinsight.models.RepositoryResourceInfo
        :keyword last_deployment_info: Information regarding the latest deployment for the source
         control.
        :paramtype last_deployment_info: ~azure.mgmt.securityinsight.models.DeploymentInfo
        """
        super().__init__(etag=etag, **kwargs)
        self.id_properties_id = id_properties_id
        self.version = version
        self.display_name = display_name
        self.description = description
        self.repo_type = repo_type
        self.content_types = content_types
        self.repository = repository
        self.repository_resource_info = repository_resource_info
        self.last_deployment_info = last_deployment_info


class SourceControlList(_serialization.Model):
    """List all the source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of source controls.
    :vartype next_link: str
    :ivar value: Array of source controls. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.SourceControl]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[SourceControl]"},
    }

    def __init__(self, *, value: List["_models.SourceControl"], **kwargs):
        """
        :keyword value: Array of source controls. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.SourceControl]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class SubmissionMailEntity(Entity):  # pylint: disable=too-many-instance-attributes
    """Represents a submission mail entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the entity. Required. Known values are: "Account", "Host", "File",
     "AzureResource", "CloudApplication", "DnsResolution", "FileHash", "Ip", "Malware", "Process",
     "RegistryKey", "RegistryValue", "SecurityGroup", "Url", "IoTDevice", "SecurityAlert",
     "Bookmark", "MailCluster", "MailMessage", "Mailbox", "SubmissionMail", and "Nic".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.EntityKind
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar network_message_id: The network message id of email to which submission belongs.
    :vartype network_message_id: str
    :ivar submission_id: The submission id.
    :vartype submission_id: str
    :ivar submitter: The submitter.
    :vartype submitter: str
    :ivar submission_date: The submission date.
    :vartype submission_date: ~datetime.datetime
    :ivar timestamp: The Time stamp when the message is received (Mail).
    :vartype timestamp: ~datetime.datetime
    :ivar recipient: The recipient of the mail.
    :vartype recipient: str
    :ivar sender: The sender of the mail.
    :vartype sender: str
    :ivar sender_ip: The sender's IP.
    :vartype sender_ip: str
    :ivar subject: The subject of submission mail.
    :vartype subject: str
    :ivar report_type: The submission type for the given instance. This maps to Junk, Phish,
     Malware or NotJunk.
    :vartype report_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "network_message_id": {"readonly": True},
        "submission_id": {"readonly": True},
        "submitter": {"readonly": True},
        "submission_date": {"readonly": True},
        "timestamp": {"readonly": True},
        "recipient": {"readonly": True},
        "sender": {"readonly": True},
        "sender_ip": {"readonly": True},
        "subject": {"readonly": True},
        "report_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "network_message_id": {"key": "properties.networkMessageId", "type": "str"},
        "submission_id": {"key": "properties.submissionId", "type": "str"},
        "submitter": {"key": "properties.submitter", "type": "str"},
        "submission_date": {"key": "properties.submissionDate", "type": "iso-8601"},
        "timestamp": {"key": "properties.timestamp", "type": "iso-8601"},
        "recipient": {"key": "properties.recipient", "type": "str"},
        "sender": {"key": "properties.sender", "type": "str"},
        "sender_ip": {"key": "properties.senderIp", "type": "str"},
        "subject": {"key": "properties.subject", "type": "str"},
        "report_type": {"key": "properties.reportType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind: str = "SubmissionMail"
        self.additional_data = None
        self.friendly_name = None
        self.network_message_id = None
        self.submission_id = None
        self.submitter = None
        self.submission_date = None
        self.timestamp = None
        self.recipient = None
        self.sender = None
        self.sender_ip = None
        self.subject = None
        self.report_type = None


class SubmissionMailEntityProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Submission mail entity property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar network_message_id: The network message id of email to which submission belongs.
    :vartype network_message_id: str
    :ivar submission_id: The submission id.
    :vartype submission_id: str
    :ivar submitter: The submitter.
    :vartype submitter: str
    :ivar submission_date: The submission date.
    :vartype submission_date: ~datetime.datetime
    :ivar timestamp: The Time stamp when the message is received (Mail).
    :vartype timestamp: ~datetime.datetime
    :ivar recipient: The recipient of the mail.
    :vartype recipient: str
    :ivar sender: The sender of the mail.
    :vartype sender: str
    :ivar sender_ip: The sender's IP.
    :vartype sender_ip: str
    :ivar subject: The subject of submission mail.
    :vartype subject: str
    :ivar report_type: The submission type for the given instance. This maps to Junk, Phish,
     Malware or NotJunk.
    :vartype report_type: str
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
        "network_message_id": {"readonly": True},
        "submission_id": {"readonly": True},
        "submitter": {"readonly": True},
        "submission_date": {"readonly": True},
        "timestamp": {"readonly": True},
        "recipient": {"readonly": True},
        "sender": {"readonly": True},
        "sender_ip": {"readonly": True},
        "subject": {"readonly": True},
        "report_type": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "network_message_id": {"key": "networkMessageId", "type": "str"},
        "submission_id": {"key": "submissionId", "type": "str"},
        "submitter": {"key": "submitter", "type": "str"},
        "submission_date": {"key": "submissionDate", "type": "iso-8601"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "recipient": {"key": "recipient", "type": "str"},
        "sender": {"key": "sender", "type": "str"},
        "sender_ip": {"key": "senderIp", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "report_type": {"key": "reportType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.network_message_id = None
        self.submission_id = None
        self.submitter = None
        self.submission_date = None
        self.timestamp = None
        self.recipient = None
        self.sender = None
        self.sender_ip = None
        self.subject = None
        self.report_type = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.securityinsight.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.securityinsight.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.securityinsight.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.securityinsight.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TeamInformation(_serialization.Model):
    """Describes team information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar team_id: Team ID.
    :vartype team_id: str
    :ivar primary_channel_url: The primary channel URL of the team.
    :vartype primary_channel_url: str
    :ivar team_creation_time_utc: The time the team was created.
    :vartype team_creation_time_utc: ~datetime.datetime
    :ivar name: The name of the team.
    :vartype name: str
    :ivar description: The description of the team.
    :vartype description: str
    """

    _validation = {
        "team_id": {"readonly": True},
        "primary_channel_url": {"readonly": True},
        "team_creation_time_utc": {"readonly": True},
        "name": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "team_id": {"key": "teamId", "type": "str"},
        "primary_channel_url": {"key": "primaryChannelUrl", "type": "str"},
        "team_creation_time_utc": {"key": "teamCreationTimeUtc", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.team_id = None
        self.primary_channel_url = None
        self.team_creation_time_utc = None
        self.name = None
        self.description = None


class TeamProperties(_serialization.Model):
    """Describes team properties.

    All required parameters must be populated in order to send to Azure.

    :ivar team_name: The name of the team. Required.
    :vartype team_name: str
    :ivar team_description: The description of the team.
    :vartype team_description: str
    :ivar group_ids: List of group IDs to add their members to the team.
    :vartype group_ids: list[str]
    :ivar member_ids: List of member IDs to add to the team.
    :vartype member_ids: list[str]
    """

    _validation = {
        "team_name": {"required": True},
    }

    _attribute_map = {
        "team_name": {"key": "teamName", "type": "str"},
        "team_description": {"key": "teamDescription", "type": "str"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
        "member_ids": {"key": "memberIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        team_name: str,
        team_description: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        member_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword team_name: The name of the team. Required.
        :paramtype team_name: str
        :keyword team_description: The description of the team.
        :paramtype team_description: str
        :keyword group_ids: List of group IDs to add their members to the team.
        :paramtype group_ids: list[str]
        :keyword member_ids: List of member IDs to add to the team.
        :paramtype member_ids: list[str]
        """
        super().__init__(**kwargs)
        self.team_name = team_name
        self.team_description = team_description
        self.group_ids = group_ids
        self.member_ids = member_ids


class ThreatIntelligence(_serialization.Model):
    """ThreatIntelligence property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar confidence: Confidence (must be between 0 and 1).
    :vartype confidence: float
    :ivar provider_name: Name of the provider from whom this Threat Intelligence information was
     received.
    :vartype provider_name: str
    :ivar report_link: Report link.
    :vartype report_link: str
    :ivar threat_description: Threat description (free text).
    :vartype threat_description: str
    :ivar threat_name: Threat name (e.g. "Jedobot malware").
    :vartype threat_name: str
    :ivar threat_type: Threat type (e.g. "Botnet").
    :vartype threat_type: str
    """

    _validation = {
        "confidence": {"readonly": True},
        "provider_name": {"readonly": True},
        "report_link": {"readonly": True},
        "threat_description": {"readonly": True},
        "threat_name": {"readonly": True},
        "threat_type": {"readonly": True},
    }

    _attribute_map = {
        "confidence": {"key": "confidence", "type": "float"},
        "provider_name": {"key": "providerName", "type": "str"},
        "report_link": {"key": "reportLink", "type": "str"},
        "threat_description": {"key": "threatDescription", "type": "str"},
        "threat_name": {"key": "threatName", "type": "str"},
        "threat_type": {"key": "threatType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.confidence = None
        self.provider_name = None
        self.report_link = None
        self.threat_description = None
        self.threat_name = None
        self.threat_type = None


class ThreatIntelligenceAlertRule(AlertRule):  # pylint: disable=too-many-instance-attributes
    """Represents Threat Intelligence alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :vartype alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :ivar enabled: Determines whether this alert rule is enabled or disabled.
    :vartype enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "description": {"readonly": True},
        "display_name": {"readonly": True},
        "last_modified_utc": {"readonly": True},
        "severity": {"readonly": True},
        "tactics": {"readonly": True},
        "techniques": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rule_template_name": {"key": "properties.alertRuleTemplateName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "severity": {"key": "properties.severity", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword alert_rule_template_name: The Name of the alert rule template used to create this
         rule.
        :paramtype alert_rule_template_name: str
        :keyword enabled: Determines whether this alert rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "ThreatIntelligence"
        self.alert_rule_template_name = alert_rule_template_name
        self.description = None
        self.display_name = None
        self.enabled = enabled
        self.last_modified_utc = None
        self.severity = None
        self.tactics = None
        self.techniques = None


class ThreatIntelligenceAlertRuleTemplate(AlertRuleTemplate):  # pylint: disable=too-many-instance-attributes
    """Represents Threat Intelligence alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar kind: The kind of the alert rule. Required. Known values are: "Scheduled",
     "MicrosoftSecurityIncidentCreation", "Fusion", "MLBehaviorAnalytics", "ThreatIntelligence", and
     "NRT".
    :vartype kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar severity: The severity for alerts created by this alert rule. Known values are: "High",
     "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "alert_rules_created_by_template_count": {"key": "properties.alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "properties.lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "properties.createdDateUTC", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "required_data_connectors": {
            "key": "properties.requiredDataConnectors",
            "type": "[AlertRuleTemplateDataSource]",
        },
        "status": {"key": "properties.status", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        severity: Optional[Union[str, "_models.AlertSeverity"]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword severity: The severity for alerts created by this alert rule. Known values are:
         "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super().__init__(**kwargs)
        self.kind: str = "ThreatIntelligence"
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.last_updated_date_utc = None
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.tactics = tactics
        self.techniques = techniques
        self.severity = severity


class ThreatIntelligenceAlertRuleTemplateProperties(AlertRuleTemplateWithMitreProperties):
    """Threat Intelligence alert rule template properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :vartype alert_rules_created_by_template_count: int
    :ivar last_updated_date_utc: The last time that this alert rule template has been updated.
    :vartype last_updated_date_utc: ~datetime.datetime
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :ivar description: The description of the alert rule template.
    :vartype description: str
    :ivar display_name: The display name for alert rule template.
    :vartype display_name: str
    :ivar required_data_connectors: The required data sources for this template.
    :vartype required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :ivar status: The alert rule template status. Known values are: "Installed", "Available", and
     "NotAvailable".
    :vartype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    :ivar techniques: The techniques of the alert rule.
    :vartype techniques: list[str]
    :ivar severity: The severity for alerts created by this alert rule. Required. Known values are:
     "High", "Medium", "Low", and "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    """

    _validation = {
        "last_updated_date_utc": {"readonly": True},
        "created_date_utc": {"readonly": True},
        "severity": {"required": True},
    }

    _attribute_map = {
        "alert_rules_created_by_template_count": {"key": "alertRulesCreatedByTemplateCount", "type": "int"},
        "last_updated_date_utc": {"key": "lastUpdatedDateUTC", "type": "iso-8601"},
        "created_date_utc": {"key": "createdDateUTC", "type": "iso-8601"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "required_data_connectors": {"key": "requiredDataConnectors", "type": "[AlertRuleTemplateDataSource]"},
        "status": {"key": "status", "type": "str"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "techniques": {"key": "techniques", "type": "[str]"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(
        self,
        *,
        severity: Union[str, "_models.AlertSeverity"],
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["_models.AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "_models.TemplateStatus"]] = None,
        tactics: Optional[List[Union[str, "_models.AttackTactic"]]] = None,
        techniques: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword alert_rules_created_by_template_count: the number of alert rules that were created by
         this template.
        :paramtype alert_rules_created_by_template_count: int
        :keyword description: The description of the alert rule template.
        :paramtype description: str
        :keyword display_name: The display name for alert rule template.
        :paramtype display_name: str
        :keyword required_data_connectors: The required data sources for this template.
        :paramtype required_data_connectors:
         list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
        :keyword status: The alert rule template status. Known values are: "Installed", "Available",
         and "NotAvailable".
        :paramtype status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
        :keyword tactics: The tactics of the alert rule.
        :paramtype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
        :keyword techniques: The techniques of the alert rule.
        :paramtype techniques: list[str]
        :keyword severity: The severity for alerts created by this alert rule. Required. Known values
         are: "High", "Medium", "Low", and "Informational".
        :paramtype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
        """
        super().__init__(
            alert_rules_created_by_template_count=alert_rules_created_by_template_count,
            description=description,
            display_name=display_name,
            required_data_connectors=required_data_connectors,
            status=status,
            tactics=tactics,
            techniques=techniques,
            **kwargs
        )
        self.severity = severity


class ThreatIntelligenceAppendTags(_serialization.Model):
    """Array of tags to be appended to the threat intelligence indicator.

    :ivar threat_intelligence_tags: List of tags to be appended.
    :vartype threat_intelligence_tags: list[str]
    """

    _attribute_map = {
        "threat_intelligence_tags": {"key": "threatIntelligenceTags", "type": "[str]"},
    }

    def __init__(self, *, threat_intelligence_tags: Optional[List[str]] = None, **kwargs):
        """
        :keyword threat_intelligence_tags: List of tags to be appended.
        :paramtype threat_intelligence_tags: list[str]
        """
        super().__init__(**kwargs)
        self.threat_intelligence_tags = threat_intelligence_tags


class ThreatIntelligenceExternalReference(_serialization.Model):
    """Describes external reference.

    :ivar description: External reference description.
    :vartype description: str
    :ivar external_id: External reference ID.
    :vartype external_id: str
    :ivar source_name: External reference source name.
    :vartype source_name: str
    :ivar url: External reference URL.
    :vartype url: str
    :ivar hashes: External reference hashes.
    :vartype hashes: dict[str, str]
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "external_id": {"key": "externalId", "type": "str"},
        "source_name": {"key": "sourceName", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "hashes": {"key": "hashes", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        external_id: Optional[str] = None,
        source_name: Optional[str] = None,
        url: Optional[str] = None,
        hashes: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: External reference description.
        :paramtype description: str
        :keyword external_id: External reference ID.
        :paramtype external_id: str
        :keyword source_name: External reference source name.
        :paramtype source_name: str
        :keyword url: External reference URL.
        :paramtype url: str
        :keyword hashes: External reference hashes.
        :paramtype hashes: dict[str, str]
        """
        super().__init__(**kwargs)
        self.description = description
        self.external_id = external_id
        self.source_name = source_name
        self.url = url
        self.hashes = hashes


class ThreatIntelligenceFilteringCriteria(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Filtering criteria for querying threat intelligence indicators.

    :ivar page_size: Page size.
    :vartype page_size: int
    :ivar min_confidence: Minimum confidence.
    :vartype min_confidence: int
    :ivar max_confidence: Maximum confidence.
    :vartype max_confidence: int
    :ivar min_valid_until: Start time for ValidUntil filter.
    :vartype min_valid_until: str
    :ivar max_valid_until: End time for ValidUntil filter.
    :vartype max_valid_until: str
    :ivar include_disabled: Parameter to include/exclude disabled indicators.
    :vartype include_disabled: bool
    :ivar sort_by: Columns to sort by and sorting order.
    :vartype sort_by: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceSortingCriteria]
    :ivar sources: Sources of threat intelligence indicators.
    :vartype sources: list[str]
    :ivar pattern_types: Pattern types.
    :vartype pattern_types: list[str]
    :ivar threat_types: Threat types of threat intelligence indicators.
    :vartype threat_types: list[str]
    :ivar ids: Ids of threat intelligence indicators.
    :vartype ids: list[str]
    :ivar keywords: Keywords for searching threat intelligence indicators.
    :vartype keywords: list[str]
    :ivar skip_token: Skip token.
    :vartype skip_token: str
    """

    _attribute_map = {
        "page_size": {"key": "pageSize", "type": "int"},
        "min_confidence": {"key": "minConfidence", "type": "int"},
        "max_confidence": {"key": "maxConfidence", "type": "int"},
        "min_valid_until": {"key": "minValidUntil", "type": "str"},
        "max_valid_until": {"key": "maxValidUntil", "type": "str"},
        "include_disabled": {"key": "includeDisabled", "type": "bool"},
        "sort_by": {"key": "sortBy", "type": "[ThreatIntelligenceSortingCriteria]"},
        "sources": {"key": "sources", "type": "[str]"},
        "pattern_types": {"key": "patternTypes", "type": "[str]"},
        "threat_types": {"key": "threatTypes", "type": "[str]"},
        "ids": {"key": "ids", "type": "[str]"},
        "keywords": {"key": "keywords", "type": "[str]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        page_size: Optional[int] = None,
        min_confidence: Optional[int] = None,
        max_confidence: Optional[int] = None,
        min_valid_until: Optional[str] = None,
        max_valid_until: Optional[str] = None,
        include_disabled: Optional[bool] = None,
        sort_by: Optional[List["_models.ThreatIntelligenceSortingCriteria"]] = None,
        sources: Optional[List[str]] = None,
        pattern_types: Optional[List[str]] = None,
        threat_types: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        keywords: Optional[List[str]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword page_size: Page size.
        :paramtype page_size: int
        :keyword min_confidence: Minimum confidence.
        :paramtype min_confidence: int
        :keyword max_confidence: Maximum confidence.
        :paramtype max_confidence: int
        :keyword min_valid_until: Start time for ValidUntil filter.
        :paramtype min_valid_until: str
        :keyword max_valid_until: End time for ValidUntil filter.
        :paramtype max_valid_until: str
        :keyword include_disabled: Parameter to include/exclude disabled indicators.
        :paramtype include_disabled: bool
        :keyword sort_by: Columns to sort by and sorting order.
        :paramtype sort_by: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceSortingCriteria]
        :keyword sources: Sources of threat intelligence indicators.
        :paramtype sources: list[str]
        :keyword pattern_types: Pattern types.
        :paramtype pattern_types: list[str]
        :keyword threat_types: Threat types of threat intelligence indicators.
        :paramtype threat_types: list[str]
        :keyword ids: Ids of threat intelligence indicators.
        :paramtype ids: list[str]
        :keyword keywords: Keywords for searching threat intelligence indicators.
        :paramtype keywords: list[str]
        :keyword skip_token: Skip token.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.page_size = page_size
        self.min_confidence = min_confidence
        self.max_confidence = max_confidence
        self.min_valid_until = min_valid_until
        self.max_valid_until = max_valid_until
        self.include_disabled = include_disabled
        self.sort_by = sort_by
        self.sources = sources
        self.pattern_types = pattern_types
        self.threat_types = threat_types
        self.ids = ids
        self.keywords = keywords
        self.skip_token = skip_token


class ThreatIntelligenceGranularMarkingModel(_serialization.Model):
    """Describes threat granular marking model entity.

    :ivar language: Language granular marking model.
    :vartype language: str
    :ivar marking_ref: marking reference granular marking model.
    :vartype marking_ref: int
    :ivar selectors: granular marking model selectors.
    :vartype selectors: list[str]
    """

    _attribute_map = {
        "language": {"key": "language", "type": "str"},
        "marking_ref": {"key": "markingRef", "type": "int"},
        "selectors": {"key": "selectors", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        language: Optional[str] = None,
        marking_ref: Optional[int] = None,
        selectors: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword language: Language granular marking model.
        :paramtype language: str
        :keyword marking_ref: marking reference granular marking model.
        :paramtype marking_ref: int
        :keyword selectors: granular marking model selectors.
        :paramtype selectors: list[str]
        """
        super().__init__(**kwargs)
        self.language = language
        self.marking_ref = marking_ref
        self.selectors = selectors


class ThreatIntelligenceInformation(ResourceWithEtag):
    """Threat intelligence information object.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ThreatIntelligenceIndicatorModel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the entity. Required. "indicator"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.ThreatIntelligenceResourceKindEnum
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"indicator": "ThreatIntelligenceIndicatorModel"}}

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: Optional[str] = None


class ThreatIntelligenceIndicatorModel(ThreatIntelligenceInformation):  # pylint: disable=too-many-instance-attributes
    """Threat intelligence indicator entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securityinsight.models.SystemData
    :ivar etag: Etag of the azure resource.
    :vartype etag: str
    :ivar kind: The kind of the entity. Required. "indicator"
    :vartype kind: str or ~azure.mgmt.securityinsight.models.ThreatIntelligenceResourceKindEnum
    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar threat_intelligence_tags: List of tags.
    :vartype threat_intelligence_tags: list[str]
    :ivar last_updated_time_utc: Last updated time in UTC.
    :vartype last_updated_time_utc: str
    :ivar source: Source of a threat intelligence entity.
    :vartype source: str
    :ivar display_name: Display name of a threat intelligence entity.
    :vartype display_name: str
    :ivar description: Description of a threat intelligence entity.
    :vartype description: str
    :ivar indicator_types: Indicator types of threat intelligence entities.
    :vartype indicator_types: list[str]
    :ivar pattern: Pattern of a threat intelligence entity.
    :vartype pattern: str
    :ivar pattern_type: Pattern type of a threat intelligence entity.
    :vartype pattern_type: str
    :ivar pattern_version: Pattern version of a threat intelligence entity.
    :vartype pattern_version: str
    :ivar kill_chain_phases: Kill chain phases.
    :vartype kill_chain_phases:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceKillChainPhase]
    :ivar parsed_pattern: Parsed patterns.
    :vartype parsed_pattern:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPattern]
    :ivar external_id: External ID of threat intelligence entity.
    :vartype external_id: str
    :ivar created_by_ref: Created by reference of threat intelligence entity.
    :vartype created_by_ref: str
    :ivar defanged: Is threat intelligence entity defanged.
    :vartype defanged: bool
    :ivar external_last_updated_time_utc: External last updated time in UTC.
    :vartype external_last_updated_time_utc: str
    :ivar external_references: External References.
    :vartype external_references:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceExternalReference]
    :ivar granular_markings: Granular Markings.
    :vartype granular_markings:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceGranularMarkingModel]
    :ivar labels: Labels  of threat intelligence entity.
    :vartype labels: list[str]
    :ivar revoked: Is threat intelligence entity revoked.
    :vartype revoked: bool
    :ivar confidence: Confidence of threat intelligence entity.
    :vartype confidence: int
    :ivar object_marking_refs: Threat intelligence entity object marking references.
    :vartype object_marking_refs: list[str]
    :ivar language: Language of threat intelligence entity.
    :vartype language: str
    :ivar threat_types: Threat types.
    :vartype threat_types: list[str]
    :ivar valid_from: Valid from.
    :vartype valid_from: str
    :ivar valid_until: Valid until.
    :vartype valid_until: str
    :ivar created: Created by.
    :vartype created: str
    :ivar modified: Modified by.
    :vartype modified: str
    :ivar extensions: Extensions map.
    :vartype extensions: dict[str, any]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{object}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "threat_intelligence_tags": {"key": "properties.threatIntelligenceTags", "type": "[str]"},
        "last_updated_time_utc": {"key": "properties.lastUpdatedTimeUtc", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "indicator_types": {"key": "properties.indicatorTypes", "type": "[str]"},
        "pattern": {"key": "properties.pattern", "type": "str"},
        "pattern_type": {"key": "properties.patternType", "type": "str"},
        "pattern_version": {"key": "properties.patternVersion", "type": "str"},
        "kill_chain_phases": {"key": "properties.killChainPhases", "type": "[ThreatIntelligenceKillChainPhase]"},
        "parsed_pattern": {"key": "properties.parsedPattern", "type": "[ThreatIntelligenceParsedPattern]"},
        "external_id": {"key": "properties.externalId", "type": "str"},
        "created_by_ref": {"key": "properties.createdByRef", "type": "str"},
        "defanged": {"key": "properties.defanged", "type": "bool"},
        "external_last_updated_time_utc": {"key": "properties.externalLastUpdatedTimeUtc", "type": "str"},
        "external_references": {
            "key": "properties.externalReferences",
            "type": "[ThreatIntelligenceExternalReference]",
        },
        "granular_markings": {"key": "properties.granularMarkings", "type": "[ThreatIntelligenceGranularMarkingModel]"},
        "labels": {"key": "properties.labels", "type": "[str]"},
        "revoked": {"key": "properties.revoked", "type": "bool"},
        "confidence": {"key": "properties.confidence", "type": "int"},
        "object_marking_refs": {"key": "properties.objectMarkingRefs", "type": "[str]"},
        "language": {"key": "properties.language", "type": "str"},
        "threat_types": {"key": "properties.threatTypes", "type": "[str]"},
        "valid_from": {"key": "properties.validFrom", "type": "str"},
        "valid_until": {"key": "properties.validUntil", "type": "str"},
        "created": {"key": "properties.created", "type": "str"},
        "modified": {"key": "properties.modified", "type": "str"},
        "extensions": {"key": "properties.extensions", "type": "{object}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        etag: Optional[str] = None,
        threat_intelligence_tags: Optional[List[str]] = None,
        last_updated_time_utc: Optional[str] = None,
        source: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        indicator_types: Optional[List[str]] = None,
        pattern: Optional[str] = None,
        pattern_type: Optional[str] = None,
        pattern_version: Optional[str] = None,
        kill_chain_phases: Optional[List["_models.ThreatIntelligenceKillChainPhase"]] = None,
        parsed_pattern: Optional[List["_models.ThreatIntelligenceParsedPattern"]] = None,
        external_id: Optional[str] = None,
        created_by_ref: Optional[str] = None,
        defanged: Optional[bool] = None,
        external_last_updated_time_utc: Optional[str] = None,
        external_references: Optional[List["_models.ThreatIntelligenceExternalReference"]] = None,
        granular_markings: Optional[List["_models.ThreatIntelligenceGranularMarkingModel"]] = None,
        labels: Optional[List[str]] = None,
        revoked: Optional[bool] = None,
        confidence: Optional[int] = None,
        object_marking_refs: Optional[List[str]] = None,
        language: Optional[str] = None,
        threat_types: Optional[List[str]] = None,
        valid_from: Optional[str] = None,
        valid_until: Optional[str] = None,
        created: Optional[str] = None,
        modified: Optional[str] = None,
        extensions: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword etag: Etag of the azure resource.
        :paramtype etag: str
        :keyword threat_intelligence_tags: List of tags.
        :paramtype threat_intelligence_tags: list[str]
        :keyword last_updated_time_utc: Last updated time in UTC.
        :paramtype last_updated_time_utc: str
        :keyword source: Source of a threat intelligence entity.
        :paramtype source: str
        :keyword display_name: Display name of a threat intelligence entity.
        :paramtype display_name: str
        :keyword description: Description of a threat intelligence entity.
        :paramtype description: str
        :keyword indicator_types: Indicator types of threat intelligence entities.
        :paramtype indicator_types: list[str]
        :keyword pattern: Pattern of a threat intelligence entity.
        :paramtype pattern: str
        :keyword pattern_type: Pattern type of a threat intelligence entity.
        :paramtype pattern_type: str
        :keyword pattern_version: Pattern version of a threat intelligence entity.
        :paramtype pattern_version: str
        :keyword kill_chain_phases: Kill chain phases.
        :paramtype kill_chain_phases:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceKillChainPhase]
        :keyword parsed_pattern: Parsed patterns.
        :paramtype parsed_pattern:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPattern]
        :keyword external_id: External ID of threat intelligence entity.
        :paramtype external_id: str
        :keyword created_by_ref: Created by reference of threat intelligence entity.
        :paramtype created_by_ref: str
        :keyword defanged: Is threat intelligence entity defanged.
        :paramtype defanged: bool
        :keyword external_last_updated_time_utc: External last updated time in UTC.
        :paramtype external_last_updated_time_utc: str
        :keyword external_references: External References.
        :paramtype external_references:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceExternalReference]
        :keyword granular_markings: Granular Markings.
        :paramtype granular_markings:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceGranularMarkingModel]
        :keyword labels: Labels  of threat intelligence entity.
        :paramtype labels: list[str]
        :keyword revoked: Is threat intelligence entity revoked.
        :paramtype revoked: bool
        :keyword confidence: Confidence of threat intelligence entity.
        :paramtype confidence: int
        :keyword object_marking_refs: Threat intelligence entity object marking references.
        :paramtype object_marking_refs: list[str]
        :keyword language: Language of threat intelligence entity.
        :paramtype language: str
        :keyword threat_types: Threat types.
        :paramtype threat_types: list[str]
        :keyword valid_from: Valid from.
        :paramtype valid_from: str
        :keyword valid_until: Valid until.
        :paramtype valid_until: str
        :keyword created: Created by.
        :paramtype created: str
        :keyword modified: Modified by.
        :paramtype modified: str
        :keyword extensions: Extensions map.
        :paramtype extensions: dict[str, any]
        """
        super().__init__(etag=etag, **kwargs)
        self.kind: str = "indicator"
        self.additional_data = None
        self.friendly_name = None
        self.threat_intelligence_tags = threat_intelligence_tags
        self.last_updated_time_utc = last_updated_time_utc
        self.source = source
        self.display_name = display_name
        self.description = description
        self.indicator_types = indicator_types
        self.pattern = pattern
        self.pattern_type = pattern_type
        self.pattern_version = pattern_version
        self.kill_chain_phases = kill_chain_phases
        self.parsed_pattern = parsed_pattern
        self.external_id = external_id
        self.created_by_ref = created_by_ref
        self.defanged = defanged
        self.external_last_updated_time_utc = external_last_updated_time_utc
        self.external_references = external_references
        self.granular_markings = granular_markings
        self.labels = labels
        self.revoked = revoked
        self.confidence = confidence
        self.object_marking_refs = object_marking_refs
        self.language = language
        self.threat_types = threat_types
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.created = created
        self.modified = modified
        self.extensions = extensions


class ThreatIntelligenceIndicatorProperties(EntityCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Describes threat intelligence entity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_data: A bag of custom fields that should be part of the entity and will be
     presented to the user.
    :vartype additional_data: dict[str, any]
    :ivar friendly_name: The graph item display name which is a short humanly readable description
     of the graph item instance. This property is optional and might be system generated.
    :vartype friendly_name: str
    :ivar threat_intelligence_tags: List of tags.
    :vartype threat_intelligence_tags: list[str]
    :ivar last_updated_time_utc: Last updated time in UTC.
    :vartype last_updated_time_utc: str
    :ivar source: Source of a threat intelligence entity.
    :vartype source: str
    :ivar display_name: Display name of a threat intelligence entity.
    :vartype display_name: str
    :ivar description: Description of a threat intelligence entity.
    :vartype description: str
    :ivar indicator_types: Indicator types of threat intelligence entities.
    :vartype indicator_types: list[str]
    :ivar pattern: Pattern of a threat intelligence entity.
    :vartype pattern: str
    :ivar pattern_type: Pattern type of a threat intelligence entity.
    :vartype pattern_type: str
    :ivar pattern_version: Pattern version of a threat intelligence entity.
    :vartype pattern_version: str
    :ivar kill_chain_phases: Kill chain phases.
    :vartype kill_chain_phases:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceKillChainPhase]
    :ivar parsed_pattern: Parsed patterns.
    :vartype parsed_pattern:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPattern]
    :ivar external_id: External ID of threat intelligence entity.
    :vartype external_id: str
    :ivar created_by_ref: Created by reference of threat intelligence entity.
    :vartype created_by_ref: str
    :ivar defanged: Is threat intelligence entity defanged.
    :vartype defanged: bool
    :ivar external_last_updated_time_utc: External last updated time in UTC.
    :vartype external_last_updated_time_utc: str
    :ivar external_references: External References.
    :vartype external_references:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceExternalReference]
    :ivar granular_markings: Granular Markings.
    :vartype granular_markings:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceGranularMarkingModel]
    :ivar labels: Labels  of threat intelligence entity.
    :vartype labels: list[str]
    :ivar revoked: Is threat intelligence entity revoked.
    :vartype revoked: bool
    :ivar confidence: Confidence of threat intelligence entity.
    :vartype confidence: int
    :ivar object_marking_refs: Threat intelligence entity object marking references.
    :vartype object_marking_refs: list[str]
    :ivar language: Language of threat intelligence entity.
    :vartype language: str
    :ivar threat_types: Threat types.
    :vartype threat_types: list[str]
    :ivar valid_from: Valid from.
    :vartype valid_from: str
    :ivar valid_until: Valid until.
    :vartype valid_until: str
    :ivar created: Created by.
    :vartype created: str
    :ivar modified: Modified by.
    :vartype modified: str
    :ivar extensions: Extensions map.
    :vartype extensions: dict[str, any]
    """

    _validation = {
        "additional_data": {"readonly": True},
        "friendly_name": {"readonly": True},
    }

    _attribute_map = {
        "additional_data": {"key": "additionalData", "type": "{object}"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "threat_intelligence_tags": {"key": "threatIntelligenceTags", "type": "[str]"},
        "last_updated_time_utc": {"key": "lastUpdatedTimeUtc", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "indicator_types": {"key": "indicatorTypes", "type": "[str]"},
        "pattern": {"key": "pattern", "type": "str"},
        "pattern_type": {"key": "patternType", "type": "str"},
        "pattern_version": {"key": "patternVersion", "type": "str"},
        "kill_chain_phases": {"key": "killChainPhases", "type": "[ThreatIntelligenceKillChainPhase]"},
        "parsed_pattern": {"key": "parsedPattern", "type": "[ThreatIntelligenceParsedPattern]"},
        "external_id": {"key": "externalId", "type": "str"},
        "created_by_ref": {"key": "createdByRef", "type": "str"},
        "defanged": {"key": "defanged", "type": "bool"},
        "external_last_updated_time_utc": {"key": "externalLastUpdatedTimeUtc", "type": "str"},
        "external_references": {"key": "externalReferences", "type": "[ThreatIntelligenceExternalReference]"},
        "granular_markings": {"key": "granularMarkings", "type": "[ThreatIntelligenceGranularMarkingModel]"},
        "labels": {"key": "labels", "type": "[str]"},
        "revoked": {"key": "revoked", "type": "bool"},
        "confidence": {"key": "confidence", "type": "int"},
        "object_marking_refs": {"key": "objectMarkingRefs", "type": "[str]"},
        "language": {"key": "language", "type": "str"},
        "threat_types": {"key": "threatTypes", "type": "[str]"},
        "valid_from": {"key": "validFrom", "type": "str"},
        "valid_until": {"key": "validUntil", "type": "str"},
        "created": {"key": "created", "type": "str"},
        "modified": {"key": "modified", "type": "str"},
        "extensions": {"key": "extensions", "type": "{object}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        threat_intelligence_tags: Optional[List[str]] = None,
        last_updated_time_utc: Optional[str] = None,
        source: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        indicator_types: Optional[List[str]] = None,
        pattern: Optional[str] = None,
        pattern_type: Optional[str] = None,
        pattern_version: Optional[str] = None,
        kill_chain_phases: Optional[List["_models.ThreatIntelligenceKillChainPhase"]] = None,
        parsed_pattern: Optional[List["_models.ThreatIntelligenceParsedPattern"]] = None,
        external_id: Optional[str] = None,
        created_by_ref: Optional[str] = None,
        defanged: Optional[bool] = None,
        external_last_updated_time_utc: Optional[str] = None,
        external_references: Optional[List["_models.ThreatIntelligenceExternalReference"]] = None,
        granular_markings: Optional[List["_models.ThreatIntelligenceGranularMarkingModel"]] = None,
        labels: Optional[List[str]] = None,
        revoked: Optional[bool] = None,
        confidence: Optional[int] = None,
        object_marking_refs: Optional[List[str]] = None,
        language: Optional[str] = None,
        threat_types: Optional[List[str]] = None,
        valid_from: Optional[str] = None,
        valid_until: Optional[str] = None,
        created: Optional[str] = None,
        modified: Optional[str] = None,
        extensions: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword threat_intelligence_tags: List of tags.
        :paramtype threat_intelligence_tags: list[str]
        :keyword last_updated_time_utc: Last updated time in UTC.
        :paramtype last_updated_time_utc: str
        :keyword source: Source of a threat intelligence entity.
        :paramtype source: str
        :keyword display_name: Display name of a threat intelligence entity.
        :paramtype display_name: str
        :keyword description: Description of a threat intelligence entity.
        :paramtype description: str
        :keyword indicator_types: Indicator types of threat intelligence entities.
        :paramtype indicator_types: list[str]
        :keyword pattern: Pattern of a threat intelligence entity.
        :paramtype pattern: str
        :keyword pattern_type: Pattern type of a threat intelligence entity.
        :paramtype pattern_type: str
        :keyword pattern_version: Pattern version of a threat intelligence entity.
        :paramtype pattern_version: str
        :keyword kill_chain_phases: Kill chain phases.
        :paramtype kill_chain_phases:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceKillChainPhase]
        :keyword parsed_pattern: Parsed patterns.
        :paramtype parsed_pattern:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceParsedPattern]
        :keyword external_id: External ID of threat intelligence entity.
        :paramtype external_id: str
        :keyword created_by_ref: Created by reference of threat intelligence entity.
        :paramtype created_by_ref: str
        :keyword defanged: Is threat intelligence entity defanged.
        :paramtype defanged: bool
        :keyword external_last_updated_time_utc: External last updated time in UTC.
        :paramtype external_last_updated_time_utc: str
        :keyword external_references: External References.
        :paramtype external_references:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceExternalReference]
        :keyword granular_markings: Granular Markings.
        :paramtype granular_markings:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceGranularMarkingModel]
        :keyword labels: Labels  of threat intelligence entity.
        :paramtype labels: list[str]
        :keyword revoked: Is threat intelligence entity revoked.
        :paramtype revoked: bool
        :keyword confidence: Confidence of threat intelligence entity.
        :paramtype confidence: int
        :keyword object_marking_refs: Threat intelligence entity object marking references.
        :paramtype object_marking_refs: list[str]
        :keyword language: Language of threat intelligence entity.
        :paramtype language: str
        :keyword threat_types: Threat types.
        :paramtype threat_types: list[str]
        :keyword valid_from: Valid from.
        :paramtype valid_from: str
        :keyword valid_until: Valid until.
        :paramtype valid_until: str
        :keyword created: Created by.
        :paramtype created: str
        :keyword modified: Modified by.
        :paramtype modified: str
        :keyword extensions: Extensions map.
        :paramtype extensions: dict[str, any]
        """
        super().__init__(**kwargs)
        self.threat_intelligence_tags = threat_intelligence_tags
        self.last_updated_time_utc = last_updated_time_utc
        self.source = source
        self.display_name = display_name
        self.description = description
        self.indicator_types = indicator_types
        self.pattern = pattern
        self.pattern_type = pattern_type
        self.pattern_version = pattern_version
        self.kill_chain_phases = kill_chain_phases
        self.parsed_pattern = parsed_pattern
        self.external_id = external_id
        self.created_by_ref = created_by_ref
        self.defanged = defanged
        self.external_last_updated_time_utc = external_last_updated_time_utc
        self.external_references = external_references
        self.granular_markings = granular_markings
        self.labels = labels
        self.revoked = revoked
        self.confidence = confidence
        self.object_marking_refs = object_marking_refs
        self.language = language
        self.threat_types = threat_types
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.created = created
        self.modified = modified
        self.extensions = extensions


class ThreatIntelligenceInformationList(_serialization.Model):
    """List of all the threat intelligence information objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of information objects.
    :vartype next_link: str
    :ivar value: Array of threat intelligence information objects. Required.
    :vartype value: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ThreatIntelligenceInformation]"},
    }

    def __init__(self, *, value: List["_models.ThreatIntelligenceInformation"], **kwargs):
        """
        :keyword value: Array of threat intelligence information objects. Required.
        :paramtype value: list[~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class ThreatIntelligenceKillChainPhase(_serialization.Model):
    """Describes threat kill chain phase entity.

    :ivar kill_chain_name: Kill chainName name.
    :vartype kill_chain_name: str
    :ivar phase_name: Phase name.
    :vartype phase_name: str
    """

    _attribute_map = {
        "kill_chain_name": {"key": "killChainName", "type": "str"},
        "phase_name": {"key": "phaseName", "type": "str"},
    }

    def __init__(self, *, kill_chain_name: Optional[str] = None, phase_name: Optional[str] = None, **kwargs):
        """
        :keyword kill_chain_name: Kill chainName name.
        :paramtype kill_chain_name: str
        :keyword phase_name: Phase name.
        :paramtype phase_name: str
        """
        super().__init__(**kwargs)
        self.kill_chain_name = kill_chain_name
        self.phase_name = phase_name


class ThreatIntelligenceMetric(_serialization.Model):
    """Describes threat intelligence metric.

    :ivar last_updated_time_utc: Last updated indicator metric.
    :vartype last_updated_time_utc: str
    :ivar threat_type_metrics: Threat type metrics.
    :vartype threat_type_metrics:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
    :ivar pattern_type_metrics: Pattern type metrics.
    :vartype pattern_type_metrics:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
    :ivar source_metrics: Source metrics.
    :vartype source_metrics:
     list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
    """

    _attribute_map = {
        "last_updated_time_utc": {"key": "lastUpdatedTimeUtc", "type": "str"},
        "threat_type_metrics": {"key": "threatTypeMetrics", "type": "[ThreatIntelligenceMetricEntity]"},
        "pattern_type_metrics": {"key": "patternTypeMetrics", "type": "[ThreatIntelligenceMetricEntity]"},
        "source_metrics": {"key": "sourceMetrics", "type": "[ThreatIntelligenceMetricEntity]"},
    }

    def __init__(
        self,
        *,
        last_updated_time_utc: Optional[str] = None,
        threat_type_metrics: Optional[List["_models.ThreatIntelligenceMetricEntity"]] = None,
        pattern_type_metrics: Optional[List["_models.ThreatIntelligenceMetricEntity"]] = None,
        source_metrics: Optional[List["_models.ThreatIntelligenceMetricEntity"]] = None,
        **kwargs
    ):
        """
        :keyword last_updated_time_utc: Last updated indicator metric.
        :paramtype last_updated_time_utc: str
        :keyword threat_type_metrics: Threat type metrics.
        :paramtype threat_type_metrics:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
        :keyword pattern_type_metrics: Pattern type metrics.
        :paramtype pattern_type_metrics:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
        :keyword source_metrics: Source metrics.
        :paramtype source_metrics:
         list[~azure.mgmt.securityinsight.models.ThreatIntelligenceMetricEntity]
        """
        super().__init__(**kwargs)
        self.last_updated_time_utc = last_updated_time_utc
        self.threat_type_metrics = threat_type_metrics
        self.pattern_type_metrics = pattern_type_metrics
        self.source_metrics = source_metrics


class ThreatIntelligenceMetricEntity(_serialization.Model):
    """Describes threat intelligence metric entity.

    :ivar metric_name: Metric name.
    :vartype metric_name: str
    :ivar metric_value: Metric value.
    :vartype metric_value: int
    """

    _attribute_map = {
        "metric_name": {"key": "metricName", "type": "str"},
        "metric_value": {"key": "metricValue", "type": "int"},
    }

    def __init__(self, *, metric_name: Optional[str] = None, metric_value: Optional[int] = None, **kwargs):
        """
        :keyword metric_name: Metric name.
        :paramtype metric_name: str
        :keyword metric_value: Metric value.
        :paramtype metric_value: int
        """
        super().__init__(**kwargs)
        self.metric_name = metric_name
        self.metric_value = metric_value


class ThreatIntelligenceMetrics(_serialization.Model):
    """Threat intelligence metrics.

    :ivar properties: Threat intelligence metrics.
    :vartype properties: ~azure.mgmt.securityinsight.models.ThreatIntelligenceMetric
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ThreatIntelligenceMetric"},
    }

    def __init__(self, *, properties: Optional["_models.ThreatIntelligenceMetric"] = None, **kwargs):
        """
        :keyword properties: Threat intelligence metrics.
        :paramtype properties: ~azure.mgmt.securityinsight.models.ThreatIntelligenceMetric
        """
        super().__init__(**kwargs)
        self.properties = properties


class ThreatIntelligenceMetricsList(_serialization.Model):
    """List of all the threat intelligence metric fields (type/threat type/source).

    All required parameters must be populated in order to send to Azure.

    :ivar value: Array of threat intelligence metric fields (type/threat type